<?php
require_once 'includes/config.php';

$pdo = getDB();
$results = [];

// 1. הוספת עמודות לטבלת drafts
try {
    $pdo->exec("ALTER TABLE drafts ADD COLUMN parent_order_id INT NULL AFTER order_id");
    $results[] = "✅ נוספה עמודה parent_order_id";
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        $results[] = "⚠️ עמודה parent_order_id כבר קיימת";
    } else {
        $results[] = "❌ שגיאה: " . $e->getMessage();
    }
}

try {
    $pdo->exec("ALTER TABLE drafts ADD COLUMN addon_description VARCHAR(255) NULL AFTER parent_order_id");
    $results[] = "✅ נוספה עמודה addon_description";
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        $results[] = "⚠️ עמודה addon_description כבר קיימת";
    } else {
        $results[] = "❌ שגיאה: " . $e->getMessage();
    }
}

try {
    $pdo->exec("ALTER TABLE drafts ADD INDEX idx_parent_order (parent_order_id)");
    $results[] = "✅ נוסף אינדקס idx_parent_order";
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate key') !== false) {
        $results[] = "⚠️ אינדקס idx_parent_order כבר קיים";
    } else {
        $results[] = "❌ שגיאה באינדקס: " . $e->getMessage();
    }
}

// 2. יצירת טבלת חובות ספקים
try {
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS supplier_debts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            order_id INT NOT NULL,
            draft_id INT NULL,
            supplier_name VARCHAR(100) NOT NULL,
            supplier_booking VARCHAR(100) NULL,
            description VARCHAR(255) NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            currency VARCHAR(3) DEFAULT 'USD',
            status ENUM('unpaid', 'paid') DEFAULT 'unpaid',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            paid_at DATETIME NULL,
            INDEX idx_order (order_id),
            INDEX idx_supplier (supplier_name),
            INDEX idx_status (status)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    $results[] = "✅ נוצרה טבלת supplier_debts";
} catch (Exception $e) {
    $results[] = "❌ שגיאה בטבלה: " . $e->getMessage();
}

// 3. העברת חובות קיימים מהזמנות לטבלה החדשה (אם אין עדיין)
try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM supplier_debts");
    $count = $stmt->fetchColumn();
    
    if ($count == 0) {
        // העברת חובות מהזמנות קיימות
        $orders = $pdo->query("SELECT * FROM orders WHERE id > 0")->fetchAll();
        $migrated = 0;
        
        foreach ($orders as $order) {
            // ספק טיסה
            if (!empty($order['flight_supplier']) && !empty($order['flight_supplier_cost'])) {
                $stmt = $pdo->prepare("
                    INSERT INTO supplier_debts (order_id, supplier_name, supplier_booking, description, amount, currency, status, created_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([
                    $order['id'],
                    $order['flight_supplier'],
                    $order['flight_supplier_booking'] ?? '',
                    'טיסה',
                    $order['flight_supplier_cost'],
                    $order['flight_supplier_currency'] ?? 'USD',
                    ($order['flight_supplier_paid'] ?? 'unpaid') === 'paid' ? 'paid' : 'unpaid',
                    $order['created_at']
                ]);
                $migrated++;
            }
            
            // ספק מלון
            if (!empty($order['hotel_supplier']) && !empty($order['hotel_supplier_cost'])) {
                $stmt = $pdo->prepare("
                    INSERT INTO supplier_debts (order_id, supplier_name, supplier_booking, description, amount, currency, status, created_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([
                    $order['id'],
                    $order['hotel_supplier'],
                    $order['hotel_supplier_booking'] ?? '',
                    'מלון',
                    $order['hotel_supplier_cost'],
                    $order['hotel_supplier_currency'] ?? 'USD',
                    ($order['hotel_supplier_paid'] ?? 'unpaid') === 'paid' ? 'paid' : 'unpaid',
                    $order['created_at']
                ]);
                $migrated++;
            }
            
            // ספק חבילה
            if (!empty($order['package_supplier']) && !empty($order['package_supplier_cost'])) {
                $stmt = $pdo->prepare("
                    INSERT INTO supplier_debts (order_id, supplier_name, supplier_booking, description, amount, currency, status, created_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([
                    $order['id'],
                    $order['package_supplier'],
                    $order['package_supplier_booking'] ?? '',
                    'חבילה/מאורגן',
                    $order['package_supplier_cost'],
                    $order['package_supplier_currency'] ?? 'USD',
                    ($order['package_supplier_paid'] ?? 'unpaid') === 'paid' ? 'paid' : 'unpaid',
                    $order['created_at']
                ]);
                $migrated++;
            }
        }
        
        $results[] = "✅ הועברו $migrated רשומות חוב לטבלה החדשה";
    } else {
        $results[] = "⚠️ טבלת supplier_debts כבר מכילה נתונים ($count רשומות)";
    }
} catch (Exception $e) {
    $results[] = "❌ שגיאה בהעברת נתונים: " . $e->getMessage();
}

?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>עדכון מבנה מסד נתונים</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 40px; background: #f5f5f5; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        .result { padding: 10px 15px; margin: 10px 0; border-radius: 8px; background: #f8f9fa; }
        .result.success { background: #d4edda; color: #155724; }
        .result.warning { background: #fff3cd; color: #856404; }
        .result.error { background: #f8d7da; color: #721c24; }
        a { color: #007bff; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 עדכון מבנה מסד נתונים</h1>
        
        <?php foreach ($results as $result): ?>
            <?php 
            $class = 'result';
            if (strpos($result, '✅') !== false) $class .= ' success';
            elseif (strpos($result, '⚠️') !== false) $class .= ' warning';
            else $class .= ' error';
            ?>
            <div class="<?= $class ?>"><?= $result ?></div>
        <?php endforeach; ?>
        
        <hr style="margin: 20px 0;">
        <p>
            <a href="drafts_list.php">📋 לרשימת טיוטות</a> | 
            <a href="orders.php">📦 לרשימת הזמנות</a>
        </p>
    </div>
</body>
</html>
