<?php
/**
 * הוספת עמודת email לטבלת agents
 * ועדכון האימיילים של כל ה-agents
 */

require_once 'includes/config.php';

echo "<h2>הוספת אימייל ל-Agents</h2>";
echo "<pre>";

try {
    $pdo = getDB();
    
    // בדיקה והוספת עמודת email (לקבלת CC)
    $stmt = $pdo->query("SHOW COLUMNS FROM agents LIKE 'email'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE agents ADD COLUMN email VARCHAR(255) DEFAULT NULL AFTER full_name");
        echo "✅ עמודת email נוספה לטבלת agents\n";
    } else {
        echo "✓ עמודת email כבר קיימת\n";
    }
    
    // בדיקה והוספת עמודת send_from_email (לשליחה מהכתובת הזו)
    $stmt = $pdo->query("SHOW COLUMNS FROM agents LIKE 'send_from_email'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE agents ADD COLUMN send_from_email VARCHAR(255) DEFAULT NULL AFTER email");
        echo "✅ עמודת send_from_email נוספה לטבלת agents\n";
    } else {
        echo "✓ עמודת send_from_email כבר קיימת\n";
    }
    
    // עדכון אימיילים
    $agents = [
        'shani' => [
            'email' => 'shaniholidayinsale@gmail.com',
            'send_from' => 'shani@holidayinsale.com'
        ],
        'dasha' => [
            'email' => 'dashaholidayinsale@gmail.com',
            'send_from' => 'dasha@holidayinsale.com'
        ],
        'zina' => [
            'email' => 'zinaholidayinsale@gmail.com',
            'send_from' => 'zina@holidayinsale.com'
        ],
        'anna' => [
            'email' => 'annaholidayinsale@gmail.com',
            'send_from' => 'anna@holidayinsale.com'
        ],
        'admin' => [
            'email' => 'info@hufshagroup.com',
            'send_from' => 'orders@holidayinsale.com'
        ]
    ];
    
    echo "\n--- עדכון אימיילים ---\n";
    
    foreach ($agents as $username => $emails) {
        $stmt = $pdo->prepare("UPDATE agents SET email = ?, send_from_email = ? WHERE username = ?");
        $stmt->execute([$emails['email'], $emails['send_from'], $username]);
        
        if ($stmt->rowCount() > 0) {
            echo "✅ {$username}:\n";
            echo "   CC: {$emails['email']}\n";
            echo "   From: {$emails['send_from']}\n";
        } else {
            echo "⚠️ {$username}: לא נמצא או כבר מעודכן\n";
        }
    }
    
    // הצגת כל ה-agents
    echo "\n--- רשימת Agents ---\n";
    $stmt = $pdo->query("SELECT username, full_name, email, send_from_email, role FROM agents ORDER BY role, username");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $email = $row['email'] ?: '(לא הוגדר)';
        $sendFrom = $row['send_from_email'] ?: '(לא הוגדר)';
        echo "{$row['full_name']} ({$row['username']}):\n";
        echo "   CC: {$email}\n";
        echo "   From: {$sendFrom}\n";
        echo "   Role: {$row['role']}\n\n";
    }
    
    echo "\n✅ הסתיים בהצלחה!\n";
    
} catch (Exception $e) {
    echo "❌ שגיאה: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><strong>אפשר למחוק קובץ זה אחרי ההרצה.</strong></p>";
?>
