<?php
/**
 * הוספת חברות תעופה נוספות למערכת
 */
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

// רשימת כל חברות התעופה הגדולות
$airlines = [
    // ישראליות
    ['EL AL', 'LY'],
    ['Israir', '6H'],
    ['Arkia', 'IZ'],
    ['Sun d\'Or', '2U'],
    
    // אמריקאיות
    ['United Airlines', 'UA'],
    ['American Airlines', 'AA'],
    ['Delta Air Lines', 'DL'],
    ['JetBlue', 'B6'],
    ['Southwest Airlines', 'WN'],
    ['Alaska Airlines', 'AS'],
    ['Spirit Airlines', 'NK'],
    ['Frontier Airlines', 'F9'],
    
    // אירופאיות - מובילות
    ['Lufthansa', 'LH'],
    ['British Airways', 'BA'],
    ['Air France', 'AF'],
    ['KLM', 'KL'],
    ['Swiss', 'LX'],
    ['Austrian', 'OS'],
    ['Brussels Airlines', 'SN'],
    ['Iberia', 'IB'],
    ['TAP Portugal', 'TP'],
    ['Alitalia', 'AZ'],
    ['ITA Airways', 'AZ'],
    ['SAS Scandinavian', 'SK'],
    ['Finnair', 'AY'],
    ['Norwegian', 'DY'],
    ['LOT Polish', 'LO'],
    ['Aer Lingus', 'EI'],
    ['Icelandair', 'FI'],
    ['Air Europa', 'UX'],
    
    // אירופאיות - לואו קוסט
    ['Ryanair', 'FR'],
    ['Wizz Air', 'W6'],
    ['EasyJet', 'U2'],
    ['Vueling', 'VY'],
    ['Transavia', 'TO'],
    ['Eurowings', 'EW'],
    ['Norwegian', 'DY'],
    ['Volotea', 'V7'],
    ['Smart Wings', 'QS'],
    ['Pegasus', 'PC'],
    ['SunExpress', 'XQ'],
    ['Condor', 'DE'],
    ['TUI fly', 'X3'],
    ['Jet2', 'LS'],
    ['Corendon', 'XC'],
    ['Bluebird Airways', 'BZ'],
    ['Tus Airways', 'U8'],
    ['Air Baltic', 'BT'],
    ['Flydubai', 'FZ'],
    ['Air Serbia', 'JU'],
    ['Croatia Airlines', 'OU'],
    ['TAROM', 'RO'],
    ['Bulgaria Air', 'FB'],
    ['Ukraine International', 'PS'],
    ['Air Malta', 'KM'],
    ['Olympic Air', 'OA'],
    ['Sky Express Greece', 'GQ'],
    ['Blue Air', '0B'],
    ['Wideroe', 'WF'],
    
    // מזרח תיכון
    ['Emirates', 'EK'],
    ['Qatar Airways', 'QR'],
    ['Etihad', 'EY'],
    ['Turkish Airlines', 'TK'],
    ['Royal Jordanian', 'RJ'],
    ['Gulf Air', 'GF'],
    ['Oman Air', 'WY'],
    ['Saudia', 'SV'],
    ['Kuwait Airways', 'KU'],
    ['Middle East Airlines', 'ME'],
    ['flydubai', 'FZ'],
    ['Air Arabia', 'G9'],
    ['Jazeera Airways', 'J9'],
    
    // אסיה
    ['Singapore Airlines', 'SQ'],
    ['Cathay Pacific', 'CX'],
    ['Thai Airways', 'TG'],
    ['Malaysia Airlines', 'MH'],
    ['Vietnam Airlines', 'VN'],
    ['Korean Air', 'KE'],
    ['Asiana Airlines', 'OZ'],
    ['Japan Airlines', 'JL'],
    ['ANA', 'NH'],
    ['Air China', 'CA'],
    ['China Eastern', 'MU'],
    ['China Southern', 'CZ'],
    ['Hainan Airlines', 'HU'],
    ['EVA Air', 'BR'],
    ['China Airlines', 'CI'],
    ['Philippine Airlines', 'PR'],
    ['Garuda Indonesia', 'GA'],
    ['Air India', 'AI'],
    ['IndiGo', '6E'],
    ['SpiceJet', 'SG'],
    ['Bangkok Airways', 'PG'],
    ['AirAsia', 'AK'],
    ['Scoot', 'TR'],
    ['Cebu Pacific', '5J'],
    
    // אוסטרליה / אוקיאניה
    ['Qantas', 'QF'],
    ['Virgin Australia', 'VA'],
    ['Jetstar', 'JQ'],
    ['Air New Zealand', 'NZ'],
    ['Fiji Airways', 'FJ'],
    
    // אפריקה
    ['Ethiopian Airlines', 'ET'],
    ['South African Airways', 'SA'],
    ['Kenya Airways', 'KQ'],
    ['EgyptAir', 'MS'],
    ['Royal Air Maroc', 'AT'],
    ['Tunisair', 'TU'],
    ['Air Mauritius', 'MK'],
    ['RwandAir', 'WB'],
    
    // דרום אמריקה
    ['LATAM', 'LA'],
    ['Avianca', 'AV'],
    ['Gol', 'G3'],
    ['Azul', 'AD'],
    ['Copa Airlines', 'CM'],
    ['Aeromexico', 'AM'],
    
    // קנדה
    ['Air Canada', 'AC'],
    ['WestJet', 'WS'],
    
    // רוסיה / מזרח אירופה
    ['Aeroflot', 'SU'],
    ['S7 Airlines', 'S7'],
    ['UTair', 'UT'],
    ['Czech Airlines', 'OK'],
    ['Aegean Airlines', 'A3'],
    
    // שונות
    ['Neos', 'NO'],
    ['Enter Air', 'E4'],
    ['Small Planet', 'LLC'],
    ['Alba Star', 'AP'],
];

$added = 0;
$skipped = 0;

foreach ($airlines as $airline) {
    $name = $airline[0];
    $code = $airline[1];
    
    // בדיקה אם כבר קיים (לפי שם או קוד)
    $stmt = $pdo->prepare("SELECT id FROM settings_airlines WHERE name = ? OR code = ?");
    $stmt->execute([$name, $code]);
    
    if (!$stmt->fetch()) {
        // הוספה
        $stmt = $pdo->prepare("INSERT INTO settings_airlines (name, code, active) VALUES (?, ?, 1)");
        try {
            $stmt->execute([$name, $code]);
            $added++;
            echo "✅ נוסף: $name ($code)<br>";
        } catch (Exception $e) {
            echo "⚠️ שגיאה ב-$name: " . $e->getMessage() . "<br>";
        }
    } else {
        $skipped++;
    }
}

echo "<hr>";
echo "<h2>סיכום:</h2>";
echo "✅ נוספו: $added חברות תעופה<br>";
echo "⏭️ דילגנו (כבר קיימות): $skipped<br>";
echo "<br><a href='settings.php?tab=airlines'>חזרה להגדרות</a>";
