<?php
// הוספת עמודות bank_verified לטבלת order_additions
require_once 'includes/auth.php';
$pdo = getDB();

echo "<h2>הוספת עמודות אימות העברה בנקאית</h2>";

try {
    // בדיקה אם העמודה קיימת
    $result = $pdo->query("SHOW COLUMNS FROM order_additions LIKE 'bank_verified'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN bank_verified TINYINT(1) DEFAULT 0");
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN verified_at DATETIME NULL");
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN verified_by INT NULL");
        echo "<p style='color:green;'>✅ עמודות נוספו בהצלחה!</p>";
    } else {
        echo "<p style='color:blue;'>ℹ️ העמודות כבר קיימות</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ שגיאה: " . $e->getMessage() . "</p>";
}

echo "<p><a href='bank_transfers.php'>← חזרה להעברות בנקאיות</a></p>";