<?php
// הוספת עמודת deal_builder לטבלת orders
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>🔧 הוספת עמודת בונה הדיל</h2><br>";

try {
    // בדיקה אם העמודה קיימת
    $columns = $pdo->query("SHOW COLUMNS FROM orders LIKE 'deal_builder'")->fetch();
    
    if (!$columns) {
        $pdo->exec("ALTER TABLE orders ADD COLUMN deal_builder VARCHAR(100) NULL AFTER agent_id");
        echo "✅ עמודת deal_builder נוספה בהצלחה!<br>";
    } else {
        echo "⏭️ עמודת deal_builder כבר קיימת<br>";
    }
    
    // בדיקה אם יש עמודה ישנה deal_builder_id ומחיקתה
    $oldColumn = $pdo->query("SHOW COLUMNS FROM orders LIKE 'deal_builder_id'")->fetch();
    if ($oldColumn) {
        $pdo->exec("ALTER TABLE orders DROP COLUMN deal_builder_id");
        echo "🗑️ עמודה ישנה deal_builder_id נמחקה<br>";
    }
    
    echo "<br><strong style='color: green;'>✅ סיום!</strong><br>";
    echo "<br><strong style='color: red;'>⚠️ מחק קובץ זה אחרי השימוש!</strong>";
    
} catch (Exception $e) {
    echo "<br><strong style='color: red;'>❌ שגיאה: " . $e->getMessage() . "</strong>";
}
