<?php
// הוספת עמודת קישור לטיוטה
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>הוספת עמודת draft_id לטבלת order_additions</h2>";

try {
    // בדיקה אם העמודה קיימת
    $check = $pdo->query("SHOW COLUMNS FROM order_additions LIKE 'draft_id'");
    if ($check->rowCount() == 0) {
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN draft_id INT DEFAULT NULL AFTER id");
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN customer_paid TINYINT(1) DEFAULT 0 COMMENT 'האם הלקוח שילם' AFTER is_paid");
        $pdo->exec("ALTER TABLE order_additions ADD COLUMN customer_paid_date DATETIME DEFAULT NULL AFTER customer_paid");
        echo "<p style='color:green;'>✅ עמודות נוספו בהצלחה!</p>";
    } else {
        echo "<p style='color:blue;'>ℹ️ עמודה draft_id כבר קיימת</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ שגיאה: " . $e->getMessage() . "</p>";
}

echo "<h3>מבנה הטבלה הנוכחי:</h3>";
$result = $pdo->query("DESCRIBE order_additions");
echo "<table border='1' cellpadding='5'>";
while ($row = $result->fetch()) {
    echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td></tr>";
}
echo "</table>";
?>
