<?php
// הוספת עמודות חסרות לטבלת orders
require_once 'includes/config.php';

$pdo = getDB();

$columnsToAdd = [
    // ספק טיסות הלוך
    ['flight_supplier', 'VARCHAR(100) DEFAULT NULL AFTER booking_code_return'],
    ['flight_supplier_cost', 'DECIMAL(10,2) DEFAULT 0 AFTER flight_supplier'],
    ['flight_supplier_currency', "ENUM('ILS','USD','EUR') DEFAULT 'ILS' AFTER flight_supplier_cost"],
    
    // ספק טיסות חזור
    ['return_flight_supplier', 'VARCHAR(100) DEFAULT NULL AFTER flight_supplier_paid'],
    ['return_flight_supplier_cost', 'DECIMAL(10,2) DEFAULT 0 AFTER return_flight_supplier'],
    ['return_flight_supplier_currency', "ENUM('ILS','USD','EUR') DEFAULT 'ILS' AFTER return_flight_supplier_cost"],
    ['return_flight_supplier_paid', "ENUM('paid','unpaid') DEFAULT 'unpaid' AFTER return_flight_supplier_currency"],
    
    // ספק מלון
    ['hotel_supplier', 'VARCHAR(100) DEFAULT NULL AFTER hotel_supplier_paid'],
    ['hotel_supplier_booking', 'VARCHAR(100) DEFAULT NULL AFTER hotel_supplier'],
    ['hotel_supplier_cost', 'DECIMAL(10,2) DEFAULT 0 AFTER hotel_supplier_booking'],
    ['hotel_supplier_currency', "ENUM('ILS','USD','EUR') DEFAULT 'ILS' AFTER hotel_supplier_cost"],
    
    // שונות
    ['extras', 'JSON DEFAULT NULL AFTER payments'],
];

echo "<h2>הוספת עמודות לטבלת orders</h2>";
echo "<pre>";

foreach ($columnsToAdd as $col) {
    $columnName = $col[0];
    $columnDef = $col[1];
    
    try {
        // בדיקה אם העמודה כבר קיימת
        $stmt = $pdo->query("SHOW COLUMNS FROM orders LIKE '$columnName'");
        if ($stmt->fetch()) {
            echo "✓ העמודה '$columnName' כבר קיימת\n";
        } else {
            $sql = "ALTER TABLE orders ADD COLUMN $columnName $columnDef";
            $pdo->exec($sql);
            echo "✅ נוספה העמודה '$columnName'\n";
        }
    } catch (Exception $e) {
        echo "❌ שגיאה בעמודה '$columnName': " . $e->getMessage() . "\n";
    }
}

echo "\n✅ הסתיים!\n";
echo "</pre>";
echo "<a href='edit_order.php?id=1'>← חזרה לעריכת הזמנה</a>";
