<?php
// הוספת עמודת סוג הזמנה לטבלת orders
require_once 'includes/config.php';
$pdo = getDB();

try {
    // בדיקה אם העמודה קיימת
    $stmt = $pdo->query("SHOW COLUMNS FROM orders LIKE 'order_type'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE orders ADD COLUMN order_type ENUM('separate', 'package', 'tour') DEFAULT 'separate' AFTER id");
        echo "✅ עמודת order_type נוספה בהצלחה<br>";
    } else {
        echo "ℹ️ עמודת order_type כבר קיימת<br>";
    }
    
    // הצגת המבנה הנוכחי
    echo "<br><strong>עמודות בטבלה:</strong><br>";
    $cols = $pdo->query("SHOW COLUMNS FROM orders")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($cols as $col) {
        if ($col['Field'] === 'order_type') {
            echo "✅ <strong>{$col['Field']}</strong> - {$col['Type']} (Default: {$col['Default']})<br>";
        }
    }
    
} catch (Exception $e) {
    echo "❌ שגיאה: " . $e->getMessage();
}
