<?php
// הוספת עמודת payment_method לטבלת draft_payments
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>הוספת עמודת payment_method</h2>";

try {
    // בדיקה אם העמודה קיימת
    $result = $pdo->query("SHOW COLUMNS FROM draft_payments LIKE 'payment_method'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE draft_payments ADD COLUMN payment_method VARCHAR(50) DEFAULT 'credit_card' AFTER amount");
        echo "<p style='color:green;'>✅ עמודת payment_method נוספה!</p>";
    } else {
        echo "<p>העמודה כבר קיימת</p>";
    }
    
    // הוספת עמודות נוספות אם חסרות
    $result = $pdo->query("SHOW COLUMNS FROM draft_payments LIKE 'last_4_digits'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE draft_payments ADD COLUMN last_4_digits VARCHAR(4) DEFAULT NULL");
        echo "<p style='color:green;'>✅ עמודת last_4_digits נוספה!</p>";
    }
    
    $result = $pdo->query("SHOW COLUMNS FROM draft_payments LIKE 'card_brand'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE draft_payments ADD COLUMN card_brand VARCHAR(50) DEFAULT NULL");
        echo "<p style='color:green;'>✅ עמודת card_brand נוספה!</p>";
    }
    
    $result = $pdo->query("SHOW COLUMNS FROM draft_payments LIKE 'payer_email'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE draft_payments ADD COLUMN payer_email VARCHAR(255) DEFAULT NULL AFTER payer_name");
        echo "<p style='color:green;'>✅ עמודת payer_email נוספה!</p>";
    }
    
    echo "<h3>מבנה הטבלה:</h3>";
    $result = $pdo->query("DESCRIBE draft_payments");
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Field</th><th>Type</th><th>Default</th></tr>";
    while ($row = $result->fetch()) {
        echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td><td>{$row['Default']}</td></tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ שגיאה: " . $e->getMessage() . "</p>";
}
?>
