<?php
// יצירת טיוטה וקבלת לינק תשלום עבור תוספת
require_once '../includes/auth.php';
requireLogin();

header('Content-Type: application/json; charset=utf-8');

$pdo = getDB();
$agent = getCurrentAgent();

try {
    $orderId = $_POST['order_id'] ?? null;
    $additionId = $_POST['addition_id'] ?? null;
    $description = trim($_POST['description'] ?? '');
    $amount = floatval($_POST['amount'] ?? 0);
    $customerName = trim($_POST['customer_name'] ?? '');
    $customerEmail = trim($_POST['customer_email'] ?? '');
    $customerPhone = trim($_POST['customer_phone'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    
    if (!$orderId || !$description || $amount <= 0 || !$customerName) {
        throw new Exception('חסרים פרטים חובה');
    }
    
    // שליפת ההזמנה
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order) {
        throw new Exception('הזמנה לא נמצאה');
    }
    
    // יצירת טיוטה חדשה
    $token = bin2hex(random_bytes(16));
    $expiresAt = date('Y-m-d H:i:s', strtotime('+7 days'));
    
    // יצירת טיוטה בטבלה - כולל עמודות תוספת
    $stmt = $pdo->prepare("
        INSERT INTO drafts (
            token, agent_id, customer_name, customer_phone, customer_email,
            destination, num_passengers, departure_date, return_date,
            airline, hotel_name, 
            price_per_person, total_price, currency, notes, 
            parent_order_id, addon_description,
            status, expires_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending', ?)
    ");
    
    $stmt->execute([
        $token,
        $agent['id'],
        $customerName,
        $customerPhone,
        $customerEmail,
        $order['destination'],
        1,
        $order['departure_date'],
        $order['return_date'],
        $order['airline_outbound'] ?? '',
        $order['hotel_name'] ?? '',
        $amount,
        $amount,
        'ILS',
        $notes,
        $orderId,  // parent_order_id
        $description,  // addon_description
        $expiresAt
    ]);
    
    $draftId = $pdo->lastInsertId();
    
    // עדכון התוספת עם מזהה הטיוטה
    if ($additionId) {
        $stmt = $pdo->prepare("UPDATE order_additions SET draft_id = ? WHERE id = ?");
        $stmt->execute([$draftId, $additionId]);
    }
    
    // לינק לתשלום
    $paymentUrl = "https://hufshagroup.com/newprojectmillion/pay.php?token=" . $token;
    
    // אם יש אימייל - נשלח ללקוח
    if ($customerEmail) {
        $subject = "בקשת תשלום - " . $description;
        $emailBody = "שלום " . $customerName . ",\n\n";
        $emailBody .= "מצורף לינק לתשלום עבור:\n";
        $emailBody .= $description . "\n\n";
        $emailBody .= "סכום לתשלום: ₪" . number_format($amount, 2) . "\n\n";
        $emailBody .= "לתשלום לחצו כאן:\n" . $paymentUrl . "\n\n";
        $emailBody .= "בברכה,\nחופשה במבצע";
        
        $headers = "From: orders@hufshagroup.com\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        @mail($customerEmail, "=?UTF-8?B?" . base64_encode($subject) . "?=", $emailBody, $headers);
    }
    
    // לוג
    $logDir = __DIR__ . '/../logs';
    if (!is_dir($logDir)) mkdir($logDir, 0755, true);
    $logEntry = date('Y-m-d H:i:s') . " - Addition draft #{$draftId} created for order #{$orderId}, amount: ₪{$amount}, desc: {$description}\n";
    file_put_contents($logDir . '/additions_' . date('Y-m-d') . '.log', $logEntry, FILE_APPEND);
    
    echo json_encode([
        'success' => true,
        'draft_id' => $draftId,
        'token' => $token,
        'payment_url' => $paymentUrl,
        'message' => 'הטיוטה נוצרה בהצלחה'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}