<?php
// API - יצירת טיוטת הזמנה
header('Content-Type: application/json');

require_once '../includes/auth.php';

// בדיקת התחברות
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'לא מחובר']);
    exit;
}

// בדיקת שיטת בקשה
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'שיטה לא נתמכת']);
    exit;
}

try {
    $pdo = getDB();
    
    // יצירת טוקן ייחודי לטיוטה
    $token = generateToken();
    
    // הכנת הנתונים
    $data = [
        'draft_token' => $token,
        'agent_id' => $_SESSION['agent_id'],
        'customer_name' => sanitize($_POST['customer_name']),
        'customer_phone' => sanitize($_POST['customer_phone']),
        'destination' => sanitize($_POST['destination']),
        'departure_date' => $_POST['departure_date'],
        'return_date' => $_POST['return_date'],
        'adults' => (int)$_POST['adults'],
        'children' => (int)$_POST['children'],
        'hotel_name' => sanitize($_POST['hotel_name']),
        'meal_basis' => $_POST['meal_basis'],
        'total_price' => (float)$_POST['total_price'],
        'notes' => sanitize($_POST['notes'] ?? ''),
        'status' => 'sent'
    ];
    
    // וולידציה בסיסית
    if (empty($data['customer_name']) || empty($data['customer_phone']) || empty($data['destination'])) {
        throw new Exception('חסרים שדות חובה');
    }
    
    if (strtotime($data['return_date']) <= strtotime($data['departure_date'])) {
        throw new Exception('תאריך חזרה חייב להיות אחרי תאריך יציאה');
    }
    
    // שמירה בדאטאבייס
    $sql = "INSERT INTO orders (draft_token, agent_id, customer_name, customer_phone, destination, 
            departure_date, return_date, adults, children, hotel_name, meal_basis, total_price, notes, status) 
            VALUES (:draft_token, :agent_id, :customer_name, :customer_phone, :destination, 
            :departure_date, :return_date, :adults, :children, :hotel_name, :meal_basis, :total_price, :notes, :status)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($data);
    
    // יצירת URL לטיוטה
    $draftUrl = SITE_URL . '/draft.php?token=' . $token;
    
    echo json_encode([
        'success' => true,
        'draft_url' => $draftUrl,
        'customer_phone' => $data['customer_phone'],
        'customer_name' => $data['customer_name']
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
