<?php
// API להשלמה אוטומטית
header('Content-Type: application/json; charset=utf-8');

require_once '../includes/auth.php';

// בדיקת התחברות
if (!isLoggedIn()) {
    echo json_encode(['error' => 'לא מחובר']);
    exit;
}

$pdo = getDB();
$type = $_GET['type'] ?? '';
$query = $_GET['q'] ?? '';
$destination = $_GET['destination'] ?? '';

try {
    switch ($type) {
        case 'suppliers':
            $stmt = $pdo->query("SELECT name FROM settings_suppliers WHERE active = 1 ORDER BY sort_order, name");
            $items = $stmt->fetchAll(PDO::FETCH_COLUMN);
            break;
            
        case 'airlines':
            $stmt = $pdo->query("SELECT name, code FROM settings_airlines WHERE active = 1 ORDER BY sort_order, name");
            $items = [];
            while ($row = $stmt->fetch()) {
                $items[] = [
                    'name' => $row['name'],
                    'code' => $row['code'],
                    'display' => $row['code'] ? "{$row['name']} ({$row['code']})" : $row['name']
                ];
            }
            break;
            
        case 'destinations':
            $stmt = $pdo->query("SELECT name, country FROM settings_destinations WHERE active = 1 ORDER BY sort_order, name");
            $items = [];
            while ($row = $stmt->fetch()) {
                $items[] = [
                    'name' => $row['name'],
                    'country' => $row['country'],
                    'display' => $row['country'] ? "{$row['name']}, {$row['country']}" : $row['name']
                ];
            }
            break;
            
        case 'hotels':
            if ($destination) {
                $stmt = $pdo->prepare("SELECT name, stars FROM settings_hotels WHERE active = 1 AND destination = ? ORDER BY times_used DESC, name");
                $stmt->execute([$destination]);
            } else {
                $stmt = $pdo->query("SELECT name, stars, destination FROM settings_hotels WHERE active = 1 ORDER BY times_used DESC, name LIMIT 50");
            }
            $items = [];
            while ($row = $stmt->fetch()) {
                $stars = $row['stars'] ? str_repeat('⭐', $row['stars']) : '';
                $items[] = [
                    'name' => $row['name'],
                    'stars' => $row['stars'],
                    'display' => $stars ? "{$row['name']} {$stars}" : $row['name']
                ];
            }
            break;
            
        case 'search_hotels':
            // חיפוש מלונות לפי טקסט
            if ($query) {
                $stmt = $pdo->prepare("SELECT name, stars, destination FROM settings_hotels WHERE active = 1 AND name LIKE ? ORDER BY times_used DESC LIMIT 10");
                $stmt->execute(["%$query%"]);
                $items = [];
                while ($row = $stmt->fetch()) {
                    $stars = $row['stars'] ? str_repeat('⭐', $row['stars']) : '';
                    $dest = $row['destination'] ? " ({$row['destination']})" : '';
                    $items[] = [
                        'name' => $row['name'],
                        'display' => "{$row['name']}{$dest} {$stars}"
                    ];
                }
            } else {
                $items = [];
            }
            break;
            
        default:
            $items = [];
    }
    
    echo json_encode(['success' => true, 'items' => $items]);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
