<?php
// API למשיכת תשלומים מטיוטה
header('Content-Type: application/json');
require_once '../includes/config.php';

$draftId = $_GET['draft_id'] ?? null;

if (!$draftId) {
    echo json_encode(['success' => false, 'error' => 'Missing draft_id']);
    exit;
}

try {
    $pdo = getDB();
    
    // משיכת תשלומים מטבלת draft_payments
    $stmt = $pdo->prepare("
        SELECT payer_name, payer_email, amount, installments, last_4_digits, card_brand, approval_number, transaction_id, payment_date 
        FROM draft_payments 
        WHERE draft_id = ? 
        ORDER BY payment_date ASC
    ");
    $stmt->execute([$draftId]);
    $payments = $stmt->fetchAll();
    
    // משיכת סה"כ מהטיוטה
    $stmt = $pdo->prepare("SELECT total_price, amount_paid FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    $draft = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'payments' => $payments,
        'total_price' => $draft['total_price'] ?? 0,
        'amount_paid' => $draft['amount_paid'] ?? 0
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>