<?php
// API מרכזי לסטטיסטיקות פריטים
header('Content-Type: application/json; charset=utf-8');

require_once '../includes/auth.php';

if (!isLoggedIn()) {
    echo json_encode(['error' => 'לא מחובר']);
    exit;
}

$pdo = getDB();

$type = $_GET['type'] ?? '';
$name = $_GET['name'] ?? '';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';

if (!$type || !$name) {
    echo json_encode(['error' => 'חסרים פרמטרים']);
    exit;
}

try {
    $stats = [];
    
    // בניית תנאי תאריכים
    $dateCondition = "";
    $dateParams = [];
    if ($dateFrom) {
        $dateCondition .= " AND o.departure_date >= ?";
        $dateParams[] = $dateFrom;
    }
    if ($dateTo) {
        $dateCondition .= " AND o.departure_date <= ?";
        $dateParams[] = $dateTo;
    }
    
    switch ($type) {
        case 'supplier':
            // סטטיסטיקות ספק - חיפוש בשדות ספק טיסה, מלון, וחבילה
            $sql = "SELECT 
                        COUNT(*) as total_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() THEN 1 ELSE 0 END) as open_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as this_week,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as this_month,
                        SUM(total_price) as total_revenue,
                        SUM(profit) as total_profit,
                        SUM(flight_supplier_cost) as flight_cost,
                        SUM(hotel_supplier_cost) as hotel_cost,
                        SUM(CASE WHEN flight_supplier_paid = 'no' THEN flight_supplier_cost ELSE 0 END) as flight_pending,
                        SUM(CASE WHEN hotel_supplier_paid = 'no' THEN hotel_supplier_cost ELSE 0 END) as hotel_pending,
                        MIN(order_date) as first_order,
                        MAX(order_date) as last_order
                    FROM orders o
                    WHERE (flight_supplier = ? OR hotel_supplier = ? OR package_supplier = ?)
                    $dateCondition";
            
            $params = array_merge([$name, $name, $name], $dateParams);
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $stats = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // חישוב סה"כ עלות וחוב
            $stats['total_cost'] = ($stats['flight_cost'] ?? 0) + ($stats['hotel_cost'] ?? 0);
            $stats['pending_payment'] = ($stats['flight_pending'] ?? 0) + ($stats['hotel_pending'] ?? 0);
            
            // יעדים פופולריים לספק זה
            $sql2 = "SELECT destination, COUNT(*) as cnt 
                     FROM orders 
                     WHERE (flight_supplier = ? OR hotel_supplier = ? OR package_supplier = ?)
                     AND destination IS NOT NULL AND destination != ''
                     GROUP BY destination 
                     ORDER BY cnt DESC 
                     LIMIT 5";
            $stmt2 = $pdo->prepare($sql2);
            $stmt2->execute([$name, $name, $name]);
            $stats['top_destinations'] = $stmt2->fetchAll(PDO::FETCH_ASSOC);
            break;
            
        case 'airline':
            // סטטיסטיקות חברת תעופה
            $sql = "SELECT 
                        COUNT(*) as total_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() THEN 1 ELSE 0 END) as open_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as this_week,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as this_month,
                        SUM(total_price) as total_revenue,
                        SUM(profit) as total_profit,
                        MIN(order_date) as first_order,
                        MAX(order_date) as last_order
                    FROM orders o
                    WHERE (airline_outbound = ? OR airline_return = ?)
                    $dateCondition";
            
            $params = array_merge([$name, $name], $dateParams);
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $stats = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // יעדים פופולריים
            $sql2 = "SELECT destination, COUNT(*) as cnt 
                     FROM orders 
                     WHERE (airline_outbound = ? OR airline_return = ?)
                     AND destination IS NOT NULL AND destination != ''
                     GROUP BY destination 
                     ORDER BY cnt DESC 
                     LIMIT 5";
            $stmt2 = $pdo->prepare($sql2);
            $stmt2->execute([$name, $name]);
            $stats['top_destinations'] = $stmt2->fetchAll(PDO::FETCH_ASSOC);
            break;
            
        case 'hotel':
            // סטטיסטיקות מלון
            $sql = "SELECT 
                        COUNT(*) as total_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() THEN 1 ELSE 0 END) as open_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as this_week,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as this_month,
                        SUM(total_price) as total_revenue,
                        SUM(hotel_supplier_cost) as total_cost,
                        SUM(CASE WHEN hotel_supplier_paid = 'no' THEN hotel_supplier_cost ELSE 0 END) as pending_payment,
                        MIN(order_date) as first_order,
                        MAX(order_date) as last_order,
                        AVG(DATEDIFF(return_date, departure_date)) as avg_nights
                    FROM orders o
                    WHERE hotel_name = ?
                    $dateCondition";
            
            $params = array_merge([$name], $dateParams);
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $stats = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // ספקים נפוצים למלון זה
            $sql2 = "SELECT hotel_supplier as supplier, COUNT(*) as cnt 
                     FROM orders 
                     WHERE hotel_name = ? AND hotel_supplier IS NOT NULL AND hotel_supplier != ''
                     GROUP BY hotel_supplier 
                     ORDER BY cnt DESC 
                     LIMIT 5";
            $stmt2 = $pdo->prepare($sql2);
            $stmt2->execute([$name]);
            $stats['top_suppliers'] = $stmt2->fetchAll(PDO::FETCH_ASSOC);
            break;
            
        case 'destination':
            // סטטיסטיקות יעד
            $sql = "SELECT 
                        COUNT(*) as total_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() THEN 1 ELSE 0 END) as open_orders,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as this_week,
                        SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as this_month,
                        SUM(total_price) as total_revenue,
                        SUM(profit) as total_profit,
                        MIN(order_date) as first_order,
                        MAX(order_date) as last_order,
                        AVG(DATEDIFF(return_date, departure_date)) as avg_nights
                    FROM orders o
                    WHERE (destination LIKE ? OR destination LIKE ?)
                    $dateCondition";
            
            $params = array_merge([$name . '%', '%' . $name . '%'], $dateParams);
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $stats = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // מלונות פופולריים ביעד
            $sql2 = "SELECT hotel_name, COUNT(*) as cnt 
                     FROM orders 
                     WHERE (destination LIKE ? OR destination LIKE ?)
                     AND hotel_name IS NOT NULL AND hotel_name != ''
                     GROUP BY hotel_name 
                     ORDER BY cnt DESC 
                     LIMIT 5";
            $stmt2 = $pdo->prepare($sql2);
            $stmt2->execute([$name . '%', '%' . $name . '%']);
            $stats['top_hotels'] = $stmt2->fetchAll(PDO::FETCH_ASSOC);
            
            // חברות תעופה פופולריות ליעד
            $sql3 = "SELECT airline_outbound as airline, COUNT(*) as cnt 
                     FROM orders 
                     WHERE (destination LIKE ? OR destination LIKE ?)
                     AND airline_outbound IS NOT NULL AND airline_outbound != ''
                     GROUP BY airline_outbound 
                     ORDER BY cnt DESC 
                     LIMIT 5";
            $stmt3 = $pdo->prepare($sql3);
            $stmt3->execute([$name . '%', '%' . $name . '%']);
            $stats['top_airlines'] = $stmt3->fetchAll(PDO::FETCH_ASSOC);
            break;
            
        default:
            echo json_encode(['error' => 'סוג לא תקין']);
            exit;
    }
    
    // המרת null ל-0
    foreach ($stats as $key => $value) {
        if (!is_array($value) && $value === null) {
            $stats[$key] = 0;
        }
    }
    
    echo json_encode([
        'success' => true,
        'type' => $type,
        'name' => $name,
        'stats' => $stats
    ]);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
