<?php
// API - סימון הזמנה כשולמה
// (זמני - יוחלף בחיבור לקארדקום)
require_once '../includes/config.php';

$token = $_POST['token'] ?? '';

if (empty($token)) {
    die('טוקן חסר');
}

try {
    $pdo = getDB();
    
    // עדכון סטטוס ההזמנה
    $stmt = $pdo->prepare("
        UPDATE orders 
        SET status = 'paid', 
            paid_at = NOW(),
            payment_reference = ? 
        WHERE draft_token = ? AND status != 'paid'
    ");
    
    // יצירת מספר אסמכתא זמני
    $reference = 'SIM-' . date('Ymd') . '-' . rand(1000, 9999);
    
    $stmt->execute([$reference, $token]);
    
    if ($stmt->rowCount() > 0) {
        // TODO: שליחת מייל אישור
        // TODO: שליחת הודעה לנציג
    }
    
    // הפניה חזרה לדף הטיוטה
    header('Location: ../draft.php?token=' . $token);
    exit;
    
} catch (Exception $e) {
    die('שגיאה: ' . $e->getMessage());
}
