<?php
// API - סימון תשלום לספק כשולם
header('Content-Type: application/json');

require_once '../includes/auth.php';

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'לא מחובר']);
    exit;
}

// רק מנהל יכול לסמן תשלומים לספקים
$agent = getCurrentAgent();
if ($agent['role'] !== 'admin') {
    echo json_encode(['success' => false, 'error' => 'אין הרשאה']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'שיטה לא נתמכת']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $orderId = (int)($input['order_id'] ?? 0);
    $type = $input['type'] ?? '';
    
    if (!$orderId || !in_array($type, ['flight', 'hotel', 'package'])) {
        throw new Exception('פרמטרים חסרים');
    }
    
    $pdo = getDB();
    
    $columnMap = [
        'flight' => 'flight_supplier_paid',
        'hotel' => 'hotel_supplier_paid',
        'package' => 'package_supplier_paid'
    ];
    
    $column = $columnMap[$type];
    
    $stmt = $pdo->prepare("UPDATE orders SET $column = 'paid' WHERE id = ?");
    $stmt->execute([$orderId]);
    
    echo json_encode(['success' => true]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
