<?php
// API לניהול תוספות להזמנות
require_once '../includes/auth.php';
requireLogin();

header('Content-Type: application/json; charset=utf-8');

$pdo = getDB();
$agent = getCurrentAgent();

// רק מנהל יכול לנהל תוספות
if ($agent['role'] !== 'admin') {
    echo json_encode(['success' => false, 'error' => 'אין הרשאה']);
    exit;
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'add':
            // הוספת תוספת חדשה
            $orderId = (int)$_POST['order_id'];
            $component = $_POST['component']; // flight_outbound, flight_return, hotel
            $description = trim($_POST['description']);
            $amount = (float)$_POST['amount'];
            $currency = $_POST['currency'] ?? 'ILS';
            $customerCharge = (float)($_POST['customer_charge'] ?? 0);
            $isPaid = (int)($_POST['is_paid'] ?? 0);
            
            if (!$orderId || !$component || !$description || $amount <= 0) {
                throw new Exception('חסרים פרטים');
            }
            
            // שליפת שער מטבע עדכני
            $exchangeRate = 1;
            if ($currency !== 'ILS') {
                $stmt = $pdo->prepare("SELECT rate FROM exchange_rates WHERE currency = ?");
                $stmt->execute([$currency]);
                $rate = $stmt->fetchColumn();
                if ($rate) $exchangeRate = (float)$rate;
            }
            
            $amountIls = $amount * $exchangeRate;
            $profit = $customerCharge - $amountIls;
            
            $stmt = $pdo->prepare("INSERT INTO order_additions 
                (order_id, component, description, amount, currency, exchange_rate, amount_ils, customer_charge, profit, is_paid, paid_date, created_by) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $stmt->execute([
                $orderId,
                $component,
                $description,
                $amount,
                $currency,
                $exchangeRate,
                $amountIls,
                $customerCharge,
                $profit,
                $isPaid,
                $isPaid ? date('Y-m-d') : null,
                $agent['id']
            ]);
            
            $additionId = $pdo->lastInsertId();
            
            echo json_encode([
                'success' => true,
                'id' => $additionId,
                'message' => 'התוספת נוספה בהצלחה'
            ]);
            break;
            
        case 'update_paid':
            // עדכון סטטוס תשלום
            $additionId = (int)$_POST['addition_id'];
            $isPaid = (int)$_POST['is_paid'];
            
            $stmt = $pdo->prepare("UPDATE order_additions SET is_paid = ?, paid_date = ? WHERE id = ?");
            $stmt->execute([$isPaid, $isPaid ? date('Y-m-d') : null, $additionId]);
            
            echo json_encode(['success' => true]);
            break;
            
        case 'delete':
            // מחיקת תוספת
            $additionId = (int)$_POST['addition_id'];
            
            $stmt = $pdo->prepare("DELETE FROM order_additions WHERE id = ?");
            $stmt->execute([$additionId]);
            
            echo json_encode(['success' => true]);
            break;
            
        case 'get':
            // שליפת תוספות להזמנה
            $orderId = (int)$_GET['order_id'];
            $component = $_GET['component'] ?? null;
            
            $sql = "SELECT * FROM order_additions WHERE order_id = ?";
            $params = [$orderId];
            
            if ($component) {
                $sql .= " AND component = ?";
                $params[] = $component;
            }
            
            $sql .= " ORDER BY created_at";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $additions = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'additions' => $additions]);
            break;
            
        default:
            throw new Exception('פעולה לא חוקית');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
