<?php
// API - שמירת הזמנה מלאה
header('Content-Type: application/json');

require_once '../includes/auth.php';

// בדיקת התחברות
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'לא מחובר']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'שיטה לא נתמכת']);
    exit;
}

try {
    $pdo = getDB();
    
    // יצירת טוקן ייחודי
    $token = generateToken();
    
    // סוג הזמנה
    $orderType = $_POST['order_type'] ?? 'separate';
    
    // הכנת הנתונים
    $data = [
        'draft_token' => $token,
        'agent_id' => $_SESSION['agent_id'],
        'order_type' => $orderType,
        'order_date' => $_POST['order_date'],
        'customer_phone' => sanitize($_POST['customer_phone']),
        'customer_email' => sanitize($_POST['customer_email'] ?? ''),
        'passengers' => $_POST['passengers'] ?? '[]',
        'destination' => sanitize($_POST['destination']),
        'departure_date' => $_POST['departure_date'] ?: null,
        'return_date' => $_POST['return_date'] ?: null,
        'airline_outbound' => sanitize($_POST['airline_outbound'] ?? ''),
        'flight_number_outbound' => sanitize($_POST['flight_number_outbound'] ?? ''),
        'flight_time_outbound' => $_POST['flight_time_outbound'] ?: null,
        'booking_code_outbound' => sanitize($_POST['booking_code_outbound'] ?? ''),
        'airline_return' => sanitize($_POST['airline_return'] ?? ''),
        'flight_number_return' => sanitize($_POST['flight_number_return'] ?? ''),
        'flight_time_return' => $_POST['flight_time_return'] ?: null,
        'booking_code_return' => sanitize($_POST['booking_code_return'] ?? ''),
        // ספק טיסה
        'flight_supplier' => sanitize($_POST['flight_supplier'] ?? ''),
        'flight_supplier_booking' => sanitize($_POST['flight_supplier_booking'] ?? ''),
        'flight_supplier_cost' => (float)($_POST['flight_supplier_cost'] ?? 0),
        'flight_supplier_currency' => $_POST['flight_supplier_currency'] ?? 'ILS',
        'flight_supplier_paid' => $_POST['flight_supplier_paid'] ?? 'paid',
        // מלון
        'hotel_name' => sanitize($_POST['hotel_name'] ?? ''),
        'hotel_checkin' => $_POST['hotel_checkin'] ?: null,
        'hotel_checkout' => $_POST['hotel_checkout'] ?: null,
        'room_type' => sanitize($_POST['room_type'] ?? ''),
        'hotel_confirmation' => sanitize($_POST['hotel_confirmation'] ?? ''),
        'meal_basis' => $_POST['meal_basis'] ?? 'BB',
        // ספק מלון
        'hotel_supplier' => sanitize($_POST['hotel_supplier'] ?? ''),
        'hotel_supplier_booking' => sanitize($_POST['hotel_supplier_booking'] ?? ''),
        'hotel_supplier_cost' => (float)($_POST['hotel_supplier_cost'] ?? 0),
        'hotel_supplier_currency' => $_POST['hotel_supplier_currency'] ?? 'ILS',
        'hotel_supplier_paid' => $_POST['hotel_supplier_paid'] ?? 'paid',
        // ספק חבילה (נופשון/טיול מאורגן)
        'package_supplier' => sanitize($_POST['package_supplier'] ?? ''),
        'package_supplier_booking' => sanitize($_POST['package_supplier_booking'] ?? ''),
        'package_supplier_cost' => (float)($_POST['package_supplier_cost'] ?? 0),
        'package_supplier_currency' => $_POST['package_supplier_currency'] ?? 'ILS',
        'package_supplier_paid' => $_POST['package_supplier_paid'] ?? 'paid',
        // כללי
        'luggage_details' => sanitize($_POST['luggage_details'] ?? ''),
        'total_price' => (float)$_POST['total_price'],
        'profit' => (float)($_POST['profit'] ?? 0),
        'usd_rate' => (float)($_POST['usd_rate'] ?? 3.65),
        'eur_rate' => (float)($_POST['eur_rate'] ?? 3.95),
        'payments' => $_POST['payments'] ?? '[]',
        'deal_builder' => sanitize($_POST['deal_builder'] ?? ''),
        'notes' => sanitize($_POST['notes'] ?? ''),
        'status' => 'confirmed'
    ];
    
    // בדיקה אם יש תשלומים בהעברה בנקאית
    $payments = json_decode($data['payments'], true);
    $hasBankTransfer = false;
    if (is_array($payments)) {
        foreach ($payments as $payment) {
            if (isset($payment['method']) && $payment['method'] === 'העברה בנקאית') {
                $hasBankTransfer = true;
                break;
            }
        }
    }
    
    // שמירה בדאטאבייס
    $sql = "INSERT INTO orders (
        draft_token, agent_id, order_type, order_date, customer_phone, customer_email, 
        passengers, destination, departure_date, return_date,
        airline_outbound, flight_number_outbound, flight_time_outbound, booking_code_outbound, 
        airline_return, flight_number_return, flight_time_return, booking_code_return,
        flight_supplier, flight_supplier_booking, flight_supplier_cost, flight_supplier_currency, flight_supplier_paid,
        hotel_name, hotel_checkin, hotel_checkout, room_type, hotel_confirmation, meal_basis,
        hotel_supplier, hotel_supplier_booking, hotel_supplier_cost, hotel_supplier_currency, hotel_supplier_paid,
        package_supplier, package_supplier_booking, package_supplier_cost, package_supplier_currency, package_supplier_paid,
        luggage_details, total_price, profit, usd_rate, eur_rate, payments, deal_builder, notes, status
    ) VALUES (
        :draft_token, :agent_id, :order_type, :order_date, :customer_phone, :customer_email,
        :passengers, :destination, :departure_date, :return_date,
        :airline_outbound, :flight_number_outbound, :flight_time_outbound, :booking_code_outbound,
        :airline_return, :flight_number_return, :flight_time_return, :booking_code_return,
        :flight_supplier, :flight_supplier_booking, :flight_supplier_cost, :flight_supplier_currency, :flight_supplier_paid,
        :hotel_name, :hotel_checkin, :hotel_checkout, :room_type, :hotel_confirmation, :meal_basis,
        :hotel_supplier, :hotel_supplier_booking, :hotel_supplier_cost, :hotel_supplier_currency, :hotel_supplier_paid,
        :package_supplier, :package_supplier_booking, :package_supplier_cost, :package_supplier_currency, :package_supplier_paid,
        :luggage_details, :total_price, :profit, :usd_rate, :eur_rate, :payments, :deal_builder, :notes, :status
    )";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($data);
    
    $orderId = $pdo->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'order_id' => $orderId,
        'token' => $token,
        'has_bank_transfer' => $hasBankTransfer
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
