<?php
// API - שמירת הזמנה לייט (עם קבצים)
header('Content-Type: application/json');

require_once '../includes/auth.php';

// בדיקת התחברות
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'לא מחובר']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'שיטה לא נתמכת']);
    exit;
}

try {
    $pdo = getDB();
    
    // יצירת טוקן ייחודי
    $token = generateToken();
    
    // תיקייה לשמירת קבצים
    $uploadDirRelative = 'uploads/vouchers/' . date('Y/m/');  // נתיב יחסי ל-root (בלי ../)
    $uploadDirFull = __DIR__ . '/../' . $uploadDirRelative;   // נתיב מלא בשרת
    
    if (!file_exists($uploadDirFull)) {
        mkdir($uploadDirFull, 0755, true);
    }
    
    // שמירת קבצים מ-base64
    $voucherFiles = [];
    
    // פונקציה לשמירת קובץ מ-base64
    function saveBase64File($base64Data, $uploadDirFull, $uploadDirRelative, $prefix) {
        if (empty($base64Data) || strpos($base64Data, 'data:') !== 0) {
            return null;
        }
        
        // חילוץ הסוג והנתונים
        preg_match('/data:([^;]+);base64,(.+)/', $base64Data, $matches);
        if (count($matches) !== 3) {
            return null;
        }
        
        $mimeType = $matches[1];
        $data = base64_decode($matches[2]);
        
        // קביעת סיומת הקובץ
        $extensions = [
            'image/jpeg' => 'jpg',
            'image/png' => 'png',
            'image/gif' => 'gif',
            'image/webp' => 'webp',
            'application/pdf' => 'pdf'
        ];
        $ext = $extensions[$mimeType] ?? 'bin';
        
        // שם קובץ ייחודי
        $filename = $prefix . '_' . uniqid() . '.' . $ext;
        $filepathFull = $uploadDirFull . $filename;
        $filepathRelative = $uploadDirRelative . $filename;  // בלי ../
        
        // שמירה
        if (file_put_contents($filepathFull, $data)) {
            return $filepathRelative;
        }
        
        return null;
    }
    
    // בדיקה אם יש הפרדה בין טיסות
    $hasReturnFlight = !empty($_POST['voucher_return_data']);
    
    // שמירת אישור טיסת הלוך (או "אישור טיסה" אם אין הפרדה)
    if (!empty($_POST['voucher_outbound_data'])) {
        $path = saveBase64File($_POST['voucher_outbound_data'], $uploadDirFull, $uploadDirRelative, 'flight_out');
        if ($path) {
            $label = $hasReturnFlight ? 'אישור טיסת הלוך' : 'אישור טיסה';
            $voucherFiles[] = ['type' => 'flight_outbound', 'path' => $path, 'label' => $label];
        }
    }
    
    // שמירת אישור טיסת חזור (רק אם יש הפרדה)
    if ($hasReturnFlight) {
        $path = saveBase64File($_POST['voucher_return_data'], $uploadDirFull, $uploadDirRelative, 'flight_ret');
        if ($path) {
            $voucherFiles[] = ['type' => 'flight_return', 'path' => $path, 'label' => 'אישור טיסת חזור'];
        }
    }
    
    // שמירת אישור מלון
    if (!empty($_POST['voucher_hotel_data'])) {
        $path = saveBase64File($_POST['voucher_hotel_data'], $uploadDirFull, $uploadDirRelative, 'hotel');
        if ($path) {
            $voucherFiles[] = ['type' => 'hotel', 'path' => $path, 'label' => 'אישור מלון'];
        }
    }
    
    // שמירת אישורי שונות (extras)
    $extraIndex = 1;
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'voucher_extra_') === 0 && strpos($key, '_data') !== false) {
            $path = saveBase64File($value, $uploadDirFull, $uploadDirRelative, 'extra_' . $extraIndex);
            if ($path) {
                $description = $_POST['extra_description'][$extraIndex - 1] ?? 'פריט נוסף ' . $extraIndex;
                $voucherFiles[] = ['type' => 'extra', 'path' => $path, 'label' => $description];
                $extraIndex++;
            }
        }
    }
    
    // הכנת הנתונים
    $data = [
        'draft_token' => $token,
        'agent_id' => $_SESSION['agent_id'],
        'order_type' => 'separate',
        'order_date' => $_POST['order_date'] ?? date('Y-m-d'),
        'customer_phone' => sanitize($_POST['customer_phone'] ?? ''),
        'customer_email' => sanitize($_POST['customer_email'] ?? ''),
        'passengers' => $_POST['passengers'] ?? '[]',
        'destination' => sanitize($_POST['destination'] ?? ''),
        'departure_date' => $_POST['departure_date'] ?: null,
        'return_date' => $_POST['return_date'] ?: null,
        'airline_outbound' => sanitize($_POST['airline_outbound'] ?? ''),
        'booking_code_outbound' => sanitize($_POST['booking_code_outbound'] ?? ''),
        'airline_return' => sanitize($_POST['airline_return'] ?? ''),
        'booking_code_return' => sanitize($_POST['booking_code_return'] ?? ''),
        'return_flight_supplier' => sanitize($_POST['return_flight_supplier'] ?? $_POST['flight_supplier'] ?? ''),
        'return_flight_supplier_cost' => (float)($_POST['return_flight_supplier_cost'] ?? 0),
        'return_flight_supplier_currency' => $_POST['return_flight_supplier_currency'] ?? 'ILS',
        'return_flight_supplier_paid' => $_POST['return_flight_supplier_paid'] ?? 'unpaid',
        'flight_supplier' => sanitize($_POST['flight_supplier'] ?? ''),
        'flight_supplier_cost' => (float)($_POST['flight_supplier_cost'] ?? 0),
        'flight_supplier_currency' => $_POST['flight_supplier_currency'] ?? 'ILS',
        'flight_supplier_paid' => $_POST['flight_supplier_paid'] ?? 'unpaid',
        'hotel_supplier' => sanitize($_POST['hotel_supplier'] ?? ''),
        'hotel_supplier_booking' => sanitize($_POST['hotel_booking_code'] ?? ''),
        'hotel_supplier_cost' => (float)($_POST['hotel_supplier_cost'] ?? 0),
        'hotel_supplier_currency' => $_POST['hotel_supplier_currency'] ?? 'ILS',
        'hotel_supplier_paid' => $_POST['hotel_supplier_paid'] ?? 'unpaid',
        'luggage_details' => sanitize($_POST['luggage_details'] ?? ''),
        'total_price' => (float)($_POST['total_price'] ?? 0),
        'profit' => (float)($_POST['profit'] ?? 0),
        'usd_rate' => (float)($_POST['usd_rate'] ?? 3.65),
        'eur_rate' => (float)($_POST['eur_rate'] ?? 3.95),
        'payments' => $_POST['payments'] ?? '[]',
        'extras' => $_POST['extras'] ?? '[]',
        'email_text' => $_POST['email_text'] ?? '',
        'notes' => sanitize($_POST['notes'] ?? ''),
        'status' => 'confirmed'
    ];
    
    // שמירה בדאטאבייס
    $sql = "INSERT INTO orders (
        draft_token, agent_id, order_type, order_date, customer_phone, customer_email, 
        passengers, destination, departure_date, return_date,
        airline_outbound, booking_code_outbound, 
        airline_return, booking_code_return,
        return_flight_supplier, return_flight_supplier_cost, return_flight_supplier_currency, return_flight_supplier_paid,
        flight_supplier, flight_supplier_cost, flight_supplier_currency, flight_supplier_paid,
        hotel_supplier, hotel_supplier_booking, hotel_supplier_cost, hotel_supplier_currency, hotel_supplier_paid,
        luggage_details, total_price, profit, usd_rate, eur_rate, payments, extras, email_text, notes, status
    ) VALUES (
        :draft_token, :agent_id, :order_type, :order_date, :customer_phone, :customer_email,
        :passengers, :destination, :departure_date, :return_date,
        :airline_outbound, :booking_code_outbound,
        :airline_return, :booking_code_return,
        :return_flight_supplier, :return_flight_supplier_cost, :return_flight_supplier_currency, :return_flight_supplier_paid,
        :flight_supplier, :flight_supplier_cost, :flight_supplier_currency, :flight_supplier_paid,
        :hotel_supplier, :hotel_supplier_booking, :hotel_supplier_cost, :hotel_supplier_currency, :hotel_supplier_paid,
        :luggage_details, :total_price, :profit, :usd_rate, :eur_rate, :payments, :extras, :email_text, :notes, :status
    )";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'draft_token' => $data['draft_token'],
        'agent_id' => $data['agent_id'],
        'order_type' => $data['order_type'],
        'order_date' => $data['order_date'],
        'customer_phone' => $data['customer_phone'],
        'customer_email' => $data['customer_email'],
        'passengers' => $data['passengers'],
        'destination' => $data['destination'],
        'departure_date' => $data['departure_date'],
        'return_date' => $data['return_date'],
        'airline_outbound' => $data['airline_outbound'],
        'booking_code_outbound' => $data['booking_code_outbound'],
        'airline_return' => $data['airline_return'],
        'booking_code_return' => $data['booking_code_return'],
        'return_flight_supplier' => $data['return_flight_supplier'],
        'return_flight_supplier_cost' => $data['return_flight_supplier_cost'],
        'return_flight_supplier_currency' => $data['return_flight_supplier_currency'],
        'return_flight_supplier_paid' => $data['return_flight_supplier_paid'],
        'flight_supplier' => $data['flight_supplier'],
        'flight_supplier_cost' => $data['flight_supplier_cost'],
        'flight_supplier_currency' => $data['flight_supplier_currency'],
        'flight_supplier_paid' => $data['flight_supplier_paid'],
        'hotel_supplier' => $data['hotel_supplier'],
        'hotel_supplier_booking' => $data['hotel_supplier_booking'],
        'hotel_supplier_cost' => $data['hotel_supplier_cost'],
        'hotel_supplier_currency' => $data['hotel_supplier_currency'],
        'hotel_supplier_paid' => $data['hotel_supplier_paid'],
        'luggage_details' => $data['luggage_details'],
        'total_price' => $data['total_price'],
        'profit' => $data['profit'],
        'usd_rate' => $data['usd_rate'],
        'eur_rate' => $data['eur_rate'],
        'payments' => $data['payments'],
        'extras' => $data['extras'],
        'email_text' => $data['email_text'],
        'notes' => $data['notes'],
        'status' => $data['status']
    ]);
    
    $orderId = $pdo->lastInsertId();
    
    // עדכון הטיוטה עם מספר ההזמנה (אם יש)
    $draftId = $_POST['draft_id'] ?? null;
    if ($draftId) {
        $pdo->prepare("UPDATE drafts SET order_id = ? WHERE id = ?")->execute([$orderId, $draftId]);
        
        // עדכון גם בטבלת bank_transfers אם יש העברות בנקאיות לטיוטה הזו
        try {
            $pdo->prepare("UPDATE bank_transfers SET order_id = ? WHERE draft_id = ?")->execute([$orderId, $draftId]);
        } catch (Exception $e) {
            // אם אין טבלה או שגיאה - ממשיכים
        }
    }
    
    // שמירת קבצי הוואצ'ר בקובץ JSON
    if (!empty($voucherFiles)) {
        $voucherDataFile = $uploadDirFull . 'order_' . $orderId . '_files.json';
        file_put_contents($voucherDataFile, json_encode([
            'order_id' => $orderId,
            'token' => $token,
            'files' => $voucherFiles,
            'created_at' => date('Y-m-d H:i:s')
        ]));
    }
    
    echo json_encode([
        'success' => true,
        'order_id' => $orderId,
        'token' => $token,
        'files_count' => count($voucherFiles)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
