<?php
// שליחת אישור הזמנה למייל הלקוח
require_once '../includes/auth.php';
requireLogin();

header('Content-Type: application/json; charset=utf-8');

$pdo = getDB();

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $orderId = $input['order_id'] ?? null;
    
    if (!$orderId) {
        throw new Exception('חסר מזהה הזמנה');
    }
    
    // שליפת ההזמנה
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order) {
        throw new Exception('הזמנה לא נמצאה');
    }
    
    $customerEmail = $order['customer_email'];
    if (!$customerEmail) {
        throw new Exception('אין כתובת מייל להזמנה זו');
    }
    
    $passengers = json_decode($order['passengers'] ?? '[]', true);
    $passengersList = implode(', ', $passengers);
    
    // בניית גוף המייל
    $subject = "אישור הזמנה #{$order['id']} - חופשה במבצע ✈️";
    
    $body = "
<!DOCTYPE html>
<html dir='rtl' lang='he'>
<head>
    <meta charset='UTF-8'>
    <style>
        body { font-family: Arial, sans-serif; direction: rtl; background: #f5f5f5; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .content { padding: 30px; }
        .detail-row { display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #eee; }
        .detail-label { color: #666; }
        .detail-value { font-weight: bold; }
        .highlight { color: #667eea; font-size: 1.2em; }
        .section { margin: 20px 0; padding: 15px; background: #f8f9fa; border-radius: 8px; }
        .section h3 { margin-top: 0; color: #333; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; font-size: 14px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>✈️ אישור הזמנה #{$order['id']}</h1>
        </div>
        <div class='content'>
            <p>שלום,</p>
            <p>תודה שבחרת בחופשה במבצע! להלן פרטי ההזמנה שלך:</p>
            
            <div class='section'>
                <h3>🌍 פרטי הטיול</h3>
                <div class='detail-row'>
                    <span class='detail-label'>יעד:</span>
                    <span class='detail-value highlight'>{$order['destination']}</span>
                </div>
                <div class='detail-row'>
                    <span class='detail-label'>תאריך יציאה:</span>
                    <span class='detail-value'>" . date('d/m/Y', strtotime($order['departure_date'])) . "</span>
                </div>
                <div class='detail-row'>
                    <span class='detail-label'>תאריך חזרה:</span>
                    <span class='detail-value'>" . date('d/m/Y', strtotime($order['return_date'])) . "</span>
                </div>
            </div>
            
            <div class='section'>
                <h3>👥 נוסעים</h3>
                <p>{$passengersList}</p>
            </div>
            
            <div class='section'>
                <h3>✈️ פרטי טיסה</h3>
                <div class='detail-row'>
                    <span class='detail-label'>חברת תעופה:</span>
                    <span class='detail-value'>{$order['airline_outbound']}</span>
                </div>
                " . ($order['booking_code_outbound'] ? "<div class='detail-row'>
                    <span class='detail-label'>קוד הזמנה הלוך:</span>
                    <span class='detail-value highlight'>{$order['booking_code_outbound']}</span>
                </div>" : "") . "
                " . ($order['booking_code_return'] ? "<div class='detail-row'>
                    <span class='detail-label'>קוד הזמנה חזור:</span>
                    <span class='detail-value highlight'>{$order['booking_code_return']}</span>
                </div>" : "") . "
            </div>
            
            <p style='margin-top:30px;'>לשאלות ובירורים, אנחנו כאן בשבילך!</p>
            <p>בברכה,<br><strong>חופשה במבצע</strong></p>
        </div>
        <div class='footer'>
            חופשה במבצע - החופשה שלך מתחילה כאן! 🌴
        </div>
    </div>
</body>
</html>";
    
    // שליפת פרטי ה-agent שיצר את ההזמנה
    $agentEmail = null;
    $agentSendFrom = null;
    $agentName = null;
    if (!empty($order['agent_id'])) {
        try {
            $stmtAgent = $pdo->prepare("SELECT email, send_from_email, full_name FROM agents WHERE id = ?");
            $stmtAgent->execute([$order['agent_id']]);
            $agentData = $stmtAgent->fetch(PDO::FETCH_ASSOC);
            if ($agentData) {
                $agentEmail = $agentData['email'] ?? null;
                $agentSendFrom = $agentData['send_from_email'] ?? null;
                $agentName = $agentData['full_name'] ?? null;
            }
        } catch (Exception $e) {
            // fallback אם העמודה לא קיימת
            $stmtAgent = $pdo->prepare("SELECT email, full_name FROM agents WHERE id = ?");
            $stmtAgent->execute([$order['agent_id']]);
            $agentData = $stmtAgent->fetch(PDO::FETCH_ASSOC);
            if ($agentData) {
                $agentEmail = $agentData['email'] ?? null;
                $agentName = $agentData['full_name'] ?? null;
            }
        }
    }
    
    // שימוש באימייל הנציג אם קיים
    $fromEmail = (!empty($agentSendFrom) && filter_var($agentSendFrom, FILTER_VALIDATE_EMAIL)) 
        ? $agentSendFrom 
        : 'orders@holidayinsale.com';
    $fromName = !empty($agentName) ? $agentName . ' - חופשה במבצע' : 'חופשה במבצע';
    
    // שליחת המייל
    $headers = [
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: =?UTF-8?B?' . base64_encode($fromName) . '?= <' . $fromEmail . '>',
        'Reply-To: ' . $fromEmail
    ];
    
    // הוספת CC ל-agent
    if (!empty($agentEmail) && filter_var($agentEmail, FILTER_VALIDATE_EMAIL)) {
        $headers[] = 'Cc: ' . $agentEmail;
    }
    
    $sent = mail($customerEmail, $subject, $body, implode("\r\n", $headers));
    
    if ($sent) {
        echo json_encode([
            'success' => true,
            'message' => 'אישור נשלח ל-' . $customerEmail
        ]);
    } else {
        throw new Exception('שגיאה בשליחת המייל');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
