<?php
// עדכון שדה בודד בהזמנה - AJAX
require_once '../includes/auth.php';
requireLogin();

header('Content-Type: application/json; charset=utf-8');

// רק מנהל יכול לערוך הזמנות
$agent = getCurrentAgent();
if ($agent['role'] !== 'admin') {
    echo json_encode(['success' => false, 'error' => 'אין הרשאה לעריכת הזמנות']);
    exit;
}

$pdo = getDB();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

try {
    $orderId = $_POST['order_id'] ?? null;
    $field = $_POST['field'] ?? null;
    $value = $_POST['value'] ?? '';
    $table = $_POST['table'] ?? 'orders'; // ברירת מחדל: orders
    $rowId = $_POST['row_id'] ?? null; // מזהה שורה ספציפית (למלונות)
    
    if (!$orderId || !$field) {
        throw new Exception('חסרים פרמטרים');
    }
    
    // טיפול בטבלת order_hotels
    if ($table === 'order_hotels') {
        if (!$rowId) {
            throw new Exception('חסר מזהה מלון');
        }
        
        $allowedHotelFields = [
            'supplier', 'confirmation_code', 'supplier_cost', 'supplier_currency', 'supplier_paid'
        ];
        
        if (!in_array($field, $allowedHotelFields)) {
            throw new Exception('שדה לא מורשה לעריכה');
        }
        
        // וידוא שהמלון קיים ושייך להזמנה
        $stmt = $pdo->prepare("SELECT id FROM order_hotels WHERE id = ? AND order_id = ?");
        $stmt->execute([$rowId, $orderId]);
        if (!$stmt->fetch()) {
            throw new Exception('מלון לא נמצא');
        }
        
        // סניטציה
        if ($field === 'supplier_cost') {
            $value = floatval(str_replace(',', '', $value));
        } elseif ($field === 'supplier_paid') {
            $value = ($value === 'paid' || $value === '1' || $value === 'true') ? 'paid' : 'unpaid';
        } elseif ($field === 'supplier') {
            // וידוא שהספק תקין
            if (!in_array($value, ['DIRECT', 'ORANGE', 'YELLOW', 'BLUE'])) {
                $value = 'DIRECT';
            }
        } else {
            $value = htmlspecialchars(trim($value), ENT_QUOTES, 'UTF-8');
        }
        
        // עדכון
        $sql = "UPDATE order_hotels SET `$field` = ?, updated_at = NOW() WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$value, $rowId]);
        
        // ערך להצגה
        $displayValue = $value;
        if ($field === 'supplier_cost') {
            $displayValue = number_format($value, 2);
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'השדה עודכן בהצלחה',
            'value' => $value,
            'display_value' => $displayValue
        ]);
        exit;
    }
    
    // רשימת שדות מותרים לעריכה (טבלת orders)
    $allowedFields = [
        // פרטי הזמנה
        'destination', 'departure_date', 'return_date', 'order_date',
        // פרטי לקוח
        'customer_phone', 'customer_email',
        // נוסעים
        'passengers',
        // טיסת הלוך
        'flight_supplier', 'airline_outbound', 'booking_code_outbound',
        'flight_supplier_cost', 'flight_supplier_currency', 'flight_supplier_paid',
        // טיסת חזור
        'return_flight_supplier', 'airline_return', 'booking_code_return',
        'return_flight_supplier_cost', 'return_flight_supplier_currency', 'return_flight_supplier_paid',
        // מלון
        'hotel_supplier', 'hotel_supplier_booking',
        'hotel_supplier_cost', 'hotel_supplier_currency', 'hotel_supplier_paid',
        // שונות
        'luggage_details', 'notes', 'total_price', 'profit',
        // נציג ובונה הדיל
        'agent_id', 'deal_builder'
    ];
    
    if (!in_array($field, $allowedFields)) {
        throw new Exception('שדה לא מורשה לעריכה');
    }
    
    // וידוא שההזמנה קיימת
    $stmt = $pdo->prepare("SELECT id FROM orders WHERE id = ?");
    $stmt->execute([$orderId]);
    if (!$stmt->fetch()) {
        throw new Exception('הזמנה לא נמצאה');
    }
    
    // סניטציה לפי סוג שדה
    if (in_array($field, ['departure_date', 'return_date', 'order_date'])) {
        // תאריכים - המרה לפורמט DB
        if ($value) {
            // אם התאריך בפורמט dd/mm/yyyy, המר ל-yyyy-mm-dd
            if (preg_match('/^(\d{2})\/(\d{2})\/(\d{4})$/', $value, $m)) {
                $value = $m[3] . '-' . $m[2] . '-' . $m[1];
            }
        }
    } elseif (in_array($field, ['flight_supplier_cost', 'return_flight_supplier_cost', 'hotel_supplier_cost', 'total_price', 'profit'])) {
        // מספרים
        $value = floatval(str_replace(',', '', $value));
    } elseif ($field === 'passengers') {
        // נוסעים - JSON - לא לעשות sanitize
        if (is_string($value)) {
            // וידוא שזה JSON תקין
            $decoded = json_decode($value, true);
            if (json_last_error() === JSON_ERROR_NONE) {
                $value = $value; // השאר כמו שזה
            } else {
                // אם זה לא JSON, הפוך למערך
                $value = json_encode([$value], JSON_UNESCAPED_UNICODE);
            }
        } else {
            $value = json_encode($value, JSON_UNESCAPED_UNICODE);
        }
    } elseif (in_array($field, ['flight_supplier_paid', 'return_flight_supplier_paid', 'hotel_supplier_paid'])) {
        // סטטוס תשלום
        $value = ($value === 'paid' || $value === '1' || $value === 'true') ? 'paid' : 'unpaid';
    } elseif ($field === 'agent_id') {
        // נציג - חיפוש לפי שם
        $stmt = $pdo->prepare("SELECT id FROM agents WHERE full_name = ?");
        $stmt->execute([$value]);
        $agentRow = $stmt->fetch();
        if ($agentRow) {
            $value = $agentRow['id'];
        } else {
            throw new Exception('נציג לא נמצא');
        }
    } else {
        // טקסט רגיל
        $value = htmlspecialchars(trim($value), ENT_QUOTES, 'UTF-8');
    }
    
    // עדכון השדה
    $sql = "UPDATE orders SET `$field` = ?, updated_at = NOW() WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$value, $orderId]);
    
    // החזרת הערך המעודכן (לעדכון ה-UI)
    $displayValue = $value;
    if (in_array($field, ['departure_date', 'return_date', 'order_date']) && $value) {
        $displayValue = date('d/m/Y', strtotime($value));
    } elseif (in_array($field, ['flight_supplier_cost', 'return_flight_supplier_cost', 'hotel_supplier_cost'])) {
        $displayValue = number_format($value, 2);
    } elseif ($field === 'agent_id') {
        // החזרת שם הנציג
        $stmt = $pdo->prepare("SELECT full_name FROM agents WHERE id = ?");
        $stmt->execute([$value]);
        $agentRow = $stmt->fetch();
        $displayValue = $agentRow ? $agentRow['full_name'] : $value;
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'השדה עודכן בהצלחה',
        'value' => $value,
        'display_value' => $displayValue
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}