<?php
// צפייה בלוג קארדקום
$logFile = __DIR__ . '/logs/cardcom_callback_' . date('Y-m-d') . '.log';

echo "<h2>Cardcom Callback Log</h2>";

if (file_exists($logFile)) {
    $content = file_get_contents($logFile);
    echo "<pre style='background:#f5f5f5; padding:15px; direction:ltr; text-align:left;'>";
    echo htmlspecialchars($content);
    echo "</pre>";
} else {
    echo "<p>No log file found for today: $logFile</p>";
    
    // חפש לוגים אחרים
    $logsDir = __DIR__ . '/logs/';
    if (is_dir($logsDir)) {
        echo "<p>Available logs:</p><ul>";
        foreach (glob($logsDir . "cardcom_*.log") as $file) {
            echo "<li>" . basename($file) . "</li>";
        }
        echo "</ul>";
    }
}
?>
