<?php
// סיום תוספת וקישור להזמנה מקורית + עדכון כבודה + עדכון חוב ספק
require_once 'includes/auth.php';
requireLogin();

header('Content-Type: application/json');

$pdo = getDB();

try {
    $draftId = $_POST['draft_id'] ?? null;
    $parentOrderId = $_POST['parent_order_id'] ?? null;
    
    if (!$draftId || !$parentOrderId) {
        throw new Exception('חסרים פרטים');
    }
    
    // שליפת הטיוטה
    $stmt = $pdo->prepare("SELECT * FROM drafts WHERE id = ? AND parent_order_id = ?");
    $stmt->execute([$draftId, $parentOrderId]);
    $draft = $stmt->fetch();
    
    if (!$draft) {
        throw new Exception('טיוטה לא נמצאה');
    }
    
    if ($draft['status'] !== 'paid') {
        throw new Exception('הטיוטה עדיין לא שולמה');
    }
    
    // שליפת ההזמנה המקורית
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$parentOrderId]);
    $parentOrder = $stmt->fetch();
    
    if (!$parentOrder) {
        throw new Exception('הזמנה מקורית לא נמצאה');
    }
    
    // פענוח המידע מה-notes
    $notesData = json_decode($draft['notes'], true);
    $luggageUpdated = false;
    $supplierDebtAdded = false;
    
    // טיפול בכבודה
    if ($notesData && isset($notesData['type']) && $notesData['type'] === 'luggage_addon') {
        $luggageAdditions = $notesData['luggage_data'] ?? [];
        
        // שליפת הכבודה הקיימת
        $currentLuggage = json_decode(html_entity_decode($parentOrder['luggage_details'] ?? '[]'), true) ?: [];
        
        // עדכון הכבודה לפי התוספות
        foreach ($luggageAdditions as $addition) {
            $passengerName = $addition['name'];
            $direction = $addition['direction'] ?? 'both'; // both, outbound, return
            
            // מציאת הנוסע במערך הקיים
            $foundIndex = -1;
            foreach ($currentLuggage as $idx => $passenger) {
                if ($passenger['name'] === $passengerName) {
                    $foundIndex = $idx;
                    break;
                }
            }
            
            if ($foundIndex >= 0) {
                $passenger = &$currentLuggage[$foundIndex];
                
                // בדיקה אם צריך להמיר לפורמט נפרד
                $isSameBothWays = !isset($passenger['same_both_ways']) || $passenger['same_both_ways'];
                
                if ($direction !== 'both' && $isSameBothWays) {
                    // צריך להמיר לפורמט נפרד
                    $oldTrolley = $passenger['trolley'] ?? 0;
                    $oldSuitcase = $passenger['suitcase'] ?? 0;
                    $oldBackpack = $passenger['backpack'] ?? false;
                    
                    $passenger = [
                        'name' => $passengerName,
                        'same_both_ways' => false,
                        'outbound' => [
                            'trolley' => $oldTrolley,
                            'suitcase' => $oldSuitcase,
                            'backpack' => $oldBackpack
                        ],
                        'return' => [
                            'trolley' => $oldTrolley,
                            'suitcase' => $oldSuitcase,
                            'backpack' => $oldBackpack
                        ]
                    ];
                }
                
                // עדכון לפי כיוון
                if ($isSameBothWays && $direction === 'both') {
                    // פורמט ישן - עדכון רגיל
                    if (!empty($addition['add_trolley'])) {
                        $passenger['trolley'] = intval($passenger['trolley'] ?? 0) + intval($addition['add_trolley']);
                    }
                    if (!empty($addition['add_suitcase'])) {
                        $passenger['suitcase'] = intval($passenger['suitcase'] ?? 0) + intval($addition['add_suitcase']);
                    }
                    if (!empty($addition['add_backpack'])) {
                        $passenger['backpack'] = true;
                    }
                } else {
                    // פורמט נפרד
                    $passenger['same_both_ways'] = false;
                    
                    if ($direction === 'both' || $direction === 'outbound') {
                        if (!isset($passenger['outbound'])) {
                            $passenger['outbound'] = ['trolley' => 0, 'suitcase' => 0, 'backpack' => false];
                        }
                        if (!empty($addition['add_trolley'])) {
                            $passenger['outbound']['trolley'] = intval($passenger['outbound']['trolley'] ?? 0) + intval($addition['add_trolley']);
                        }
                        if (!empty($addition['add_suitcase'])) {
                            $passenger['outbound']['suitcase'] = intval($passenger['outbound']['suitcase'] ?? 0) + intval($addition['add_suitcase']);
                        }
                        if (!empty($addition['add_backpack'])) {
                            $passenger['outbound']['backpack'] = true;
                        }
                    }
                    
                    if ($direction === 'both' || $direction === 'return') {
                        if (!isset($passenger['return'])) {
                            $passenger['return'] = ['trolley' => 0, 'suitcase' => 0, 'backpack' => false];
                        }
                        if (!empty($addition['add_trolley'])) {
                            $passenger['return']['trolley'] = intval($passenger['return']['trolley'] ?? 0) + intval($addition['add_trolley']);
                        }
                        if (!empty($addition['add_suitcase'])) {
                            $passenger['return']['suitcase'] = intval($passenger['return']['suitcase'] ?? 0) + intval($addition['add_suitcase']);
                        }
                        if (!empty($addition['add_backpack'])) {
                            $passenger['return']['backpack'] = true;
                        }
                    }
                }
                
                $currentLuggage[$foundIndex] = $passenger;
                
            } else {
                // נוסע חדש
                if ($direction === 'both') {
                    $currentLuggage[] = [
                        'name' => $passengerName,
                        'same_both_ways' => true,
                        'trolley' => intval($addition['add_trolley'] ?? 0),
                        'suitcase' => intval($addition['add_suitcase'] ?? 0),
                        'backpack' => !empty($addition['add_backpack'])
                    ];
                } else {
                    $outbound = ['trolley' => 0, 'suitcase' => 0, 'backpack' => false];
                    $return = ['trolley' => 0, 'suitcase' => 0, 'backpack' => false];
                    
                    $addData = [
                        'trolley' => intval($addition['add_trolley'] ?? 0),
                        'suitcase' => intval($addition['add_suitcase'] ?? 0),
                        'backpack' => !empty($addition['add_backpack'])
                    ];
                    
                    if ($direction === 'outbound') $outbound = $addData;
                    if ($direction === 'return') $return = $addData;
                    
                    $currentLuggage[] = [
                        'name' => $passengerName,
                        'same_both_ways' => false,
                        'outbound' => $outbound,
                        'return' => $return
                    ];
                }
            }
        }
        
        // שמירת הכבודה המעודכנת בהזמנה
        $stmt = $pdo->prepare("UPDATE orders SET luggage_details = ? WHERE id = ?");
        $stmt->execute([json_encode($currentLuggage, JSON_UNESCAPED_UNICODE), $parentOrderId]);
        $luggageUpdated = true;
    }
    
    // הוספת חוב לספק
    if ($notesData && isset($notesData['supplier']) && !empty($notesData['supplier']['cost'])) {
        $supplier = $notesData['supplier'];
        
        $stmt = $pdo->prepare("
            INSERT INTO supplier_debts (
                order_id, draft_id, supplier_name, supplier_booking,
                description, amount, currency, status, created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        
        $stmt->execute([
            $parentOrderId,
            $draftId,
            $supplier['name'],
            $supplier['booking'],
            $notesData['description'] ?? 'תוספת',
            $supplier['cost'],
            $supplier['currency'] ?? 'USD',
            $supplier['paid'] ?? 'unpaid'
        ]);
        
        $supplierDebtAdded = true;
    }
    
    // עדכון הטיוטה - סימון שהושלמה וקישור להזמנה
    $stmt = $pdo->prepare("UPDATE drafts SET order_id = ? WHERE id = ?");
    $stmt->execute([$parentOrderId, $draftId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'התוספת נוספה להזמנה בהצלחה',
        'parent_order_id' => $parentOrderId,
        'luggage_updated' => $luggageUpdated,
        'supplier_debt_added' => $supplierDebtAdded
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
