<?php
// טופס השלמת הזמנה - לאחר תשלום
require_once 'includes/auth.php';
requireLogin();

$agent = getCurrentAgent();
$pdo = getDB();

// שליפת שערי מטבע
$rates = ['USD' => 3.65, 'EUR' => 3.95, 'ILS' => 1];
$stmt = $pdo->query("SELECT currency, rate FROM exchange_rates");
while ($row = $stmt->fetch()) {
    $rates[$row['currency']] = (float)$row['rate'];
}

// שליפת ספקים מההגדרות
$suppliers = $pdo->query("SELECT name FROM settings_suppliers WHERE active = 1 ORDER BY sort_order, name")->fetchAll(PDO::FETCH_COLUMN);

// קבלת פרטי הזמנה קיימת (אם יש)
$order = null;
$order_id = $_GET['id'] ?? null;

if ($order_id) {
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$order_id]);
    $order = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>השלמת הזמנה - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        /* Main Navigation */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 30px;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            flex-wrap: wrap;
            gap: 15px;
        }
        .main-nav {
            display: flex;
            gap: 5px;
        }
        .nav-link {
            padding: 10px 20px;
            text-decoration: none;
            color: #555;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s;
        }
        .nav-link:hover {
            background: #f0f0f0;
            color: #333;
        }
        .nav-link.active {
            background: #667eea;
            color: white;
        }
        @media (max-width: 900px) {
            .main-nav { order: 3; width: 100%; justify-content: center; }
        }
        
        .form-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .dynamic-fields {
            border: 1px dashed #ddd;
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
        }
        .passenger-row, .payment-row {
            display: flex;
            gap: 10px;
            align-items: center;
            margin-bottom: 10px;
            flex-wrap: wrap;
        }
        .passenger-row input {
            flex: 1;
            min-width: 200px;
        }
        .payment-row input, .payment-row select {
            flex: 1;
            min-width: 100px;
        }
        .payment-row .payment-name { flex: 2; min-width: 120px; }
        .payment-row .payment-amount { flex: 1; min-width: 80px; }
        .payment-row .payment-method { flex: 1; min-width: 100px; }
        .payment-row .payment-installments { flex: 0; width: 80px !important; min-width: 80px; }
        .btn-add {
            background: #28a745;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.9rem;
        }
        .btn-remove {
            background: #dc3545;
            color: white;
            border: none;
            padding: 8px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
        .checkbox-highlight {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px;
            background: #fff3cd;
            border-radius: 5px;
            margin-top: 5px;
        }
        .return-flight-toggle {
            margin: 15px 0;
            padding: 10px;
            background: #e9ecef;
            border-radius: 5px;
        }
        .hidden { display: none; }
        .output-section {
            background: #e8f5e9;
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
        }
        .email-output {
            background: white;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #ddd;
            white-space: pre-wrap;
            font-family: inherit;
            line-height: 1.8;
        }
        .copy-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1rem;
            margin-top: 10px;
        }
        .copy-btn:hover {
            background: #0056b3;
        }
        /* פרטי ספק */
        .supplier-section {
            margin-top: 20px;
            padding: 15px;
            background: #e8f4fc;
            border-radius: 8px;
            border: 1px solid #b8daff;
        }
        .supplier-section h3 {
            margin: 0 0 15px 0;
            font-size: 1rem;
            color: #004085;
        }
        /* סיכום תשלומים */
        .total-summary {
            margin-top: 20px;
            padding: 15px;
            background: #d4edda;
            border-radius: 8px;
        }
        .total-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 1.2rem;
            font-weight: 600;
        }
        .total-amount {
            font-size: 1.5rem;
            color: #28a745;
        }
        /* סיכום רווח */
        .profit-summary {
            background: white;
            padding: 15px;
            border-radius: 8px;
        }
        .profit-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
            font-size: 1.1rem;
        }
        .profit-row:last-child {
            border-bottom: none;
        }
        .profit-row.total {
            border-top: 2px solid #28a745;
            margin-top: 10px;
            padding-top: 15px;
            font-weight: bold;
            font-size: 1.3rem;
        }
        .profit-value {
            font-weight: 600;
        }
        .profit-value.expense {
            color: #dc3545;
        }
        .profit-value.final {
            color: #28a745;
            font-size: 1.5rem;
        }
        .profit-value.negative {
            color: #dc3545 !important;
        }
        .rates-info {
            margin-top: 15px;
            padding: 10px;
            background: #fff3cd;
            border-radius: 5px;
            font-size: 0.9rem;
            color: #856404;
        }
        
        /* מערכת כבודה חדשה */
        .passenger-row-new {
            background: #f8f9fa;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 10px;
        }
        .passenger-name-row {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 8px;
        }
        .passenger-num {
            font-weight: bold;
            color: #1e3c72;
            min-width: 25px;
        }
        .passenger-name-row input {
            flex: 1;
            padding: 8px 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
        }
        .passenger-luggage {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            padding: 8px 0 0 35px;
            border-top: 1px dashed #ddd;
            margin-top: 8px;
        }
        .luggage-item {
            display: flex;
            align-items: center;
            gap: 5px;
            background: white;
            padding: 5px 10px;
            border-radius: 20px;
            border: 1px solid #ddd;
            cursor: pointer;
            font-size: 0.9rem;
            transition: all 0.2s;
        }
        .luggage-item:hover {
            border-color: #1e3c72;
        }
        .luggage-item input[type="checkbox"] {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }
        .luggage-item input[type="checkbox"]:checked + span {
            color: #28a745;
            font-weight: 600;
        }
        .weight-select {
            padding: 3px 5px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 0.85rem;
            background: #f8f9fa;
        }
        .weight-select-sm {
            padding: 2px 4px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 0.8rem;
            background: #f8f9fa;
            width: 55px;
        }
        .passenger-luggage-split {
            padding: 10px 0 0 35px;
            border-top: 1px dashed #ddd;
            margin-top: 8px;
        }
        .luggage-direction {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 10px;
            padding: 8px;
            margin-bottom: 5px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        .luggage-direction:first-child {
            background: #e8f5e9;
        }
        .luggage-direction:last-child {
            background: #fff3e0;
        }
        .direction-label {
            font-weight: 600;
            min-width: 70px;
            font-size: 0.9rem;
        }
        .luggage-global-section {
            margin-top: 20px;
            padding: 15px;
            background: linear-gradient(135deg, #e8f4fd, #f0f7ff);
            border-radius: 10px;
            border: 1px solid #b8daff;
        }
        .luggage-global-section h3 {
            margin: 0 0 12px 0;
            color: #1e3c72;
            font-size: 1rem;
        }
        .luggage-global-controls {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-bottom: 12px;
        }
        .btn-luggage-apply {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            cursor: pointer;
            font-size: 0.85rem;
            transition: transform 0.2s;
        }
        .btn-luggage-apply:hover {
            transform: scale(1.05);
        }
        .btn-luggage-clear {
            background: #6c757d;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            cursor: pointer;
            font-size: 0.85rem;
        }
        .btn-luggage-clear:hover {
            background: #5a6268;
        }
        .luggage-global-weights {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            font-size: 0.9rem;
            color: #555;
        }
        .luggage-global-weights select {
            padding: 5px 10px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <nav class="main-nav">
            <a href="complete_order.php" class="nav-link active">📝 הזמנה חדשה</a>
            <a href="draft.php" class="nav-link">📋 טיוטה ללקוח</a>
            <a href="orders_panel.php" class="nav-link">🔍 פאנל מתקדם</a>
            <a href="reports.php" class="nav-link">📈 דוחות</a>
            <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
        </nav>
        <div class="user-info">
            <span class="user-name">שלום, <?= sanitize($agent['full_name']) ?></span>
            <a href="logout.php" class="btn-logout">התנתק</a>
        </div>
    </header>

    <div class="container" style="max-width:900px;">
        <div class="card">
            <h1 class="card-title">📋 השלמת הזמנה - אחרי תשלום</h1>
            
            <button type="button" onclick="fillTestData()" style="background:#ff9800; color:white; border:none; padding:10px 20px; border-radius:5px; cursor:pointer; margin-bottom:20px;">
                🧪 מלא נתוני טסט
            </button>
            
            <form id="completeOrderForm">
                
                <!-- פרטי עסקה -->
                <div class="form-section">
                    <h2 class="section-title">פרטי עסקה</h2>
                    <div class="form-row">
                        <div class="form-group">
                            <label>תאריך ביצוע העסקה</label>
                            <input type="date" name="order_date" id="order_date" value="<?= date('Y-m-d') ?>" required>
                        </div>
                        <div class="form-group">
                            <label>בונה הדיל (לעמלה)</label>
                            <input type="text" name="deal_builder" id="deal_builder" placeholder="שם בונה הדיל">
                        </div>
                    </div>
                    
                    <!-- סוג הזמנה -->
                    <div class="form-group" style="margin-top:15px;">
                        <label style="font-size:1.1rem; font-weight:bold;">📦 סוג הזמנה</label>
                        <select name="order_type" id="order_type" onchange="toggleOrderType()" style="font-size:1.1rem; padding:12px;">
                            <option value="separate">טיסה + מלון בנפרד</option>
                            <option value="package">נופשון (חבילה)</option>
                            <option value="organized">טיול מאורגן</option>
                        </select>
                    </div>
                </div>

                <!-- פרטי נוסעים + כבודה -->
                <div class="form-section">
                    <h2 class="section-title">פרטי נוסעים</h2>
                    <div class="form-row">
                        <div class="form-group">
                            <label>טלפון נוסע ראשי</label>
                            <input type="tel" name="customer_phone" id="customer_phone" required placeholder="050-1234567">
                        </div>
                        <div class="form-group">
                            <label>אימייל</label>
                            <input type="email" name="customer_email" id="customer_email" placeholder="email@example.com">
                        </div>
                    </div>
                    
                    <label>שמות הנוסעים (באנגלית כמו בדרכון)</label>
                    <div id="passengers-container" class="dynamic-fields">
                        <div class="passenger-row-new">
                            <div class="passenger-name-row">
                                <span class="passenger-num">1.</span>
                                <input type="text" name="passengers[]" placeholder="Full Name in English" required>
                                <button type="button" class="btn-remove" onclick="removePassengerRow(this)" style="visibility:hidden;">✕</button>
                            </div>
                            <!-- צ'קבוקס אותה כבודה - לכל נוסע בנפרד -->
                            <div class="same-luggage-toggle" style="padding:8px 0 5px 35px;">
                                <label style="display:flex; align-items:center; gap:8px; cursor:pointer; font-size:0.9rem; color:#555;">
                                    <input type="checkbox" class="same-luggage-checkbox" checked onchange="togglePassengerLuggageMode(this)" style="width:16px; height:16px;">
                                    <span>🧳 אותה כבודה לשני הכיוונים</span>
                                </label>
                            </div>
                            <!-- כבודה משותפת (דיפולט) -->
                            <div class="passenger-luggage luggage-combined">
                                <label class="luggage-item">
                                    <input type="checkbox" name="passenger_backpack[]" value="1">
                                    <span>🎒 Backpack</span>
                                </label>
                                <label class="luggage-item">
                                    <input type="checkbox" name="passenger_trolley[]" value="1">
                                    <span>🧳 Trolley</span>
                                    <select name="passenger_trolley_weight[]" class="weight-select">
                                        <option value="7">7kg</option>
                                        <option value="8" selected>8kg</option>
                                        <option value="10">10kg</option>
                                    </select>
                                </label>
                                <label class="luggage-item">
                                    <input type="checkbox" name="passenger_suitcase[]" value="1">
                                    <span>🛄 Suitcase</span>
                                    <select name="passenger_suitcase_weight[]" class="weight-select">
                                        <option value="15">15kg</option>
                                        <option value="20" selected>20kg</option>
                                        <option value="23">23kg</option>
                                        <option value="25">25kg</option>
                                        <option value="30">30kg</option>
                                    </select>
                                </label>
                            </div>
                            <!-- כבודה נפרדת הלוך/חזור (מוסתר בדיפולט) -->
                            <div class="passenger-luggage-split hidden">
                                <div class="luggage-direction">
                                    <span class="direction-label">✈️ הלוך:</span>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_backpack_outbound[]" value="1">
                                        <span>🎒</span>
                                    </label>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_trolley_outbound[]" value="1">
                                        <span>🧳</span>
                                        <select name="passenger_trolley_weight_outbound[]" class="weight-select-sm">
                                            <option value="7">7kg</option>
                                            <option value="8" selected>8kg</option>
                                            <option value="10">10kg</option>
                                        </select>
                                    </label>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_suitcase_outbound[]" value="1">
                                        <span>🛄</span>
                                        <select name="passenger_suitcase_weight_outbound[]" class="weight-select-sm">
                                            <option value="15">15kg</option>
                                            <option value="20" selected>20kg</option>
                                            <option value="23">23kg</option>
                                            <option value="25">25kg</option>
                                            <option value="30">30kg</option>
                                        </select>
                                    </label>
                                </div>
                                <div class="luggage-direction">
                                    <span class="direction-label">✈️ חזור:</span>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_backpack_return[]" value="1">
                                        <span>🎒</span>
                                    </label>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_trolley_return[]" value="1">
                                        <span>🧳</span>
                                        <select name="passenger_trolley_weight_return[]" class="weight-select-sm">
                                            <option value="7">7kg</option>
                                            <option value="8" selected>8kg</option>
                                            <option value="10">10kg</option>
                                        </select>
                                    </label>
                                    <label class="luggage-item">
                                        <input type="checkbox" name="passenger_suitcase_return[]" value="1">
                                        <span>🛄</span>
                                        <select name="passenger_suitcase_weight_return[]" class="weight-select-sm">
                                            <option value="15">15kg</option>
                                            <option value="20" selected>20kg</option>
                                            <option value="23">23kg</option>
                                            <option value="25">25kg</option>
                                            <option value="30">30kg</option>
                                        </select>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn-add" onclick="addPassenger()">+ הוסף נוסע</button>
                    
                    <!-- הגדרות כבודה גורפות -->
                    <div class="luggage-global-section">
                        <h3>⚡ החל כבודה על כולם</h3>
                        <div class="luggage-global-controls">
                            <button type="button" class="btn-luggage-apply" onclick="applyToAll('backpack')">🎒 Backpack לכולם</button>
                            <button type="button" class="btn-luggage-apply" onclick="applyToAll('trolley')">🧳 Trolley לכולם</button>
                            <button type="button" class="btn-luggage-apply" onclick="applyToAll('suitcase')">🛄 Suitcase לכולם</button>
                            <button type="button" class="btn-luggage-clear" onclick="clearAllLuggage()">❌ נקה הכל</button>
                            <button type="button" class="btn-luggage-apply" style="background:#28a745;" onclick="selectAllLuggage()">✅ בחר הכל</button>
                        </div>
                        <div class="luggage-global-weights">
                            <label>משקל Trolley ברירת מחדל: 
                                <select id="default_trolley_weight">
                                    <option value="7">7kg</option>
                                    <option value="8" selected>8kg</option>
                                    <option value="10">10kg</option>
                                </select>
                            </label>
                            <label>משקל Suitcase ברירת מחדל: 
                                <select id="default_suitcase_weight">
                                    <option value="15">15kg</option>
                                    <option value="20" selected>20kg</option>
                                    <option value="23">23kg</option>
                                    <option value="25">25kg</option>
                                    <option value="30">30kg</option>
                                </select>
                            </label>
                        </div>
                    </div>
                    
                    <!-- שדה נסתר לשמירת JSON -->
                    <input type="hidden" name="luggage_details" id="luggage_details">
                </div>

                <!-- ========== וריאציה 1: טיסה + מלון בנפרד ========== -->
                <div id="separate-section">
                    <!-- פרטי טיסה -->
                    <div class="form-section">
                        <h2 class="section-title">✈️ פרטי טיסה</h2>
                        <div class="form-group">
                            <label>יעד</label>
                            <input type="text" name="destination" id="destination" required placeholder="בודפשט, הונגריה" list="destinations-list">
                        </div>
                        
                        <!-- טיסת הלוך -->
                        <h3 style="margin-top:20px; color:#1e3c72;">🛫 טיסת הלוך</h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label>תאריך</label>
                                <input type="date" name="departure_date" id="departure_date" required>
                            </div>
                            <div class="form-group">
                                <label>שעת המראה</label>
                                <input type="time" name="flight_time_outbound" id="flight_time_outbound" placeholder="06:30">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>חברת תעופה</label>
                                <input type="text" name="airline_outbound" id="airline_outbound" placeholder="Wizz Air" list="airlines-list">
                            </div>
                            <div class="form-group">
                                <label>מספר טיסה</label>
                                <input type="text" name="flight_number_outbound" id="flight_number_outbound" placeholder="W6 2457">
                            </div>
                            <div class="form-group">
                                <label>קוד הזמנה</label>
                                <input type="text" name="booking_code_outbound" id="booking_code_outbound" placeholder="ABC123">
                            </div>
                        </div>
                        
                        <!-- ספק טיסת הלוך -->
                        <div class="supplier-section">
                            <h3>💰 ספק הטיסה (הלוך)</h3>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>ספק</label>
                                    <select name="flight_supplier" id="flight_supplier">
                                        <option value="DIRECT">DIRECT</option>
                                        <?php foreach ($suppliers as $supplier): ?>
                                            <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>מספר הזמנה אצל הספק</label>
                                    <input type="text" name="flight_supplier_booking" id="flight_supplier_booking" placeholder="50944095">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>עלות לספק</label>
                                    <input type="number" step="0.01" name="flight_supplier_cost" id="flight_supplier_cost" placeholder="836.00">
                                </div>
                                <div class="form-group">
                                    <label>מטבע</label>
                                    <select name="flight_supplier_currency" id="flight_supplier_currency">
                                        <option value="ILS">₪ שקל</option>
                                        <option value="USD">$ דולר</option>
                                        <option value="EUR">€ יורו</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>סטטוס תשלום</label>
                                    <select name="flight_supplier_paid" id="flight_supplier_paid">
                                        <option value="paid">✅ שולם</option>
                                        <option value="unpaid">⏳ טרם שולם</option>
                                    </select>
                                </div>
                            </div>
                            <div style="background:#e8f5e9; padding:8px 12px; border-radius:5px; margin-top:10px; font-size:0.9rem;">
                                <span style="color:#2e7d32;">💡 ספק זה חל גם על טיסת החזור, אלא אם תסמן למטה "טיסת החזור עם ספק/חברה אחרת"</span>
                            </div>
                        </div>
                        
                        <!-- טיסת חזור -->
                        <h3 style="margin-top:20px; color:#1e3c72;">🛬 טיסת חזור</h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label>תאריך</label>
                                <input type="date" name="return_date" id="return_date" required>
                            </div>
                            <div class="form-group">
                                <label>שעת המראה</label>
                                <input type="time" name="flight_time_return" id="flight_time_return" placeholder="10:15">
                            </div>
                        </div>
                        
                        <div class="return-flight-toggle">
                            <label>
                                <input type="checkbox" id="different_return" onchange="toggleReturnFlight()">
                                טיסת החזור עם ספק/חברה אחרת
                            </label>
                        </div>
                        
                        <div id="return-flight-fields" class="hidden">
                            <h4 style="margin:15px 0 10px; color:#555;">✈️ פרטי טיסת חזור</h4>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>חברת תעופה (חזור)</label>
                                    <input type="text" name="airline_return" id="airline_return" placeholder="Ryanair" list="airlines-list">
                                </div>
                                <div class="form-group">
                                    <label>מספר טיסה (חזור)</label>
                                    <input type="text" name="flight_number_return" id="flight_number_return" placeholder="FR 1234">
                                </div>
                                <div class="form-group">
                                    <label>קוד הזמנה (חזור)</label>
                                    <input type="text" name="booking_code_return" id="booking_code_return" placeholder="XYZ789">
                                </div>
                            </div>
                            
                            <div class="supplier-section" style="background:#fff8e1;">
                                <h3>💰 ספק טיסת החזור</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label>ספק</label>
                                        <select name="return_flight_supplier" id="return_flight_supplier">
                                            <option value="DIRECT">DIRECT</option>
                                            <?php foreach ($suppliers as $supplier): ?>
                                                <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>מספר הזמנה אצל הספק</label>
                                        <input type="text" name="return_flight_supplier_booking" id="return_flight_supplier_booking" placeholder="50944095">
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label>עלות לספק</label>
                                        <input type="number" step="0.01" name="return_flight_supplier_cost" id="return_flight_supplier_cost" placeholder="400.00">
                                    </div>
                                    <div class="form-group">
                                        <label>מטבע</label>
                                        <select name="return_flight_supplier_currency" id="return_flight_supplier_currency">
                                            <option value="ILS">₪ שקל</option>
                                            <option value="USD">$ דולר</option>
                                            <option value="EUR">€ יורו</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>סטטוס תשלום</label>
                                        <select name="return_flight_supplier_paid" id="return_flight_supplier_paid">
                                            <option value="paid">✅ שולם</option>
                                            <option value="unpaid">⏳ טרם שולם</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- פרטי מלון - בנפרד -->
                    <div class="form-section">
                        <h2 class="section-title">🏨 פרטי מלון</h2>
                        <div class="form-row">
                            <div class="form-group">
                                <label>שם המלון</label>
                                <input type="text" name="hotel_name" id="hotel_name" placeholder="Hilton Budapest" list="hotels-list">
                            </div>
                            <div class="form-group">
                                <label>מספר אישור הזמנה</label>
                                <input type="text" name="hotel_confirmation" id="hotel_confirmation" placeholder="HTL123456">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>צ'ק אין</label>
                                <input type="date" name="hotel_checkin" id="hotel_checkin">
                            </div>
                            <div class="form-group">
                                <label>צ'ק אאוט</label>
                                <input type="date" name="hotel_checkout" id="hotel_checkout">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>סוג חדר</label>
                                <input type="text" name="room_type" id="room_type" placeholder="חדר זוגי / סטנדרט">
                            </div>
                            <div class="form-group">
                                <label>בסיס אירוח</label>
                                <select name="meal_basis" id="meal_basis">
                                    <option value="RO">Room Only</option>
                                    <option value="BB" selected>Bed & Breakfast</option>
                                    <option value="HB">Half Board</option>
                                    <option value="FB">Full Board</option>
                                    <option value="AI">All Inclusive</option>
                                </select>
                            </div>
                        </div>

                        <div class="supplier-section">
                            <h3>💰 ספק המלון</h3>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>ספק</label>
                                    <select name="hotel_supplier" id="hotel_supplier">
                                        <option value="Booking.com">Booking.com</option>
                                        <option value="Hotels.com">Hotels.com</option>
                                        <option value="Expedia">Expedia</option>
                                        <option value="Agoda">Agoda</option>
                                        <option value="ישיר מהמלון">ישיר מהמלון</option>
                                        <option value="אחר">אחר</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>מספר אישור</label>
                                    <input type="text" name="hotel_supplier_booking" id="hotel_supplier_booking" placeholder="1234567890">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>עלות לספק</label>
                                    <input type="number" step="0.01" name="hotel_supplier_cost" id="hotel_supplier_cost" placeholder="420.00">
                                </div>
                                <div class="form-group">
                                    <label>מטבע</label>
                                    <select name="hotel_supplier_currency" id="hotel_supplier_currency">
                                        <option value="ILS">₪ שקל</option>
                                        <option value="USD">$ דולר</option>
                                        <option value="EUR">€ יורו</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>סטטוס תשלום</label>
                                    <select name="hotel_supplier_paid" id="hotel_supplier_paid">
                                        <option value="paid">✅ שולם</option>
                                        <option value="unpaid">⏳ טרם שולם</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ========== וריאציה 2+3: נופשון / טיול מאורגן ========== -->
                <div id="package-section" class="hidden">
                    <div class="form-section" style="background: #e8f5e9;">
                        <h2 class="section-title">📦 פרטי <span id="package-type-title">נופשון</span></h2>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>יעד</label>
                                <input type="text" name="package_destination" id="package_destination" placeholder="בודפשט, הונגריה" list="destinations-list">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>תאריך יציאה</label>
                                <input type="date" name="package_departure" id="package_departure">
                            </div>
                            <div class="form-group">
                                <label>תאריך חזרה</label>
                                <input type="date" name="package_return" id="package_return">
                            </div>
                        </div>
                        
                        <div class="supplier-section" style="background: #c8e6c9;">
                            <h3>💰 ספק החבילה</h3>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>סוכנות</label>
                                    <select name="package_supplier" id="package_supplier">
                                        <?php foreach ($suppliers as $supplier): ?>
                                            <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>מספר הזמנה</label>
                                    <input type="text" name="package_supplier_booking" id="package_supplier_booking" placeholder="50944095">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group">
                                    <label>עלות כוללת לספק</label>
                                    <input type="number" step="0.01" name="package_supplier_cost" id="package_supplier_cost" placeholder="1200.00">
                                </div>
                                <div class="form-group">
                                    <label>מטבע</label>
                                    <select name="package_supplier_currency" id="package_supplier_currency">
                                        <option value="ILS">₪ שקל</option>
                                        <option value="USD">$ דולר</option>
                                        <option value="EUR">€ יורו</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>סטטוס תשלום</label>
                                    <select name="package_supplier_paid" id="package_supplier_paid">
                                        <option value="paid">✅ שולם</option>
                                        <option value="unpaid">⏳ טרם שולם</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <h3 style="margin-top:20px;">🛫 טיסת הלוך</h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label>חברת תעופה</label>
                                <input type="text" name="package_airline" id="package_airline" placeholder="Wizz Air" list="airlines-list">
                            </div>
                            <div class="form-group">
                                <label>מספר טיסה</label>
                                <input type="text" name="package_flight_number_out" id="package_flight_number_out" placeholder="W6 2457">
                            </div>
                            <div class="form-group">
                                <label>קוד הזמנה</label>
                                <input type="text" name="package_flight_code" id="package_flight_code" placeholder="ABC123">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>שעת המראה</label>
                                <input type="time" name="package_flight_time_out" id="package_flight_time_out">
                            </div>
                        </div>
                        
                        <div class="return-flight-toggle">
                            <label>
                                <input type="checkbox" id="package_different_return" onchange="togglePackageReturnFlight()">
                                טיסת החזור עם חברה אחרת
                            </label>
                        </div>
                        
                        <h3 style="margin-top:20px;">🛬 טיסת חזור</h3>
                        <div id="package-return-flight-fields" class="hidden">
                            <div class="form-row">
                                <div class="form-group">
                                    <label>חברת תעופה (חזור)</label>
                                    <input type="text" name="package_airline_return" id="package_airline_return" placeholder="Ryanair" list="airlines-list">
                                </div>
                                <div class="form-group">
                                    <label>מספר טיסה (חזור)</label>
                                    <input type="text" name="package_flight_number_ret" id="package_flight_number_ret" placeholder="FR 1234">
                                </div>
                                <div class="form-group">
                                    <label>קוד הזמנה (חזור)</label>
                                    <input type="text" name="package_flight_code_return" id="package_flight_code_return" placeholder="XYZ789">
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>שעת המראה (חזור)</label>
                                <input type="time" name="package_flight_time_ret" id="package_flight_time_ret">
                            </div>
                        </div>
                        
                        <h3 style="margin-top:20px;">🏨 פרטי המלון</h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label>שם המלון</label>
                                <input type="text" name="package_hotel" id="package_hotel" placeholder="Hilton Budapest">
                            </div>
                            <div class="form-group">
                                <label>בסיס אירוח</label>
                                <select name="package_meal_basis" id="package_meal_basis">
                                    <option value="RO">Room Only</option>
                                    <option value="BB" selected>Bed & Breakfast</option>
                                    <option value="HB">Half Board</option>
                                    <option value="FB">Full Board</option>
                                    <option value="AI">All Inclusive</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label>צ'ק אין</label>
                                <input type="date" name="package_checkin" id="package_checkin">
                            </div>
                            <div class="form-group">
                                <label>צ'ק אאוט</label>
                                <input type="date" name="package_checkout" id="package_checkout">
                            </div>
                        </div>
                        <div class="form-group">
                            <label>סוג חדר</label>
                            <input type="text" name="package_room_type" id="package_room_type" placeholder="חדר זוגי סטנדרט">
                        </div>
                    </div>
                </div>

                <!-- תשלומים -->
                <div class="form-section">
                    <h2 class="section-title">פרטי תשלומים מלקוחות</h2>
                    
                    <label>פירוט תשלומים</label>
                    <div class="payment-headers" style="display:flex; gap:10px; margin-bottom:5px; font-size:0.85rem; color:#666;">
                        <span style="flex:2; min-width:120px;">שם משלם</span>
                        <span style="flex:1; min-width:80px;">סכום</span>
                        <span style="flex:1; min-width:100px;">אמצעי תשלום</span>
                        <span style="width:80px;">תשלומים</span>
                        <span style="width:40px;"></span>
                    </div>
                    <div id="payments-container" class="dynamic-fields">
                        <div class="payment-row">
                            <input type="text" name="payment_name[]" placeholder="שם המשלם" class="payment-name">
                            <input type="number" name="payment_amount[]" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                            <select name="payment_method[]" class="payment-method">
                                <option value="אשראי">אשראי</option>
                                <option value="העברה בנקאית">העברה בנקאית</option>
                                <option value="מזומן">מזומן</option>
                                <option value="ביט">ביט</option>
                            </select>
                            <input type="number" name="payment_installments[]" placeholder="תשלומים" class="payment-installments" min="1" value="1" style="width:80px;">
                            <button type="button" class="btn-remove" onclick="removePaymentRow(this)" style="visibility:hidden;">✕</button>
                        </div>
                    </div>
                    <button type="button" class="btn-add" onclick="addPayment()">+ הוסף תשלום</button>
                    
                    <div class="total-summary">
                        <div class="total-row">
                            <span>סה"כ שולם:</span>
                            <span id="total-paid" class="total-amount">₪0</span>
                        </div>
                    </div>

                    <div class="checkbox-highlight" style="margin-top:15px;">
                        ⚠️ <strong>שים לב:</strong> תשלומים בהעברה בנקאית יסומנו לבדיקה בדוחות
                    </div>
                </div>

                <!-- סיכום רווח -->
                <div class="form-section" style="background: #e8f5e9;">
                    <h2 class="section-title">💰 סיכום רווח</h2>
                    <div class="profit-summary">
                        <div class="profit-row">
                            <span>סה"כ מהלקוח:</span>
                            <span id="summary-customer" class="profit-value">₪0</span>
                        </div>
                        <div class="profit-row">
                            <span>עלות טיסה לספק:</span>
                            <span id="summary-flight" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row">
                            <span>עלות מלון לספק:</span>
                            <span id="summary-hotel" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row" style="display:none;">
                            <span>עלות חבילה לספק:</span>
                            <span id="summary-package" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row total">
                            <span>רווח סופי:</span>
                            <span id="summary-profit" class="profit-value final">₪0</span>
                        </div>
                    </div>
                    <input type="hidden" name="profit" id="profit" value="0">
                    <input type="hidden" name="usd_rate" id="usd_rate" value="<?= $rates['USD'] ?>">
                    <input type="hidden" name="eur_rate" id="eur_rate" value="<?= $rates['EUR'] ?>">
                    <div class="rates-info">
                        💱 שערי מטבע: $1 = ₪<?= $rates['USD'] ?> | €1 = ₪<?= $rates['EUR'] ?>
                        <a href="exchange_rates.php" style="margin-right:10px;">[עדכן שערים]</a>
                    </div>
                </div>

                <!-- הערות -->
                <div class="form-section">
                    <h2 class="section-title">הערות</h2>
                    <div class="form-group">
                        <label>הערות חשובות להזמנה</label>
                        <textarea name="notes" id="notes" rows="3" placeholder="הערות פנימיות..."></textarea>
                    </div>
                </div>

                <button type="button" class="btn btn-primary" onclick="generateEmail()">
                    ✨ צור אישור הזמנה למייל
                </button>
            </form>

            <!-- תוצאה - מייל מוכן -->
            <div id="output-section" class="output-section hidden">
                <h2 class="section-title">📧 אישור הזמנה מוכן לשליחה</h2>
                <div id="email-output" class="email-output"></div>
                <button type="button" class="copy-btn" onclick="copyEmail()">📋 העתק למייל</button>
                <button type="button" class="btn btn-primary" onclick="saveOrder()" style="margin-right:10px;">💾 שמור במערכת</button>
            </div>
        </div>
    </div>

    <script>
        // הצגה/הסתרת סעיפים לפי סוג הזמנה
        function toggleOrderType() {
            const orderType = document.getElementById('order_type').value;
            const separateSection = document.getElementById('separate-section');
            const packageSection = document.getElementById('package-section');
            const packageTitle = document.getElementById('package-type-title');
            
            if (orderType === 'separate') {
                separateSection.classList.remove('hidden');
                packageSection.classList.add('hidden');
            } else {
                separateSection.classList.add('hidden');
                packageSection.classList.remove('hidden');
                packageTitle.textContent = orderType === 'package' ? 'נופשון' : 'טיול מאורגן';
            }
            
            calculateTotal();
        }

        // מילוי נתוני טסט - לפי סוג הזמנה
        function fillTestData() {
            // בחירת סוג אקראי או לפי הנבחר
            const orderTypes = ['separate', 'package', 'organized'];
            const currentType = document.getElementById('order_type').value;
            
            // שאל את המשתמש איזה סוג למלא
            const choice = prompt('איזה סוג הזמנה למלא?\n1 = טיסה+מלון בנפרד\n2 = נופשון\n3 = טיול מאורגן\n\n(או Enter לסוג הנבחר כרגע)', '');
            
            let selectedType = currentType;
            if (choice === '1') selectedType = 'separate';
            else if (choice === '2') selectedType = 'package';
            else if (choice === '3') selectedType = 'organized';
            
            // עדכון הבחירה
            document.getElementById('order_type').value = selectedType;
            toggleOrderType();
            
            // תאריכים
            const today = new Date();
            const departure = new Date(today.getTime() + 30 * 24 * 60 * 60 * 1000); // עוד 30 יום
            const returnDate = new Date(departure.getTime() + 4 * 24 * 60 * 60 * 1000); // 4 לילות
            const depStr = departure.toISOString().split('T')[0];
            const retStr = returnDate.toISOString().split('T')[0];
            
            // נתונים בסיסיים - משותפים לכולם
            document.getElementById('order_date').value = today.toISOString().split('T')[0];
            document.getElementById('deal_builder').value = 'אוקי';
            document.getElementById('customer_phone').value = '050-' + Math.floor(1000000 + Math.random() * 9000000);
            document.getElementById('customer_email').value = 'test' + Math.floor(Math.random() * 1000) + '@example.com';
            
            // מילוי נוסעים
            document.querySelector('input[name="passengers[]"]').value = 'Israel Israeli';
            // הוסף נוסע שני אם אין
            const passengerInputs = document.querySelectorAll('input[name="passengers[]"]');
            if (passengerInputs.length < 2) {
                addPassenger();
            }
            document.querySelectorAll('input[name="passengers[]"]')[1].value = 'Sara Israeli';
            
            // יעדים אפשריים
            const destinations = ['Budapest, Hungary', 'Prague, Czech Republic', 'Barcelona, Spain', 'Rome, Italy', 'Vienna, Austria', 'Athens, Greece'];
            const airlines = ['Wizz Air', 'Ryanair', 'El Al', 'Aegean', 'Austrian'];
            const hotels = ['Hilton', 'Marriott', 'Radisson', 'Novotel', 'Ibis Styles'];
            const suppliers = <?= json_encode($suppliers) ?>;
            const hotelSuppliers = ['Booking.com', 'Hotels.com', 'Expedia', 'Agoda'];
            
            const randomDest = destinations[Math.floor(Math.random() * destinations.length)];
            const randomAirline = airlines[Math.floor(Math.random() * airlines.length)];
            const randomHotel = hotels[Math.floor(Math.random() * hotels.length)] + ' ' + randomDest.split(',')[0];
            const randomSupplier = suppliers[Math.floor(Math.random() * suppliers.length)];
            const randomHotelSupplier = hotelSuppliers[Math.floor(Math.random() * hotelSuppliers.length)];
            
            // קודי הזמנה אקראיים
            const flightCode = String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                              String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                              String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                              Math.floor(100 + Math.random() * 900);
            const supplierBooking = Math.floor(50000000 + Math.random() * 9999999);
            
            // מספרי טיסה אקראיים
            const flightNumbers = ['W6 2457', 'W6 2458', 'FR 1234', 'FR 5678', 'LY 331', 'LY 332', 'A3 904', 'OS 859'];
            const randomFlightNum = flightNumbers[Math.floor(Math.random() * flightNumbers.length)];
            const randomFlightNumReturn = flightNumbers[Math.floor(Math.random() * flightNumbers.length)];
            
            // שעות טיסה אקראיות
            const flightTimes = ['06:30', '07:15', '08:00', '10:30', '12:45', '14:20', '16:00', '19:30', '21:45'];
            const randomTimeOut = flightTimes[Math.floor(Math.random() * flightTimes.length)];
            const randomTimeRet = flightTimes[Math.floor(Math.random() * flightTimes.length)];
            
            if (selectedType === 'separate') {
                // וריאציה 1: טיסה + מלון בנפרד
                document.getElementById('destination').value = randomDest;
                document.getElementById('departure_date').value = depStr;
                document.getElementById('return_date').value = retStr;
                
                // טיסת הלוך
                document.getElementById('airline_outbound').value = randomAirline;
                document.getElementById('flight_number_outbound').value = randomFlightNum;
                document.getElementById('flight_time_outbound').value = randomTimeOut;
                document.getElementById('booking_code_outbound').value = flightCode;
                
                // טיסת חזור
                document.getElementById('flight_time_return').value = randomTimeRet;
                
                // אקראית - טיסת חזור עם חברה אחרת
                if (Math.random() > 0.7) {
                    document.getElementById('different_return').checked = true;
                    toggleReturnFlight();
                    const otherAirlines = airlines.filter(a => a !== randomAirline);
                    document.getElementById('airline_return').value = otherAirlines[Math.floor(Math.random() * otherAirlines.length)];
                    document.getElementById('flight_number_return').value = randomFlightNumReturn;
                    document.getElementById('booking_code_return').value = String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                                                                           String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                                                                           Math.floor(100 + Math.random() * 900);
                    
                    // ספק טיסת החזור
                    const otherSuppliers = suppliers.filter(s => s !== randomSupplier);
                    const returnSupplier = otherSuppliers[Math.floor(Math.random() * otherSuppliers.length)];
                    document.getElementById('return_flight_supplier').value = returnSupplier;
                    document.getElementById('return_flight_supplier_booking').value = Math.floor(50000000 + Math.random() * 9999999);
                    document.getElementById('return_flight_supplier_cost').value = Math.floor(200 + Math.random() * 400);
                    document.getElementById('return_flight_supplier_currency').value = 'USD';
                    document.getElementById('return_flight_supplier_paid').value = Math.random() > 0.5 ? 'paid' : 'unpaid';
                }
                
                // ספק טיסה (הלוך)
                document.getElementById('flight_supplier').value = Math.random() > 0.3 ? randomSupplier : 'DIRECT';
                document.getElementById('flight_supplier_booking').value = supplierBooking;
                document.getElementById('flight_supplier_cost').value = Math.floor(300 + Math.random() * 700);
                document.getElementById('flight_supplier_currency').value = 'USD';
                document.getElementById('flight_supplier_paid').value = Math.random() > 0.5 ? 'paid' : 'unpaid';
                
                // מלון
                document.getElementById('hotel_name').value = randomHotel;
                document.getElementById('hotel_confirmation').value = 'HTL' + Math.floor(100000 + Math.random() * 900000);
                document.getElementById('hotel_checkin').value = depStr;
                document.getElementById('hotel_checkout').value = retStr;
                document.getElementById('room_type').value = 'Double Standard';
                document.getElementById('meal_basis').value = 'BB';
                
                // ספק מלון
                document.getElementById('hotel_supplier').value = randomHotelSupplier;
                document.getElementById('hotel_supplier_booking').value = Math.floor(1000000000 + Math.random() * 9000000000);
                document.getElementById('hotel_supplier_cost').value = Math.floor(200 + Math.random() * 500);
                document.getElementById('hotel_supplier_currency').value = 'EUR';
                document.getElementById('hotel_supplier_paid').value = 'paid'; // Booking תמיד משלמים מראש
                
            } else {
                // וריאציה 2+3: נופשון / טיול מאורגן
                document.getElementById('package_destination').value = randomDest;
                document.getElementById('package_departure').value = depStr;
                document.getElementById('package_return').value = retStr;
                
                // ספק חבילה
                document.getElementById('package_supplier').value = randomSupplier;
                document.getElementById('package_supplier_booking').value = supplierBooking;
                document.getElementById('package_supplier_cost').value = Math.floor(800 + Math.random() * 1500);
                document.getElementById('package_supplier_currency').value = 'USD';
                document.getElementById('package_supplier_paid').value = Math.random() > 0.5 ? 'paid' : 'unpaid';
                
                // פרטי טיסת הלוך
                document.getElementById('package_airline').value = randomAirline;
                document.getElementById('package_flight_number_out').value = randomFlightNum;
                document.getElementById('package_flight_time_out').value = randomTimeOut;
                document.getElementById('package_flight_code').value = flightCode;
                
                // טיסת חזור
                document.getElementById('package_flight_time_ret').value = randomTimeRet;
                
                // אקראית - טיסת חזור עם חברה אחרת
                if (Math.random() > 0.7) {
                    document.getElementById('package_different_return').checked = true;
                    togglePackageReturnFlight();
                    const otherAirlines = airlines.filter(a => a !== randomAirline);
                    document.getElementById('package_airline_return').value = otherAirlines[Math.floor(Math.random() * otherAirlines.length)];
                    document.getElementById('package_flight_number_ret').value = randomFlightNumReturn;
                    document.getElementById('package_flight_code_return').value = String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                                                                                  String.fromCharCode(65 + Math.floor(Math.random() * 26)) + 
                                                                                  Math.floor(100 + Math.random() * 900);
                }
                
                // פרטי מלון
                document.getElementById('package_hotel').value = randomHotel;
                document.getElementById('package_meal_basis').value = selectedType === 'organized' ? 'HB' : 'BB';
                document.getElementById('package_checkin').value = depStr;
                document.getElementById('package_checkout').value = retStr;
                document.getElementById('package_room_type').value = 'Double Standard';
            }
            
            // כבודה - החל על כל הנוסעים
            applyToAll('backpack');
            applyToAll('trolley');
            applyToAll('suitcase');
            
            // מילוי תשלומים
            const totalAmount = Math.floor(4000 + Math.random() * 3000);
            const payment1 = Math.floor(totalAmount / 2);
            const payment2 = totalAmount - payment1;
            
            document.querySelector('input[name="payment_name[]"]').value = 'Israel Israeli';
            document.querySelector('input[name="payment_amount[]"]').value = payment1;
            document.querySelector('select[name="payment_method[]"]').value = 'אשראי';
            document.querySelector('input[name="payment_installments[]"]').value = '3';
            
            // הוסף תשלום שני אם אין
            const paymentRows = document.querySelectorAll('.payment-row');
            if (paymentRows.length < 2) {
                addPayment();
            }
            const lastRow = document.querySelectorAll('.payment-row')[1];
            if (lastRow) {
                lastRow.querySelector('input[name="payment_name[]"]').value = 'Sara Israeli';
                lastRow.querySelector('input[name="payment_amount[]"]').value = payment2;
                lastRow.querySelector('select[name="payment_method[]"]').value = 'אשראי';
                lastRow.querySelector('input[name="payment_installments[]"]').value = '3';
            }
            
            // חישוב רווח אוטומטי
            calculateTotal();
            
            const typeNames = {
                'separate': 'טיסה+מלון בנפרד',
                'package': 'נופשון',
                'organized': 'טיול מאורגן'
            };
            alert(`נתוני טסט מולאו! 🧪\n\nסוג: ${typeNames[selectedType]}\nיעד: ${selectedType === 'separate' ? document.getElementById('destination').value : document.getElementById('package_destination').value}\n\nרווח מחושב אוטומטית!`);
        }

        // הוספת נוסע
        function addPassenger() {
            const container = document.getElementById('passengers-container');
            const passengerCount = container.querySelectorAll('.passenger-row-new').length + 1;
            const row = document.createElement('div');
            row.className = 'passenger-row-new';
            row.innerHTML = `
                <div class="passenger-name-row">
                    <span class="passenger-num">${passengerCount}.</span>
                    <input type="text" name="passengers[]" placeholder="Full Name in English" required>
                    <button type="button" class="btn-remove" onclick="removePassengerRow(this)">✕</button>
                </div>
                <!-- צ'קבוקס אותה כבודה - לכל נוסע בנפרד -->
                <div class="same-luggage-toggle" style="padding:8px 0 5px 35px;">
                    <label style="display:flex; align-items:center; gap:8px; cursor:pointer; font-size:0.9rem; color:#555;">
                        <input type="checkbox" class="same-luggage-checkbox" checked onchange="togglePassengerLuggageMode(this)" style="width:16px; height:16px;">
                        <span>🧳 אותה כבודה לשני הכיוונים</span>
                    </label>
                </div>
                <!-- כבודה משותפת -->
                <div class="passenger-luggage luggage-combined">
                    <label class="luggage-item">
                        <input type="checkbox" name="passenger_backpack[]" value="1">
                        <span>🎒 Backpack</span>
                    </label>
                    <label class="luggage-item">
                        <input type="checkbox" name="passenger_trolley[]" value="1">
                        <span>🧳 Trolley</span>
                        <select name="passenger_trolley_weight[]" class="weight-select">
                            <option value="7">7kg</option>
                            <option value="8" selected>8kg</option>
                            <option value="10">10kg</option>
                        </select>
                    </label>
                    <label class="luggage-item">
                        <input type="checkbox" name="passenger_suitcase[]" value="1">
                        <span>🛄 Suitcase</span>
                        <select name="passenger_suitcase_weight[]" class="weight-select">
                            <option value="15">15kg</option>
                            <option value="20" selected>20kg</option>
                            <option value="23">23kg</option>
                            <option value="25">25kg</option>
                            <option value="30">30kg</option>
                        </select>
                    </label>
                </div>
                <!-- כבודה נפרדת הלוך/חזור -->
                <div class="passenger-luggage-split hidden">
                    <div class="luggage-direction">
                        <span class="direction-label">✈️ הלוך:</span>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_backpack_outbound[]" value="1">
                            <span>🎒</span>
                        </label>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_trolley_outbound[]" value="1">
                            <span>🧳</span>
                            <select name="passenger_trolley_weight_outbound[]" class="weight-select-sm">
                                <option value="7">7kg</option>
                                <option value="8" selected>8kg</option>
                                <option value="10">10kg</option>
                            </select>
                        </label>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_suitcase_outbound[]" value="1">
                            <span>🛄</span>
                            <select name="passenger_suitcase_weight_outbound[]" class="weight-select-sm">
                                <option value="15">15kg</option>
                                <option value="20" selected>20kg</option>
                                <option value="23">23kg</option>
                                <option value="25">25kg</option>
                                <option value="30">30kg</option>
                            </select>
                        </label>
                    </div>
                    <div class="luggage-direction">
                        <span class="direction-label">✈️ חזור:</span>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_backpack_return[]" value="1">
                            <span>🎒</span>
                        </label>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_trolley_return[]" value="1">
                            <span>🧳</span>
                            <select name="passenger_trolley_weight_return[]" class="weight-select-sm">
                                <option value="7">7kg</option>
                                <option value="8" selected>8kg</option>
                                <option value="10">10kg</option>
                            </select>
                        </label>
                        <label class="luggage-item">
                            <input type="checkbox" name="passenger_suitcase_return[]" value="1">
                            <span>🛄</span>
                            <select name="passenger_suitcase_weight_return[]" class="weight-select-sm">
                                <option value="15">15kg</option>
                                <option value="20" selected>20kg</option>
                                <option value="23">23kg</option>
                                <option value="25">25kg</option>
                                <option value="30">30kg</option>
                            </select>
                        </label>
                    </div>
                </div>
            `;
            container.appendChild(row);
            updatePassengerNumbers();
        }
        
        // הסרת נוסע ועדכון מספרים
        function removePassengerRow(btn) {
            btn.closest('.passenger-row-new').remove();
            updatePassengerNumbers();
        }
        
        // עדכון מספרי נוסעים
        function updatePassengerNumbers() {
            const rows = document.querySelectorAll('.passenger-row-new');
            rows.forEach((row, index) => {
                row.querySelector('.passenger-num').textContent = (index + 1) + '.';
                // הסתר כפתור מחיקה לנוסע ראשון
                const removeBtn = row.querySelector('.btn-remove');
                if (removeBtn) {
                    removeBtn.style.visibility = index === 0 ? 'hidden' : 'visible';
                }
            });
        }
        
        // החלת כבודה על כל הנוסעים
        function applyToAll(type) {
            const rows = document.querySelectorAll('.passenger-row-new');
            const defaultTrolleyWeight = document.getElementById('default_trolley_weight').value;
            const defaultSuitcaseWeight = document.getElementById('default_suitcase_weight').value;
            
            rows.forEach(row => {
                const isSameBothWays = row.querySelector('.same-luggage-checkbox')?.checked ?? true;
                
                if (isSameBothWays) {
                    // מצב משותף
                    if (type === 'backpack') {
                        row.querySelector('input[name="passenger_backpack[]"]').checked = true;
                    } else if (type === 'trolley') {
                        row.querySelector('input[name="passenger_trolley[]"]').checked = true;
                        row.querySelector('select[name="passenger_trolley_weight[]"]').value = defaultTrolleyWeight;
                    } else if (type === 'suitcase') {
                        row.querySelector('input[name="passenger_suitcase[]"]').checked = true;
                        row.querySelector('select[name="passenger_suitcase_weight[]"]').value = defaultSuitcaseWeight;
                    }
                } else {
                    // מצב נפרד - החל על שני הכיוונים
                    if (type === 'backpack') {
                        row.querySelector('input[name="passenger_backpack_outbound[]"]').checked = true;
                        row.querySelector('input[name="passenger_backpack_return[]"]').checked = true;
                    } else if (type === 'trolley') {
                        row.querySelector('input[name="passenger_trolley_outbound[]"]').checked = true;
                        row.querySelector('input[name="passenger_trolley_return[]"]').checked = true;
                        row.querySelector('select[name="passenger_trolley_weight_outbound[]"]').value = defaultTrolleyWeight;
                        row.querySelector('select[name="passenger_trolley_weight_return[]"]').value = defaultTrolleyWeight;
                    } else if (type === 'suitcase') {
                        row.querySelector('input[name="passenger_suitcase_outbound[]"]').checked = true;
                        row.querySelector('input[name="passenger_suitcase_return[]"]').checked = true;
                        row.querySelector('select[name="passenger_suitcase_weight_outbound[]"]').value = defaultSuitcaseWeight;
                        row.querySelector('select[name="passenger_suitcase_weight_return[]"]').value = defaultSuitcaseWeight;
                    }
                }
            });
        }
        
        // ניקוי כל הכבודה
        function clearAllLuggage() {
            const rows = document.querySelectorAll('.passenger-row-new');
            rows.forEach(row => {
                // מצב משותף
                const backpack = row.querySelector('input[name="passenger_backpack[]"]');
                const trolley = row.querySelector('input[name="passenger_trolley[]"]');
                const suitcase = row.querySelector('input[name="passenger_suitcase[]"]');
                if (backpack) backpack.checked = false;
                if (trolley) trolley.checked = false;
                if (suitcase) suitcase.checked = false;
                
                // מצב נפרד
                const fields = ['backpack_outbound', 'trolley_outbound', 'suitcase_outbound', 
                               'backpack_return', 'trolley_return', 'suitcase_return'];
                fields.forEach(field => {
                    const el = row.querySelector(`input[name="passenger_${field}[]"]`);
                    if (el) el.checked = false;
                });
            });
        }
        
        // בחירת כל הכבודה
        function selectAllLuggage() {
            const rows = document.querySelectorAll('.passenger-row-new');
            const defaultTrolleyWeight = document.getElementById('default_trolley_weight').value;
            const defaultSuitcaseWeight = document.getElementById('default_suitcase_weight').value;
            
            rows.forEach(row => {
                const isSameBothWays = row.querySelector('.same-luggage-checkbox')?.checked ?? true;
                
                if (isSameBothWays) {
                    row.querySelector('input[name="passenger_backpack[]"]').checked = true;
                    row.querySelector('input[name="passenger_trolley[]"]').checked = true;
                    row.querySelector('input[name="passenger_suitcase[]"]').checked = true;
                    row.querySelector('select[name="passenger_trolley_weight[]"]').value = defaultTrolleyWeight;
                    row.querySelector('select[name="passenger_suitcase_weight[]"]').value = defaultSuitcaseWeight;
                } else {
                    ['outbound', 'return'].forEach(dir => {
                        row.querySelector(`input[name="passenger_backpack_${dir}[]"]`).checked = true;
                        row.querySelector(`input[name="passenger_trolley_${dir}[]"]`).checked = true;
                        row.querySelector(`input[name="passenger_suitcase_${dir}[]"]`).checked = true;
                        row.querySelector(`select[name="passenger_trolley_weight_${dir}[]"]`).value = defaultTrolleyWeight;
                        row.querySelector(`select[name="passenger_suitcase_weight_${dir}[]"]`).value = defaultSuitcaseWeight;
                    });
                }
            });
        }
        
        // מעבר בין מצב כבודה משותפת לנפרדת - לנוסע ספציפי
        function togglePassengerLuggageMode(checkbox) {
            const row = checkbox.closest('.passenger-row-new');
            const isSameBothWays = checkbox.checked;
            
            const combined = row.querySelector('.luggage-combined');
            const split = row.querySelector('.passenger-luggage-split');
            
            if (isSameBothWays) {
                if (combined) combined.classList.remove('hidden');
                if (split) split.classList.add('hidden');
            } else {
                if (combined) combined.classList.add('hidden');
                if (split) split.classList.remove('hidden');
            }
        }
        
        // בניית JSON כבודה לשמירה
        function buildLuggageJSON() {
            const rows = document.querySelectorAll('.passenger-row-new');
            const passengers = [];
            
            rows.forEach(row => {
                const name = row.querySelector('input[name="passengers[]"]').value.trim();
                if (!name) return;
                
                // בדיקה לכל נוסע בנפרד
                const isSameBothWays = row.querySelector('.same-luggage-checkbox')?.checked ?? true;
                
                if (isSameBothWays) {
                    // מצב משותף - אותה כבודה לשני הכיוונים
                    const hasBackpack = row.querySelector('input[name="passenger_backpack[]"]')?.checked || false;
                    const hasTrolley = row.querySelector('input[name="passenger_trolley[]"]')?.checked || false;
                    const trolleyWeight = row.querySelector('select[name="passenger_trolley_weight[]"]')?.value || '8';
                    const hasSuitcase = row.querySelector('input[name="passenger_suitcase[]"]')?.checked || false;
                    const suitcaseWeight = row.querySelector('select[name="passenger_suitcase_weight[]"]')?.value || '20';
                    
                    passengers.push({
                        name: name,
                        same_both_ways: true,
                        backpack: hasBackpack,
                        trolley: hasTrolley ? parseInt(trolleyWeight) : 0,
                        suitcase: hasSuitcase ? parseInt(suitcaseWeight) : 0
                    });
                } else {
                    // מצב נפרד - כבודה שונה להלוך וחזור
                    const outbound = {
                        backpack: row.querySelector('input[name="passenger_backpack_outbound[]"]')?.checked || false,
                        trolley: row.querySelector('input[name="passenger_trolley_outbound[]"]')?.checked ? 
                                 parseInt(row.querySelector('select[name="passenger_trolley_weight_outbound[]"]')?.value || '8') : 0,
                        suitcase: row.querySelector('input[name="passenger_suitcase_outbound[]"]')?.checked ? 
                                  parseInt(row.querySelector('select[name="passenger_suitcase_weight_outbound[]"]')?.value || '20') : 0
                    };
                    const returnFlight = {
                        backpack: row.querySelector('input[name="passenger_backpack_return[]"]')?.checked || false,
                        trolley: row.querySelector('input[name="passenger_trolley_return[]"]')?.checked ? 
                                 parseInt(row.querySelector('select[name="passenger_trolley_weight_return[]"]')?.value || '8') : 0,
                        suitcase: row.querySelector('input[name="passenger_suitcase_return[]"]')?.checked ? 
                                  parseInt(row.querySelector('select[name="passenger_suitcase_weight_return[]"]')?.value || '20') : 0
                    };
                    
                    passengers.push({
                        name: name,
                        same_both_ways: false,
                        outbound: outbound,
                        return: returnFlight
                    });
                }
            });
            
            return JSON.stringify(passengers);
        }
        
        // יצירת טקסט כבודה בעברית
        function generateLuggageTextHebrew() {
            const rows = document.querySelectorAll('.passenger-row-new');
            let lines = [];
            
            rows.forEach(row => {
                const name = row.querySelector('input[name="passengers[]"]').value.trim();
                if (!name) return; // דלג על נוסעים בלי שם
                
                const isSameBothWays = row.querySelector('.same-luggage-checkbox')?.checked ?? true;
                
                if (isSameBothWays) {
                    // כבודה זהה לשני הכיוונים
                    const hasBackpack = row.querySelector('input[name="passenger_backpack[]"]').checked;
                    const hasTrolley = row.querySelector('input[name="passenger_trolley[]"]').checked;
                    const trolleyWeight = row.querySelector('select[name="passenger_trolley_weight[]"]').value;
                    const hasSuitcase = row.querySelector('input[name="passenger_suitcase[]"]').checked;
                    const suitcaseWeight = row.querySelector('select[name="passenger_suitcase_weight[]"]').value;
                    
                    let items = [];
                    if (hasBackpack) items.push('תיק גב');
                    if (hasTrolley) items.push(`טרולי ${trolleyWeight} ק"ג`);
                    if (hasSuitcase) items.push(`מזוודה ${suitcaseWeight} ק"ג`);
                    
                    if (items.length > 0) {
                        lines.push(`${name}: ${items.join(', ')}`);
                    }
                } else {
                    // כבודה שונה להלוך וחזור
                    // הלוך
                    const hasBackpackOut = row.querySelector('input[name="passenger_backpack_outbound[]"]')?.checked;
                    const hasTrolleyOut = row.querySelector('input[name="passenger_trolley_outbound[]"]')?.checked;
                    const trolleyWeightOut = row.querySelector('select[name="passenger_trolley_weight_outbound[]"]')?.value;
                    const hasSuitcaseOut = row.querySelector('input[name="passenger_suitcase_outbound[]"]')?.checked;
                    const suitcaseWeightOut = row.querySelector('select[name="passenger_suitcase_weight_outbound[]"]')?.value;
                    
                    let outItems = [];
                    if (hasBackpackOut) outItems.push('תיק גב');
                    if (hasTrolleyOut) outItems.push(`טרולי ${trolleyWeightOut} ק"ג`);
                    if (hasSuitcaseOut) outItems.push(`מזוודה ${suitcaseWeightOut} ק"ג`);
                    
                    // חזור
                    const hasBackpackRet = row.querySelector('input[name="passenger_backpack_return[]"]')?.checked;
                    const hasTrolleyRet = row.querySelector('input[name="passenger_trolley_return[]"]')?.checked;
                    const trolleyWeightRet = row.querySelector('select[name="passenger_trolley_weight_return[]"]')?.value;
                    const hasSuitcaseRet = row.querySelector('input[name="passenger_suitcase_return[]"]')?.checked;
                    const suitcaseWeightRet = row.querySelector('select[name="passenger_suitcase_weight_return[]"]')?.value;
                    
                    let retItems = [];
                    if (hasBackpackRet) retItems.push('תיק גב');
                    if (hasTrolleyRet) retItems.push(`טרולי ${trolleyWeightRet} ק"ג`);
                    if (hasSuitcaseRet) retItems.push(`מזוודה ${suitcaseWeightRet} ק"ג`);
                    
                    const outText = outItems.length > 0 ? outItems.join(', ') : 'ללא כבודה';
                    const retText = retItems.length > 0 ? retItems.join(', ') : 'ללא כבודה';
                    
                    // בדיקה אם הכבודה זהה למרות שמסומן נפרד
                    if (outText === retText) {
                        lines.push(`${name}: ${outText}`);
                    } else {
                        lines.push(`${name}:`);
                        lines.push(`   ✈️ הלוך: ${outText}`);
                        lines.push(`   ✈️ חזור: ${retText}`);
                    }
                }
            });
            
            return lines.join('\n');
        }
        
        // יצירת טקסט כבודה באנגלית
        function generateLuggageTextEnglish() {
            const rows = document.querySelectorAll('.passenger-row-new');
            let lines = [];
            
            rows.forEach(row => {
                const name = row.querySelector('input[name="passengers[]"]').value.trim();
                if (!name) return; // דלג על נוסעים בלי שם
                
                const isSameBothWays = row.querySelector('.same-luggage-checkbox')?.checked ?? true;
                
                if (isSameBothWays) {
                    // כבודה זהה לשני הכיוונים
                    const hasBackpack = row.querySelector('input[name="passenger_backpack[]"]').checked;
                    const hasTrolley = row.querySelector('input[name="passenger_trolley[]"]').checked;
                    const trolleyWeight = row.querySelector('select[name="passenger_trolley_weight[]"]').value;
                    const hasSuitcase = row.querySelector('input[name="passenger_suitcase[]"]').checked;
                    const suitcaseWeight = row.querySelector('select[name="passenger_suitcase_weight[]"]').value;
                    
                    let items = [];
                    if (hasBackpack) items.push('Backpack');
                    if (hasTrolley) items.push(`Trolley ${trolleyWeight}kg`);
                    if (hasSuitcase) items.push(`Suitcase ${suitcaseWeight}kg`);
                    
                    if (items.length > 0) {
                        lines.push(`${name}: ${items.join(' + ')}`);
                    }
                } else {
                    // כבודה שונה להלוך וחזור
                    // הלוך
                    const hasBackpackOut = row.querySelector('input[name="passenger_backpack_outbound[]"]')?.checked;
                    const hasTrolleyOut = row.querySelector('input[name="passenger_trolley_outbound[]"]')?.checked;
                    const trolleyWeightOut = row.querySelector('select[name="passenger_trolley_weight_outbound[]"]')?.value;
                    const hasSuitcaseOut = row.querySelector('input[name="passenger_suitcase_outbound[]"]')?.checked;
                    const suitcaseWeightOut = row.querySelector('select[name="passenger_suitcase_weight_outbound[]"]')?.value;
                    
                    let outItems = [];
                    if (hasBackpackOut) outItems.push('Backpack');
                    if (hasTrolleyOut) outItems.push(`Trolley ${trolleyWeightOut}kg`);
                    if (hasSuitcaseOut) outItems.push(`Suitcase ${suitcaseWeightOut}kg`);
                    
                    // חזור
                    const hasBackpackRet = row.querySelector('input[name="passenger_backpack_return[]"]')?.checked;
                    const hasTrolleyRet = row.querySelector('input[name="passenger_trolley_return[]"]')?.checked;
                    const trolleyWeightRet = row.querySelector('select[name="passenger_trolley_weight_return[]"]')?.value;
                    const hasSuitcaseRet = row.querySelector('input[name="passenger_suitcase_return[]"]')?.checked;
                    const suitcaseWeightRet = row.querySelector('select[name="passenger_suitcase_weight_return[]"]')?.value;
                    
                    let retItems = [];
                    if (hasBackpackRet) retItems.push('Backpack');
                    if (hasTrolleyRet) retItems.push(`Trolley ${trolleyWeightRet}kg`);
                    if (hasSuitcaseRet) retItems.push(`Suitcase ${suitcaseWeightRet}kg`);
                    
                    const outText = outItems.length > 0 ? outItems.join(' + ') : 'No luggage';
                    const retText = retItems.length > 0 ? retItems.join(' + ') : 'No luggage';
                    
                    // בדיקה אם הכבודה זהה למרות שמסומן נפרד
                    if (outText === retText) {
                        lines.push(`${name}: ${outText}`);
                    } else {
                        lines.push(`${name}:`);
                        lines.push(`   ✈️ Outbound: ${outText}`);
                        lines.push(`   ✈️ Return: ${retText}`);
                    }
                }
            });
            
            return lines.join('\n');
        }

        // הוספת תשלום
        function addPayment() {
            const container = document.getElementById('payments-container');
            const row = document.createElement('div');
            row.className = 'payment-row';
            row.innerHTML = `
                <input type="text" name="payment_name[]" placeholder="שם המשלם" class="payment-name">
                <input type="number" name="payment_amount[]" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                <select name="payment_method[]" class="payment-method">
                    <option value="אשראי">אשראי</option>
                    <option value="העברה בנקאית">העברה בנקאית</option>
                    <option value="מזומן">מזומן</option>
                    <option value="ביט">ביט</option>
                </select>
                <input type="number" name="payment_installments[]" placeholder="תשלומים" class="payment-installments" min="1" value="1" style="width:80px;">
                <button type="button" class="btn-remove" onclick="removePaymentRow(this)">✕</button>
            `;
            container.appendChild(row);
        }

        // הסרת שורה
        function removeRow(btn) {
            btn.parentElement.remove();
        }

        // הסרת שורת תשלום + עדכון סכום
        function removePaymentRow(btn) {
            btn.parentElement.remove();
            calculateTotal();
        }

        // שערי מטבע מה-PHP
        const exchangeRates = {
            ILS: 1,
            USD: <?= $rates['USD'] ?>,
            EUR: <?= $rates['EUR'] ?>
        };

        // המרה לשקלים
        function convertToILS(amount, currency) {
            const rate = exchangeRates[currency] || 1;
            return amount * rate;
        }

        // חישוב סה"כ תשלומים ורווח
        function calculateTotal() {
            const orderType = document.getElementById('order_type')?.value || 'separate';
            
            // סכום מהלקוח
            const amounts = document.querySelectorAll('input[name="payment_amount[]"]');
            let customerTotal = 0;
            amounts.forEach(input => {
                const val = parseFloat(input.value) || 0;
                customerTotal += val;
            });
            document.getElementById('total-paid').textContent = '₪' + customerTotal.toLocaleString();
            document.getElementById('summary-customer').textContent = '₪' + customerTotal.toLocaleString();

            let totalSupplierCost = 0;
            
            if (orderType === 'separate') {
                // וריאציה 1: טיסה + מלון בנפרד
                
                // עלות טיסה לספק
                const flightCost = parseFloat(document.getElementById('flight_supplier_cost')?.value) || 0;
                const flightCurrency = document.getElementById('flight_supplier_currency')?.value || 'ILS';
                const flightCostILS = convertToILS(flightCost, flightCurrency);
                
                let flightDisplay = '-₪' + Math.round(flightCostILS).toLocaleString();
                if (flightCurrency !== 'ILS' && flightCost > 0) {
                    const symbol = flightCurrency === 'USD' ? '$' : '€';
                    flightDisplay += ` (${symbol}${flightCost})`;
                }
                document.getElementById('summary-flight').textContent = flightDisplay;
                document.getElementById('summary-flight').parentElement.style.display = '';

                // עלות מלון לספק
                const hotelCost = parseFloat(document.getElementById('hotel_supplier_cost')?.value) || 0;
                const hotelCurrency = document.getElementById('hotel_supplier_currency')?.value || 'ILS';
                const hotelCostILS = convertToILS(hotelCost, hotelCurrency);
                
                let hotelDisplay = '-₪' + Math.round(hotelCostILS).toLocaleString();
                if (hotelCurrency !== 'ILS' && hotelCost > 0) {
                    const symbol = hotelCurrency === 'USD' ? '$' : '€';
                    hotelDisplay += ` (${symbol}${hotelCost})`;
                }
                document.getElementById('summary-hotel').textContent = hotelDisplay;
                document.getElementById('summary-hotel').parentElement.style.display = '';
                
                // הסתרת שורת חבילה
                document.getElementById('summary-package').parentElement.style.display = 'none';
                
                totalSupplierCost = flightCostILS + hotelCostILS;
                
            } else {
                // וריאציה 2+3: נופשון / טיול מאורגן
                
                // הסתרת שורות טיסה ומלון
                document.getElementById('summary-flight').parentElement.style.display = 'none';
                document.getElementById('summary-hotel').parentElement.style.display = 'none';
                
                // עלות חבילה לספק
                const packageCost = parseFloat(document.getElementById('package_supplier_cost')?.value) || 0;
                const packageCurrency = document.getElementById('package_supplier_currency')?.value || 'ILS';
                const packageCostILS = convertToILS(packageCost, packageCurrency);
                
                let packageDisplay = '-₪' + Math.round(packageCostILS).toLocaleString();
                if (packageCurrency !== 'ILS' && packageCost > 0) {
                    const symbol = packageCurrency === 'USD' ? '$' : '€';
                    packageDisplay += ` (${symbol}${packageCost})`;
                }
                document.getElementById('summary-package').textContent = packageDisplay;
                document.getElementById('summary-package').parentElement.style.display = '';
                
                totalSupplierCost = packageCostILS;
            }

            // רווח סופי
            const profit = customerTotal - totalSupplierCost;
            const profitEl = document.getElementById('summary-profit');
            profitEl.textContent = '₪' + Math.round(profit).toLocaleString();
            profitEl.classList.toggle('negative', profit < 0);
            
            // עדכון שדה hidden
            document.getElementById('profit').value = Math.round(profit);
        }

        // האזנה לשינויים בעלויות ספקים
        document.addEventListener('DOMContentLoaded', function() {
            const costInputs = [
                'flight_supplier_cost', 'hotel_supplier_cost', 
                'flight_supplier_currency', 'hotel_supplier_currency',
                'package_supplier_cost', 'package_supplier_currency'
            ];
            costInputs.forEach(id => {
                const el = document.getElementById(id);
                if (el) {
                    el.addEventListener('change', calculateTotal);
                    el.addEventListener('input', calculateTotal);
                }
            });
            
            // הפעלה ראשונית
            calculateTotal();
        });

        // הצגת/הסתרת שדות טיסת חזור
        function toggleReturnFlight() {
            const fields = document.getElementById('return-flight-fields');
            const checkbox = document.getElementById('different_return');
            fields.classList.toggle('hidden', !checkbox.checked);
        }

        // הצגה/הסתרה טיסת חזור בחבילה
        function togglePackageReturnFlight() {
            const fields = document.getElementById('package-return-flight-fields');
            const checkbox = document.getElementById('package_different_return');
            fields.classList.toggle('hidden', !checkbox.checked);
        }

        // יצירת טקסט המייל
        function generateEmail() {
            const passengers = Array.from(document.querySelectorAll('input[name="passengers[]"]'))
                .map(input => input.value).filter(v => v);
            
            const destination = document.getElementById('destination').value;
            const airline = document.getElementById('airline_outbound').value.trim();
            const airlineReturn = document.getElementById('airline_return').value.trim();
            const bookingCode = document.getElementById('booking_code_outbound').value;
            const departureDate = document.getElementById('departure_date').value;
            const returnDate = document.getElementById('return_date').value;
            const hotelName = document.getElementById('hotel_name').value;
            const hotelConfirmation = document.getElementById('hotel_confirmation').value;
            const checkin = document.getElementById('hotel_checkin').value;
            const checkout = document.getElementById('hotel_checkout').value;
            const roomType = document.getElementById('room_type').value;
            const mealBasis = document.getElementById('meal_basis').value;
            const luggage = document.getElementById('luggage_details').value;
            const luggageTextHebrew = generateLuggageTextHebrew(); // טקסט עברי לכבודה
            const isDifferentReturn = document.getElementById('different_return').checked;
            
            // מילון תרגום יעדים
            const destinationTranslations = {
                'budapest': 'בודפשט',
                'prague': 'פראג',
                'rome': 'רומא',
                'paris': 'פריז',
                'barcelona': 'ברצלונה',
                'amsterdam': 'אמסטרדם',
                'london': 'לונדון',
                'vienna': 'וינה',
                'berlin': 'ברלין',
                'athens': 'אתונה',
                'lisbon': 'ליסבון',
                'madrid': 'מדריד',
                'milan': 'מילאנו',
                'venice': 'ונציה',
                'florence': 'פירנצה',
                'krakow': 'קרקוב',
                'warsaw': 'ורשה',
                'dublin': 'דבלין',
                'brussels': 'בריסל',
                'munich': 'מינכן',
                'salzburg': 'זלצבורג',
                'rhodes': 'רודוס',
                'crete': 'כרתים',
                'cyprus': 'קפריסין',
                'larnaca': 'לרנקה',
                'paphos': 'פאפוס',
                'sofia': 'סופיה',
                'bucharest': 'בוקרשט',
                'belgrade': 'בלגרד',
                'tirana': 'טירנה',
                'batumi': 'באטומי',
                'tbilisi': 'טביליסי',
                'istanbul': 'איסטנבול',
                'antalya': 'אנטליה'
            };
            
            // תרגום היעד לעברית
            const destLower = destination.toLowerCase().trim();
            let hebrewDestination = destination;
            for (const [eng, heb] of Object.entries(destinationTranslations)) {
                if (destLower.includes(eng)) {
                    hebrewDestination = heb;
                    break;
                }
            }
            
            // חברות "מוקש" - צ'ק אין ידני
            const manualCheckinAirlines = ['wizzair', 'wizz air', 'wizz', 'ryanair', 'ryan air', 'flyone', 'fly one'];
            const airlineLower = airline.toLowerCase();
            const airlineReturnLower = airlineReturn.toLowerCase();
            
            const isManualCheckin = manualCheckinAirlines.some(a => airlineLower.includes(a)) || 
                                   (isDifferentReturn && manualCheckinAirlines.some(a => airlineReturnLower.includes(a)));
            
            // בדיקה אם הטיסה מעל 3 שבועות
            const today = new Date();
            const flightDate = new Date(departureDate);
            const diffDays = Math.floor((flightDate - today) / (1000 * 60 * 60 * 24));
            const showCancellationInsurance = diffDays > 21;
            
            // בניית טקסט חברת תעופה
            let airlineText = '';
            if (isDifferentReturn && airlineReturn) {
                airlineText = `הטיסה בהלוך עם חברת ${airline}, בחזור עם חברת ${airlineReturn}. הטיסה בהלוך אמורה לצאת מטרמינל 3`;
            } else {
                airlineText = `הטיסות הן עם חברת ${airline}. הטיסה הלוך אמורה לצאת מטרמינל 3`;
            }
            
            // בניית טקסט כרטיסי טיסה
            let ticketsText = '';
            if (isManualCheckin) {
                ticketsText = `כרטיסי טיסה תקבלו מאיתנו בוואטסאפ בטווח של 24 שעות מהטיסה אחרי שנבצע לכם את הצ'ק אין.`;
            } else {
                ticketsText = `את כרטיסי הטיסה תקבלו בדלפק של חברת התעופה אחרי שיבוצע לכם הצ'ק אין בשדה.`;
            }
            
            // בניית טקסט ביטוח ביטול
            let cancellationInsuranceText = '';
            if (showCancellationInsurance) {
                cancellationInsuranceText = `
━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח ביטול נסיעה

במידה ומועד החופשה שלכם רחוק אנו ממליצים בחום לרכוש ביטוח לביטול מכל סיבה של חברת טריפ גרנטי (מבית הפניקס) שיאפשר לכם לקבל 80 אחוז בחזרה אפילו עד 6 שעות ממועד הטיסה.
ניתן לרכוש את הביטוח עד 7 ימים ממועד הזמנת החופשה ובתנאי שטווח הזמן עד הנסיעה גדול מ- 15 ימים. לפרטים מלאים ולרכישת הביטוח יש ללחוץ על הקישור הבא:
https://www.tripguaranty.co.il/InsurancePurchase/?agentCode=228`;
            }

            const emailText = `שלום רב,

מצורפים בזאת אישורי הזמנה של הטיסות והמלון ב${hebrewDestination}.
אנא וודאו שהשמות רשומים בדיוק כפי שהם מופיעים אצלכם בדרכון באנגלית.

━━━━━━━━━━━━━━━━━━━━━━━━━

✈️ הנחיות חשובות מאוד לטיסה

${airlineText} אך יש לוודא זאת ביום הטיסה למקרה ויהיו שינויים בקישור הבא:
https://www.iaa.gov.il/airports/ben-gurion/flight-board/

יש להגיע לשדה לפחות 3 וחצי שעות לפני הטיסה.

${ticketsText}

🧳 כבודה
${luggageTextHebrew}
${cancellationInsuranceText}

━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח נסיעות

טרם הנסיעה מומלץ מאוד לעשות ביטוח נסיעות לחו״ל שיכסה הוצאות רפואיות ומקרי חירום.
אנו ממליצים בחום על PassportCard, חברת ביטוח הנסיעות שלטעמנו היא המובילה והאמינה בישראל. ניתן לרכוש את הביטוח שלהם בקלות דרך הלינק הבא:
https://buy.passportcard.co.il/?AffiliateId=xEOn9OJj4ELo8mVndfdKjQ%3D%3D

יתרונות בולטים של PassportCard:
• אין הוצאות מהכיס בחו״ל - ללא צורך בהחזרים!
• מקבלים כרטיס פספורטכארד שמטעינים במקום ומאפשר לשלם ישר לרופא/בית חולים.
• שירות רופאים אונליין 24/7, כולל מרשמים דיגיטליים.
• שירות לקוחות זמין בוואטסאפ.
• מעקב ותפעול תביעה ישירות מהאפליקציה, ללא טפסים.
• אפשרות להרחבות כמו ביטול נסיעה, ציוד יקר, ספורט אתגרי ועוד.

━━━━━━━━━━━━━━━━━━━━━━━━━

למקרים דחופים נשמח לעמוד לרשותכם בוואטסאפ 050-6101031

מאחלים לכם חופשה נעימה! ✈️🌴

חופשה במבצע`;

            document.getElementById('email-output').textContent = emailText;
            document.getElementById('output-section').classList.remove('hidden');
            document.getElementById('output-section').scrollIntoView({ behavior: 'smooth' });
        }

        // פורמט תאריך עברי
        function formatHebrewDate(dateStr) {
            if (!dateStr) return '';
            const date = new Date(dateStr);
            const months = ['ינואר', 'פברואר', 'מרץ', 'אפריל', 'מאי', 'יוני', 
                           'יולי', 'אוגוסט', 'ספטמבר', 'אוקטובר', 'נובמבר', 'דצמבר'];
            return `${date.getDate()} ב${months[date.getMonth()]} ${date.getFullYear()}`;
        }

        // העתקה ללוח
        function copyEmail() {
            const text = document.getElementById('email-output').textContent;
            navigator.clipboard.writeText(text).then(() => {
                alert('הטקסט הועתק! אפשר להדביק במייל');
            });
        }

        // שמירה במערכת
        async function saveOrder() {
            const form = document.getElementById('completeOrderForm');
            const formData = new FormData(form);
            
            // איסוף נוסעים
            const passengers = Array.from(document.querySelectorAll('input[name="passengers[]"]'))
                .map(input => input.value).filter(v => v);
            formData.set('passengers', JSON.stringify(passengers));
            
            // איסוף כבודה
            formData.set('luggage_details', buildLuggageJSON());
            
            // איסוף תשלומים
            const paymentNames = Array.from(document.querySelectorAll('input[name="payment_name[]"]'))
                .map(input => input.value);
            const paymentAmounts = Array.from(document.querySelectorAll('input[name="payment_amount[]"]'))
                .map(input => input.value);
            const paymentMethods = Array.from(document.querySelectorAll('select[name="payment_method[]"]'))
                .map(select => select.value);
            const paymentInstallments = Array.from(document.querySelectorAll('input[name="payment_installments[]"]'))
                .map(input => input.value || '1');
            
            const payments = paymentNames.map((name, i) => ({
                name: name,
                amount: paymentAmounts[i],
                method: paymentMethods[i],
                installments: paymentInstallments[i]
            })).filter(p => p.name || p.amount);
            
            formData.set('payments', JSON.stringify(payments));
            
            // חישוב סה"כ מחיר מהתשלומים
            const totalPrice = payments.reduce((sum, p) => sum + (parseFloat(p.amount) || 0), 0);
            formData.set('total_price', totalPrice);
            
            // סוג הזמנה
            const orderType = document.getElementById('order_type')?.value || 'separate';
            formData.set('order_type', orderType);
            
            if (orderType === 'separate') {
                // וריאציה 1: טיסה + מלון בנפרד
                formData.set('flight_supplier_paid', document.getElementById('flight_supplier_paid')?.value || 'paid');
                formData.set('hotel_supplier_paid', document.getElementById('hotel_supplier_paid')?.value || 'paid');
            } else {
                // וריאציה 2+3: נופשון / טיול מאורגן
                // העתקת נתונים מחבילה לשדות הרגילים
                formData.set('destination', document.getElementById('package_destination')?.value || '');
                formData.set('departure_date', document.getElementById('package_departure')?.value || '');
                formData.set('return_date', document.getElementById('package_return')?.value || '');
                
                // פרטי טיסת הלוך
                formData.set('airline_outbound', document.getElementById('package_airline')?.value || '');
                formData.set('flight_number_outbound', document.getElementById('package_flight_number_out')?.value || '');
                formData.set('flight_time_outbound', document.getElementById('package_flight_time_out')?.value || '');
                formData.set('booking_code_outbound', document.getElementById('package_flight_code')?.value || '');
                
                // פרטי טיסת חזור
                formData.set('flight_time_return', document.getElementById('package_flight_time_ret')?.value || '');
                if (document.getElementById('package_different_return')?.checked) {
                    formData.set('airline_return', document.getElementById('package_airline_return')?.value || '');
                    formData.set('flight_number_return', document.getElementById('package_flight_number_ret')?.value || '');
                    formData.set('booking_code_return', document.getElementById('package_flight_code_return')?.value || '');
                }
                
                // פרטי מלון
                formData.set('hotel_name', document.getElementById('package_hotel')?.value || '');
                formData.set('meal_basis', document.getElementById('package_meal_basis')?.value || '');
                formData.set('hotel_checkin', document.getElementById('package_checkin')?.value || '');
                formData.set('hotel_checkout', document.getElementById('package_checkout')?.value || '');
                formData.set('room_type', document.getElementById('package_room_type')?.value || '');
                
                // ספק החבילה
                formData.set('package_supplier', document.getElementById('package_supplier')?.value || '');
                formData.set('package_supplier_booking', document.getElementById('package_supplier_booking')?.value || '');
                formData.set('package_supplier_cost', document.getElementById('package_supplier_cost')?.value || '0');
                formData.set('package_supplier_currency', document.getElementById('package_supplier_currency')?.value || 'ILS');
                formData.set('package_supplier_paid', document.getElementById('package_supplier_paid')?.value || 'paid');
                
                // איפוס שדות נפרדים
                formData.set('flight_supplier', '');
                formData.set('flight_supplier_paid', 'paid');
                formData.set('hotel_supplier', '');
                formData.set('hotel_supplier_paid', 'paid');
            }
            
            try {
                const response = await fetch('api/save_complete_order.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('ההזמנה נשמרה בהצלחה!');
                    // הצג כפתור לוואצ'ר
                    const voucherBtn = document.createElement('a');
                    voucherBtn.href = 'voucher.php?token=' + result.token;
                    voucherBtn.target = '_blank';
                    voucherBtn.className = 'btn btn-primary';
                    voucherBtn.style.marginRight = '10px';
                    voucherBtn.innerHTML = '📄 צפה בוואצ\'ר';
                    document.getElementById('output-section').appendChild(voucherBtn);
                } else {
                    alert('שגיאה: ' + result.error);
                }
            } catch (error) {
                alert('שגיאת תקשורת');
            }
        }

        // סנכרון תאריכים
        document.getElementById('departure_date').addEventListener('change', function() {
            document.getElementById('hotel_checkin').value = this.value;
        });
        document.getElementById('return_date').addEventListener('change', function() {
            document.getElementById('hotel_checkout').value = this.value;
        });
        
        // טעינת רשימות להשלמה אוטומטית
        async function loadAutocompleteData() {
            try {
                // טעינת ספקים
                const suppliersRes = await fetch('api/get_autocomplete.php?type=suppliers');
                const suppliersData = await suppliersRes.json();
                if (suppliersData.success && suppliersData.items) {
                    populateSupplierSelects(suppliersData.items);
                }
                
                // טעינת חברות תעופה
                const airlinesRes = await fetch('api/get_autocomplete.php?type=airlines');
                const airlinesData = await airlinesRes.json();
                if (airlinesData.success && airlinesData.items) {
                    populateDatalist('airlines-list', airlinesData.items.map(a => a.name));
                }
                
                // טעינת יעדים
                const destRes = await fetch('api/get_autocomplete.php?type=destinations');
                const destData = await destRes.json();
                if (destData.success && destData.items) {
                    populateDatalist('destinations-list', destData.items.map(d => d.display));
                }
                
            } catch (error) {
                console.log('Error loading autocomplete data:', error);
            }
        }
        
        function populateDatalist(listId, items) {
            let datalist = document.getElementById(listId);
            if (!datalist) {
                datalist = document.createElement('datalist');
                datalist.id = listId;
                document.body.appendChild(datalist);
            }
            datalist.innerHTML = items.map(item => `<option value="${item}">`).join('');
        }
        
        function populateSupplierSelects(suppliers) {
            const selects = [
                'flight_supplier', 'hotel_supplier', 'package_supplier', 'organized_supplier'
            ];
            selects.forEach(selectId => {
                const select = document.getElementById(selectId);
                if (select) {
                    // שמור את הערך הנוכחי
                    const currentValue = select.value;
                    // נקה את האופציות הקיימות (חוץ מהראשונה)
                    while (select.options.length > 1) {
                        select.remove(1);
                    }
                    // הוסף ספקים מהשרת
                    suppliers.forEach(s => {
                        const option = document.createElement('option');
                        option.value = s;
                        option.textContent = s;
                        select.appendChild(option);
                    });
                    // הוסף אפשרות "אחר"
                    const otherOption = document.createElement('option');
                    otherOption.value = '_other';
                    otherOption.textContent = '➕ ספק אחר...';
                    select.appendChild(otherOption);
                    // החזר את הערך
                    if (currentValue) select.value = currentValue;
                }
            });
        }
        
        // טעינת מלונות לפי יעד
        async function loadHotelsForDestination(destination) {
            if (!destination) return;
            const cityName = destination.split(',')[0].trim();
            try {
                const res = await fetch(`api/get_autocomplete.php?type=hotels&destination=${encodeURIComponent(cityName)}`);
                const data = await res.json();
                if (data.success && data.items) {
                    populateDatalist('hotels-list', data.items.map(h => h.name));
                }
            } catch (error) {
                console.log('Error loading hotels:', error);
            }
        }
        
        // חיבור שדות יעד לטעינת מלונות
        document.getElementById('destination')?.addEventListener('change', function() {
            loadHotelsForDestination(this.value);
        });
        document.getElementById('package_destination')?.addEventListener('change', function() {
            loadHotelsForDestination(this.value);
        });
        
        // טעינה ראשונית
        loadAutocompleteData();
        
        // === טעינת תשלומים מטיוטה ===
        async function loadDraftPayments(draftId) {
            console.log('loadDraftPayments called with draftId:', draftId);
            try {
                const url = `api/get_draft_payments.php?draft_id=${draftId}`;
                console.log('Fetching:', url);
                const response = await fetch(url);
                const data = await response.json();
                console.log('API response:', data);
                
                if (!data.success || !data.payments || data.payments.length === 0) {
                    console.log('No draft payments found or error:', data);
                    return;
                }
                
                console.log('Loading draft payments:', data.payments);
                
                // נקה תשלומים קיימים
                const container = document.getElementById('payments-container');
                container.innerHTML = '';
                
                // הוסף כל תשלום מהטיוטה
                data.payments.forEach((payment, index) => {
                    const installments = payment.installments || 1;
                    const last4 = payment.last_4_digits ? ` (${payment.last_4_digits})` : '';
                    const cardInfo = payment.card_brand ? ` - ${payment.card_brand}` : '';
                    
                    const row = document.createElement('div');
                    row.className = 'payment-row';
                    row.innerHTML = `
                        <input type="text" name="payment_name[]" value="${payment.payer_name || ''}${last4}" placeholder="שם המשלם" class="payment-name">
                        <input type="number" name="payment_amount[]" value="${payment.amount || ''}" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                        <select name="payment_method[]" class="payment-method">
                            <option value="אשראי" selected>אשראי${cardInfo}</option>
                            <option value="העברה בנקאית">העברה בנקאית</option>
                            <option value="מזומן">מזומן</option>
                            <option value="ביט">ביט</option>
                        </select>
                        <input type="number" name="payment_installments[]" placeholder="תשלומים" class="payment-installments" min="1" value="${installments}" style="width:80px;">
                        <button type="button" class="btn-remove" onclick="removePaymentRow(this)"${index === 0 ? ' style="visibility:hidden;"' : ''}>✕</button>
                    `;
                    container.appendChild(row);
                });
                
                // עדכון סה"כ
                calculateTotal();
                
                // הודעה
                const paymentsTitle = document.querySelector('.form-section:has(#payments-container) .section-title');
                if (paymentsTitle) {
                    paymentsTitle.innerHTML = 'פרטי תשלומים מלקוחות <span style="color:#28a745; font-size:0.8em;">✓ נטענו מקארדקום</span>';
                }
                
            } catch (e) {
                console.error('Error loading draft payments:', e);
            }
        }
        
        // === טעינת נתונים מטיוטה ===
        function loadDraftData() {
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.get('from') !== 'draft') return;
            
            const draftJson = sessionStorage.getItem('draftData');
            if (!draftJson) return;
            
            try {
                const draft = JSON.parse(draftJson);
                console.log('Loading draft data:', draft);
                
                // פרטי לקוח -> משלם ראשון
                if (draft.customer_name) {
                    const payerInput = document.querySelector('input[name="payers[]"]');
                    if (payerInput) payerInput.value = draft.customer_name;
                }
                
                // טלפון לקוח
                if (draft.customer_phone) {
                    const phoneField = document.getElementById('customer_phone');
                    if (phoneField) phoneField.value = draft.customer_phone;
                }
                
                // אימייל לקוח
                if (draft.customer_email) {
                    const emailField = document.getElementById('customer_email');
                    if (emailField) emailField.value = draft.customer_email;
                }
                
                // יעד
                if (draft.destination) {
                    const destField = document.getElementById('destination');
                    if (destField) destField.value = draft.destination;
                    const pkgDestField = document.getElementById('package_destination');
                    if (pkgDestField) pkgDestField.value = draft.destination;
                }
                
                // תאריכים
                if (draft.departure_date) {
                    const depField = document.getElementById('departure_date');
                    if (depField) depField.value = draft.departure_date;
                    const checkinField = document.getElementById('hotel_checkin');
                    if (checkinField) checkinField.value = draft.departure_date;
                }
                if (draft.return_date) {
                    const retField = document.getElementById('return_date');
                    if (retField) retField.value = draft.return_date;
                    const checkoutField = document.getElementById('hotel_checkout');
                    if (checkoutField) checkoutField.value = draft.return_date;
                }
                
                // נוסעים - הוספת שדות אם צריך
                if (draft.num_passengers) {
                    const numPass = parseInt(draft.num_passengers);
                    const passContainer = document.getElementById('passengersContainer');
                    if (passContainer) {
                        const currentRows = passContainer.querySelectorAll('.passenger-row').length;
                        for (let i = currentRows; i < numPass; i++) {
                            addPassenger();
                        }
                    }
                    // מילוי שם ראשון
                    if (draft.customer_name) {
                        const firstPassenger = document.querySelector('input[name="passengers[]"]');
                        if (firstPassenger) firstPassenger.value = draft.customer_name;
                    }
                }
                
                // חברת תעופה
                if (draft.airline) {
                    const airlineField = document.getElementById('airline_outbound');
                    if (airlineField) airlineField.value = draft.airline;
                    const pkgAirline = document.getElementById('package_airline');
                    if (pkgAirline) pkgAirline.value = draft.airline;
                }
                
                // שעות טיסה
                if (draft.flight_time_out) {
                    const timeOutField = document.getElementById('flight_time_outbound');
                    if (timeOutField) timeOutField.value = draft.flight_time_out;
                    const pkgTimeOut = document.getElementById('package_flight_time_out');
                    if (pkgTimeOut) pkgTimeOut.value = draft.flight_time_out;
                }
                if (draft.flight_time_return) {
                    const timeRetField = document.getElementById('flight_time_return');
                    if (timeRetField) timeRetField.value = draft.flight_time_return;
                    const pkgTimeRet = document.getElementById('package_flight_time_return');
                    if (pkgTimeRet) pkgTimeRet.value = draft.flight_time_return;
                }
                
                // מלון
                if (draft.hotel_name) {
                    const hotelField = document.getElementById('hotel_name');
                    if (hotelField) hotelField.value = draft.hotel_name;
                    const pkgHotel = document.getElementById('package_hotel');
                    if (pkgHotel) pkgHotel.value = draft.hotel_name;
                }
                
                // בסיס לינה
                if (draft.board_basis) {
                    const boardField = document.getElementById('board_basis');
                    if (boardField) boardField.value = draft.board_basis;
                    const pkgBoard = document.getElementById('package_board_basis');
                    if (pkgBoard) pkgBoard.value = draft.board_basis;
                }
                
                // מחיר
                if (draft.total_price) {
                    const priceField = document.getElementById('total_price');
                    if (priceField) priceField.value = draft.total_price;
                }
                
                // דרוג כוכבים
                if (draft.hotel_stars) {
                    const starsField = document.getElementById('hotel_stars');
                    if (starsField) starsField.value = draft.hotel_stars;
                }
                
                // הערות
                if (draft.notes) {
                    const notesField = document.getElementById('notes');
                    if (notesField) notesField.value = draft.notes;
                }
                
                // הצגת הודעה
                const title = document.querySelector('.card-title');
                if (title) {
                    title.innerHTML = '📋 השלמת הזמנה - <span style="color:#28a745;">נתונים נטענו מטיוטה #' + draft.id + '!</span>';
                }
                
                // שמירת מזהה הטיוטה בשדה נסתר
                let hiddenDraftId = document.getElementById('draft_id');
                if (!hiddenDraftId) {
                    hiddenDraftId = document.createElement('input');
                    hiddenDraftId.type = 'hidden';
                    hiddenDraftId.name = 'draft_id';
                    hiddenDraftId.id = 'draft_id';
                    document.querySelector('form')?.appendChild(hiddenDraftId);
                }
                hiddenDraftId.value = draft.id;
                
                // טעינת תשלומים מהטיוטה (אם יש)
                console.log('About to call loadDraftPayments with draft.id:', draft.id);
                loadDraftPayments(draft.id);
                
                // ניקוי ה-sessionStorage
                sessionStorage.removeItem('draftData');
                
                // עדכון חישובים
                if (typeof calculateAll === 'function') calculateAll();
                
            } catch (e) {
                console.error('Error loading draft data:', e);
            }
        }
        
        // טעינה אחרי שהדף נטען
        setTimeout(loadDraftData, 500);
    </script>
</body>
</html>
