<?php
// טופס השלמת הזמנה - גרסה לייט
require_once 'includes/auth.php';
requireLogin();
blockAccountant();

$agent = getCurrentAgent();
$isAdmin = ($agent && isset($agent['role']) && $agent['role'] === 'admin');
$pdo = getDB();

// שליפת נתוני טיוטה אם יש
$draftData = null;
$draftPayments = [];
if (!empty($_GET['draft_id'])) {
    $draftId = (int)$_GET['draft_id'];
    $stmt = $pdo->prepare("SELECT * FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    $draftData = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // שליפת תשלומים
    if ($draftData) {
        try {
            // שליפת תשלומים - עם bank_transfer_id
            try {
                $stmt = $pdo->prepare("SELECT payer_name, payer_email, amount, payment_method, last_4_digits, card_brand, bank_transfer_id FROM draft_payments WHERE draft_id = ? ORDER BY payment_date");
                $stmt->execute([$draftId]);
            } catch (Exception $e) {
                // fallback - בלי bank_transfer_id
                try {
                    $stmt = $pdo->prepare("SELECT payer_name, payer_email, amount, payment_method, last_4_digits, card_brand, NULL as bank_transfer_id FROM draft_payments WHERE draft_id = ? ORDER BY payment_date");
                    $stmt->execute([$draftId]);
                } catch (Exception $e2) {
                    // fallback - עמודות בסיסיות בלבד
                    $stmt = $pdo->prepare("SELECT payer_name, '' as payer_email, amount, 'credit_card' as payment_method, '' as last_4_digits, '' as card_brand, NULL as bank_transfer_id FROM draft_payments WHERE draft_id = ? ORDER BY payment_date");
                    $stmt->execute([$draftId]);
                }
            }
            $draftPayments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            // טבלה לא קיימת
        }
    }
}

// שליפת שערי מטבע
$rates = ['USD' => 3.65, 'EUR' => 3.95, 'ILS' => 1];
$stmt = $pdo->query("SELECT currency, rate FROM exchange_rates");
while ($row = $stmt->fetch()) {
    $rates[$row['currency']] = (float)$row['rate'];
}

// שליפת ספקים מההגדרות
$suppliers = $pdo->query("SELECT name FROM settings_suppliers WHERE active = 1 ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);

// שליפת חברות תעופה מההגדרות
$airlines = $pdo->query("SELECT name FROM settings_airlines WHERE active = 1 ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);

// שליפת יעדים מההגדרות
$destinations = $pdo->query("SELECT name, country, name_he FROM settings_destinations WHERE active = 1 ORDER BY sort_order, name")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>השלמת הזמנה - לייט | <?= SITE_NAME ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            padding: 0;
            color: #333;
        }
        .top-nav {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 30px;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            flex-wrap: wrap;
            gap: 15px;
        }
        .logo {
            font-size: 1.3rem;
            font-weight: bold;
            color: #333;
        }
        .logo span {
            color: #667eea;
        }
        .main-nav {
            display: flex;
            gap: 5px;
        }
        .nav-link {
            padding: 10px 20px;
            text-decoration: none;
            color: #555;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s;
        }
        .nav-link:hover {
            background: #f0f0f0;
            color: #333;
        }
        .nav-link.active {
            background: #667eea;
            color: white;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .user-name {
            color: #666;
        }
        .btn-logout {
            background: #f44336;
            color: white;
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 0.85rem;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 30px;
            border-radius: 15px 15px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .header .badge {
            background: #ff9800;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
        }
        .form-container {
            background: white;
            padding: 30px;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }
        .section {
            margin-bottom: 30px;
            padding-bottom: 25px;
            border-bottom: 2px solid #eee;
        }
        .section:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        .section-title {
            font-size: 1.1rem;
            color: #667eea;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 15px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
        }
        .form-group label {
            font-size: 0.85rem;
            color: #666;
            margin-bottom: 5px;
            font-weight: 500;
        }
        .form-group input,
        .form-group select {
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        .form-group input:focus,
        .form-group select:focus {
            border-color: #667eea;
            outline: none;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .form-group.full-width {
            grid-column: 1 / -1;
        }
        
        /* נוסעים */
        .passengers-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .passenger-input {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .passenger-input input {
            flex: 1;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
        }
        .passenger-input .passenger-num {
            background: #667eea;
            color: white;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 0.85rem;
        }
        .btn-add-passenger {
            background: #e8f5e9;
            color: #4caf50;
            border: 2px dashed #4caf50;
            padding: 10px;
            border-radius: 10px;
            cursor: pointer;
            font-size: 0.9rem;
            transition: all 0.3s;
        }
        .btn-add-passenger:hover {
            background: #4caf50;
            color: white;
        }
        .btn-remove {
            background: #ffebee;
            color: #e53935;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 1.2rem;
        }
        
        /* ספק טיסה */
        .supplier-card {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 15px;
            border: 2px solid #e0e0e0;
        }
        .supplier-card.return-supplier {
            background: #fff8e1;
            border-color: #ffcc80;
        }
        /* כרטיסי מלונות */
        .hotel-card {
            background: #f0f7ff;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 15px;
            border: 2px solid #90caf9;
            position: relative;
        }
        .hotel-card:hover {
            border-color: #42a5f5;
        }
        .hotel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #bbdefb;
        }
        .hotel-number {
            font-weight: bold;
            color: #1976d2;
            font-size: 1rem;
        }
        .btn-remove-hotel {
            background: #f44336;
            color: white;
            border: none;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            cursor: pointer;
            font-size: 1rem;
            transition: all 0.2s;
        }
        .btn-remove-hotel:hover {
            background: #d32f2f;
            transform: scale(1.1);
        }
        .btn-add-hotel {
            background: linear-gradient(135deg, #42a5f5 0%, #1976d2 100%);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            display: block;
            margin: 15px auto 0;
            transition: all 0.2s;
        }
        .btn-add-hotel:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(25, 118, 210, 0.3);
        }
        .supplier-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        .supplier-header h4 {
            color: #333;
            font-size: 1rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        /* העלאת קבצים */
        .upload-area {
            border: 2px dashed #ccc;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
            background: #fafafa;
        }
        .upload-area:hover {
            border-color: #667eea;
            background: #f0f4ff;
        }
        .upload-area:not(.has-file):hover .upload-text::after {
            content: '';
            color: #667eea;
            font-weight: 600;
        }
        .upload-area.has-file {
            border-color: #4caf50;
            background: #e8f5e9;
        }
        .upload-area.drag-over {
            border-color: #667eea;
            background: #e3f2fd;
            transform: scale(1.02);
        }
        .upload-area:focus {
            outline: 3px solid #667eea;
            outline-offset: 2px;
            background: #e8eaf6;
        }
        .upload-area:focus .upload-text {
            color: #667eea;
            font-weight: 600;
        }
        .upload-area input[type="file"] {
            display: none;
        }
        .upload-icon {
            font-size: 2rem;
            margin-bottom: 10px;
        }
        .upload-text {
            color: #666;
            font-size: 0.85rem;
        }
        .file-preview {
            margin-top: 10px;
            max-width: 100%;
            max-height: 150px;
            border-radius: 8px;
        }
        .file-name {
            margin-top: 10px;
            color: #4caf50;
            font-weight: 500;
        }
        .btn-remove-file {
            display: block;
            margin: 10px auto 0;
            padding: 5px 15px;
            background: #ffebee;
            color: #e53935;
            border: 1px solid #e53935;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.8rem;
        }
        .btn-remove-file:hover {
            background: #e53935;
            color: white;
        }
        
        /* קוביה מתקפלת - שונות */
        .collapsible-header {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px 20px;
            background: #f5f5f5;
            border: 2px dashed #ccc;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
        }
        .collapsible-header:hover {
            background: #e8f5e9;
            border-color: #4caf50;
        }
        .collapsible-header.open {
            background: #e3f2fd;
            border-color: #667eea;
            border-style: solid;
            border-radius: 10px 10px 0 0;
        }
        .collapsible-icon {
            font-size: 1.2rem;
            transition: transform 0.3s;
        }
        .collapsible-hint {
            margin-right: auto;
            color: #999;
            font-size: 0.85rem;
        }
        .collapsible-header.open .collapsible-hint {
            display: none;
        }
        .collapsible-content {
            background: #fafafa;
            border: 2px solid #667eea;
            border-top: none;
            border-radius: 0 0 10px 10px;
            padding: 20px;
        }
        .extra-item {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            position: relative;
        }
        .extra-item-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        .extra-item-title {
            font-weight: 600;
            color: #333;
        }
        .btn-remove-extra {
            background: #ffebee;
            color: #e53935;
            border: none;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 1rem;
        }
        .btn-remove-extra:hover {
            background: #e53935;
            color: white;
        }
        .btn-add-extra {
            display: block;
            width: 100%;
            padding: 12px;
            background: #e8f5e9;
            color: #4caf50;
            border: 2px dashed #4caf50;
            border-radius: 10px;
            cursor: pointer;
            font-size: 0.95rem;
            font-weight: 500;
            transition: all 0.3s;
        }
        .btn-add-extra:hover {
            background: #4caf50;
            color: white;
        }
        .extra-item .upload-area {
            padding: 15px;
        }
        .extra-item .upload-icon {
            font-size: 1.5rem;
            margin-bottom: 5px;
        }
        .extra-item .upload-text {
            font-size: 0.8rem;
        }
        .extra-item .file-preview {
            max-height: 100px;
        }
        
        /* תשלומים */
        .payment-row {
            display: flex;
            gap: 8px;
            align-items: flex-start;
            margin-bottom: 10px;
            flex-wrap: wrap;
            padding: 10px;
            background: #f9f9f9;
            border-radius: 8px;
            border: 1px solid #eee;
        }
        .payment-row input, .payment-row select {
            padding: 10px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 0.9rem;
        }
        .payment-row .payment-name { flex: 2; min-width: 100px; }
        .payment-row .payment-amount { flex: 1; min-width: 70px; width: 80px; }
        .payment-row .payment-method { flex: 1; min-width: 90px; }
        .payment-row .payment-installments { width: 60px !important; min-width: 60px; flex: 0; }
        .payment-row .payment-last4 { width: 70px !important; min-width: 70px; flex: 0; }
        .payment-row .payment-email { flex: 2; min-width: 140px; }
        .payment-row .bank-transfer-fields {
            width: 100%;
            margin-top: 8px;
            padding: 10px;
            background: #fff3e0;
            border-radius: 6px;
            border: 1px dashed #ff9800;
        }
        .payment-row .bank-transfer-fields label {
            display: block;
            font-size: 0.8rem;
            color: #e65100;
            margin-bottom: 5px;
        }
        .payment-row .bank-upload-area {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .payment-row .bank-upload-btn {
            background: #ff9800;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 0.85rem;
        }
        .payment-row .bank-upload-btn:hover { background: #f57c00; }
        .payment-row .bank-file-name {
            color: #4caf50;
            font-size: 0.85rem;
        }
        .btn-add {
            background: #28a745;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 0.9rem;
            margin-top: 10px;
        }
        .btn-add:hover {
            background: #218838;
        }
        .total-summary {
            margin-top: 20px;
            padding: 15px;
            background: #d4edda;
            border-radius: 10px;
        }
        .total-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 1.2rem;
            font-weight: 600;
        }
        .total-amount {
            font-size: 1.5rem;
            color: #28a745;
        }
        
        /* סיכום רווח */
        .profit-section {
            background: #e8f5e9;
            border-radius: 15px;
            padding: 20px;
        }
        .profit-summary {
            background: white;
            padding: 15px;
            border-radius: 10px;
        }
        .profit-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
            font-size: 1.05rem;
        }
        .profit-row:last-child {
            border-bottom: none;
        }
        .profit-row.total {
            border-top: 2px solid #28a745;
            margin-top: 10px;
            padding-top: 15px;
            font-weight: bold;
            font-size: 1.2rem;
        }
        .profit-value {
            font-weight: 600;
        }
        .profit-value.expense {
            color: #dc3545;
        }
        .profit-value.final {
            color: #28a745;
            font-size: 1.4rem;
        }
        .profit-value.negative {
            color: #dc3545 !important;
        }
        .rates-info {
            margin-top: 15px;
            padding: 10px 15px;
            background: #fff3cd;
            border-radius: 8px;
            font-size: 0.9rem;
            color: #856404;
        }
        .rates-info a {
            color: #856404;
        }
        
        /* הערות */
        .notes-textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
            resize: vertical;
            min-height: 80px;
        }
        .notes-textarea:focus {
            border-color: #667eea;
            outline: none;
        }
        
        /* אזור פלט - אישור הזמנה */
        .output-section {
            background: #e8f5e9;
            padding: 20px;
            border-radius: 15px;
            margin-top: 20px;
        }
        .email-output {
            background: white;
            padding: 20px;
            border-radius: 10px;
            border: 1px solid #ddd;
            white-space: pre-wrap;
            font-family: inherit;
            line-height: 1.8;
            max-height: 400px;
            overflow-y: auto;
        }
        .copy-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            margin-top: 15px;
            margin-left: 10px;
        }
        .copy-btn:hover {
            background: #0056b3;
        }
        .send-email-btn {
            background: #28a745;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
        }
        .send-email-btn:hover {
            background: #1e7e34;
        }
        .send-email-btn:disabled {
            background: #6c757d;
            cursor: not-allowed;
        }
        .output-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 15px;
        }
        
        /* כפתורים */
        .btn {
            padding: 15px 30px;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 600;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        .btn-secondary {
            background: #f5f5f5;
            color: #333;
        }
        .btn-test {
            background: linear-gradient(135deg, #ff9800 0%, #f57c00 100%);
            color: white;
        }
        .btn-test:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(255, 152, 0, 0.4);
        }
        
        /* צ'קבוקס טיסת חזור שונה */
        .different-return-check {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px;
            background: #fff3e0;
            border-radius: 10px;
            margin-top: 15px;
            cursor: pointer;
        }
        .different-return-check input {
            width: 20px;
            height: 20px;
        }
        .different-return-check label {
            cursor: pointer;
            font-weight: 500;
            color: #e65100;
        }
        
        /* סטטוס תשלום */
        .payment-status {
            display: flex;
            gap: 10px;
        }
        .payment-status label {
            display: flex;
            align-items: center;
            gap: 5px;
            padding: 10px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
        }
        .payment-status input[type="radio"] {
            display: none;
        }
        .payment-status input[type="radio"]:checked + label {
            border-color: #667eea;
            background: #f0f4ff;
        }
        .payment-status .paid {
            color: #4caf50;
        }
        .payment-status .unpaid {
            color: #ff9800;
        }
        
        /* Actions */
        .form-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
        }
        
        /* Back link */
        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            color: white;
            text-decoration: none;
            margin-bottom: 15px;
            opacity: 0.8;
        }
        .back-link:hover {
            opacity: 1;
        }
        
        /* Hidden */
        .hidden {
            display: none !important;
        }
        
        /* Order Type Selector */
        .order-type-option:has(input:checked) {
            border-color: #667eea !important;
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
            transform: translateY(-3px);
        }
        .order-type-option:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
    </style>
    <!-- Flatpickr - בוחר תאריכים נוח -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/he.js"></script>
    <style>
        /* מסגרת ירוקה לסוג הזמנה שנבחר */
        .order-type-option:has(input:checked) {
            border-color: #28a745 !important;
            box-shadow: 0 0 10px rgba(40, 167, 69, 0.3);
        }
        .order-type-option.selected {
            border-color: #28a745 !important;
            box-shadow: 0 0 10px rgba(40, 167, 69, 0.3);
        }
        
        .flatpickr-input {
            cursor: pointer !important;
            background: white !important;
        }
        .flatpickr-calendar {
            font-family: Arial, sans-serif;
            direction: rtl;
            width: 320px;
        }
        .flatpickr-day.selected {
            background: #667eea !important;
            border-color: #667eea !important;
        }
        /* הסתרת כל החצים */
        .flatpickr-prev-month,
        .flatpickr-next-month,
        .flatpickr-current-month .numInputWrapper span {
            display: none !important;
        }
        /* עיצוב אזור החודש והשנה */
        .flatpickr-months {
            padding: 10px;
        }
        .flatpickr-current-month {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            padding: 0;
            width: 100%;
        }
        /* דרופדאון חודשים */
        .flatpickr-current-month select.flatpickr-monthDropdown-months {
            font-size: 1rem;
            font-weight: bold;
            padding: 8px 30px 8px 10px;
            border-radius: 6px;
            border: 1px solid #ddd;
            background: white;
            cursor: pointer;
            appearance: menulist;
            -webkit-appearance: menulist;
        }
        /* שדה שנה - דרופדאון */
        .flatpickr-current-month .numInputWrapper {
            width: auto;
        }
        .flatpickr-current-month .numInputWrapper input.cur-year {
            font-size: 1rem;
            font-weight: bold;
            padding: 8px 10px;
            border-radius: 6px;
            border: 1px solid #ddd;
            background: white;
            cursor: pointer;
            width: 80px;
            text-align: center;
        }
        .flatpickr-weekdays, .flatpickr-days {
            direction: rtl;
        }
        
        /* Loading Overlay */
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }
        .loading-overlay.active {
            display: flex;
        }
        .loading-spinner {
            width: 60px;
            height: 60px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .loading-text {
            color: white;
            font-size: 1.3rem;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <!-- תפריט עליון -->
    <header class="top-nav">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <nav class="main-nav">
            <a href="complete_order_lite.php" class="nav-link active">⚡ הזמנה לייט</a>
            <a href="drafts_list.php" class="nav-link">📋 טיוטות</a>
            <a href="orders_panel.php" class="nav-link">🔍 פאנל מתקדם</a>
            <?php if ($isAdmin): ?>
            <a href="reports.php" class="nav-link">📈 דוחות</a>
            <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
            <?php endif; ?>
        </nav>
        <div class="user-info">
            <span class="user-name">שלום, <?= sanitize($agent['full_name']) ?></span>
            <a href="logout.php" class="btn-logout">התנתק</a>
        </div>
    </header>

    <div class="container">
        <div class="header">
            <h1>✈️ השלמת הזמנה</h1>
            <span class="badge">גרסה לייט</span>
        </div>
        
        <div class="form-container">
            <form id="orderForm">
                
                <!-- סוג הזמנה -->
                <div class="section" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px; border-radius: 15px; margin-bottom: 25px;">
                    <h3 class="section-title" style="color: white; margin-bottom: 20px;">🎯 סוג ההזמנה <span style="color: #ffeb3b;">*</span></h3>
                    <div class="order-type-selector" id="orderTypeSelector" style="display: flex; gap: 15px; flex-wrap: wrap;">
                        <label class="order-type-option" style="flex: 1; min-width: 150px; background: white; border-radius: 12px; padding: 20px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;">
                            <input type="radio" name="order_type" value="separate" style="display: none;">
                            <div style="font-size: 2rem; margin-bottom: 10px;">✈️🏨</div>
                            <div style="font-weight: bold; color: #333;">חבילה נפרדת</div>
                            <div style="font-size: 0.8rem; color: #666; margin-top: 5px;">טיסה + מלון בנפרד</div>
                        </label>
                        <label class="order-type-option" style="flex: 1; min-width: 150px; background: white; border-radius: 12px; padding: 20px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;">
                            <input type="radio" name="order_type" value="package" style="display: none;">
                            <div style="font-size: 2rem; margin-bottom: 10px;">📦</div>
                            <div style="font-weight: bold; color: #333;">נופשון קומפלט</div>
                            <div style="font-size: 0.8rem; color: #666; margin-top: 5px;">חבילה מספק אחד</div>
                        </label>
                        <label class="order-type-option" style="flex: 1; min-width: 150px; background: white; border-radius: 12px; padding: 20px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;">
                            <input type="radio" name="order_type" value="tour" style="display: none;">
                            <div style="font-size: 2rem; margin-bottom: 10px;">🚌</div>
                            <div style="font-weight: bold; color: #333;">טיול מאורגן</div>
                            <div style="font-size: 0.8rem; color: #666; margin-top: 5px;">חבילה כוללת הכל</div>
                        </label>
                    </div>
                    <div id="orderTypeError" style="display: none; color: #ffeb3b; margin-top: 10px; font-weight: bold; background: rgba(255,0,0,0.3); padding: 10px; border-radius: 8px;">
                        ⚠️ חובה לבחור סוג הזמנה!
                    </div>
                </div>
                
                <!-- בונה הדיל -->
                <div class="section" style="background: #fff3cd; padding: 20px; border-radius: 15px; margin-bottom: 25px; border: 2px solid #ffc107;">
                    <div class="form-row" style="align-items: center;">
                        <div class="form-group" style="flex: 2;">
                            <label style="font-weight: bold; color: #856404;">🏆 מי בנה את הדיל?</label>
                            <input type="text" name="deal_builder" id="deal_builder" placeholder="הקלד שם..." style="padding: 12px; border: 2px solid #ffc107; border-radius: 8px; font-size: 1rem;">
                        </div>
                        <div style="flex: 3; color: #856404; font-size: 0.9rem;">
                            💡 חשוב לציין מי מצא/בנה את הדיל לצורך חישוב בונוסים
                        </div>
                    </div>
                </div>
                
                <!-- פרטי הזמנה בסיסיים -->
                <div class="section">
                    <h3 class="section-title">📋 פרטי הזמנה</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>תאריך ביצוע ההזמנה</label>
                            <input type="date" name="order_date" id="order_date" value="<?= date('Y-m-d') ?>" required>
                        </div>
                        <div class="form-group">
                            <label>יעד</label>
                            <input type="text" name="destination" id="destination" list="destinations-list" placeholder="התחל להקליד..." required autocomplete="off">
                            <datalist id="destinations-list">
                                <?php foreach ($destinations as $dest): ?>
                                <option value="<?= htmlspecialchars($dest['name'] . ', ' . $dest['country']) ?>">
                                <?php endforeach; ?>
                            </datalist>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>📅 תאריך טיסה - הלוך</label>
                            <input type="date" name="departure_date" id="departure_date" required>
                        </div>
                        <div class="form-group">
                            <label>📅 תאריך טיסה - חזור</label>
                            <input type="date" name="return_date" id="return_date" required>
                        </div>
                    </div>
                </div>
                
                <!-- נוסעים -->
                <div class="section">
                    <h3 class="section-title">👥 נוסעים</h3>
                    <div class="passengers-list" id="passengers-list">
                        <div class="passenger-input">
                            <span class="passenger-num">1</span>
                            <input type="text" name="passengers[]" placeholder="שם מלא באנגלית (כמו בדרכון)" required>
                        </div>
                    </div>
                    <button type="button" class="btn-add-passenger" onclick="addPassenger()">
                        + הוסף נוסע
                    </button>
                </div>
                
                <!-- פרטי קשר -->
                <div class="section">
                    <h3 class="section-title">📞 פרטי קשר</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>אימייל <span style="font-weight: normal; color: #666; font-size: 0.85rem;">(לשם ישלח אישור הזמנה)</span></label>
                            <input type="email" name="customer_email" id="customer_email" placeholder="email@example.com">
                        </div>
                        <div class="form-group">
                            <label>טלפון ראש ההזמנה</label>
                            <input type="tel" name="customer_phone" id="customer_phone" placeholder="050-1234567" required>
                        </div>
                    </div>
                    <div id="additional-emails-container"></div>
                    <button type="button" onclick="addEmailField()" style="background: #f0f0f0; border: 1px dashed #999; color: #666; padding: 8px 15px; border-radius: 6px; cursor: pointer; font-size: 0.9rem; margin-top: 5px;">
                        ➕ הוסף כתובת מייל נוספת
                    </button>
                </div>
                
                <!-- ספק טיסה - הלוך -->
                <div class="section">
                    <h3 class="section-title">✈️ פרטי טיסה</h3>
                    
                    <div class="supplier-card" id="outbound-supplier-card">
                        <div class="supplier-header">
                            <h4>🛫 טיסת הלוך</h4>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>ספק</label>
                                <select name="flight_supplier" id="flight_supplier" required>
                                    <option value="DIRECT">DIRECT (ישיר מחברת התעופה)</option>
                                    <?php foreach ($suppliers as $supplier): ?>
                                        <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>חברת תעופה</label>
                                <select name="airline_outbound" id="airline_outbound" required>
                                    <option value="">בחר חברה</option>
                                    <?php foreach ($airlines as $airline): ?>
                                        <option value="<?= htmlspecialchars($airline) ?>"><?= htmlspecialchars($airline) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>קוד הזמנה</label>
                                <input type="text" name="booking_code_outbound" id="booking_code_outbound" placeholder="ABC123">
                            </div>
                            <div class="form-group">
                                <label>עלות לספק</label>
                                <input type="number" step="0.01" name="flight_supplier_cost" id="flight_supplier_cost" placeholder="500.00">
                            </div>
                            <div class="form-group">
                                <label>מטבע</label>
                                <select name="flight_supplier_currency" id="flight_supplier_currency">
                                    <option value="USD">$ USD</option>
                                    <option value="EUR">€ EUR</option>
                                    <option value="ILS">₪ ILS</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>סטטוס תשלום לספק</label>
                                <div class="payment-status">
                                    <input type="radio" name="flight_supplier_paid" id="flight_paid_yes" value="paid">
                                    <label for="flight_paid_yes" class="paid">✓ שולם</label>
                                    
                                    <input type="radio" name="flight_supplier_paid" id="flight_paid_no" value="unpaid" checked>
                                    <label for="flight_paid_no" class="unpaid">⏳ טרם שולם</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group full-width">
                                <label>וואצ'ר / אישור הזמנה מהספק</label>
                                <div class="upload-area" onclick="clickUpload(event, 'voucher_outbound')">
                                    <input type="file" name="voucher_outbound" id="voucher_outbound" accept="image/*,.pdf" onchange="handleFileUpload(this, 'outbound')">
                                    <div class="upload-icon">📄</div>
                                    <div class="upload-text">📎 לחץ לבחירת קובץ או Ctrl+V להדבקה</div>
                                    <div id="preview-outbound"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- צ'קבוקס לטיסת חזור שונה -->
                    <div class="different-return-check">
                        <input type="checkbox" id="different_return" onchange="toggleReturnFlight()">
                        <label for="different_return">🔄 טיסת החזור עם ספק או חברת תעופה שונה</label>
                    </div>
                    
                    <!-- ספק טיסה - חזור (מוסתר כברירת מחדל) -->
                    <div class="supplier-card return-supplier hidden" id="return-supplier-card">
                        <div class="supplier-header">
                            <h4>🛬 טיסת חזור</h4>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>ספק</label>
                                <select name="return_flight_supplier" id="return_flight_supplier">
                                    <option value="DIRECT">DIRECT (ישיר מחברת התעופה)</option>
                                    <?php foreach ($suppliers as $supplier): ?>
                                        <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>חברת תעופה</label>
                                <select name="airline_return" id="airline_return">
                                    <option value="">בחר חברה</option>
                                    <?php foreach ($airlines as $airline): ?>
                                        <option value="<?= htmlspecialchars($airline) ?>"><?= htmlspecialchars($airline) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>קוד הזמנה</label>
                                <input type="text" name="booking_code_return" id="booking_code_return" placeholder="XYZ789">
                            </div>
                            <div class="form-group">
                                <label>עלות לספק</label>
                                <input type="number" step="0.01" name="return_flight_supplier_cost" id="return_flight_supplier_cost" placeholder="500.00">
                            </div>
                            <div class="form-group">
                                <label>מטבע</label>
                                <select name="return_flight_supplier_currency" id="return_flight_supplier_currency">
                                    <option value="USD">$ USD</option>
                                    <option value="EUR">€ EUR</option>
                                    <option value="ILS">₪ ILS</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label>סטטוס תשלום לספק</label>
                                <div class="payment-status">
                                    <input type="radio" name="return_flight_supplier_paid" id="return_paid_yes" value="paid">
                                    <label for="return_paid_yes" class="paid">✓ שולם</label>
                                    
                                    <input type="radio" name="return_flight_supplier_paid" id="return_paid_no" value="unpaid" checked>
                                    <label for="return_paid_no" class="unpaid">⏳ טרם שולם</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group full-width">
                                <label>וואצ'ר / אישור הזמנה מהספק</label>
                                <div class="upload-area" onclick="clickUpload(event, 'voucher_return')">
                                    <input type="file" name="voucher_return" id="voucher_return" accept="image/*,.pdf" onchange="handleFileUpload(this, 'return')">
                                    <div class="upload-icon">📄</div>
                                    <div class="upload-text">📎 לחץ לבחירת קובץ או Ctrl+V להדבקה</div>
                                    <div id="preview-return"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- פרטי מלונות -->
                <div class="section">
                    <h3 class="section-title">🏨 פרטי מלונות</h3>
                    
                    <div id="hotels-list">
                        <!-- מלון ראשון -->
                        <div class="hotel-card" id="hotel-1" data-hotel-id="1">
                            <div class="hotel-header">
                                <span class="hotel-number">מלון #1</span>
                                <button type="button" class="btn-remove-hotel" onclick="removeHotel(1)" style="display:none;">🗑️</button>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label>ספק מלון</label>
                                    <select name="hotels[0][supplier]">
                                        <option value="DIRECT">DIRECT (ישירות מהמלון)</option>
                                        <option value="ORANGE">ORANGE</option>
                                        <option value="BLUE">BLUE</option>
                                        <option value="YELLOW">YELLOW</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>קוד הזמנה</label>
                                    <input type="text" name="hotels[0][booking_code]" placeholder="HTL123456">
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label>עלות לספק</label>
                                    <input type="number" step="0.01" name="hotels[0][cost]" class="hotel-cost" placeholder="300.00">
                                </div>
                                <div class="form-group">
                                    <label>מטבע</label>
                                    <select name="hotels[0][currency]" class="hotel-currency">
                                        <option value="USD">$ USD</option>
                                        <option value="EUR">€ EUR</option>
                                        <option value="ILS">₪ ILS</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label>סטטוס תשלום לספק</label>
                                    <div class="payment-status">
                                        <input type="radio" name="hotels[0][paid]" id="hotel_0_paid_yes" value="paid">
                                        <label for="hotel_0_paid_yes" class="paid">✓ שולם</label>
                                        
                                        <input type="radio" name="hotels[0][paid]" id="hotel_0_paid_no" value="unpaid" checked>
                                        <label for="hotel_0_paid_no" class="unpaid">⏳ טרם שולם</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group full-width">
                                    <label>אישור הזמנה מהמלון / ספק</label>
                                    <div class="upload-area" onclick="clickUpload(event, 'voucher_hotel_0')" tabindex="0">
                                        <input type="file" name="voucher_hotel_0" id="voucher_hotel_0" accept="image/*,.pdf" onchange="handleFileUpload(this, 'hotel_0')">
                                        <div class="upload-icon">🏨</div>
                                        <div class="upload-text">📎 לחץ לבחירת קובץ או Ctrl+V להדבקה</div>
                                        <div id="preview-hotel_0"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="button" class="btn-add-hotel" onclick="addHotel()">
                        ➕ הוסף מלון נוסף
                    </button>
                </div>
                
                <!-- קבצים נוספים - מתקפל -->
                <div class="section">
                    <div class="collapsible-header" onclick="toggleExtraFiles()">
                        <span class="collapsible-icon" id="extra-files-icon">➕</span>
                        <h3 class="section-title" style="margin:0;">📎 קבצים נוספים למייל</h3>
                        <span class="collapsible-hint">לחץ להוספה</span>
                    </div>
                    
                    <div id="extra-files-content" class="hidden">
                        <div id="extra-files-list"></div>
                        <button type="button" class="btn-add-passenger" onclick="addExtraFile()" style="margin-top: 10px;">
                            ➕ הוסף קובץ
                        </button>
                    </div>
                </div>
                
                <!-- פרטי כבודה -->
                <div class="section">
                    <h3 class="section-title">🧳 פרטי כבודה</h3>
                    <div class="form-group">
                        <label>פירוט הכבודה שמגיעה ללקוח (בעברית)</label>
                        <textarea name="luggage_text" id="luggage_text" class="notes-textarea" rows="3" placeholder="לדוגמה:
לכל נוסע מגיע תיק גב 40x20x25 ס״מ + טרולי 8 ק״ג
מזוודה 20 ק״ג משותפת לזוג"></textarea>
                    </div>
                </div>
                
                <!-- שונות - מתקפל -->
                <div class="section">
                    <div class="collapsible-header" onclick="toggleExtras()">
                        <span class="collapsible-icon" id="extras-icon">➕</span>
                        <h3 class="section-title" style="margin:0;">🎫 שונות (כרטיסים, העברות, אטרקציות...)</h3>
                        <span class="collapsible-hint">לחץ להוספה</span>
                    </div>
                    
                    <div class="collapsible-content hidden" id="extras-content">
                        <div id="extras-list">
                            <!-- פריטים יתווספו כאן דינמית -->
                        </div>
                        
                        <button type="button" class="btn-add-extra" onclick="addExtraItem()">
                            ➕ הוסף פריט
                        </button>
                    </div>
                </div>
                
                <!-- תשלומים מלקוחות -->
                <div class="section">
                    <h3 class="section-title">💳 פרטי תשלומים מלקוחות</h3>
                    
                    <div class="payment-headers" style="display:flex; gap:8px; margin-bottom:8px; font-size:0.8rem; color:#666; padding: 0 10px;">
                        <span style="flex:2; min-width:100px;">שם משלם</span>
                        <span style="flex:1; min-width:70px;">סכום ₪</span>
                        <span style="flex:1; min-width:90px;">אמצעי</span>
                        <span style="width:60px;">תשלומים</span>
                        <span style="width:70px;">4 ספרות</span>
                        <span style="flex:2; min-width:140px;">📧 מייל לקבלה</span>
                        <span style="width:30px;"></span>
                    </div>
                    <div id="payments-container">
                        <div class="payment-row" data-row-index="0">
                            <input type="text" name="payment_name[]" placeholder="שם המשלם" class="payment-name">
                            <input type="number" name="payment_amount[]" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                            <select name="payment_method[]" class="payment-method" onchange="toggleBankTransfer(this)">
                                <option value="credit_card">אשראי</option>
                                <option value="bank_transfer">העברה בנקאית</option>
                                <option value="cash">מזומן</option>
                                <option value="bit">ביט</option>
                            </select>
                            <input type="number" name="payment_installments[]" placeholder="תש׳" class="payment-installments" min="1" value="1">
                            <input type="text" name="payment_last4[]" placeholder="4 ספרות" class="payment-last4" maxlength="4">
                            <input type="email" name="payment_email[]" placeholder="מייל לקבלה" class="payment-email" value="<?= htmlspecialchars($_GET['email'] ?? '') ?>">
                            <button type="button" class="btn-remove" onclick="removePaymentRow(this)" style="visibility:hidden;">✕</button>
                            <div class="bank-transfer-fields" style="display:none;">
                                <label>📎 צרף אסמכתא להעברה:</label>
                                <div class="bank-upload-area">
                                    <input type="file" name="bank_proof_0" accept="image/*,.pdf" style="display:none;" onchange="handleBankProof(this)">
                                    <button type="button" class="bank-upload-btn" onclick="this.previousElementSibling.click()">📎 צרף קובץ</button>
                                    <span class="bank-file-name"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn-add" onclick="addPayment()">+ הוסף תשלום</button>
                    
                    <div class="total-summary">
                        <div class="total-row">
                            <span>סה"כ שולם:</span>
                            <span id="total-paid" class="total-amount">₪0</span>
                        </div>
                    </div>
                    
                    <!-- הודעה על קבלות -->
                    <?php if (empty($draftData)): ?>
                    <div style="margin-top: 15px; padding: 12px; background: #e3f2fd; border-radius: 8px; text-align: center;">
                        <div style="color: #1565c0; font-size: 0.9rem;">
                            📧 קבלות יישלחו אוטומטית לכל מייל שהוזן בעת שמירת ההזמנה
                        </div>
                    </div>
                    <?php else: ?>
                    <div style="margin-top: 15px; padding: 12px; background: #e8f5e9; border-radius: 8px; text-align: center;">
                        <div style="color: #2e7d32; font-size: 0.9rem;">
                            ✅ קבלות נשלחו אוטומטית ללקוחות לאחר התשלום בטיוטה
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- סיכום רווח -->
                <div class="section profit-section">
                    <h3 class="section-title">💰 סיכום רווח</h3>
                    <div class="profit-summary">
                        <div class="profit-row">
                            <span>סה"כ מהלקוח:</span>
                            <span id="summary-customer" class="profit-value">₪0</span>
                        </div>
                        <div class="profit-row">
                            <span>עלות טיסה לספק:</span>
                            <span id="summary-flight" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row">
                            <span>עלות מלונות לספק:</span>
                            <span id="summary-hotel" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row" id="extras-cost-row" style="display:none;">
                            <span>עלות שונות:</span>
                            <span id="summary-extras" class="profit-value expense">-₪0</span>
                        </div>
                        <div class="profit-row total">
                            <span>רווח סופי:</span>
                            <span id="summary-profit" class="profit-value final">₪0</span>
                        </div>
                    </div>
                    <input type="hidden" name="profit" id="profit" value="0">
                    <input type="hidden" name="usd_rate" id="usd_rate" value="<?= $rates['USD'] ?>">
                    <input type="hidden" name="eur_rate" id="eur_rate" value="<?= $rates['EUR'] ?>">
                    <div class="rates-info">
                        💱 שערי מטבע: $1 = ₪<?= $rates['USD'] ?> | €1 = ₪<?= $rates['EUR'] ?>
                        <a href="exchange_rates.php" style="margin-right:10px;">[עדכן שערים]</a>
                    </div>
                </div>
                
                <!-- הערות -->
                <div class="section">
                    <h3 class="section-title">📝 הערות</h3>
                    <div class="form-group">
                        <label>הערות חשובות להזמנה</label>
                        <textarea name="notes" id="notes" class="notes-textarea" rows="3" placeholder="הערות פנימיות..."></textarea>
                    </div>
                </div>
                
                <!-- כפתורי פעולה -->
                <div class="form-actions">
                    <button type="button" class="btn btn-secondary" onclick="window.location='orders.php'">ביטול</button>
                    <button type="button" class="btn btn-test" onclick="fillRandomData()">🎲 מלא נתוני טסט</button>
                    <button type="button" class="btn btn-primary" onclick="generateEmail()">✨ צור אישור הזמנה למייל</button>
                </div>
                
            </form>
            
            <!-- תוצאה - אישור הזמנה מוכן -->
            <div id="output-section" class="output-section hidden">
                <h3 class="section-title">📧 אישור הזמנה מוכן לשליחה <span style="font-size: 0.8rem; color: #666;">(ניתן לערוך)</span></h3>
                <div id="email-output" class="email-output" contenteditable="true" style="border: 2px dashed #667eea; padding: 15px; border-radius: 10px; background: #fafafa; min-height: 200px; outline: none;"></div>
                <div style="font-size: 0.85rem; color: #666; margin-top: 5px; text-align: center;">💡 לחץ על הטקסט כדי לערוך לפני השליחה</div>
                <div class="output-buttons" style="display: flex; gap: 10px; flex-wrap: wrap; justify-content: center; margin-top: 15px;">
                    <button type="button" class="copy-btn" onclick="copyEmail()">📋 העתק למייל</button>
                    <button type="button" id="btnSaveOrder" class="btn btn-primary" onclick="saveOrder()">💾 שמור במערכת</button>
                    <button type="button" id="btnSendEmail" class="send-email-btn" onclick="sendEmailToCustomer()" disabled style="opacity: 0.5; cursor: not-allowed;">📧 שלח מייל ללקוח</button>
                </div>
                <div id="btnOrderMessage" style="display: none; text-align: center; margin-top: 10px; padding: 10px; border-radius: 8px; font-weight: bold;"></div>
            </div>
        </div>
    </div>
    
    <script>
        let passengerCount = 1;
        let extraItemCount = 0;
        let hotelCount = 1;
        let orderAlreadySaved = false; // מעקב אם כבר נשמר
        
        // רשימות מותרות (מהגדרות)
        const allowedDestinations = <?= json_encode(array_map(function($d) { 
            return $d['name'] . ', ' . $d['country']; 
        }, $destinations), JSON_UNESCAPED_UNICODE) ?>;
        
        // מילון שמות עברית ליעדים
        const destinationHebrewNames = <?= json_encode(array_combine(
            array_map(function($d) { return strtolower($d['name']); }, $destinations),
            array_map(function($d) { return $d['name_he'] ?? $d['name']; }, $destinations)
        ), JSON_UNESCAPED_UNICODE) ?>;
        
        // נתוני טיוטה (אם יש)
        const draftData = <?= $draftData ? json_encode($draftData, JSON_UNESCAPED_UNICODE) : 'null' ?>;
        const draftPayments = <?= json_encode($draftPayments, JSON_UNESCAPED_UNICODE) ?>;
        
        // פתיחה/סגירה של קוביית שונות
        function toggleExtras() {
            const content = document.getElementById('extras-content');
            const icon = document.getElementById('extras-icon');
            const header = document.querySelector('.collapsible-header');
            
            if (content.classList.contains('hidden')) {
                content.classList.remove('hidden');
                icon.textContent = '➖';
                header.classList.add('open');
                // אם אין פריטים, הוסף אחד אוטומטית
                if (extraItemCount === 0) {
                    addExtraItem();
                }
            } else {
                content.classList.add('hidden');
                icon.textContent = '➕';
                header.classList.remove('open');
            }
        }
        
        // פתיחה/סגירה של קבצים נוספים
        let extraFileCount = 0;
        
        function toggleExtraFiles() {
            const content = document.getElementById('extra-files-content');
            const icon = document.getElementById('extra-files-icon');
            
            if (content.classList.contains('hidden')) {
                content.classList.remove('hidden');
                icon.textContent = '➖';
                // אם אין קבצים, הוסף אחד אוטומטית
                if (extraFileCount === 0) {
                    addExtraFile();
                }
            } else {
                content.classList.add('hidden');
                icon.textContent = '➕';
            }
        }
        
        // הוספת קובץ נוסף
        function addExtraFile() {
            extraFileCount++;
            const list = document.getElementById('extra-files-list');
            const div = document.createElement('div');
            div.className = 'extra-file-item';
            div.id = 'extra-file-' + extraFileCount;
            div.style.cssText = 'display: flex; gap: 10px; align-items: center; margin-bottom: 10px; padding: 10px; background: #f8f9fa; border-radius: 8px;';
            div.innerHTML = `
                <input type="text" name="extra_file_name[]" placeholder="שם הקובץ (לדוגמה: אישור השכרת רכב)" style="flex: 1; padding: 8px; border: 1px solid #ddd; border-radius: 5px;">
                <div class="upload-area" style="flex: 2; padding: 10px; border: 2px dashed #ddd; border-radius: 5px; text-align: center; cursor: pointer; min-height: 40px;">
                    <input type="file" name="extra_file[]" accept="image/*,.pdf" style="display: none;" onchange="handleExtraFileSelect(this, ${extraFileCount})">
                    <span class="upload-placeholder" id="extra-file-placeholder-${extraFileCount}">📎 לחץ או גרור קובץ</span>
                </div>
                <button type="button" onclick="removeExtraFile(${extraFileCount})" style="background: #dc3545; color: white; border: none; border-radius: 5px; padding: 8px 12px; cursor: pointer;">🗑️</button>
            `;
            list.appendChild(div);
            
            // הוספת אירועי לחיצה וגרירה
            const uploadArea = div.querySelector('.upload-area');
            const fileInput = div.querySelector('input[type="file"]');
            
            uploadArea.addEventListener('click', () => fileInput.click());
            uploadArea.addEventListener('dragover', (e) => { e.preventDefault(); uploadArea.style.borderColor = '#667eea'; });
            uploadArea.addEventListener('dragleave', () => { uploadArea.style.borderColor = '#ddd'; });
            uploadArea.addEventListener('drop', (e) => {
                e.preventDefault();
                uploadArea.style.borderColor = '#ddd';
                if (e.dataTransfer.files.length > 0) {
                    fileInput.files = e.dataTransfer.files;
                    handleExtraFileSelect(fileInput, extraFileCount);
                }
            });
        }
        
        function handleExtraFileSelect(input, id) {
            const placeholder = document.getElementById('extra-file-placeholder-' + id);
            if (input.files && input.files[0]) {
                placeholder.textContent = '✅ ' + input.files[0].name;
                placeholder.style.color = '#28a745';
            }
        }
        
        function removeExtraFile(id) {
            const item = document.getElementById('extra-file-' + id);
            if (item) item.remove();
        }
        
        // הוספת פריט שונות
        function addExtraItem() {
            extraItemCount++;
            const list = document.getElementById('extras-list');
            const div = document.createElement('div');
            div.className = 'extra-item';
            div.id = 'extra-item-' + extraItemCount;
            div.innerHTML = `
                <div class="extra-item-header">
                    <span class="extra-item-title">🎫 פריט #${extraItemCount}</span>
                    <button type="button" class="btn-remove-extra" onclick="removeExtraItem(${extraItemCount})">×</button>
                </div>
                <div class="form-row">
                    <div class="form-group" style="flex:2;">
                        <label>תיאור</label>
                        <input type="text" name="extra_description[]" placeholder="כרטיסים למשחק ברצלונה / העברות משדה / פארק מים...">
                    </div>
                    <div class="form-group">
                        <label>קוד הזמנה</label>
                        <input type="text" name="extra_booking_code[]" placeholder="TKT123">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>סכום</label>
                        <input type="number" step="0.01" name="extra_cost[]" placeholder="150.00">
                    </div>
                    <div class="form-group">
                        <label>מטבע</label>
                        <select name="extra_currency[]">
                            <option value="USD">$ USD</option>
                            <option value="EUR">€ EUR</option>
                            <option value="ILS">₪ ILS</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>סטטוס תשלום</label>
                        <div class="payment-status">
                            <input type="radio" name="extra_paid_${extraItemCount}" id="extra_paid_yes_${extraItemCount}" value="paid">
                            <label for="extra_paid_yes_${extraItemCount}" class="paid">✓ שולם</label>
                            
                            <input type="radio" name="extra_paid_${extraItemCount}" id="extra_paid_no_${extraItemCount}" value="unpaid" checked>
                            <label for="extra_paid_no_${extraItemCount}" class="unpaid">⏳ טרם</label>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group full-width">
                        <label>אישור הזמנה / צילום מסך</label>
                        <div class="upload-area upload-area-extra" data-extra-id="${extraItemCount}" onclick="clickUpload(event, 'voucher_extra_${extraItemCount}')" tabindex="0">
                            <input type="file" name="voucher_extra_${extraItemCount}" id="voucher_extra_${extraItemCount}" accept="image/*,.pdf" onchange="handleFileUpload(this, 'extra_${extraItemCount}')">
                            <div class="upload-icon">📎</div>
                            <div class="upload-text">📎 לחץ לבחירת קובץ או Ctrl+V להדבקה</div>
                            <div id="preview-extra_${extraItemCount}"></div>
                        </div>
                    </div>
                </div>
            `;
            list.appendChild(div);
            
            // הוסף event listeners לאזור ההעלאה החדש
            const newUploadArea = div.querySelector('.upload-area-extra');
            const currentExtraId = extraItemCount; // שמור את הערך הנוכחי
            if (newUploadArea) {
                newUploadArea.addEventListener('mouseenter', function() {
                    hoveredUploadArea = this;
                });
                newUploadArea.addEventListener('mouseleave', function() {
                    if (hoveredUploadArea === this) {
                        hoveredUploadArea = null;
                    }
                });
                newUploadArea.addEventListener('paste', function(e) {
                    const extraId = this.dataset.extraId;
                    handlePaste(e, 'extra_' + extraId);
                });
            }
        }
        
        // הסרת פריט שונות
        function removeExtraItem(id) {
            const item = document.getElementById('extra-item-' + id);
            if (item) {
                item.remove();
            }
        }
        
        // לחיצה על אזור העלאה - פותח בוחר קבצים רק אם לא לחצו על כפתור
        function clickUpload(event, inputId) {
            // אם לחצו על כפתור הסרה או על התמונה - לא לעשות כלום
            if (event.target.classList.contains('btn-remove-file') || 
                event.target.tagName === 'IMG' ||
                event.target.classList.contains('file-name')) {
                return;
            }
            
            // פותחים בוחר קבצים
            // להדבקה מהזיכרון - יש להשתמש ב-Ctrl+V כשהעכבר מעל האזור
            const input = document.getElementById(inputId);
            if (input) {
                input.click();
            }
        }
        
        // הוספת שדה מייל נוסף
        let additionalEmailCount = 0;
        function addEmailField() {
            additionalEmailCount++;
            const container = document.getElementById('additional-emails-container');
            const div = document.createElement('div');
            div.className = 'form-row';
            div.style.marginTop = '10px';
            div.id = 'additional-email-' + additionalEmailCount;
            div.innerHTML = `
                <div class="form-group" style="flex: 1;">
                    <label>מייל נוסף לשליחת אישור</label>
                    <div style="display: flex; gap: 10px;">
                        <input type="email" name="additional_emails[]" placeholder="email@example.com" style="flex: 1;">
                        <button type="button" onclick="removeEmailField(this)" style="background: #dc3545; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer;">✕</button>
                    </div>
                </div>
            `;
            container.appendChild(div);
        }
        
        function removeEmailField(btn) {
            btn.closest('.form-row').remove();
        }
        
        // הוספת נוסע
        function addPassenger() {
            passengerCount++;
            const list = document.getElementById('passengers-list');
            const div = document.createElement('div');
            div.className = 'passenger-input';
            div.innerHTML = `
                <span class="passenger-num">${passengerCount}</span>
                <input type="text" name="passengers[]" placeholder="שם מלא באנגלית (כמו בדרכון)" required>
                <button type="button" class="btn-remove" onclick="removePassenger(this)">×</button>
            `;
            list.appendChild(div);
        }
        
        // הסרת נוסע
        function removePassenger(btn) {
            btn.parentElement.remove();
            updatePassengerNumbers();
        }
        
        // עדכון מספרי נוסעים
        function updatePassengerNumbers() {
            const nums = document.querySelectorAll('.passenger-num');
            nums.forEach((num, index) => {
                num.textContent = index + 1;
            });
            passengerCount = nums.length;
        }
        
        // הוספת מלון
        function addHotel() {
            hotelCount++;
            const list = document.getElementById('hotels-list');
            const div = document.createElement('div');
            div.className = 'hotel-card';
            div.id = 'hotel-' + hotelCount;
            div.dataset.hotelId = hotelCount;
            
            const idx = hotelCount - 1; // אינדקס למערך
            
            div.innerHTML = `
                <div class="hotel-header">
                    <span class="hotel-number">מלון #${hotelCount}</span>
                    <button type="button" class="btn-remove-hotel" onclick="removeHotel(${hotelCount})">🗑️</button>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>ספק מלון</label>
                        <select name="hotels[${idx}][supplier]">
                            <option value="DIRECT">DIRECT (ישירות מהמלון)</option>
                            <option value="ORANGE">ORANGE</option>
                            <option value="BLUE">BLUE</option>
                            <option value="YELLOW">YELLOW</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>קוד הזמנה</label>
                        <input type="text" name="hotels[${idx}][booking_code]" placeholder="HTL123456">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>עלות לספק</label>
                        <input type="number" step="0.01" name="hotels[${idx}][cost]" class="hotel-cost" placeholder="300.00" onchange="calculateTotal()" oninput="calculateTotal()">
                    </div>
                    <div class="form-group">
                        <label>מטבע</label>
                        <select name="hotels[${idx}][currency]" class="hotel-currency" onchange="calculateTotal()">
                            <option value="USD">$ USD</option>
                            <option value="EUR">€ EUR</option>
                            <option value="ILS">₪ ILS</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>סטטוס תשלום לספק</label>
                        <div class="payment-status">
                            <input type="radio" name="hotels[${idx}][paid]" id="hotel_${idx}_paid_yes" value="paid">
                            <label for="hotel_${idx}_paid_yes" class="paid">✓ שולם</label>
                            
                            <input type="radio" name="hotels[${idx}][paid]" id="hotel_${idx}_paid_no" value="unpaid" checked>
                            <label for="hotel_${idx}_paid_no" class="unpaid">⏳ טרם שולם</label>
                        </div>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group full-width">
                        <label>אישור הזמנה מהמלון / ספק</label>
                        <div class="upload-area" onclick="clickUpload(event, 'voucher_hotel_${idx}')" tabindex="0">
                            <input type="file" name="voucher_hotel_${idx}" id="voucher_hotel_${idx}" accept="image/*,.pdf" onchange="handleFileUpload(this, 'hotel_${idx}')">
                            <div class="upload-icon">🏨</div>
                            <div class="upload-text">📎 לחץ לבחירת קובץ או Ctrl+V להדבקה</div>
                            <div id="preview-hotel_${idx}"></div>
                        </div>
                    </div>
                </div>
            `;
            list.appendChild(div);
            
            // הצג כפתור מחיקה גם במלון הראשון אם יש יותר ממלון אחד
            updateHotelRemoveButtons();
            
            // הוסף event listeners לאזור ההעלאה
            const uploadArea = div.querySelector('.upload-area');
            if (uploadArea) {
                uploadArea.addEventListener('mouseenter', function() { hoveredUploadArea = this; });
                uploadArea.addEventListener('mouseleave', function() { if (hoveredUploadArea === this) hoveredUploadArea = null; });
                uploadArea.addEventListener('paste', function(e) { handlePaste(e, 'hotel_' + idx); });
            }
            
            calculateTotal();
        }
        
        // הסרת מלון
        function removeHotel(id) {
            const hotel = document.getElementById('hotel-' + id);
            if (hotel) {
                hotel.remove();
                updateHotelNumbers();
                updateHotelRemoveButtons();
                calculateTotal();
            }
        }
        
        // עדכון מספרי מלונות
        function updateHotelNumbers() {
            const hotels = document.querySelectorAll('.hotel-card');
            hotels.forEach((hotel, index) => {
                const numSpan = hotel.querySelector('.hotel-number');
                if (numSpan) numSpan.textContent = 'מלון #' + (index + 1);
            });
            hotelCount = hotels.length;
        }
        
        // הצג/הסתר כפתורי מחיקה של מלונות
        function updateHotelRemoveButtons() {
            const hotels = document.querySelectorAll('.hotel-card');
            hotels.forEach(hotel => {
                const removeBtn = hotel.querySelector('.btn-remove-hotel');
                if (removeBtn) {
                    removeBtn.style.display = hotels.length > 1 ? 'block' : 'none';
                }
            });
        }
        
        // הצג/הסתר טיסת חזור שונה
        function toggleReturnFlight() {
            const checkbox = document.getElementById('different_return');
            const returnCard = document.getElementById('return-supplier-card');
            
            if (checkbox.checked) {
                returnCard.classList.remove('hidden');
            } else {
                returnCard.classList.add('hidden');
            }
        }
        
        // טיפול בהעלאת קובץ
        function handleFileUpload(input, direction) {
            const preview = document.getElementById('preview-' + direction);
            const uploadArea = input.closest('.upload-area');
            
            if (input.files && input.files[0]) {
                showFilePreview(input.files[0], preview, uploadArea, direction);
            }
        }
        
        // הצגת תצוגה מקדימה של קובץ
        function showFilePreview(file, preview, uploadArea, direction) {
            uploadArea.classList.add('has-file');
            
            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.innerHTML = `
                        <img src="${e.target.result}" class="file-preview">
                        <div class="file-name">📎 ${file.name || 'צילום מסך'}</div>
                        <button type="button" class="btn-remove-file" onclick="removeFile('${direction}')">✕ הסר</button>
                    `;
                    // שמור את ה-data URL לשימוש בשליחה
                    uploadArea.dataset.imageData = e.target.result;
                };
                reader.readAsDataURL(file);
            } else {
                preview.innerHTML = `
                    <div class="file-name">📎 ${file.name}</div>
                    <button type="button" class="btn-remove-file" onclick="removeFile('${direction}')">✕ הסר</button>
                `;
            }
        }
        
        // הסרת קובץ
        function removeFile(direction) {
            const preview = document.getElementById('preview-' + direction);
            const uploadArea = preview.closest('.upload-area');
            const input = uploadArea.querySelector('input[type="file"]');
            
            preview.innerHTML = '';
            uploadArea.classList.remove('has-file');
            uploadArea.dataset.imageData = '';
            if (input) input.value = '';
        }
        
        // טיפול בהדבקה מ-clipboard (Ctrl+V)
        function handlePaste(e, direction) {
            const items = e.clipboardData?.items;
            if (!items) return;
            
            for (let item of items) {
                if (item.type.startsWith('image/')) {
                    e.preventDefault();
                    const file = item.getAsFile();
                    const preview = document.getElementById('preview-' + direction);
                    const uploadArea = preview.closest('.upload-area');
                    showFilePreview(file, preview, uploadArea, direction);
                    break;
                }
            }
        }
        
        // הוספת event listeners להדבקה על כל אזורי ההעלאה
        let hoveredUploadArea = null; // עוקב אחרי איזה אזור העכבר מעליו
        
        document.addEventListener('DOMContentLoaded', function() {
            // מסגרת ירוקה לסוג הזמנה נבחר
            function updateOrderTypeSelection() {
                document.querySelectorAll('.order-type-option').forEach(option => {
                    const radio = option.querySelector('input[type="radio"]');
                    if (radio && radio.checked) {
                        option.classList.add('selected');
                        // הסתרת הודעת שגיאה כשבוחרים
                        const errorMsg = document.getElementById('orderTypeError');
                        if (errorMsg) errorMsg.style.display = 'none';
                    } else {
                        option.classList.remove('selected');
                    }
                });
            }
            
            // האזנה ללחיצה על האופציות
            document.querySelectorAll('.order-type-option').forEach(option => {
                option.addEventListener('click', function() {
                    const radio = this.querySelector('input[type="radio"]');
                    if (radio) {
                        radio.checked = true;
                        updateOrderTypeSelection();
                    }
                });
            });
            
            // האזנה לשינוי בחירה
            document.querySelectorAll('input[name="order_type"]').forEach(radio => {
                radio.addEventListener('change', updateOrderTypeSelection);
            });
            
            // עדכון ראשוני
            updateOrderTypeSelection();
            
            document.querySelectorAll('.upload-area').forEach(area => {
                // מאפשר focus על האזור
                area.setAttribute('tabindex', '0');
                
                // עוקב אחרי hover
                area.addEventListener('mouseenter', function() {
                    hoveredUploadArea = this;
                });
                area.addEventListener('mouseleave', function() {
                    if (hoveredUploadArea === this) {
                        hoveredUploadArea = null;
                    }
                });
                
                // האזנה להדבקה על האזור עצמו (כשיש פוקוס)
                area.addEventListener('paste', function(e) {
                    const input = this.querySelector('input[type="file"]');
                    const direction = input.id.replace('voucher_', '');
                    handlePaste(e, direction);
                });
                
                // האזנה ל-drag & drop
                area.addEventListener('dragover', function(e) {
                    e.preventDefault();
                    this.classList.add('drag-over');
                });
                
                area.addEventListener('dragleave', function(e) {
                    this.classList.remove('drag-over');
                });
                
                area.addEventListener('drop', function(e) {
                    e.preventDefault();
                    this.classList.remove('drag-over');
                    const input = this.querySelector('input[type="file"]');
                    const direction = input.id.replace('voucher_', '');
                    if (e.dataTransfer.files.length > 0) {
                        const preview = document.getElementById('preview-' + direction);
                        showFilePreview(e.dataTransfer.files[0], preview, this, direction);
                    }
                });
            });
            
            // האזנה גלובלית ל-paste - עובד כשהעכבר מעל אזור העלאה
            document.addEventListener('paste', function(e) {
                if (hoveredUploadArea) {
                    const input = hoveredUploadArea.querySelector('input[type="file"]');
                    const direction = input.id.replace('voucher_', '');
                    handlePaste(e, direction);
                }
            });
            
            // האזנה לשינויים בעלויות ספקים
            const costInputs = [
                'flight_supplier_cost', 'flight_supplier_currency',
                'return_flight_supplier_cost', 'return_flight_supplier_currency',
                'hotel_supplier_cost', 'hotel_supplier_currency'
            ];
            costInputs.forEach(id => {
                const el = document.getElementById(id);
                if (el) {
                    el.addEventListener('change', calculateTotal);
                    el.addEventListener('input', calculateTotal);
                }
            });
            
            // האזנה לשינויים בשונות (עלויות נוספות)
            document.getElementById('extras-list')?.addEventListener('input', function(e) {
                if (e.target.name === 'extra_cost[]' || e.target.name === 'extra_currency[]') {
                    calculateTotal();
                }
            });
            document.getElementById('extras-list')?.addEventListener('change', function(e) {
                if (e.target.name === 'extra_currency[]') {
                    calculateTotal();
                }
            });
            
            // הפעלה ראשונית
            calculateTotal();
            
            // מילוי טופס מנתוני טיוטה - עם setTimeout כדי לאפשר ל-flatpickr להתאתחל
            if (draftData) {
                setTimeout(fillFormFromDraft, 100);
            }
        });
        
        // מילוי הטופס מנתוני הטיוטה
        function fillFormFromDraft() {
            if (!draftData) return;
            
            console.log('Loading draft data:', draftData);
            console.log('Draft payments:', draftPayments);
            
            // שם לקוח = נוסע ראשון
            if (draftData.customer_name) {
                const firstPassenger = document.querySelector('input[name="passengers[]"]');
                if (firstPassenger) firstPassenger.value = draftData.customer_name;
            }
            
            // טלפון ומייל
            const phoneField = document.getElementById('customer_phone');
            if (phoneField && draftData.customer_phone) {
                phoneField.value = draftData.customer_phone;
            }
            
            const emailField = document.getElementById('customer_email');
            if (emailField && draftData.customer_email) {
                emailField.value = draftData.customer_email;
            }
            
            // יעד ותאריכים
            const destField = document.getElementById('destination');
            if (destField && draftData.destination) {
                destField.value = draftData.destination;
            }
            
            const depField = document.getElementById('departure_date');
            if (depField && draftData.departure_date) {
                if (departureDatePicker) {
                    departureDatePicker.setDate(draftData.departure_date, true);
                } else {
                    depField.value = draftData.departure_date;
                }
            }
            
            const retField = document.getElementById('return_date');
            if (retField && draftData.return_date) {
                if (returnDatePicker) {
                    returnDatePicker.setDate(draftData.return_date, true);
                } else {
                    retField.value = draftData.return_date;
                }
            }
            
            // מספר נוסעים
            if (draftData.num_passengers && draftData.num_passengers > 1) {
                for (let i = 1; i < draftData.num_passengers; i++) {
                    addPassenger();
                }
            }
            
            // סוג הזמנה
            if (draftData.order_type) {
                const orderTypeRadio = document.querySelector(`input[name="order_type"][value="${draftData.order_type}"]`);
                if (orderTypeRadio) {
                    orderTypeRadio.checked = true;
                    orderTypeRadio.dispatchEvent(new Event('change'));
                }
            }
            
            // מלון
            const hotelField = document.getElementById('hotel_name');
            if (hotelField && draftData.hotel_name) {
                hotelField.value = draftData.hotel_name;
            }
            
            const boardField = document.getElementById('board_basis');
            if (boardField && draftData.board_basis) {
                boardField.value = draftData.board_basis;
            }
            
            // תשלומים מ-draft_payments
            if (draftPayments && draftPayments.length > 0) {
                const container = document.getElementById('payments-container');
                if (container) {
                    container.innerHTML = ''; // ניקוי תשלומים קיימים
                    
                    draftPayments.forEach((payment, index) => {
                        const last4 = payment.last_4_digits || '';
                        const cardInfo = payment.card_brand ? ` - ${payment.card_brand}` : '';
                        const payerEmail = payment.payer_email || (index === 0 ? (draftData.customer_email || '') : '');
                        const bankTransferId = payment.bank_transfer_id || '';
                        
                        // קביעת שיטת תשלום (באנגלית)
                        let paymentMethod = 'credit_card';
                        if (payment.payment_method === 'bank_transfer') {
                            paymentMethod = 'bank_transfer';
                        } else if (payment.payment_method === 'cash') {
                            paymentMethod = 'cash';
                        } else if (payment.payment_method === 'bit') {
                            paymentMethod = 'bit';
                        }
                        
                        const row = document.createElement('div');
                        row.className = 'payment-row';
                        row.setAttribute('data-row-index', index);
                        row.innerHTML = `
                            <input type="text" name="payment_name[]" value="${payment.payer_name || ''}" placeholder="שם המשלם" class="payment-name">
                            <input type="number" name="payment_amount[]" value="${payment.amount || ''}" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                            <select name="payment_method[]" class="payment-method" onchange="toggleBankTransfer(this)">
                                <option value="credit_card"${paymentMethod === 'credit_card' ? ' selected' : ''}>אשראי${cardInfo}</option>
                                <option value="bank_transfer"${paymentMethod === 'bank_transfer' ? ' selected' : ''}>העברה בנקאית</option>
                                <option value="cash"${paymentMethod === 'cash' ? ' selected' : ''}>מזומן</option>
                                <option value="bit"${paymentMethod === 'bit' ? ' selected' : ''}>ביט</option>
                            </select>
                            <input type="number" name="payment_installments[]" placeholder="תש׳" class="payment-installments" min="1" value="${payment.num_payments || 1}">
                            <input type="text" name="payment_last4[]" value="${last4}" placeholder="4 ספרות" class="payment-last4" maxlength="4">
                            <input type="email" name="payment_email[]" value="${payerEmail}" placeholder="מייל לקבלה" class="payment-email">
                            <input type="hidden" name="payment_bank_transfer_id[]" value="${bankTransferId}" class="payment-bank-transfer-id">
                            <button type="button" class="btn-remove" onclick="removePaymentRow(this)"${index === 0 ? ' style="visibility:hidden;"' : ''}>✕</button>
                            <div class="bank-transfer-fields" style="display:${paymentMethod === 'bank_transfer' ? 'block' : 'none'};">
                                <label>📎 צרף אסמכתא להעברה:</label>
                                <div class="bank-upload-area">
                                    <input type="file" name="bank_proof_${index}" accept="image/*,.pdf" style="display:none;" onchange="handleBankProof(this)">
                                    <button type="button" class="bank-upload-btn" onclick="this.previousElementSibling.click()">📎 צרף קובץ</button>
                                    <span class="bank-file-name">${payment.bank_proof ? '✓ קובץ קיים' : ''}</span>
                                </div>
                            </div>
                        `;
                        container.appendChild(row);
                    });
                    
                    paymentRowIndex = draftPayments.length;
                    calculateTotal();
                }
            }
            
            console.log('Draft data loaded successfully');
        }
        
        // הוספת תשלום
        // מונה שורות תשלום
        let paymentRowIndex = 1;
        
        function addPayment() {
            const container = document.getElementById('payments-container');
            const row = document.createElement('div');
            row.className = 'payment-row';
            row.setAttribute('data-row-index', paymentRowIndex);
            row.innerHTML = `
                <input type="text" name="payment_name[]" placeholder="שם המשלם" class="payment-name">
                <input type="number" name="payment_amount[]" placeholder="סכום" class="payment-amount" oninput="calculateTotal()">
                <select name="payment_method[]" class="payment-method" onchange="toggleBankTransfer(this)">
                    <option value="credit_card">אשראי</option>
                    <option value="bank_transfer">העברה בנקאית</option>
                    <option value="cash">מזומן</option>
                    <option value="bit">ביט</option>
                </select>
                <input type="number" name="payment_installments[]" placeholder="תש׳" class="payment-installments" min="1" value="1">
                <input type="text" name="payment_last4[]" placeholder="4 ספרות" class="payment-last4" maxlength="4">
                <input type="email" name="payment_email[]" placeholder="מייל לקבלה" class="payment-email">
                <input type="hidden" name="payment_bank_transfer_id[]" value="" class="payment-bank-transfer-id">
                <button type="button" class="btn-remove" onclick="removePaymentRow(this)">✕</button>
                <div class="bank-transfer-fields" style="display:none;">
                    <label>📎 צרף אסמכתא להעברה:</label>
                    <div class="bank-upload-area">
                        <input type="file" name="bank_proof_${paymentRowIndex}" accept="image/*,.pdf" style="display:none;" onchange="handleBankProof(this)">
                        <button type="button" class="bank-upload-btn" onclick="this.previousElementSibling.click()">📎 צרף קובץ</button>
                        <span class="bank-file-name"></span>
                    </div>
                </div>
            `;
            container.appendChild(row);
            paymentRowIndex++;
        }
        
        // הצגת/הסתרת שדה אסמכתא להעברה בנקאית
        function toggleBankTransfer(select) {
            const row = select.closest('.payment-row');
            const bankFields = row.querySelector('.bank-transfer-fields');
            const installmentsField = row.querySelector('.payment-installments');
            
            if (select.value === 'bank_transfer') {
                bankFields.style.display = 'block';
                installmentsField.value = 1;
                installmentsField.disabled = true;
            } else {
                bankFields.style.display = 'none';
                installmentsField.disabled = false;
            }
        }
        
        // טיפול בהעלאת קובץ אסמכתא
        function handleBankProof(input) {
            const fileName = input.files[0]?.name || '';
            const fileNameSpan = input.closest('.bank-upload-area').querySelector('.bank-file-name');
            fileNameSpan.textContent = fileName ? '✓ ' + fileName : '';
        }
        
        // סנכרון מייל ראשי לשורת תשלום ראשונה
        document.addEventListener('DOMContentLoaded', function() {
            const customerEmailField = document.getElementById('customer_email');
            if (customerEmailField) {
                customerEmailField.addEventListener('blur', function() {
                    const firstPaymentEmail = document.querySelector('.payment-row:first-child .payment-email');
                    if (firstPaymentEmail && !firstPaymentEmail.value) {
                        firstPaymentEmail.value = this.value;
                    }
                });
            }
        });
        
        // הסרת שורת תשלום
        function removePaymentRow(btn) {
            btn.parentElement.remove();
            calculateTotal();
        }
        
        // שערי מטבע מה-PHP
        const exchangeRates = {
            ILS: 1,
            USD: <?= $rates['USD'] ?>,
            EUR: <?= $rates['EUR'] ?>
        };
        
        // המרה לשקלים
        function convertToILS(amount, currency) {
            const rate = exchangeRates[currency] || 1;
            return amount * rate;
        }
        
        // חישוב סה"כ תשלומים ורווח
        function calculateTotal() {
            // סכום מהלקוח
            const amounts = document.querySelectorAll('input[name="payment_amount[]"]');
            let customerTotal = 0;
            amounts.forEach(input => {
                const val = parseFloat(input.value) || 0;
                customerTotal += val;
            });
            document.getElementById('total-paid').textContent = '₪' + customerTotal.toLocaleString();
            document.getElementById('summary-customer').textContent = '₪' + customerTotal.toLocaleString();

            let totalSupplierCost = 0;
            
            // עלות טיסה לספק
            const flightCost = parseFloat(document.getElementById('flight_supplier_cost')?.value) || 0;
            const flightCurrency = document.getElementById('flight_supplier_currency')?.value || 'ILS';
            const flightCostILS = convertToILS(flightCost, flightCurrency);
            
            // בדיקה אם יש טיסת חזור נפרדת
            const differentReturn = document.getElementById('different_return')?.checked;
            let returnFlightCostILS = 0;
            if (differentReturn) {
                const returnFlightCost = parseFloat(document.getElementById('return_flight_supplier_cost')?.value) || 0;
                const returnFlightCurrency = document.getElementById('return_flight_supplier_currency')?.value || 'ILS';
                returnFlightCostILS = convertToILS(returnFlightCost, returnFlightCurrency);
            }
            
            const totalFlightCostILS = flightCostILS + returnFlightCostILS;
            let flightDisplay = '-₪' + Math.round(totalFlightCostILS).toLocaleString();
            document.getElementById('summary-flight').textContent = flightDisplay;

            // עלות מלונות לספק (סכום כל המלונות)
            let hotelCostILS = 0;
            const hotelCosts = document.querySelectorAll('.hotel-cost');
            const hotelCurrencies = document.querySelectorAll('.hotel-currency');
            hotelCosts.forEach((input, index) => {
                const cost = parseFloat(input.value) || 0;
                const currency = hotelCurrencies[index]?.value || 'USD';
                hotelCostILS += convertToILS(cost, currency);
            });
            
            let hotelDisplay = '-₪' + Math.round(hotelCostILS).toLocaleString();
            document.getElementById('summary-hotel').textContent = hotelDisplay;
            
            // עלות שונות
            let extrasCostILS = 0;
            const extraCosts = document.querySelectorAll('input[name="extra_cost[]"]');
            const extraCurrencies = document.querySelectorAll('select[name="extra_currency[]"]');
            extraCosts.forEach((input, index) => {
                const cost = parseFloat(input.value) || 0;
                const currency = extraCurrencies[index]?.value || 'ILS';
                extrasCostILS += convertToILS(cost, currency);
            });
            
            const extrasRow = document.getElementById('extras-cost-row');
            if (extrasCostILS > 0) {
                extrasRow.style.display = '';
                document.getElementById('summary-extras').textContent = '-₪' + Math.round(extrasCostILS).toLocaleString();
            } else {
                extrasRow.style.display = 'none';
            }
            
            totalSupplierCost = totalFlightCostILS + hotelCostILS + extrasCostILS;

            // רווח סופי
            const profit = customerTotal - totalSupplierCost;
            const profitEl = document.getElementById('summary-profit');
            profitEl.textContent = '₪' + Math.round(profit).toLocaleString();
            profitEl.classList.toggle('negative', profit < 0);
            
            // עדכון שדה hidden
            document.getElementById('profit').value = Math.round(profit);
        }
        
        // שליחת הטופס
        // יצירת אישור הזמנה למייל
        function generateEmail() {
            // בדיקת סוג הזמנה - חובה לבחור
            const orderTypeSelected = document.querySelector('input[name="order_type"]:checked');
            if (!orderTypeSelected) {
                document.getElementById('orderTypeError').style.display = 'block';
                document.getElementById('orderTypeSelector').scrollIntoView({ behavior: 'smooth', block: 'center' });
                alert('⚠️ חובה לבחור סוג הזמנה (נפרד / נופשון / מאורגן)');
                return;
            }
            document.getElementById('orderTypeError').style.display = 'none';
            
            const passengers = Array.from(document.querySelectorAll('input[name="passengers[]"]'))
                .map(input => input.value).filter(v => v);
            
            const destination = document.getElementById('destination').value;
            const airline = document.getElementById('airline_outbound').value.trim();
            const departureDate = document.getElementById('departure_date').value;
            const returnDate = document.getElementById('return_date').value;
            const isDifferentReturn = document.getElementById('different_return')?.checked;
            const airlineReturn = isDifferentReturn ? document.getElementById('airline_return')?.value?.trim() : '';
            
            // סוג הזמנה
            const orderType = orderTypeSelected.value;
            
            // תרגום היעד לעברית - מהרשימה מה-DB
            const destParts = destination.split(',');
            const destName = destParts[0]?.trim().toLowerCase() || '';
            const hebrewDestination = destinationHebrewNames[destName] || destination;
            
            // חברות עם צ'ק אין ידני (24 שעות לפני)
            const manualCheckinAirlines = ['wizzair', 'wizz air', 'wizz', 'ryanair', 'ryan air', 'flyone', 'fly one'];
            const airlineLower = airline.toLowerCase();
            const airlineReturnLower = (airlineReturn || airline).toLowerCase(); // אם אין חזור שונה, זו אותה חברה
            
            // בדיקה לכל כיוון בנפרד
            const isOutboundManual = manualCheckinAirlines.some(a => airlineLower.includes(a));
            const isReturnManual = manualCheckinAirlines.some(a => airlineReturnLower.includes(a));
            
            // בדיקת טרמינל - Wizz Air ו-Ryanair יוצאים מטרמינל 1, השאר מטרמינל 3
            const terminal1Airlines = ['wizzair', 'wizz air', 'wizz', 'ryanair', 'ryan air'];
            const isTerminal1 = terminal1Airlines.some(a => airlineLower.includes(a));
            const terminalNumber = isTerminal1 ? '1' : '3';
            
            // בדיקה אם הטיסה מעל 3 שבועות
            const today = new Date();
            const flightDate = new Date(departureDate);
            const diffDays = Math.floor((flightDate - today) / (1000 * 60 * 60 * 24));
            const showCancellationInsurance = diffDays > 21;
            
            // בניית טקסט חברת תעופה
            let airlineText = '';
            if (isDifferentReturn && airlineReturn) {
                airlineText = `הטיסה בהלוך עם חברת ${airline}, בחזור עם חברת ${airlineReturn}. הטיסה בהלוך אמורה לצאת מטרמינל ${terminalNumber}`;
            } else {
                airlineText = `הטיסות הן עם חברת ${airline}. הטיסה הלוך אמורה לצאת מטרמינל ${terminalNumber}`;
            }
            
            // בניית טקסט כרטיסי טיסה - לפי שילוב החברות
            let ticketsText = '';
            if (isOutboundManual && isReturnManual) {
                // שתי הטיסות עם חברות צ'ק אין ידני
                ticketsText = `כרטיסי טיסה תקבלו מאיתנו בוואטסאפ בטווח של 24 שעות מכל טיסה אחרי שנבצע לכם את הצ'ק אין.`;
            } else if (!isOutboundManual && !isReturnManual) {
                // שתי הטיסות עם חברות רגילות
                ticketsText = `כרטיסי טיסה תקבלו בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.`;
            } else if (isOutboundManual && !isReturnManual) {
                // רק הלוך עם חברה ידנית
                ticketsText = `בטיסת ההלוך - כרטיס הטיסה יישלח אליכם בוואטסאפ בטווח של 24 שעות מהטיסה אחרי שנבצע לכם את הצ'ק אין.
בטיסת החזור - תקבלו את כרטיס הטיסה בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.`;
            } else {
                // רק חזור עם חברה ידנית
                ticketsText = `בטיסת ההלוך - תקבלו את כרטיס הטיסה בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.
בטיסת החזור - כרטיס הטיסה יישלח אליכם בוואטסאפ בטווח של 24 שעות מהטיסה אחרי שנבצע לכם את הצ'ק אין.`;
            }
            
            // טקסט כבודה
            const luggageText = document.getElementById('luggage_text')?.value?.trim() || '';
            let luggageSection = '';
            if (luggageText) {
                luggageSection = `

🧳 כבודה
${luggageText}`;
            }
            
            // בניית טקסט ביטוח ביטול
            let cancellationInsuranceText = '';
            if (showCancellationInsurance) {
                cancellationInsuranceText = `

━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח ביטול נסיעה

במידה ומועד החופשה שלכם רחוק אנו ממליצים בחום לרכוש ביטוח לביטול מכל סיבה של חברת טריפ גרנטי (מבית הפניקס) שיאפשר לכם לקבל 80 אחוז בחזרה אפילו עד 6 שעות ממועד הטיסה.
ניתן לרכוש את הביטוח עד 7 ימים ממועד הזמנת החופשה ובתנאי שטווח הזמן עד הנסיעה גדול מ- 15 ימים. לפרטים מלאים ולרכישת הביטוח יש ללחוץ על הקישור הבא:
https://www.tripguaranty.co.il/InsurancePurchase/?agentCode=228`;
            }

            // בניית טקסט הפתיחה לפי סוג הזמנה
            let openingText = '';
            if (orderType === 'tour') {
                openingText = `מצורף בזאת אישור הזמנה של הטיול המאורגן ל${hebrewDestination}.`;
            } else if (orderType === 'package') {
                openingText = `מצורף בזאת אישור הזמנה של חבילת הנופש ל${hebrewDestination}.`;
            } else {
                openingText = `מצורפים בזאת אישורי הזמנה של הטיסות והמלון ב${hebrewDestination}.`;
            }

            const emailText = `שלום רב,

${openingText}
אנא וודאו שהשמות רשומים בדיוק כפי שהם מופיעים אצלכם בדרכון באנגלית.

━━━━━━━━━━━━━━━━━━━━━━━━━

✈️ הנחיות חשובות מאוד לטיסה

${airlineText} אך יש לוודא זאת ביום הטיסה למקרה ויהיו שינויים בקישור הבא:
https://www.iaa.gov.il/airports/ben-gurion/flight-board/

יש להגיע לשדה לפחות 3 וחצי שעות לפני הטיסה.

${ticketsText}
${luggageSection}${cancellationInsuranceText}

━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח נסיעות

טרם הנסיעה מומלץ מאוד לעשות ביטוח נסיעות לחו״ל שיכסה הוצאות רפואיות ומקרי חירום.
אנו ממליצים בחום על PassportCard, חברת ביטוח הנסיעות שלטעמנו היא המובילה והאמינה בישראל. ניתן לרכוש את הביטוח שלהם בקלות דרך הלינק הבא:
https://buy.passportcard.co.il/?AffiliateId=xEOn9OJj4ELo8mVndfdKjQ%3D%3D

יתרונות בולטים של PassportCard:
• אין הוצאות מהכיס בחו״ל - ללא צורך בהחזרים!
• מקבלים כרטיס פספורטכארד שמטעינים במקום ומאפשר לשלם ישר לרופא/בית חולים.
• שירות רופאים אונליין 24/7, כולל מרשמים דיגיטליים.
• שירות לקוחות זמין בוואטסאפ.
• מעקב ותפעול תביעה ישירות מהאפליקציה, ללא טפסים.
• אפשרות להרחבות כמו ביטול נסיעה, ציוד יקר, ספורט אתגרי ועוד.

━━━━━━━━━━━━━━━━━━━━━━━━━

למקרים דחופים נשמח לעמוד לרשותכם בוואטסאפ 050-6101031

מאחלים לכם חופשה נעימה! ✈️🌴`;

            document.getElementById('email-output').textContent = emailText;
            document.getElementById('output-section').classList.remove('hidden');
            document.getElementById('output-section').scrollIntoView({ behavior: 'smooth' });
        }

        // העתקה ללוח
        function copyEmail() {
            const text = document.getElementById('email-output').textContent;
            navigator.clipboard.writeText(text).then(() => {
                alert('✅ הטקסט הועתק! אפשר להדביק במייל');
            });
        }

        // משתנה לשמירת מזהה ההזמנה האחרונה
        let lastSavedOrderId = null;

        // שליחת מייל ללקוח
        async function sendEmailToCustomer() {
            const customerEmail = document.getElementById('customer_email')?.value;
            const emailBody = document.getElementById('email-output')?.innerText || document.getElementById('email-output')?.textContent;
            const destination = document.getElementById('destination')?.value || '';
            
            // איסוף כל המיילים (ראשי + נוספים)
            let allEmails = [customerEmail].filter(e => e);
            const additionalInputs = document.querySelectorAll('#additional-emails-container input[type="email"]');
            additionalInputs.forEach(input => {
                if (input.value && input.value.trim()) {
                    allEmails.push(input.value.trim());
                }
            });
            console.log('All emails:', allEmails);
            
            // בדיקות
            if (!customerEmail) {
                alert('❌ לא הוזנה כתובת מייל של הלקוח');
                return;
            }
            
            if (!emailBody) {
                alert('❌ אין תוכן מייל לשליחה. לחץ קודם על "צור אישור הזמנה"');
                return;
            }
            
            // חובה לשמור קודם!
            if (!lastSavedOrderId) {
                alert('⚠️ חובה לשמור את ההזמנה במערכת לפני שליחת מייל!\n\nלחץ קודם על "שמור במערכת"');
                return;
            }
            
            // אישור לפני שליחה - הצגת כל הכתובות
            const emailList = allEmails.join('\n');
            if (!confirm(`לשלוח מייל לכתובות:\n${emailList}?`)) {
                return;
            }
            
            // הצגת טעינה
            const btn = document.querySelector('.send-email-btn');
            const originalText = btn.innerHTML;
            btn.innerHTML = '⏳ שולח...';
            btn.disabled = true;
            
            try {
                // שליפת שם עברי של היעד
                const destParts = destination.split(',');
                const destName = destParts[0]?.trim().toLowerCase() || '';
                const hebrewDest = destinationHebrewNames[destName] || destination;
                
                // סוג הזמנה
                const orderType = document.querySelector('input[name="order_type"]:checked')?.value || 'separate';
                let subjectPrefix = 'חבילת נופש';
                if (orderType === 'tour') {
                    subjectPrefix = 'טיול מאורגן';
                }
                
                const formData = new FormData();
                // שליחת כל המיילים מופרדים בפסיק
                formData.append('customer_email', allEmails.join(', '));
                formData.append('email_subject', `אישור הזמנה ל${subjectPrefix} ל${hebrewDest}`);
                formData.append('email_body', emailBody);
                if (lastSavedOrderId) {
                    formData.append('order_id', lastSavedOrderId);
                }
                
                const response = await fetch('api/send_order_email.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ ' + result.message);
                } else {
                    alert('❌ ' + result.error);
                }
            } catch (error) {
                alert('❌ שגיאה בשליחה: ' + error.message);
            } finally {
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        }

        // שמירה במערכת
        async function saveOrder() {
            // בדיקת יעד מהרשימה המאושרת
            const destinationValue = document.getElementById('destination').value.trim();
            if (!allowedDestinations.includes(destinationValue)) {
                alert('❌ יעד לא תקין!\n\nיש לבחור יעד מהרשימה המוגדרת בלבד.');
                document.getElementById('destination').focus();
                return;
            }
            
            // בדיקה אם כבר נשמר פעם אחת
            if (orderAlreadySaved) {
                const confirmDuplicate = confirm('⚠️ כבר שמרת את ההזמנה הזו פעם אחת!\n\nהאם אתה בטוח שאתה רוצה לשמור שיכפול?\nיהיה מסובך אח"כ למחוק.');
                if (!confirmDuplicate) {
                    return;
                }
            }
            
            // הצגת מסך טעינה
            document.getElementById('loadingOverlay').classList.add('active');
            
            // עדכון חישוב רווח לפני שמירה
            calculateTotal();
            
            const form = document.getElementById('orderForm');
            const formData = new FormData(form);
            
            // הוספת שם עברי של היעד
            const destParts = destinationValue.split(',');
            const destName = destParts[0].trim().toLowerCase();
            const hebrewDest = destinationHebrewNames[destName] || destParts[0].trim();
            formData.set('destination_hebrew', hebrewDest);
            
            // הוספת draft_id אם קיים
            if (draftData && draftData.id) {
                formData.set('draft_id', draftData.id);
            }
            
            // איסוף נוסעים
            const passengers = Array.from(document.querySelectorAll('input[name="passengers[]"]'))
                .map(input => input.value).filter(v => v);
            formData.set('passengers', JSON.stringify(passengers));
            
            // איסוף תשלומים
            const paymentNames = Array.from(document.querySelectorAll('input[name="payment_name[]"]'))
                .map(input => input.value);
            const paymentAmounts = Array.from(document.querySelectorAll('input[name="payment_amount[]"]'))
                .map(input => input.value);
            const paymentMethods = Array.from(document.querySelectorAll('select[name="payment_method[]"]'))
                .map(select => select.value);
            const paymentInstallments = Array.from(document.querySelectorAll('input[name="payment_installments[]"]'))
                .map(input => input.value || '1');
            const paymentLast4 = Array.from(document.querySelectorAll('input[name="payment_last4[]"]'))
                .map(input => input.value);
            const paymentEmails = Array.from(document.querySelectorAll('input[name="payment_email[]"]'))
                .map(input => input.value);
            const paymentBankTransferIds = Array.from(document.querySelectorAll('input[name="payment_bank_transfer_id[]"]'))
                .map(input => input.value);
            
            const payments = paymentNames.map((name, i) => ({
                name: name,
                amount: paymentAmounts[i],
                method: paymentMethods[i],
                installments: paymentInstallments[i],
                last4: paymentLast4[i] || '',
                email: paymentEmails[i] || '',
                bank_transfer_id: paymentBankTransferIds[i] ? parseInt(paymentBankTransferIds[i]) : null,
                date: document.getElementById('order_date').value // תאריך ההזמנה
            })).filter(p => p.name || p.amount);
            
            formData.set('payments', JSON.stringify(payments));
            
            // איסוף אסמכתאות העברה בנקאית
            const bankProofs = document.querySelectorAll('input[type="file"][name^="bank_proof_"]');
            bankProofs.forEach((input, index) => {
                if (input.files && input.files[0]) {
                    formData.append('bank_proofs[]', input.files[0]);
                    formData.append('bank_proof_indexes[]', index.toString());
                }
            });
            
            // חישוב סה"כ מחיר מהתשלומים
            const totalPrice = payments.reduce((sum, p) => sum + (parseFloat(p.amount) || 0), 0);
            formData.set('total_price', totalPrice);
            
            // סוג הזמנה - לפי בחירת המשתמש
            const orderType = document.querySelector('input[name="order_type"]:checked')?.value || 'separate';
            console.log('ORDER TYPE SELECTED:', orderType);
            console.log('RADIO CHECKED:', document.querySelector('input[name="order_type"]:checked'));
            formData.set('order_type', orderType);
            
            // סטטוס תשלום לספקים
            formData.set('flight_supplier_paid', document.querySelector('input[name="flight_supplier_paid"]:checked')?.value || 'unpaid');
            
            // איסוף נתוני מלונות
            const hotels = [];
            document.querySelectorAll('.hotel-card').forEach((card, index) => {
                const hotel = {
                    supplier: card.querySelector(`select[name="hotels[${index}][supplier]"]`)?.value || 'DIRECT',
                    booking_code: card.querySelector(`input[name="hotels[${index}][booking_code]"]`)?.value || '',
                    cost: card.querySelector(`input[name="hotels[${index}][cost]"]`)?.value || '0',
                    currency: card.querySelector(`select[name="hotels[${index}][currency]"]`)?.value || 'USD',
                    paid: card.querySelector(`input[name="hotels[${index}][paid]"]:checked`)?.value || 'unpaid'
                };
                // שמור רק אם יש עלות או קוד הזמנה
                if (parseFloat(hotel.cost) > 0 || hotel.booking_code) {
                    hotels.push(hotel);
                }
            });
            formData.set('hotels', JSON.stringify(hotels));
            
            // איסוף צילומי מסך של מלונות
            document.querySelectorAll('.hotel-card').forEach((card, index) => {
                const uploadArea = card.querySelector('.upload-area');
                if (uploadArea?.dataset.imageData) {
                    formData.set('voucher_hotel_' + index + '_data', uploadArea.dataset.imageData);
                }
            });
            
            // איסוף שונות (extras)
            const extraDescriptions = Array.from(document.querySelectorAll('input[name="extra_description[]"]'))
                .map(input => input.value);
            const extraCodes = Array.from(document.querySelectorAll('input[name="extra_booking_code[]"]'))
                .map(input => input.value);
            const extraCosts = Array.from(document.querySelectorAll('input[name="extra_cost[]"]'))
                .map(input => input.value);
            const extraCurrencies = Array.from(document.querySelectorAll('select[name="extra_currency[]"]'))
                .map(select => select.value);
            
            // איסוף סטטוס תשלום לכל extra
            const extraPaidStatuses = [];
            for (let i = 1; i <= extraItemCount; i++) {
                const paidRadio = document.querySelector(`input[name="extra_paid_${i}"]:checked`);
                extraPaidStatuses.push(paidRadio ? paidRadio.value : 'unpaid');
            }
            
            const extras = extraDescriptions.map((desc, i) => ({
                description: desc,
                booking_code: extraCodes[i],
                cost: extraCosts[i],
                currency: extraCurrencies[i],
                paid: extraPaidStatuses[i] || 'unpaid'
            })).filter(e => e.description || e.cost);
            
            formData.set('extras', JSON.stringify(extras));
            
            // כבודה
            formData.set('luggage_details', document.getElementById('luggage_text')?.value || '');
            
            // שמירת טקסט המייל שנוצר
            const emailText = document.getElementById('email-output')?.textContent || '';
            formData.set('email_text', emailText);
            
            // איסוף צילומי מסך (base64 data)
            const outboundUpload = document.querySelector('#voucher_outbound')?.closest('.upload-area');
            if (outboundUpload?.dataset.imageData) {
                formData.set('voucher_outbound_data', outboundUpload.dataset.imageData);
            }
            
            const returnUpload = document.querySelector('#voucher_return')?.closest('.upload-area');
            if (returnUpload?.dataset.imageData) {
                formData.set('voucher_return_data', returnUpload.dataset.imageData);
            }
            
            // איסוף צילומי מסך של שונות
            document.querySelectorAll('.upload-area-extra').forEach((area, index) => {
                if (area.dataset.imageData) {
                    formData.set('voucher_extra_' + (index + 1) + '_data', area.dataset.imageData);
                }
            });
            
            try {
                const response = await fetch('api/save_order_lite.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    lastSavedOrderId = result.order_id; // שמירת מזהה להמשך
                    
                    let msg = '✅ ההזמנה נשמרה בהצלחה!';
                    msg += '\n📋 מספר הזמנה: ' + result.order_id;
                    
                    if (result.files_count > 0) {
                        msg += '\n📎 ' + result.files_count + ' קבצים נשמרו';
                    }
                    
                    // הודעה על קבלות
                    if (result.from_draft) {
                        msg += '\n\n✅ קבלות כבר נשלחו מהטיוטה';
                    } else if (result.receipts_sent > 0) {
                        msg += '\n\n📧 נשלחו ' + result.receipts_sent + ' קבלות ללקוחות';
                    }
                    
                    if (result.receipts_errors && result.receipts_errors.length > 0) {
                        msg += '\n⚠️ שגיאות בקבלות: ' + result.receipts_errors.join(', ');
                    }
                    
                    alert(msg);
                    
                    // סימון שההזמנה נשמרה - למניעת שמירה כפולה בטעות
                    orderAlreadySaved = true;
                    
                    // שחרור כפתור שליחת מייל
                    const btnSendEmail = document.getElementById('btnSendEmail');
                    if (btnSendEmail) {
                        btnSendEmail.disabled = false;
                        btnSendEmail.style.opacity = '1';
                        btnSendEmail.style.cursor = 'pointer';
                    }
                    
                    // הודעה ויזואלית
                    const btnMessage = document.getElementById('btnOrderMessage');
                    if (btnMessage) {
                        btnMessage.style.display = 'block';
                        btnMessage.style.background = '#d4edda';
                        btnMessage.style.color = '#155724';
                        btnMessage.innerHTML = '✅ ההזמנה נשמרה! עכשיו אפשר לשלוח מייל ללקוח';
                    }
                    
                    // הצג כפתור לוואצ'ר
                    const outputSection = document.getElementById('output-section');
                    const existingVoucherBtn = outputSection.querySelector('.voucher-btn');
                    if (!existingVoucherBtn) {
                        const voucherBtn = document.createElement('a');
                        voucherBtn.href = 'voucher_lite.php?token=' + result.token;
                        voucherBtn.target = '_blank';
                        voucherBtn.className = 'btn btn-primary voucher-btn';
                        voucherBtn.innerHTML = '📄 צפה בוואצ\'ר';
                        outputSection.querySelector('.output-buttons').appendChild(voucherBtn);
                    }
                    
                    // הסתרת מסך טעינה
                    document.getElementById('loadingOverlay').classList.remove('active');
                } else {
                    // הסתרת מסך טעינה
                    document.getElementById('loadingOverlay').classList.remove('active');
                    alert('❌ שגיאה: ' + result.error);
                }
            } catch (error) {
                // הסתרת מסך טעינה
                document.getElementById('loadingOverlay').classList.remove('active');
                alert('❌ שגיאת תקשורת: ' + error.message);
            }
        }

        // מילוי נתונים אקראיים לטסט
        function fillRandomData() {
            const destinations = ['Budapest, Hungary', 'Prague, Czech Republic', 'Barcelona, Spain', 'Rome, Italy', 'Paris, France', 'Athens, Greece', 'Vienna, Austria', 'Amsterdam, Netherlands'];
            const names = ['David Cohen', 'Sarah Levi', 'Michael Ben-David', 'Rachel Mizrahi', 'Yosef Peretz', 'Miriam Katz', 'Daniel Goldberg', 'Esther Friedman'];
            const airlines = document.querySelectorAll('#airline_outbound option');
            const suppliers = document.querySelectorAll('#flight_supplier option');
            
            // פונקציות עזר
            const random = (arr) => arr[Math.floor(Math.random() * arr.length)];
            const randomNum = (min, max) => Math.floor(Math.random() * (max - min + 1)) + min;
            const randomDate = (daysFromNow) => {
                const date = new Date();
                date.setDate(date.getDate() + daysFromNow);
                return date.toISOString().split('T')[0];
            };
            
            // יעד
            document.getElementById('destination').value = random(destinations);
            
            // בונה הדיל - רוטציה בין מאי ואורי
            document.getElementById('deal_builder').value = random(['מאי', 'אורי']);
            
            // תאריכים - שימוש ב-flatpickr API
            const departDays = randomNum(14, 60);
            const depDate = randomDate(departDays);
            const retDate = randomDate(departDays + randomNum(3, 10));
            
            if (departureDatePicker) departureDatePicker.setDate(depDate, true);
            if (returnDatePicker) returnDatePicker.setDate(retDate, true);
            
            // נוסעים
            const passengerInputs = document.querySelectorAll('input[name="passengers[]"]');
            passengerInputs[0].value = random(names);
            if (Math.random() > 0.5) {
                addPassenger();
                document.querySelectorAll('input[name="passengers[]"]')[1].value = random(names);
            }
            
            // טלפון ומייל
            document.getElementById('customer_phone').value = '05' + randomNum(0, 9) + '-' + randomNum(1000000, 9999999);
            document.getElementById('customer_email').value = 'test' + randomNum(100, 999) + '@gmail.com';
            
            // טיסת הלוך
            if (suppliers.length > 1) {
                document.getElementById('flight_supplier').value = suppliers[randomNum(1, suppliers.length - 1)].value;
            }
            if (airlines.length > 1) {
                document.getElementById('airline_outbound').value = airlines[randomNum(1, airlines.length - 1)].value;
            }
            document.getElementById('booking_code_outbound').value = 'FLT' + randomNum(100000, 999999);
            document.getElementById('flight_supplier_cost').value = randomNum(200, 800);
            document.getElementById('flight_supplier_currency').value = random(['USD', 'EUR']);
            document.querySelector('input[name="flight_supplier_paid"][value="' + random(['paid', 'unpaid']) + '"]').checked = true;
            
            // מלון
            const hotelCard = document.querySelector('.hotel-card');
            if (hotelCard) {
                hotelCard.querySelector('select[name="hotels[0][supplier]"]').value = random(['DIRECT', 'ORANGE', 'YELLOW', 'BLUE']);
                hotelCard.querySelector('input[name="hotels[0][booking_code]"]').value = 'HTL' + randomNum(100000, 999999);
                hotelCard.querySelector('input[name="hotels[0][cost]"]').value = randomNum(300, 1500);
                hotelCard.querySelector('select[name="hotels[0][currency]"]').value = random(['USD', 'EUR']);
                hotelCard.querySelector('input[name="hotels[0][paid]"][value="' + random(['paid', 'unpaid']) + '"]').checked = true;
            }
            
            // תשלום מלקוח
            const paymentNames = document.querySelectorAll('input[name="payment_name[]"]');
            const paymentAmounts = document.querySelectorAll('input[name="payment_amount[]"]');
            paymentNames[0].value = random(names);
            paymentAmounts[0].value = randomNum(2000, 6000);
            
            // הערות
            // כבודה
            const luggageOptions = [
                'לכל נוסע מגיע תיק גב 40x20x25 ס״מ + טרולי 8 ק״ג',
                'לכל נוסע מגיע תיק גב + מזוודה 20 ק״ג',
                'תיק גב לכל נוסע + מזוודה 23 ק״ג משותפת לזוג',
                'לכל נוסע: תיק אישי + טרולי 10 ק״ג + מזוודה 20 ק״ג'
            ];
            document.getElementById('luggage_text').value = random(luggageOptions);
            
            // הערות
            document.getElementById('notes').value = 'הזמנת טסט - ' + new Date().toLocaleString('he-IL');
            
            // חישוב רווח
            calculateTotal();
            
            // הודעה
            alert('✅ נתוני טסט מולאו בהצלחה!');
        }
        
        document.getElementById('orderForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            // TODO: שליחה לשרת
            alert('הזמנה נשמרה! (בקרוב יהיה חיבור לשרת)');
            console.log('Form data:', Object.fromEntries(formData));
        });
    </script>
    <script>
    // משתנים גלובליים ל-flatpickr
    let orderDatePicker, departureDatePicker, returnDatePicker;
    
    // אתחול בוחר תאריכים
    document.addEventListener('DOMContentLoaded', function() {
        const fpConfig = {
            locale: 'he',
            dateFormat: 'Y-m-d',
            altInput: true,
            altFormat: 'j F Y',
            allowInput: true,
            disableMobile: false,
            monthSelectorType: 'dropdown',
            onReady: function(selectedDates, dateStr, instance) {
                // יצירת dropdown לשנים במקום input
                const yearInput = instance.calendarContainer.querySelector('.cur-year');
                if (yearInput) {
                    const currentYear = new Date().getFullYear();
                    const select = document.createElement('select');
                    select.className = 'flatpickr-year-dropdown';
                    select.style.cssText = 'font-size: 1rem; font-weight: bold; padding: 8px 10px; border-radius: 6px; border: 1px solid #ddd; background: white; cursor: pointer;';
                    
                    // יצירת אפשרויות לשנים (5 שנים אחורה, 3 שנים קדימה)
                    for (let y = currentYear - 1; y <= currentYear + 3; y++) {
                        const option = document.createElement('option');
                        option.value = y;
                        option.textContent = y;
                        if (y === currentYear) option.selected = true;
                        select.appendChild(option);
                    }
                    
                    select.addEventListener('change', function() {
                        instance.changeYear(parseInt(this.value));
                    });
                    
                    yearInput.parentNode.replaceChild(select, yearInput);
                }
            }
        };
        
        // תאריך ביצוע הזמנה
        orderDatePicker = flatpickr('#order_date', {
            ...fpConfig,
            defaultDate: 'today'
        });
        
        // תאריך טיסה הלוך
        departureDatePicker = flatpickr('#departure_date', {
            ...fpConfig,
            minDate: 'today',
            onChange: function(selectedDates) {
                // עדכון מינימום לתאריך חזור
                if (selectedDates[0]) {
                    returnDatePicker.set('minDate', selectedDates[0]);
                }
            }
        });
        
        // תאריך טיסה חזור
        returnDatePicker = flatpickr('#return_date', {
            ...fpConfig,
            minDate: 'today'
        });
    });
    </script>
    
    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">שומר את ההזמנה...</div>
    </div>
</body>
</html>
