<?php
// יצירת טיוטת תוספת להזמנה קיימת
require_once 'includes/auth.php';
requireLogin();

header('Content-Type: application/json');

$agent = getCurrentAgent();
$pdo = getDB();

try {
    $parentOrderId = $_POST['parent_order_id'] ?? null;
    $customerName = $_POST['customer_name'] ?? '';
    $customerPhone = $_POST['customer_phone'] ?? '';
    $addonDescription = $_POST['addon_description'] ?? '';
    $totalPrice = floatval($_POST['total_price'] ?? 0);
    $destination = $_POST['destination'] ?? $addonDescription;
    $addonType = $_POST['addon_type'] ?? '';
    $luggageData = $_POST['luggage_data'] ?? null;
    
    // פרטי ספק
    $supplierName = $_POST['supplier_name'] ?? '';
    $supplierBooking = $_POST['supplier_booking'] ?? '';
    $supplierCost = floatval($_POST['supplier_cost'] ?? 0);
    $supplierCurrency = $_POST['supplier_currency'] ?? 'USD';
    $supplierPaid = $_POST['supplier_paid'] ?? 'unpaid';
    
    if (!$parentOrderId || !$totalPrice || !$addonDescription) {
        throw new Exception('חסרים פרטים');
    }
    
    // וידוא שההזמנה המקורית קיימת
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$parentOrderId]);
    $parentOrder = $stmt->fetch();
    
    if (!$parentOrder) {
        throw new Exception('הזמנה מקורית לא נמצאה');
    }
    
    // יצירת token ייחודי
    $token = bin2hex(random_bytes(16));
    
    // הכנת notes עם כל המידע
    $notesData = [
        'type' => $luggageData ? 'luggage_addon' : 'general_addon',
        'description' => $addonDescription,
        'supplier' => [
            'name' => $supplierName,
            'booking' => $supplierBooking,
            'cost' => $supplierCost,
            'currency' => $supplierCurrency,
            'paid' => $supplierPaid
        ]
    ];
    
    if ($luggageData) {
        $notesData['luggage_data'] = json_decode($luggageData, true);
    }
    
    // יצירת הטיוטה
    $stmt = $pdo->prepare("
        INSERT INTO drafts (
            token, agent_id, customer_name, customer_phone, 
            destination, total_price, price_per_person, currency,
            num_passengers, status, parent_order_id, addon_description,
            departure_date, return_date, notes, created_at
        ) VALUES (
            ?, ?, ?, ?,
            ?, ?, ?, 'ILS',
            1, 'pending', ?, ?,
            ?, ?, ?, NOW()
        )
    ");
    
    $stmt->execute([
        $token,
        $agent['id'],
        $customerName,
        $customerPhone,
        $destination,
        $totalPrice,
        $totalPrice,
        $parentOrderId,
        $addonDescription,
        $parentOrder['departure_date'],
        $parentOrder['return_date'],
        json_encode($notesData, JSON_UNESCAPED_UNICODE)
    ]);
    
    $draftId = $pdo->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'draft_id' => $draftId,
        'token' => $token,
        'message' => 'הטיוטה נוצרה בהצלחה'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
