<?php
// יצירת משתמשים לעובדים
require_once 'includes/config.php';
require_once 'includes/auth.php';

$pdo = getDB();

// וידוא שטבלת agents קיימת - עם role מורחב
$pdo->exec("
    CREATE TABLE IF NOT EXISTS agents (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        full_name VARCHAR(100) NOT NULL,
        role ENUM('admin', 'agent', 'accountant') DEFAULT 'agent',
        active TINYINT(1) DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) DEFAULT CHARSET=utf8mb4
");

// עדכון ENUM אם הטבלה כבר קיימת
$pdo->exec("ALTER TABLE agents MODIFY COLUMN role ENUM('admin', 'agent', 'accountant') DEFAULT 'agent'");

echo "<h2>🔐 יצירת משתמשים</h2><br>";

// רשימת העובדים
$agents = [
    ['username' => 'admin', 'full_name' => 'אוקיי - מנהל', 'password' => 'okok', 'role' => 'admin'],
    ['username' => 'anna', 'full_name' => 'אנה', 'password' => 'Anna2025!', 'role' => 'agent'],
    ['username' => 'dasha', 'full_name' => 'דאשה', 'password' => 'Dasha2025!', 'role' => 'agent'],
    ['username' => 'zina', 'full_name' => 'זינה', 'password' => 'Zina2025!', 'role' => 'agent'],
    ['username' => 'shani', 'full_name' => 'שני', 'password' => 'Shani2025!', 'role' => 'agent'],
    ['username' => 'ziv', 'full_name' => 'זיו - רואה חשבון', 'password' => 'zivziv', 'role' => 'accountant'],
];

$created = 0;
$exists = 0;

foreach ($agents as $agent) {
    // בדיקה אם כבר קיים
    $stmt = $pdo->prepare("SELECT id FROM agents WHERE username = ?");
    $stmt->execute([$agent['username']]);
    
    if ($stmt->fetch()) {
        echo "⏭️ {$agent['full_name']} ({$agent['username']}) - כבר קיים<br>";
        $exists++;
    } else {
        // יצירת המשתמש
        $hashedPassword = hashPassword($agent['password']);
        $stmt = $pdo->prepare("INSERT INTO agents (username, password, full_name, role) VALUES (?, ?, ?, ?)");
        $stmt->execute([$agent['username'], $hashedPassword, $agent['full_name'], $agent['role']]);
        echo "✅ {$agent['full_name']} ({$agent['username']}) - נוצר בהצלחה<br>";
        $created++;
    }
}

echo "<br><hr><br>";
echo "<strong>סיכום:</strong> נוצרו $created משתמשים חדשים, $exists כבר קיימים<br><br>";

echo "<h3>📋 פרטי התחברות:</h3>";
echo "<table border='1' cellpadding='10' style='border-collapse: collapse; direction: rtl;'>";
echo "<tr style='background: #667eea; color: white;'><th>שם</th><th>שם משתמש</th><th>סיסמה</th><th>הרשאה</th></tr>";
foreach ($agents as $agent) {
    $roleHeb = ['admin' => 'מנהל', 'agent' => 'נציג', 'accountant' => 'רואה חשבון'][$agent['role']];
    echo "<tr><td>{$agent['full_name']}</td><td>{$agent['username']}</td><td>{$agent['password']}</td><td>{$roleHeb}</td></tr>";
}
echo "</table>";

echo "<br><br><strong style='color: red;'>⚠️ חשוב: מחק קובץ זה אחרי השימוש!</strong>";
