<?php
// יצירת טבלת העברות בנקאיות
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>יצירת טבלת bank_transfers</h2>";

$sql = "CREATE TABLE IF NOT EXISTS bank_transfers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    draft_id INT DEFAULT NULL COMMENT 'קישור לטיוטה',
    order_id INT DEFAULT NULL COMMENT 'קישור להזמנה',
    addition_id INT DEFAULT NULL COMMENT 'קישור לתוספת',
    
    transferrer_name VARCHAR(200) NOT NULL COMMENT 'שם המעביר',
    transferrer_phone VARCHAR(50) DEFAULT NULL,
    transferrer_email VARCHAR(200) DEFAULT NULL,
    
    amount DECIMAL(10,2) NOT NULL COMMENT 'סכום ההעברה',
    transfer_date DATE DEFAULT NULL COMMENT 'תאריך ההעברה',
    reference_number VARCHAR(100) DEFAULT NULL COMMENT 'מספר אסמכתא',
    
    screenshot_path VARCHAR(500) DEFAULT NULL COMMENT 'נתיב צילום מסך',
    notes TEXT DEFAULT NULL,
    
    status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
    reviewed_by INT DEFAULT NULL COMMENT 'מי בדק',
    reviewed_at DATETIME DEFAULT NULL,
    rejection_reason VARCHAR(500) DEFAULT NULL,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_status (status),
    INDEX idx_draft (draft_id),
    INDEX idx_order (order_id),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

try {
    $pdo->exec($sql);
    echo "<p style='color:green;'>✅ טבלה נוצרה בהצלחה!</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ שגיאה: " . $e->getMessage() . "</p>";
}

// הצגת מבנה
echo "<h3>מבנה הטבלה:</h3>";
$result = $pdo->query("DESCRIBE bank_transfers");
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Field</th><th>Type</th><th>Comment</th></tr>";
while ($row = $result->fetch()) {
    echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td><td></td></tr>";
}
echo "</table>";

echo "<p><a href='pending_transfers.php'>→ לדף אישור העברות</a></p>";
?>
