<?php
// יצירת טיוטה לחיוב על תוספת
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$agent = getCurrentAgent();

$orderId = $_GET['order_id'] ?? null;
$additionId = $_GET['addition_id'] ?? null;
$amount = $_GET['amount'] ?? 0;
$description = $_GET['description'] ?? '';
$customerName = $_GET['customer_name'] ?? '';
$customerEmail = $_GET['customer_email'] ?? '';
$customerPhone = $_GET['customer_phone'] ?? '';

if (!$orderId) {
    die('חסר מזהה הזמנה');
}

// שליפת פרטי ההזמנה
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

if (!$order) {
    die('הזמנה לא נמצאה');
}

// שליפת פרטי התוספת אם יש
$addition = null;
if ($additionId) {
    $stmt = $pdo->prepare("SELECT * FROM order_additions WHERE id = ?");
    $stmt->execute([$additionId]);
    $addition = $stmt->fetch();
}

$passengers = json_decode($order['passengers'] ?? '[]', true);
if (!$customerName && !empty($passengers)) {
    $customerName = ($passengers[0]['first_name'] ?? '') . ' ' . ($passengers[0]['last_name'] ?? '');
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>יצירת טיוטה לתוספת</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, sans-serif;
            background: #f0f2f5;
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            overflow: hidden;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
        }
        .card-header h2 { font-size: 1.3rem; }
        .card-body { padding: 25px; }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
        }
        .form-group textarea { resize: vertical; min-height: 100px; }
        .info-box {
            background: #e8f4fd;
            border: 1px solid #bee5eb;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .info-box h4 { color: #0c5460; margin-bottom: 10px; }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
        }
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
        }
        .btn-primary {
            background: #667eea;
            color: white;
        }
        .btn-primary:hover { background: #5a6fd6; }
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        .actions {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        .amount-display {
            font-size: 2rem;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h2>💳 יצירת טיוטת חיוב לתוספת</h2>
            </div>
            <div class="card-body">
                <div class="info-box">
                    <h4>פרטי ההזמנה המקורית #<?= $order['id'] ?></h4>
                    <div class="info-row">
                        <span>יעד:</span>
                        <strong><?= htmlspecialchars($order['destination']) ?></strong>
                    </div>
                    <div class="info-row">
                        <span>תאריכים:</span>
                        <strong><?= date('d/m/Y', strtotime($order['departure_date'])) ?> - <?= date('d/m/Y', strtotime($order['return_date'])) ?></strong>
                    </div>
                    <div class="info-row">
                        <span>לקוח:</span>
                        <strong><?= htmlspecialchars($customerName) ?></strong>
                    </div>
                </div>
                
                <div class="amount-display">
                    ₪<?= number_format($amount, 2) ?>
                </div>
                
                <form id="draftForm">
                    <input type="hidden" name="order_id" value="<?= $orderId ?>">
                    <input type="hidden" name="addition_id" value="<?= $additionId ?>">
                    
                    <div class="form-group">
                        <label>תיאור החיוב</label>
                        <input type="text" name="description" value="<?= htmlspecialchars($description) ?> - הזמנה #<?= $orderId ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>סכום לחיוב (₪)</label>
                        <input type="number" step="0.01" name="amount" value="<?= $amount ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>שם הלקוח</label>
                        <input type="text" name="customer_name" value="<?= htmlspecialchars($customerName) ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>אימייל</label>
                        <input type="email" name="customer_email" value="<?= htmlspecialchars($customerEmail) ?>">
                    </div>
                    
                    <div class="form-group">
                        <label>טלפון</label>
                        <input type="tel" name="customer_phone" value="<?= htmlspecialchars($customerPhone) ?>">
                    </div>
                    
                    <div class="form-group">
                        <label>הערות (אופציונלי)</label>
                        <textarea name="notes" placeholder="הערות נוספות..."></textarea>
                    </div>
                    
                    <div class="actions">
                        <button type="button" class="btn btn-secondary" onclick="window.close()">ביטול</button>
                        <button type="submit" class="btn btn-primary">📝 צור טיוטה ושלח ללקוח</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script>
        document.getElementById('draftForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            try {
                const response = await fetch('api/create_addition_draft.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ הטיוטה נוצרה בהצלחה!\n\nלינק לתשלום:\n' + result.payment_url);
                    
                    // העתקה ללוח
                    if (result.payment_url) {
                        navigator.clipboard.writeText(result.payment_url);
                        alert('הלינק הועתק ללוח!');
                    }
                    
                    window.close();
                } else {
                    alert('❌ שגיאה: ' + (result.error || 'לא ידוע'));
                }
            } catch (e) {
                alert('❌ שגיאה: ' + e.message);
            }
        });
    </script>
</body>
</html>
