<?php
/**
 * יצירת טבלת order_refunds - החזרים
 */

require_once 'includes/config.php';

echo "<h2>יצירת טבלת החזרים</h2>";
echo "<pre>";

try {
    $pdo = getDB();
    
    // יצירת הטבלה
    $sql = "
    CREATE TABLE IF NOT EXISTS order_refunds (
        id INT AUTO_INCREMENT PRIMARY KEY,
        order_id INT NOT NULL,
        description VARCHAR(255) NOT NULL COMMENT 'תיאור ההחזר',
        supplier_name VARCHAR(100) DEFAULT NULL COMMENT 'שם הספק',
        airline VARCHAR(100) DEFAULT NULL COMMENT 'חברת תעופה',
        received_from_supplier DECIMAL(10,2) DEFAULT 0 COMMENT 'קיבלנו מהספק (₪)',
        returned_to_customer DECIMAL(10,2) DEFAULT 0 COMMENT 'החזרנו ללקוח (₪)',
        refund_date DATE DEFAULT NULL COMMENT 'תאריך ההחזר',
        notes TEXT DEFAULT NULL COMMENT 'הערות פנימיות',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        created_by INT DEFAULT NULL COMMENT 'מי יצר',
        
        INDEX idx_order_id (order_id),
        INDEX idx_refund_date (refund_date),
        
        FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ";
    
    $pdo->exec($sql);
    echo "✅ טבלת order_refunds נוצרה בהצלחה!\n\n";
    
    // בדיקה אם עמודת airline קיימת (למקרה שהטבלה נוצרה קודם)
    $stmt = $pdo->query("SHOW COLUMNS FROM order_refunds LIKE 'airline'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE order_refunds ADD COLUMN airline VARCHAR(100) DEFAULT NULL COMMENT 'חברת תעופה' AFTER supplier_name");
        echo "✅ עמודת airline נוספה\n\n";
    }
    
    // הצגת מבנה הטבלה
    echo "--- מבנה הטבלה ---\n";
    $stmt = $pdo->query("DESCRIBE order_refunds");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "{$row['Field']}: {$row['Type']}\n";
    }
    
    echo "\n✅ הסתיים בהצלחה!\n";
    
} catch (Exception $e) {
    echo "❌ שגיאה: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><strong>אפשר למחוק קובץ זה אחרי ההרצה.</strong></p>";
?>
