-- מערכת CRM - חופשה במבצע
-- יצירת הדאטאבייס

CREATE DATABASE IF NOT EXISTS crm_hofsha CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE crm_hofsha;

-- טבלת נציגים
CREATE TABLE agents (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    role ENUM('admin', 'agent') DEFAULT 'agent',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- טבלת הזמנות מלאה
CREATE TABLE orders (
    id INT PRIMARY KEY AUTO_INCREMENT,
    draft_token VARCHAR(64) UNIQUE NOT NULL,
    agent_id INT NOT NULL,
    
    -- תאריך ביצוע העסקה
    order_date DATE NOT NULL,
    
    -- פרטי לקוח
    customer_phone VARCHAR(20) NOT NULL,
    customer_email VARCHAR(100),
    
    -- פרטי נוסעים (JSON array של שמות)
    passengers JSON,
    
    -- פרטי טיסה הלוך
    destination VARCHAR(100) NOT NULL,
    departure_date DATE NOT NULL,
    return_date DATE NOT NULL,
    airline_outbound VARCHAR(100),
    booking_code_outbound VARCHAR(50),
    
    -- פרטי טיסה חזור (אם שונה)
    airline_return VARCHAR(100),
    booking_code_return VARCHAR(50),
    
    -- פרטי מלון
    hotel_name VARCHAR(100),
    hotel_checkin DATE,
    hotel_checkout DATE,
    room_type VARCHAR(100),
    hotel_confirmation VARCHAR(100),
    meal_basis ENUM('ללא ארוחות', 'לינה וארוחת בוקר', 'חצי פנסיון', 'פנסיון מלא', 'הכל כלול'),
    
    -- כבודה (טקסט חופשי)
    luggage_details TEXT,
    
    -- כספים
    total_price DECIMAL(10,2) NOT NULL,
    profit DECIMAL(10,2),
    
    -- תשלומים (JSON array עם סכום, שיטה, שם משלם)
    payments JSON,
    
    -- בונה הדיל (לעמלות)
    deal_builder VARCHAR(100),
    
    -- הערות
    notes TEXT,
    
    -- סטטוס
    status ENUM('draft', 'sent', 'paid', 'confirmed', 'cancelled') DEFAULT 'draft',
    
    -- תשלום
    payment_reference VARCHAR(100),
    paid_at TIMESTAMP NULL,
    
    -- תאריכים
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    FOREIGN KEY (agent_id) REFERENCES agents(id)
);
