<?php
// סקריפט אבחון לבעיית העברות בנקאיות
require_once 'includes/config.php';
$pdo = getDB();

echo "<h1>🔍 אבחון בעיית העברות בנקאיות</h1>";
echo "<style>
body { font-family: Arial, sans-serif; direction: rtl; padding: 20px; }
table { border-collapse: collapse; width: 100%; margin: 20px 0; }
th, td { border: 1px solid #ddd; padding: 8px; text-align: right; }
th { background: #4CAF50; color: white; }
tr:nth-child(even) { background: #f2f2f2; }
.error { color: red; font-weight: bold; }
.success { color: green; font-weight: bold; }
.warning { color: orange; font-weight: bold; }
pre { background: #f4f4f4; padding: 10px; overflow: auto; }
</style>";

// 1. בדיקת מבנה טבלת bank_transfers
echo "<h2>1. מבנה טבלת bank_transfers</h2>";
$cols = $pdo->query("SHOW COLUMNS FROM bank_transfers")->fetchAll(PDO::FETCH_ASSOC);
echo "<table><tr><th>Field</th><th>Type</th><th>Default</th></tr>";
foreach ($cols as $c) {
    echo "<tr><td>{$c['Field']}</td><td>{$c['Type']}</td><td>{$c['Default']}</td></tr>";
}
echo "</table>";

// 2. כל ההעברות עם הסטטוסים שלהן
echo "<h2>2. כל ההעברות בטבלה</h2>";
$transfers = $pdo->query("
    SELECT bt.*, d.parent_order_id, d.addon_description, d.order_id as d_order_id
    FROM bank_transfers bt
    LEFT JOIN drafts d ON bt.draft_id = d.id
    ORDER BY bt.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

echo "<table><tr>
    <th>ID</th>
    <th>draft_id</th>
    <th>order_id</th>
    <th>parent_order_id</th>
    <th>שם מעביר</th>
    <th>סכום</th>
    <th>status (RAW)</th>
    <th>תיאור</th>
</tr>";
foreach ($transfers as $t) {
    $statusClass = '';
    $statusDisplay = $t['status'];
    if (empty($t['status'])) {
        $statusClass = 'error';
        $statusDisplay = 'NULL/EMPTY ❌';
    } elseif ($t['status'] === 'pending') {
        $statusClass = 'warning';
        $statusDisplay = 'pending ⏳';
    } elseif ($t['status'] === 'approved') {
        $statusClass = 'success';
        $statusDisplay = 'approved ✅';
    } elseif ($t['status'] === 'rejected') {
        $statusClass = 'error';
        $statusDisplay = 'rejected ❌';
    }
    
    echo "<tr>
        <td>{$t['id']}</td>
        <td>{$t['draft_id']}</td>
        <td>{$t['order_id']}</td>
        <td>{$t['parent_order_id']}</td>
        <td>{$t['transferrer_name']}</td>
        <td>₪{$t['amount']}</td>
        <td class='{$statusClass}'>{$statusDisplay}</td>
        <td>{$t['addon_description']}</td>
    </tr>";
}
echo "</table>";

// 3. בדיקת draft_payments
echo "<h2>3. תשלומי תוספות (draft_payments)</h2>";
$payments = $pdo->query("
    SELECT dp.*, d.parent_order_id, d.addon_description
    FROM draft_payments dp
    JOIN drafts d ON dp.draft_id = d.id
    WHERE d.parent_order_id IS NOT NULL
    ORDER BY dp.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

echo "<table><tr>
    <th>Payment ID</th>
    <th>draft_id</th>
    <th>parent_order_id</th>
    <th>שם משלם</th>
    <th>סכום</th>
    <th>תיאור</th>
    <th>העברה תואמת?</th>
</tr>";
foreach ($payments as $p) {
    // בדיקה אם יש העברה תואמת
    $matchingTransfer = null;
    foreach ($transfers as $t) {
        if ($t['draft_id'] == $p['draft_id']) {
            $matchingTransfer = $t;
            break;
        }
    }
    
    $matchDisplay = $matchingTransfer 
        ? "<span class='success'>כן - ID {$matchingTransfer['id']}, status: {$matchingTransfer['status']}</span>"
        : "<span class='error'>לא נמצאה!</span>";
    
    echo "<tr>
        <td>{$p['id']}</td>
        <td>{$p['draft_id']}</td>
        <td>{$p['parent_order_id']}</td>
        <td>{$p['payer_name']}</td>
        <td>₪{$p['amount']}</td>
        <td>{$p['addon_description']}</td>
        <td>{$matchDisplay}</td>
    </tr>";
}
echo "</table>";

// 4. תיקון אוטומטי - העברות עם סטטוס ריק
echo "<h2>4. תיקון העברות עם סטטוס לא תקין</h2>";
if (isset($_GET['fix'])) {
    $fixed = $pdo->exec("UPDATE bank_transfers SET status = 'pending' WHERE status IS NULL OR status = '' OR status NOT IN ('pending', 'approved', 'rejected')");
    echo "<p class='success'>✅ תוקנו {$fixed} העברות</p>";
    echo "<p><a href='debug_bank_issue.php'>רענן את הדף</a></p>";
} else {
    $badCount = $pdo->query("SELECT COUNT(*) FROM bank_transfers WHERE status IS NULL OR status = '' OR status NOT IN ('pending', 'approved', 'rejected')")->fetchColumn();
    if ($badCount > 0) {
        echo "<p class='error'>נמצאו {$badCount} העברות עם סטטוס לא תקין!</p>";
        echo "<p><a href='debug_bank_issue.php?fix=1' style='background:green;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>🔧 תקן אותן עכשיו</a></p>";
    } else {
        echo "<p class='success'>✅ כל ההעברות עם סטטוס תקין</p>";
    }
}

// 5. המלצות
echo "<h2>5. סיכום ובעיות</h2>";
echo "<ul>";

// בדיקה אם יש העברות בלי draft_id
$noDraftId = $pdo->query("SELECT COUNT(*) FROM bank_transfers WHERE draft_id IS NULL")->fetchColumn();
if ($noDraftId > 0) {
    echo "<li class='error'>⚠️ יש {$noDraftId} העברות בלי draft_id - קשה לקשר אותן לתשלומים</li>";
} else {
    echo "<li class='success'>✅ כל ההעברות עם draft_id</li>";
}

// בדיקה אם יש תשלומים בלי העברה תואמת
$orphanPayments = 0;
foreach ($payments as $p) {
    $found = false;
    foreach ($transfers as $t) {
        if ($t['draft_id'] == $p['draft_id']) {
            $found = true;
            break;
        }
    }
    if (!$found) $orphanPayments++;
}
if ($orphanPayments > 0) {
    echo "<li class='error'>⚠️ יש {$orphanPayments} תשלומי תוספות בלי העברה תואמת בטבלה</li>";
} else {
    echo "<li class='success'>✅ כל התשלומים עם העברה תואמת</li>";
}

echo "</ul>";

echo "<p><a href='bank_transfers.php'>← חזרה לדף העברות בנקאיות</a></p>";
