<?php
require_once 'includes/config.php';
$pdo = getDB();

$draftId = $_GET['draft_id'] ?? null;

echo "<h2>Debug Draft Payments</h2>";
echo "<p>draft_id from URL: " . ($draftId ?: 'NONE') . "</p>";

if ($draftId) {
    // שליפת הטיוטה
    $stmt = $pdo->prepare("SELECT id, customer_name, destination, total_price FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    $draft = $stmt->fetch();
    
    echo "<h3>Draft Info:</h3>";
    echo "<pre>" . print_r($draft, true) . "</pre>";
    
    // שליפת תשלומים
    $stmt = $pdo->prepare("SELECT * FROM draft_payments WHERE draft_id = ? ORDER BY payment_date");
    $stmt->execute([$draftId]);
    $payments = $stmt->fetchAll();
    
    echo "<h3>Payments for this draft (" . count($payments) . "):</h3>";
    echo "<pre>" . print_r($payments, true) . "</pre>";
    
    // JSON output
    echo "<h3>JSON for JavaScript:</h3>";
    echo "<pre>draftPayments = " . json_encode($payments, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
} else {
    echo "<p style='color:red'>No draft_id provided! Add ?draft_id=X to URL</p>";
}
?>
