<?php
// בדיקת תשלומי טיוטה
require_once 'includes/config.php';

$draftId = $_GET['draft_id'] ?? null;

echo "<h2>Debug Draft Payments</h2>";

$pdo = getDB();

if ($draftId) {
    echo "<h3>Draft ID: $draftId</h3>";
    
    // בדיקת הטיוטה
    $stmt = $pdo->prepare("SELECT * FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    $draft = $stmt->fetch();
    
    echo "<h4>Draft Info:</h4>";
    echo "<pre>";
    echo "Status: " . ($draft['status'] ?? 'N/A') . "\n";
    echo "Amount Paid: " . ($draft['amount_paid'] ?? 'N/A') . "\n";
    echo "Total Price: " . ($draft['total_price'] ?? 'N/A') . "\n";
    echo "</pre>";
    
    // בדיקת תשלומים
    $stmt = $pdo->prepare("SELECT * FROM draft_payments WHERE draft_id = ?");
    $stmt->execute([$draftId]);
    $payments = $stmt->fetchAll();
    
    echo "<h4>Payments in draft_payments table:</h4>";
    if (empty($payments)) {
        echo "<p style='color:red;'>No payments found for this draft!</p>";
    } else {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Payer Name</th><th>Amount</th><th>Installments</th><th>Last 4</th><th>Card Brand</th><th>Approval #</th><th>Transaction ID</th><th>Date</th></tr>";
        foreach ($payments as $p) {
            echo "<tr>";
            echo "<td>{$p['id']}</td>";
            echo "<td>{$p['payer_name']}</td>";
            echo "<td>{$p['amount']}</td>";
            echo "<td>" . ($p['installments'] ?? '-') . "</td>";
            echo "<td>" . ($p['last_4_digits'] ?? '-') . "</td>";
            echo "<td>" . ($p['card_brand'] ?? '-') . "</td>";
            echo "<td>" . ($p['approval_number'] ?? '-') . "</td>";
            echo "<td>{$p['transaction_id']}</td>";
            echo "<td>{$p['payment_date']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} else {
    // הצג את כל הטיוטות האחרונות
    echo "<h3>Recent Drafts with Payments:</h3>";
    
    $stmt = $pdo->query("
        SELECT d.id, d.customer_name, d.status, d.amount_paid, d.total_price, 
               COUNT(dp.id) as payment_count
        FROM drafts d 
        LEFT JOIN draft_payments dp ON d.id = dp.draft_id
        GROUP BY d.id
        ORDER BY d.id DESC 
        LIMIT 20
    ");
    $drafts = $stmt->fetchAll();
    
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Customer</th><th>Status</th><th>Amount Paid</th><th>Total</th><th>Payments Count</th><th>Action</th></tr>";
    foreach ($drafts as $d) {
        echo "<tr>";
        echo "<td>{$d['id']}</td>";
        echo "<td>{$d['customer_name']}</td>";
        echo "<td>{$d['status']}</td>";
        echo "<td>{$d['amount_paid']}</td>";
        echo "<td>{$d['total_price']}</td>";
        echo "<td>{$d['payment_count']}</td>";
        echo "<td><a href='?draft_id={$d['id']}'>View</a></td>";
        echo "</tr>";
    }
    echo "</table>";
}

// בדיקת מבנה הטבלה
echo "<h3>Table Structure:</h3>";
try {
    $stmt = $pdo->query("DESCRIBE draft_payments");
    $columns = $stmt->fetchAll();
    echo "<pre>";
    foreach ($columns as $col) {
        echo $col['Field'] . " - " . $col['Type'] . "\n";
    }
    echo "</pre>";
} catch (Exception $e) {
    echo "<p style='color:red;'>Error: " . $e->getMessage() . "</p>";
    echo "<p>Maybe table draft_payments doesn't exist?</p>";
}
?>