<?php
require_once 'includes/config.php';
$pdo = getDB();

$flightFrom = $_GET['from'] ?? '2026-03-14';
$flightTo = $_GET['to'] ?? '2026-03-14';
$orderId = $_GET['id'] ?? 31;

echo "<h2>בדיקת סינון תאריך טיסה</h2>";
echo "<pre>";

// בדיקת ההזמנה
$stmt = $pdo->prepare("SELECT id, departure_date, return_date, flight_supplier FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

echo "=== הזמנה #{$orderId} ===\n";
echo "תאריך הלוך: " . $order['departure_date'] . "\n";
echo "תאריך חזור: " . $order['return_date'] . "\n";
echo "ספק: " . $order['flight_supplier'] . "\n\n";

echo "=== פילטר ===\n";
echo "מתאריך: $flightFrom\n";
echo "עד תאריך: $flightTo\n\n";

// בדיקה אם תאריך החזור בטווח
$returnDate = date('Y-m-d', strtotime($order['return_date']));
echo "תאריך חזור (מפורמט): $returnDate\n";
echo "בטווח? " . ($returnDate >= $flightFrom && $returnDate <= $flightTo ? 'כן' : 'לא') . "\n\n";

// בדיקת השאילתה
$sql = "SELECT id, departure_date, return_date FROM orders WHERE 
    (DATE(departure_date) BETWEEN ? AND ?) 
    OR (DATE(return_date) BETWEEN ? AND ?)";
$stmt = $pdo->prepare($sql);
$stmt->execute([$flightFrom, $flightTo, $flightFrom, $flightTo]);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "=== תוצאות שאילתה ===\n";
echo "נמצאו " . count($results) . " הזמנות\n";
foreach ($results as $r) {
    echo "#{$r['id']}: הלוך={$r['departure_date']}, חזור={$r['return_date']}\n";
}

// בדיקת תוספות
echo "\n=== תוספות להזמנה #{$orderId} ===\n";
$stmt = $pdo->prepare("SELECT * FROM order_additions WHERE order_id = ?");
$stmt->execute([$orderId]);
$additions = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($additions as $add) {
    echo "ID: {$add['id']}, component: {$add['component']}, amount: {$add['amount']}, description: {$add['description']}\n";
}

echo "</pre>";
?>
