<?php
// Debug luggage parsing
require_once 'includes/config.php';

$token = $_GET['token'] ?? '';
if (!$token) die('No token');

$pdo = getDB();
$stmt = $pdo->prepare("SELECT luggage_details FROM orders WHERE draft_token = ?");
$stmt->execute([$token]);
$order = $stmt->fetch();

$raw = $order['luggage_details'] ?? '';

echo "<h3>Raw from DB:</h3>";
echo "<pre>" . htmlspecialchars($raw) . "</pre>";

echo "<h3>After stripslashes:</h3>";
$clean = stripslashes($raw);
echo "<pre>" . htmlspecialchars($clean) . "</pre>";

echo "<h3>JSON decode result:</h3>";
$decoded = json_decode($clean, true);
echo "<pre>";
var_dump($decoded);
echo "</pre>";

echo "<h3>JSON error:</h3>";
echo json_last_error_msg();

echo "<h3>Hex dump of first 100 chars:</h3>";
echo "<pre>";
for ($i = 0; $i < min(100, strlen($raw)); $i++) {
    echo sprintf("%02X ", ord($raw[$i]));
    if (($i + 1) % 20 == 0) echo "\n";
}
echo "</pre>";
?>
