<?php
require_once 'includes/config.php';

$order_id = $_GET['id'] ?? null;

echo "<h2>בדיקת הזמנה #$order_id</h2>";
echo "<pre>";

try {
    $pdo = getDB();
    
    // שליפת ההזמנה
    $stmt = $pdo->prepare("SELECT payments FROM orders WHERE id = ?");
    $stmt->execute([$order_id]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "=== PAYMENTS JSON ===\n";
    echo $order['payments'] . "\n\n";
    
    $payments = json_decode($order['payments'], true);
    
    echo "=== PARSED PAYMENTS ===\n";
    foreach ($payments as $i => $p) {
        echo "Payment $i:\n";
        echo "  name: " . ($p['name'] ?? 'NULL') . "\n";
        echo "  amount: " . ($p['amount'] ?? 'NULL') . "\n";
        echo "  method: " . ($p['method'] ?? 'NULL') . "\n";
        echo "  bank_transfer_id: " . ($p['bank_transfer_id'] ?? 'NULL') . "\n";
        echo "---\n";
    }
    
    echo "\n=== BANK TRANSFERS FOR THIS ORDER ===\n";
    $stmt = $pdo->prepare("SELECT id, order_id, transferrer_name, amount, status FROM bank_transfers WHERE order_id = ?");
    $stmt->execute([$order_id]);
    $transfers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($transfers as $t) {
        echo "ID: {$t['id']}, name: {$t['transferrer_name']}, amount: {$t['amount']}, status: {$t['status']}\n";
    }
    
} catch (Exception $e) {
    echo "שגיאה: " . $e->getMessage();
}

echo "</pre>";
?>
