<?php
// בדיקת מבנה טבלה ונתונים
require_once 'includes/config.php';

echo "<h1>🔍 בדיקת דאטאבייס</h1>";
echo "<style>body{font-family:Arial; direction:rtl; padding:20px;} table{border-collapse:collapse; margin:20px 0;} td,th{border:1px solid #ccc; padding:8px;}</style>";

try {
    $pdo = getDB();
    
    // בדיקת עמודות בטבלה
    echo "<h2>עמודות בטבלת orders:</h2>";
    $columns = $pdo->query("SHOW COLUMNS FROM orders")->fetchAll();
    
    $supplierColumns = ['flight_supplier', 'flight_supplier_booking', 'flight_supplier_cost', 
                        'flight_supplier_currency', 'flight_supplier_paid',
                        'hotel_supplier', 'hotel_supplier_booking', 'hotel_supplier_cost',
                        'hotel_supplier_currency', 'hotel_supplier_paid'];
    
    echo "<table><tr><th>עמודה</th><th>סטטוס</th></tr>";
    foreach ($supplierColumns as $col) {
        $exists = false;
        foreach ($columns as $c) {
            if ($c['Field'] === $col) {
                $exists = true;
                break;
            }
        }
        $status = $exists ? '✅ קיימת' : '❌ חסרה';
        $color = $exists ? 'green' : 'red';
        echo "<tr><td>$col</td><td style='color:$color'>$status</td></tr>";
    }
    echo "</table>";
    
    // בדיקת הזמנות עם חובות
    echo "<h2>הזמנות עם סטטוס 'טרם שולם':</h2>";
    
    // בדיקה אם העמודות קיימות
    $hasColumns = true;
    foreach (['flight_supplier', 'flight_supplier_paid', 'hotel_supplier', 'hotel_supplier_paid'] as $col) {
        $found = false;
        foreach ($columns as $c) {
            if ($c['Field'] === $col) {
                $found = true;
                break;
            }
        }
        if (!$found) $hasColumns = false;
    }
    
    if (!$hasColumns) {
        echo "<p style='color:red;'>❌ חסרות עמודות! הרץ את update_db.php קודם.</p>";
    } else {
        // טיסות
        $stmt = $pdo->query("SELECT id, destination, flight_supplier, flight_supplier_cost, flight_supplier_currency, flight_supplier_paid FROM orders WHERE flight_supplier IS NOT NULL");
        $flights = $stmt->fetchAll();
        
        echo "<h3>טיסות:</h3>";
        echo "<table><tr><th>#</th><th>יעד</th><th>ספק</th><th>עלות</th><th>מטבע</th><th>סטטוס</th></tr>";
        foreach ($flights as $f) {
            $color = $f['flight_supplier_paid'] === 'unpaid' ? 'background:#fff3cd;' : '';
            echo "<tr style='$color'>";
            echo "<td>{$f['id']}</td>";
            echo "<td>{$f['destination']}</td>";
            echo "<td>{$f['flight_supplier']}</td>";
            echo "<td>{$f['flight_supplier_cost']}</td>";
            echo "<td>{$f['flight_supplier_currency']}</td>";
            echo "<td>{$f['flight_supplier_paid']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // מלונות
        $stmt = $pdo->query("SELECT id, destination, hotel_supplier, hotel_supplier_cost, hotel_supplier_currency, hotel_supplier_paid FROM orders WHERE hotel_supplier IS NOT NULL");
        $hotels = $stmt->fetchAll();
        
        echo "<h3>מלונות:</h3>";
        echo "<table><tr><th>#</th><th>יעד</th><th>ספק</th><th>עלות</th><th>מטבע</th><th>סטטוס</th></tr>";
        foreach ($hotels as $h) {
            $color = $h['hotel_supplier_paid'] === 'unpaid' ? 'background:#fff3cd;' : '';
            echo "<tr style='$color'>";
            echo "<td>{$h['id']}</td>";
            echo "<td>{$h['destination']}</td>";
            echo "<td>{$h['hotel_supplier']}</td>";
            echo "<td>{$h['hotel_supplier_cost']}</td>";
            echo "<td>{$h['hotel_supplier_currency']}</td>";
            echo "<td>{$h['hotel_supplier_paid']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // ספירת חובות
        $unpaidFlights = $pdo->query("SELECT COUNT(*) FROM orders WHERE flight_supplier_paid = 'unpaid' AND flight_supplier != 'ישיר'")->fetchColumn();
        $unpaidHotels = $pdo->query("SELECT COUNT(*) FROM orders WHERE hotel_supplier_paid = 'unpaid' AND hotel_supplier != 'ישיר'")->fetchColumn();
        
        echo "<h2>סיכום:</h2>";
        echo "<p>טיסות לא שולמו (לא ישיר): <strong>$unpaidFlights</strong></p>";
        echo "<p>מלונות לא שולמו (לא ישיר): <strong>$unpaidHotels</strong></p>";
    }
    
    echo "<br><br>";
    echo "<a href='update_db.php' style='background:#e94560; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>הרץ update_db.php</a> ";
    echo "<a href='supplier_debts.php' style='background:#1e3c72; color:white; padding:10px 20px; text-decoration:none; border-radius:5px; margin-right:10px;'>חובות לספקים</a>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ שגיאה: " . $e->getMessage() . "</p>";
}
