<?php
// מחיקת טיוטה
require_once 'includes/auth.php';
requireLogin();

header('Content-Type: application/json');

$pdo = getDB();

try {
    $draftId = $_POST['draft_id'] ?? null;
    
    if (!$draftId) {
        throw new Exception('חסר מזהה טיוטה');
    }
    
    // שליפת הטיוטה
    $stmt = $pdo->prepare("SELECT * FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    $draft = $stmt->fetch();
    
    if (!$draft) {
        throw new Exception('טיוטה לא נמצאה');
    }
    
    // בדיקה אם הטיוטה כבר מקושרת להזמנה שהושלמה
    if ($draft['order_id']) {
        throw new Exception('לא ניתן למחוק טיוטה שכבר מקושרת להזמנה');
    }
    
    // מחיקת תשלומים קשורים (אם יש)
    $stmt = $pdo->prepare("DELETE FROM draft_payments WHERE draft_id = ?");
    $stmt->execute([$draftId]);
    
    // מחיקת הטיוטה
    $stmt = $pdo->prepare("DELETE FROM drafts WHERE id = ?");
    $stmt->execute([$draftId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'הטיוטה נמחקה בהצלחה'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
