<?php
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>🔧 יצירת טבלאות דוקט</h2>";

// טבלת דוקטים ראשית
$sql1 = "CREATE TABLE IF NOT EXISTS dockets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    docket_number VARCHAR(20) UNIQUE,
    agent_id INT NOT NULL,
    customer_name VARCHAR(100) NOT NULL,
    customer_phone VARCHAR(20),
    customer_email VARCHAR(100),
    destination VARCHAR(100),
    departure_date DATE,
    return_date DATE,
    adults INT DEFAULT 1,
    children INT DEFAULT 0,
    total_customer_price DECIMAL(10,2) DEFAULT 0,
    total_supplier_cost DECIMAL(10,2) DEFAULT 0,
    total_paid DECIMAL(10,2) DEFAULT 0,
    currency VARCHAR(10) DEFAULT 'ILS',
    status ENUM('active','completed','cancelled') DEFAULT 'active',
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_agent (agent_id),
    INDEX idx_status (status),
    INDEX idx_docket_number (docket_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

// טבלת רכיבים (פריטים בדוקט)
$sql2 = "CREATE TABLE IF NOT EXISTS docket_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    docket_id INT NOT NULL,
    item_type ENUM('flight','hotel','package','luggage','insurance','tour','transfer','other') NOT NULL,
    description VARCHAR(255),
    supplier_id INT,
    supplier_name VARCHAR(100),
    supplier_booking_code VARCHAR(100),
    supplier_cost DECIMAL(10,2) DEFAULT 0,
    customer_price DECIMAL(10,2) DEFAULT 0,
    supplier_paid TINYINT(1) DEFAULT 0,
    supplier_paid_date DATE,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_docket (docket_id),
    INDEX idx_supplier (supplier_id),
    INDEX idx_type (item_type),
    FOREIGN KEY (docket_id) REFERENCES dockets(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

// טבלת תשלומי לקוח
$sql3 = "CREATE TABLE IF NOT EXISTS docket_payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    docket_id INT NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    payment_method VARCHAR(50) DEFAULT 'credit_card',
    transaction_id VARCHAR(100),
    approval_number VARCHAR(50),
    payer_name VARCHAR(100),
    receipt_number VARCHAR(50),
    receipt_url TEXT,
    notes TEXT,
    payment_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_docket (docket_id),
    FOREIGN KEY (docket_id) REFERENCES dockets(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

$queries = [
    'dockets' => $sql1,
    'docket_items' => $sql2,
    'docket_payments' => $sql3
];

foreach ($queries as $name => $sql) {
    try {
        $pdo->exec($sql);
        echo "✅ טבלת $name נוצרה<br>";
    } catch (Exception $e) {
        echo "❌ $name: " . $e->getMessage() . "<br>";
    }
}

// יצירת מספר דוקט אוטומטי
echo "<br><h3>✅ מוכן! <a href='dockets.php'>לרשימת הדוקטים</a></h3>";
?>
