<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$docketId = $_GET['id'] ?? null;
if (!$docketId) {
    header("Location: dockets.php");
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM dockets WHERE id = ?");
$stmt->execute([$docketId]);
$docket = $stmt->fetch();

if (!$docket) {
    header("Location: dockets.php");
    exit;
}

$balance = $docket['total_customer_price'] - $docket['total_paid'];
$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$symbol = $currencySymbols[$docket['currency']] ?? '₪';

// Cardcom settings
$stmt = $pdo->query("SELECT * FROM cardcom_settings LIMIT 1");
$cardcom = $stmt->fetch();
$isTestMode = ($cardcom['test_mode'] ?? 1) == 1;

$error = '';
$paymentUrl = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = floatval($_POST['amount']);
    $payerName = trim($_POST['payer_name']);
    $payerEmail = trim($_POST['payer_email']);
    
    if ($amount <= 0) {
        $error = 'סכום לא תקין';
    } elseif ($amount > $balance) {
        $error = 'הסכום גדול מהיתרה לתשלום';
    } else {
        // יצירת טוקן תשלום
        $paymentToken = md5($docketId . time() . rand());
        
        // שמירת פרטי תשלום ממתין
        $stmt = $pdo->prepare("INSERT INTO docket_payments (docket_id, amount, payer_name, notes) VALUES (?, ?, ?, 'pending')");
        $stmt->execute([$docketId, $amount, $payerName]);
        $paymentId = $pdo->lastInsertId();
        
        // בניית בקשה ל-Cardcom
        $terminalNumber = $isTestMode ? 1000 : $cardcom['terminal_number'];
        $apiName = $isTestMode ? 'CardTest1994' : $cardcom['api_name'];
        $apiPassword = $isTestMode ? 'KdgWnrdd**!lWtLhW!y2' : $cardcom['api_password'];
        
        $returnValue = $paymentToken . '|' . $amount . '|' . urlencode($payerName) . '|docket|' . $docketId . '|' . $paymentId;
        
        $requestData = [
            'TerminalNumber' => $terminalNumber,
            'ApiName' => $apiName,
            'ApiPassword' => $apiPassword,
            'Amount' => $amount,
            'SuccessRedirectUrl' => "https://hufshagroup.com/newprojectmillion/docket_payment_success.php?token=$paymentToken",
            'FailedRedirectUrl' => "https://hufshagroup.com/newprojectmillion/docket_payment_failed.php?token=$paymentToken",
            'WebHookUrl' => "https://hufshagroup.com/newprojectmillion/docket_callback.php",
            'ReturnValue' => $returnValue,
            'Document' => [
                'To' => $payerName,
                'Email' => $payerEmail,
                'Products' => [[
                    'Description' => "דוקט #{$docket['docket_number']} - {$docket['destination']}",
                    'UnitCost' => $amount
                ]]
            ]
        ];
        
        $ch = curl_init('https://secure.cardcom.solutions/api/v11/LowProfile/Create');
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_POSTFIELDS => json_encode($requestData)
        ]);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        if (($result['ResponseCode'] ?? -1) === 0) {
            $paymentUrl = $result['Url'];
            
            // עדכון הטוקן בתשלום
            $pdo->prepare("UPDATE docket_payments SET transaction_id = ? WHERE id = ?")->execute([$paymentToken, $paymentId]);
        } else {
            $error = 'שגיאה ביצירת עמוד תשלום: ' . ($result['Description'] ?? 'Unknown');
            // מחיקת התשלום הממתין
            $pdo->prepare("DELETE FROM docket_payments WHERE id = ?")->execute([$paymentId]);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>גבייה - דוקט #<?= htmlspecialchars($docket['docket_number']) ?></title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: #f0f2f5; min-height: 100vh; padding: 20px; }
        
        .container { max-width: 500px; margin: 0 auto; }
        
        .card { background: white; border-radius: 16px; padding: 30px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
        
        h1 { color: #1e3c72; margin-bottom: 10px; font-size: 1.5rem; }
        .subtitle { color: #666; margin-bottom: 25px; }
        
        .info-box { background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 25px; }
        .info-row { display: flex; justify-content: space-between; padding: 8px 0; }
        .info-row:not(:last-child) { border-bottom: 1px solid #eee; }
        .info-label { color: #666; }
        .info-value { font-weight: 600; }
        .balance { color: #dc3545; font-size: 1.3rem; }
        
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; }
        .form-group input { width: 100%; padding: 14px; border: 2px solid #e0e0e0; border-radius: 10px; font-size: 1rem; }
        .form-group input:focus { border-color: #1e3c72; outline: none; }
        
        .btn-pay { width: 100%; background: linear-gradient(135deg, #28a745, #20c997); color: white; border: none; padding: 16px; border-radius: 10px; font-size: 1.1rem; font-weight: bold; cursor: pointer; }
        .btn-pay:hover { transform: translateY(-2px); box-shadow: 0 5px 20px rgba(40,167,69,0.3); }
        
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 10px; margin-bottom: 20px; }
        
        .success-box { background: #d4edda; padding: 25px; border-radius: 10px; text-align: center; }
        .success-box h2 { color: #155724; margin-bottom: 15px; }
        .success-box a { display: inline-block; background: #28a745; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; margin-top: 10px; }
        .success-box .link-box { background: white; padding: 15px; border-radius: 8px; margin: 15px 0; word-break: break-all; }
        .copy-btn { background: #1e3c72; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer; margin-top: 10px; }
        
        .back-link { display: block; text-align: center; margin-top: 20px; color: #666; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>💳 גביית תשלום</h1>
            <p class="subtitle">דוקט #<?= htmlspecialchars($docket['docket_number']) ?> - <?= htmlspecialchars($docket['customer_name']) ?></p>
            
            <?php if ($paymentUrl): ?>
            <div class="success-box">
                <h2>✅ לינק תשלום נוצר!</h2>
                <p>שלח את הלינק ללקוח:</p>
                <div class="link-box" id="paymentLink"><?= htmlspecialchars($paymentUrl) ?></div>
                <button class="copy-btn" onclick="copyLink()">📋 העתק לינק</button>
                <br>
                <a href="<?= htmlspecialchars($paymentUrl) ?>" target="_blank">🔗 פתח עמוד תשלום</a>
            </div>
            
            <?php else: ?>
            
            <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <div class="info-box">
                <div class="info-row">
                    <span class="info-label">יעד</span>
                    <span class="info-value"><?= htmlspecialchars($docket['destination']) ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">סה"כ הזמנה</span>
                    <span class="info-value"><?= $symbol ?><?= number_format($docket['total_customer_price']) ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">שולם</span>
                    <span class="info-value"><?= $symbol ?><?= number_format($docket['total_paid']) ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">יתרה לתשלום</span>
                    <span class="info-value balance"><?= $symbol ?><?= number_format($balance) ?></span>
                </div>
            </div>
            
            <?php if ($balance > 0): ?>
            <form method="POST">
                <div class="form-group">
                    <label>סכום לגבייה</label>
                    <input type="number" name="amount" step="0.01" max="<?= $balance ?>" value="<?= $balance ?>" required>
                </div>
                <div class="form-group">
                    <label>שם המשלם</label>
                    <input type="text" name="payer_name" value="<?= htmlspecialchars($docket['customer_name']) ?>" required>
                </div>
                <div class="form-group">
                    <label>אימייל</label>
                    <input type="email" name="payer_email" value="<?= htmlspecialchars($docket['customer_email']) ?>">
                </div>
                <button type="submit" class="btn-pay">💳 צור לינק תשלום</button>
            </form>
            <?php else: ?>
            <div class="success-box">
                <h2>✅ ההזמנה שולמה במלואה!</h2>
            </div>
            <?php endif; ?>
            
            <?php endif; ?>
            
            <a href="docket_view.php?id=<?= $docketId ?>" class="back-link">← חזרה לדוקט</a>
        </div>
    </div>
    
    <script>
    function copyLink() {
        const link = document.getElementById('paymentLink').textContent;
        navigator.clipboard.writeText(link).then(() => {
            alert('הלינק הועתק!');
        });
    }
    </script>
</body>
</html>
