<?php
require_once 'includes/config.php';
$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$token = $_GET['token'] ?? '';

// חיפוש התשלום לפי token
usleep(500000);

$stmt = $pdo->prepare("SELECT dp.*, d.docket_number, d.customer_name, d.destination, d.total_customer_price, d.total_paid, d.currency
    FROM docket_payments dp 
    JOIN dockets d ON dp.docket_id = d.id 
    WHERE dp.transaction_id = ?
    ORDER BY dp.id DESC LIMIT 1");
$stmt->execute([$token]);
$payment = $stmt->fetch();

$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$symbol = $payment ? ($currencySymbols[$payment['currency']] ?? '₪') : '₪';
$balance = $payment ? ($payment['total_customer_price'] - $payment['total_paid']) : 0;
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>תשלום הצליח!</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: linear-gradient(135deg, #28a745, #20c997); min-height: 100vh; padding: 20px; display: flex; align-items: center; justify-content: center; }
        .card { background: white; max-width: 500px; width: 100%; padding: 50px 40px; border-radius: 20px; text-align: center; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
        .icon { font-size: 80px; margin-bottom: 20px; }
        h1 { color: #28a745; margin-bottom: 15px; }
        .message { color: #666; margin-bottom: 30px; }
        .info-box { background: #f8f9fa; padding: 20px; border-radius: 12px; text-align: right; margin: 20px 0; }
        .info-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #eee; }
        .info-row:last-child { border-bottom: none; }
        .amount-paid { background: #28a745; color: white; padding: 20px; border-radius: 12px; margin: 20px 0; }
        .amount-paid .value { font-size: 2rem; font-weight: bold; }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon">✅</div>
        <h1>התשלום הצליח!</h1>
        <p class="message">תודה רבה על התשלום</p>
        
        <?php if ($payment): ?>
        <div class="amount-paid">
            <div>סכום ששולם</div>
            <div class="value"><?= $symbol ?><?= number_format($payment['amount']) ?></div>
        </div>
        
        <div class="info-box">
            <div class="info-row">
                <span>מספר דוקט</span>
                <strong>#<?= htmlspecialchars($payment['docket_number']) ?></strong>
            </div>
            <div class="info-row">
                <span>לקוח</span>
                <strong><?= htmlspecialchars($payment['customer_name']) ?></strong>
            </div>
            <div class="info-row">
                <span>יעד</span>
                <strong><?= htmlspecialchars($payment['destination']) ?></strong>
            </div>
            <?php if ($balance > 0): ?>
            <div class="info-row">
                <span>נותר לתשלום</span>
                <strong style="color: #dc3545"><?= $symbol ?><?= number_format($balance) ?></strong>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <p style="color: #666; margin-top: 20px;">קבלה תישלח למייל שלך</p>
    </div>
</body>
</html>
