<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$docketId = $_GET['id'] ?? null;
if (!$docketId) {
    header("Location: dockets.php");
    exit;
}

// טעינת דוקט
$stmt = $pdo->prepare("SELECT d.*, a.full_name as agent_name FROM dockets d JOIN agents a ON d.agent_id = a.id WHERE d.id = ?");
$stmt->execute([$docketId]);
$docket = $stmt->fetch();

if (!$docket) {
    header("Location: dockets.php");
    exit;
}

// טעינת רכיבים
$stmt = $pdo->prepare("SELECT * FROM docket_items WHERE docket_id = ? ORDER BY id");
$stmt->execute([$docketId]);
$items = $stmt->fetchAll();

// טעינת תשלומים
$stmt = $pdo->prepare("SELECT * FROM docket_payments WHERE docket_id = ? ORDER BY payment_date DESC");
$stmt->execute([$docketId]);
$payments = $stmt->fetchAll();

$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$symbol = $currencySymbols[$docket['currency']] ?? '₪';

$balance = $docket['total_customer_price'] - $docket['total_paid'];
$profit = $docket['total_customer_price'] - $docket['total_supplier_cost'];

$itemTypeLabels = [
    'flight' => '✈️ טיסה',
    'hotel' => '🏨 מלון',
    'package' => '📦 חבילה',
    'luggage' => '🧳 כבודה',
    'insurance' => '🛡️ ביטוח',
    'tour' => '🎯 טיול',
    'transfer' => '🚐 העברה',
    'other' => '📋 אחר'
];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>דוקט #<?= htmlspecialchars($docket['docket_number']) ?> - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: #f0f2f5; min-height: 100vh; }
        
        .header { background: linear-gradient(135deg, #1e3c72, #2a5298); color: white; padding: 20px; }
        .header-content { max-width: 1200px; margin: 0 auto; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; }
        .header h1 { font-size: 1.5rem; }
        .header-actions { display: flex; gap: 10px; }
        .header-actions a { color: white; text-decoration: none; background: rgba(255,255,255,0.2); padding: 10px 20px; border-radius: 8px; }
        .btn-edit { background: #ffc107 !important; color: #333 !important; }
        .btn-payment { background: #28a745 !important; }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        
        .alert { padding: 15px 20px; border-radius: 8px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        
        .summary-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin-bottom: 25px; }
        .summary-card { background: white; padding: 20px; border-radius: 12px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .summary-card .value { font-size: 1.8rem; font-weight: bold; }
        .summary-card .label { color: #666; margin-top: 5px; font-size: 0.9rem; }
        .summary-card.profit .value { color: #28a745; }
        .summary-card.balance .value { color: #dc3545; }
        .summary-card.paid .value { color: #17a2b8; }
        
        .card { background: white; border-radius: 12px; padding: 25px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .card h2 { margin-bottom: 20px; color: #1e3c72; border-bottom: 2px solid #eee; padding-bottom: 10px; }
        
        .info-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; }
        .info-item { }
        .info-item .label { color: #666; font-size: 0.9rem; }
        .info-item .value { font-size: 1.1rem; font-weight: 500; margin-top: 3px; }
        
        .status { display: inline-block; padding: 5px 15px; border-radius: 20px; font-size: 0.9rem; }
        .status-active { background: #d4edda; color: #155724; }
        .status-completed { background: #cce5ff; color: #004085; }
        .status-cancelled { background: #f8d7da; color: #721c24; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th { background: #f8f9fa; padding: 12px; text-align: right; font-weight: 600; border-bottom: 2px solid #eee; }
        td { padding: 12px; border-bottom: 1px solid #eee; }
        tr:hover { background: #f8f9fa; }
        
        .item-type { display: inline-block; padding: 3px 10px; background: #e3f2fd; border-radius: 15px; font-size: 0.85rem; }
        .supplier-code { font-family: monospace; background: #f8f9fa; padding: 3px 8px; border-radius: 4px; }
        .paid-badge { background: #28a745; color: white; padding: 3px 10px; border-radius: 10px; font-size: 0.8rem; }
        .unpaid-badge { background: #ffc107; color: #333; padding: 3px 10px; border-radius: 10px; font-size: 0.8rem; }
        
        .amount { font-weight: 600; }
        
        .empty { text-align: center; padding: 30px; color: #666; }
        
        .add-payment-form { background: #f8f9fa; padding: 20px; border-radius: 10px; margin-top: 20px; }
        .add-payment-form h3 { margin-bottom: 15px; }
        .form-row { display: flex; gap: 15px; flex-wrap: wrap; align-items: end; }
        .form-row .form-group { flex: 1; min-width: 150px; }
        .form-row label { display: block; margin-bottom: 5px; font-weight: 500; }
        .form-row input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 6px; }
        .form-row button { background: #28a745; color: white; border: none; padding: 12px 25px; border-radius: 6px; cursor: pointer; white-space: nowrap; }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <h1>📁 דוקט #<?= htmlspecialchars($docket['docket_number']) ?></h1>
            <div class="header-actions">
                <a href="docket_edit.php?id=<?= $docketId ?>" class="btn-edit">✏️ עריכה</a>
                <a href="docket_payment.php?id=<?= $docketId ?>" class="btn-payment">💳 גבייה</a>
                <a href="dockets.php">← חזרה</a>
            </div>
        </div>
    </div>
    
    <div class="container">
        <?php if (isset($_GET['saved'])): ?>
        <div class="alert alert-success">✅ הדוקט נשמר בהצלחה!</div>
        <?php endif; ?>
        
        <div class="summary-cards">
            <div class="summary-card">
                <div class="value"><?= $symbol ?><?= number_format($docket['total_customer_price']) ?></div>
                <div class="label">מחיר ללקוח</div>
            </div>
            <div class="summary-card">
                <div class="value"><?= $symbol ?><?= number_format($docket['total_supplier_cost']) ?></div>
                <div class="label">עלות ספקים</div>
            </div>
            <div class="summary-card profit">
                <div class="value"><?= $symbol ?><?= number_format($profit) ?></div>
                <div class="label">רווח</div>
            </div>
            <div class="summary-card paid">
                <div class="value"><?= $symbol ?><?= number_format($docket['total_paid']) ?></div>
                <div class="label">שולם</div>
            </div>
            <div class="summary-card balance">
                <div class="value"><?= $symbol ?><?= number_format($balance) ?></div>
                <div class="label">יתרה לגבייה</div>
            </div>
        </div>
        
        <div class="card">
            <h2>👤 פרטי הזמנה</h2>
            <div class="info-grid">
                <div class="info-item">
                    <div class="label">לקוח</div>
                    <div class="value"><?= htmlspecialchars($docket['customer_name']) ?></div>
                </div>
                <div class="info-item">
                    <div class="label">טלפון</div>
                    <div class="value"><?= htmlspecialchars($docket['customer_phone'] ?: '-') ?></div>
                </div>
                <div class="info-item">
                    <div class="label">אימייל</div>
                    <div class="value"><?= htmlspecialchars($docket['customer_email'] ?: '-') ?></div>
                </div>
                <div class="info-item">
                    <div class="label">יעד</div>
                    <div class="value"><?= htmlspecialchars($docket['destination'] ?: '-') ?></div>
                </div>
                <div class="info-item">
                    <div class="label">תאריכים</div>
                    <div class="value">
                        <?php if ($docket['departure_date']): ?>
                        <?= date('d/m/Y', strtotime($docket['departure_date'])) ?> - <?= date('d/m/Y', strtotime($docket['return_date'])) ?>
                        <?php else: ?>
                        -
                        <?php endif; ?>
                    </div>
                </div>
                <div class="info-item">
                    <div class="label">נוסעים</div>
                    <div class="value"><?= $docket['adults'] ?> מבוגרים<?= $docket['children'] ? ", {$docket['children']} ילדים" : '' ?></div>
                </div>
                <div class="info-item">
                    <div class="label">סוכן</div>
                    <div class="value"><?= htmlspecialchars($docket['agent_name']) ?></div>
                </div>
                <div class="info-item">
                    <div class="label">סטטוס</div>
                    <div class="value">
                        <span class="status status-<?= $docket['status'] ?>">
                            <?= $docket['status'] === 'active' ? 'פעיל' : ($docket['status'] === 'completed' ? 'הושלם' : 'בוטל') ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php if ($docket['notes']): ?>
            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #eee;">
                <div class="label">הערות</div>
                <div style="margin-top: 5px;"><?= nl2br(htmlspecialchars($docket['notes'])) ?></div>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="card">
            <h2>📦 רכיבי ההזמנה</h2>
            <?php if (empty($items)): ?>
            <div class="empty">אין רכיבים עדיין</div>
            <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>סוג</th>
                        <th>תיאור</th>
                        <th>ספק</th>
                        <th>מספר הזמנה</th>
                        <th>עלות לספק</th>
                        <th>מחיר ללקוח</th>
                        <th>סטטוס תשלום</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($items as $item): ?>
                    <tr>
                        <td><span class="item-type"><?= $itemTypeLabels[$item['item_type']] ?? $item['item_type'] ?></span></td>
                        <td><?= htmlspecialchars($item['description']) ?></td>
                        <td><?= htmlspecialchars($item['supplier_name'] ?: '-') ?></td>
                        <td><?= $item['supplier_booking_code'] ? '<span class="supplier-code">' . htmlspecialchars($item['supplier_booking_code']) . '</span>' : '-' ?></td>
                        <td class="amount"><?= $symbol ?><?= number_format($item['supplier_cost']) ?></td>
                        <td class="amount"><?= $symbol ?><?= number_format($item['customer_price']) ?></td>
                        <td>
                            <?php if ($item['supplier_paid']): ?>
                            <span class="paid-badge">✓ שולם</span>
                            <?php else: ?>
                            <span class="unpaid-badge">ממתין</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        
        <div class="card">
            <h2>💰 תשלומי לקוח</h2>
            <?php if (empty($payments)): ?>
            <div class="empty">אין תשלומים עדיין</div>
            <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>תאריך</th>
                        <th>סכום</th>
                        <th>אמצעי</th>
                        <th>מספר אישור</th>
                        <th>קבלה</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($payments as $p): ?>
                    <tr>
                        <td><?= date('d/m/Y H:i', strtotime($p['payment_date'])) ?></td>
                        <td class="amount"><?= $symbol ?><?= number_format($p['amount']) ?></td>
                        <td><?= $p['payment_method'] === 'credit_card' ? 'כרטיס אשראי' : $p['payment_method'] ?></td>
                        <td><?= htmlspecialchars($p['approval_number'] ?: '-') ?></td>
                        <td>
                            <?php if ($p['receipt_number']): ?>
                            <a href="<?= htmlspecialchars($p['receipt_url']) ?>" target="_blank">#<?= htmlspecialchars($p['receipt_number']) ?></a>
                            <?php else: ?>
                            -
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
            
            <?php if ($balance > 0): ?>
            <div style="margin-top: 20px; text-align: center;">
                <a href="docket_payment.php?id=<?= $docketId ?>" style="background: #28a745; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; display: inline-block;">
                    💳 גבה <?= $symbol ?><?= number_format($balance) ?>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
