<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$agentId = $_SESSION['agent_id'];
$isAdmin = ($_SESSION['role'] ?? '') === 'admin';

// פילטרים
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';

$where = [];
$params = [];

if (!$isAdmin) {
    $where[] = "d.agent_id = ?";
    $params[] = $agentId;
}

if ($status) {
    $where[] = "d.status = ?";
    $params[] = $status;
}

if ($search) {
    $where[] = "(d.docket_number LIKE ? OR d.customer_name LIKE ? OR d.destination LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$stmt = $pdo->prepare("
    SELECT d.*, a.full_name as agent_name,
           (d.total_customer_price - d.total_paid) as balance,
           (d.total_customer_price - d.total_supplier_cost) as profit
    FROM dockets d
    JOIN agents a ON d.agent_id = a.id
    $whereClause
    ORDER BY d.created_at DESC
");
$stmt->execute($params);
$dockets = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ניהול דוקטים - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: #f0f2f5; min-height: 100vh; }
        
        .header { background: linear-gradient(135deg, #1e3c72, #2a5298); color: white; padding: 20px; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; }
        .header h1 { font-size: 1.5rem; }
        .header-actions { display: flex; gap: 10px; flex-wrap: wrap; }
        .header-actions a { background: rgba(255,255,255,0.2); color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; }
        .header-actions a:hover { background: rgba(255,255,255,0.3); }
        .btn-new { background: #28a745 !important; }
        
        .container { max-width: 1400px; margin: 0 auto; padding: 20px; }
        
        .filters { background: white; padding: 20px; border-radius: 12px; margin-bottom: 20px; display: flex; gap: 15px; flex-wrap: wrap; align-items: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .filters input, .filters select { padding: 10px 15px; border: 1px solid #ddd; border-radius: 8px; font-size: 1rem; }
        .filters input[type="text"] { min-width: 250px; }
        .filters button { background: #1e3c72; color: white; border: none; padding: 10px 20px; border-radius: 8px; cursor: pointer; }
        
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .stat-card { background: white; padding: 20px; border-radius: 12px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .stat-card .number { font-size: 2rem; font-weight: bold; color: #1e3c72; }
        .stat-card .label { color: #666; margin-top: 5px; }
        
        table { width: 100%; background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-collapse: collapse; }
        th { background: #f8f9fa; padding: 15px; text-align: right; font-weight: 600; color: #333; border-bottom: 2px solid #eee; }
        td { padding: 15px; border-bottom: 1px solid #eee; }
        tr:hover { background: #f8f9fa; }
        
        .docket-num { font-weight: bold; color: #1e3c72; }
        .customer { font-weight: 500; }
        .destination { color: #666; }
        
        .status { padding: 5px 12px; border-radius: 20px; font-size: 0.85rem; }
        .status-active { background: #d4edda; color: #155724; }
        .status-completed { background: #cce5ff; color: #004085; }
        .status-cancelled { background: #f8d7da; color: #721c24; }
        
        .amount { font-weight: 600; }
        .amount.positive { color: #28a745; }
        .amount.negative { color: #dc3545; }
        
        .actions a { color: #1e3c72; text-decoration: none; margin-left: 10px; }
        .actions a:hover { text-decoration: underline; }
        
        .empty { text-align: center; padding: 60px; color: #666; }
        .empty h3 { margin-bottom: 10px; }
        
        @media (max-width: 768px) {
            .filters { flex-direction: column; }
            .filters input[type="text"] { min-width: 100%; }
            table { font-size: 0.9rem; }
            th, td { padding: 10px 8px; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📁 ניהול דוקטים</h1>
        <div class="header-actions">
            <a href="docket_edit.php" class="btn-new">➕ דוקט חדש</a>
            <a href="supplier_report.php">📊 דוח ספקים</a>
            <a href="dashboard.php">🏠 ראשי</a>
        </div>
    </div>
    
    <div class="container">
        <form class="filters" method="GET">
            <input type="text" name="search" placeholder="🔍 חיפוש לפי מספר/שם/יעד..." value="<?= htmlspecialchars($search) ?>">
            <select name="status">
                <option value="">כל הסטטוסים</option>
                <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>פעיל</option>
                <option value="completed" <?= $status === 'completed' ? 'selected' : '' ?>>הושלם</option>
                <option value="cancelled" <?= $status === 'cancelled' ? 'selected' : '' ?>>בוטל</option>
            </select>
            <button type="submit">סנן</button>
        </form>
        
        <?php
        $totalDockets = count($dockets);
        $totalCustomer = array_sum(array_column($dockets, 'total_customer_price'));
        $totalSupplier = array_sum(array_column($dockets, 'total_supplier_cost'));
        $totalProfit = $totalCustomer - $totalSupplier;
        ?>
        <div class="stats">
            <div class="stat-card">
                <div class="number"><?= $totalDockets ?></div>
                <div class="label">דוקטים</div>
            </div>
            <div class="stat-card">
                <div class="number">₪<?= number_format($totalCustomer) ?></div>
                <div class="label">סה"כ מכירות</div>
            </div>
            <div class="stat-card">
                <div class="number">₪<?= number_format($totalSupplier) ?></div>
                <div class="label">סה"כ עלויות</div>
            </div>
            <div class="stat-card">
                <div class="number" style="color: #28a745">₪<?= number_format($totalProfit) ?></div>
                <div class="label">רווח</div>
            </div>
        </div>
        
        <?php if (empty($dockets)): ?>
        <div class="empty">
            <h3>📁 אין דוקטים עדיין</h3>
            <p>לחץ על "דוקט חדש" כדי להתחיל</p>
        </div>
        <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>מספר דוקט</th>
                    <th>לקוח</th>
                    <th>יעד</th>
                    <th>תאריכים</th>
                    <th>מחיר ללקוח</th>
                    <th>עלות ספקים</th>
                    <th>רווח</th>
                    <th>יתרה לגבייה</th>
                    <th>סטטוס</th>
                    <th>פעולות</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dockets as $d): ?>
                <tr>
                    <td class="docket-num">#<?= htmlspecialchars($d['docket_number']) ?></td>
                    <td class="customer"><?= htmlspecialchars($d['customer_name']) ?></td>
                    <td class="destination"><?= htmlspecialchars($d['destination']) ?></td>
                    <td><?= $d['departure_date'] ? date('d/m', strtotime($d['departure_date'])) . '-' . date('d/m', strtotime($d['return_date'])) : '-' ?></td>
                    <td class="amount">₪<?= number_format($d['total_customer_price']) ?></td>
                    <td class="amount">₪<?= number_format($d['total_supplier_cost']) ?></td>
                    <td class="amount positive">₪<?= number_format($d['profit']) ?></td>
                    <td class="amount <?= $d['balance'] > 0 ? 'negative' : '' ?>">₪<?= number_format($d['balance']) ?></td>
                    <td>
                        <span class="status status-<?= $d['status'] ?>">
                            <?= $d['status'] === 'active' ? 'פעיל' : ($d['status'] === 'completed' ? 'הושלם' : 'בוטל') ?>
                        </span>
                    </td>
                    <td class="actions">
                        <a href="docket_view.php?id=<?= $d['id'] ?>">👁️ צפה</a>
                        <a href="docket_edit.php?id=<?= $d['id'] ?>">✏️ ערוך</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
</body>
</html>
