<?php
// טיוטה ללקוח - עם לינק תשלום
require_once 'includes/auth.php';
requireLogin();
blockAccountant();

$agent = getCurrentAgent();
$isAdmin = ($agent && isset($agent['role']) && $agent['role'] === 'admin');
$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$message = '';
$messageType = '';
$savedDraft = null;
$paymentLink = '';

// שמירת טיוטה
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_draft'])) {
    $token = bin2hex(random_bytes(16)); // 32 תווים ייחודיים
    
    $numPassengers = (int)$_POST['num_passengers'];
    $pricePerPerson = (float)$_POST['price_per_person'];
    $totalPrice = $numPassengers * $pricePerPerson;
    $orderType = $_POST['order_type'] ?? 'separate';
    
    // תוקף 7 ימים
    $expiresAt = date('Y-m-d H:i:s', strtotime('+7 days'));
    
    $stmt = $pdo->prepare("
        INSERT INTO drafts (
            token, agent_id, customer_name, customer_phone, customer_email,
            destination, num_passengers, departure_date, return_date,
            airline, flight_time_out, flight_time_return,
            hotel_name, hotel_stars, board_basis,
            price_per_person, total_price, currency, notes, expires_at, order_type
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $token,
        $agent['id'],
        $_POST['customer_name'],
        $_POST['customer_phone'],
        $_POST['customer_email'] ?? '',
        $_POST['destination'],
        $numPassengers,
        $_POST['departure_date'],
        $_POST['return_date'],
        $_POST['airline'] ?? '',
        $_POST['flight_time_out'] ?: null,
        $_POST['flight_time_return'] ?: null,
        $_POST['hotel_name'] ?? '',
        $_POST['hotel_stars'] ?: null,
        $_POST['board_basis'] ?? 'BB',
        $pricePerPerson,
        $totalPrice,
        $_POST['currency'] ?? 'ILS',
        $_POST['notes'] ?? '',
        $expiresAt,
        $orderType
    ]);
    
    $draftId = $pdo->lastInsertId();
    
    // יצירת לינק תשלום
    $baseUrl = 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']);
    $paymentLink = $baseUrl . '/pay.php?token=' . $token;
    
    // עדכון סטטוס לנשלח
    $pdo->prepare("UPDATE drafts SET status = 'sent' WHERE id = ?")->execute([$draftId]);
    
    $savedDraft = [
        'id' => $draftId,
        'token' => $token,
        'customer_name' => $_POST['customer_name'],
        'customer_phone' => $_POST['customer_phone'],
        'destination' => $_POST['destination'],
        'total_price' => $totalPrice,
        'currency' => $_POST['currency'] ?? 'ILS',
        'order_type' => $orderType
    ];
    
    $message = 'הטיוטה נשמרה! הלינק לתשלום מוכן לשליחה';
    $messageType = 'success';
}

// שליפת נתונים לautocomplete
$destinations = $pdo->query("SELECT name, country FROM settings_destinations WHERE active = 1 ORDER BY sort_order, name")->fetchAll();
$airlines = $pdo->query("SELECT name, code FROM settings_airlines WHERE active = 1 ORDER BY sort_order, name")->fetchAll();
$hotels = $pdo->query("SELECT name, destination FROM settings_hotels WHERE active = 1 ORDER BY destination, name")->fetchAll();

$destinationsJson = json_encode(array_map(function($d) {
    return $d['name'] . ', ' . $d['country'];
}, $destinations));

$airlinesJson = json_encode(array_map(function($a) {
    return $a['code'] ? $a['name'] . ' (' . $a['code'] . ')' : $a['name'];
}, $airlines));

$hotelsJson = json_encode($hotels);
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>טיוטה ללקוח - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .header { display: flex; justify-content: space-between; align-items: center; padding: 15px 30px; background: white; box-shadow: 0 2px 10px rgba(0,0,0,0.1); flex-wrap: wrap; gap: 15px; }
        .main-nav { display: flex; gap: 5px; }
        .nav-link { padding: 10px 20px; text-decoration: none; color: #555; border-radius: 8px; font-weight: 500; transition: all 0.2s; }
        .nav-link:hover { background: #f0f0f0; color: #333; }
        .nav-link.active { background: #667eea; color: white; }
        @media (max-width: 900px) { .main-nav { order: 3; width: 100%; justify-content: center; } }
        
        .form-section { background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 20px; }
        .form-section h3 { margin-top: 0; margin-bottom: 15px; color: #333; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .form-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 15px; }
        .form-group { position: relative; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; color: #555; }
        .form-group input, .form-group select, .form-group textarea { width: 100%; padding: 10px 12px; border: 2px solid #e0e0e0; border-radius: 8px; font-size: 1rem; box-sizing: border-box; }
        .form-group input:focus, .form-group select:focus { border-color: #667eea; outline: none; }
        
        .autocomplete-dropdown { position: absolute; top: 100%; right: 0; left: 0; background: white; border: 2px solid #667eea; border-top: none; border-radius: 0 0 8px 8px; max-height: 200px; overflow-y: auto; z-index: 1000; display: none; box-shadow: 0 4px 15px rgba(0,0,0,0.15); }
        .autocomplete-dropdown.show { display: block; }
        .autocomplete-item { padding: 10px 12px; cursor: pointer; border-bottom: 1px solid #eee; }
        .autocomplete-item:last-child { border-bottom: none; }
        .autocomplete-item:hover, .autocomplete-item.selected { background: #667eea; color: white; }
        .autocomplete-item .match { font-weight: bold; }
        .autocomplete-item:hover .match, .autocomplete-item.selected .match { color: #ffd700; }
        .no-results { padding: 10px 12px; color: #999; font-style: italic; }
        
        .price-calculator { background: #e8f5e9; padding: 20px; border-radius: 10px; margin-top: 20px; }
        .price-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #c8e6c9; }
        .price-row:last-child { border-bottom: none; font-weight: bold; font-size: 1.2rem; color: #2e7d32; }
        
        .preview-box { background: #fff8e1; padding: 20px; border-radius: 10px; margin-top: 20px; border: 2px solid #ffcc02; }
        .preview-box h3 { margin-top: 0; color: #f57c00; }
        #previewText { white-space: pre-wrap; font-family: Arial, sans-serif; line-height: 1.8; background: white; padding: 15px; border-radius: 8px; }
        
        .action-buttons { display: flex; gap: 15px; margin-top: 25px; flex-wrap: wrap; }
        .btn-save { background: #667eea; color: white; padding: 15px 30px; border: none; border-radius: 10px; font-size: 1.1rem; cursor: pointer; flex: 1; min-width: 200px; }
        .btn-save:hover { background: #5a6fd6; }
        .btn-random { background: #ff9800; color: white; padding: 15px 20px; border: none; border-radius: 10px; font-size: 1rem; cursor: pointer; }
        .btn-random:hover { background: #f57c00; }
        
        /* Success Modal */
        .success-modal { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 2000; align-items: center; justify-content: center; }
        .success-modal.show { display: flex; }
        .success-content { background: white; padding: 40px; border-radius: 20px; max-width: 500px; width: 90%; text-align: center; }
        .success-content h2 { color: #28a745; margin-bottom: 20px; }
        .payment-link-box { background: #f8f9fa; padding: 15px; border-radius: 10px; margin: 20px 0; word-break: break-all; font-family: monospace; font-size: 0.9rem; }
        .btn-whatsapp { background: #25D366; color: white; padding: 15px 30px; border: none; border-radius: 10px; font-size: 1.1rem; cursor: pointer; width: 100%; margin-bottom: 10px; }
        .btn-whatsapp:hover { background: #128C7E; }
        .btn-copy { background: #6c757d; color: white; padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; margin: 5px; }
        .btn-new { background: #667eea; color: white; padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; margin: 5px; text-decoration: none; display: inline-block; }
        .btn-drafts { background: #17a2b8; color: white; padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; margin: 5px; text-decoration: none; display: inline-block; }
        
        .alert { padding: 15px 20px; border-radius: 8px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        
        .order-type-option:has(input:checked) { border-color: #667eea !important; box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4); transform: translateY(-2px); }
        .order-type-option:hover { transform: translateY(-2px); box-shadow: 0 3px 10px rgba(0,0,0,0.1); }
    </style>
    <!-- Flatpickr -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/he.js"></script>
    <style>
        .flatpickr-input { cursor: pointer !important; background: white !important; }
        .flatpickr-calendar { direction: rtl; width: 320px; }
        .flatpickr-day.selected { background: #667eea !important; border-color: #667eea !important; }
        /* הסתרת כל החצים */
        .flatpickr-prev-month, .flatpickr-next-month, .flatpickr-current-month .numInputWrapper span { display: none !important; }
        .flatpickr-months { padding: 10px; }
        .flatpickr-current-month { display: flex; justify-content: center; align-items: center; gap: 15px; padding: 0; width: 100%; }
        .flatpickr-current-month select.flatpickr-monthDropdown-months { font-size: 1rem; font-weight: bold; padding: 8px 30px 8px 10px; border-radius: 6px; border: 1px solid #ddd; background: white; cursor: pointer; appearance: menulist; -webkit-appearance: menulist; }
        .flatpickr-current-month .numInputWrapper { width: auto; }
        .flatpickr-current-month .numInputWrapper input.cur-year { font-size: 1rem; font-weight: bold; padding: 8px 10px; border-radius: 6px; border: 1px solid #ddd; background: white; cursor: pointer; width: 80px; text-align: center; }
        .flatpickr-weekdays, .flatpickr-days { direction: rtl; }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <nav class="main-nav">
            <a href="complete_order_lite.php" class="nav-link">⚡ הזמנה לייט</a>
            <a href="drafts_list.php" class="nav-link">📋 טיוטות</a>
            <a href="orders_panel.php" class="nav-link">🔍 פאנל מתקדם</a>
            <?php if ($isAdmin): ?>
            <a href="reports.php" class="nav-link">📈 דוחות</a>
            <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
            <?php endif; ?>
        </nav>
        <div class="user-info">
            <span class="user-name">שלום, <?= sanitize($agent['full_name']) ?></span>
            <a href="logout.php" class="btn-logout">התנתק</a>
        </div>
    </header>

    <div class="container" style="max-width:800px;">
        <div class="card">
            <h1 class="card-title">📋 טיוטה ללקוח</h1>
            <p style="color:#666; margin-bottom:20px;">מלא את הפרטים, שמור וקבל לינק תשלום לשליחה ללקוח</p>
            
            <form id="draftForm" method="POST">
                <!-- סוג הזמנה -->
                <div class="form-section" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; border-radius: 10px; margin-bottom: 20px;">
                    <h3 style="color: white; margin-bottom: 15px;">🎯 סוג ההזמנה</h3>
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <label style="flex: 1; min-width: 120px; background: white; border-radius: 10px; padding: 15px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;" class="order-type-option">
                            <input type="radio" name="order_type" value="separate" checked style="display: none;">
                            <div style="font-size: 1.5rem;">✈️🏨</div>
                            <div style="font-weight: bold; color: #333; font-size: 0.9rem;">חבילה נפרדת</div>
                        </label>
                        <label style="flex: 1; min-width: 120px; background: white; border-radius: 10px; padding: 15px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;" class="order-type-option">
                            <input type="radio" name="order_type" value="package" style="display: none;">
                            <div style="font-size: 1.5rem;">📦</div>
                            <div style="font-weight: bold; color: #333; font-size: 0.9rem;">נופשון קומפלט</div>
                        </label>
                        <label style="flex: 1; min-width: 120px; background: white; border-radius: 10px; padding: 15px; cursor: pointer; text-align: center; transition: all 0.3s; border: 3px solid transparent;" class="order-type-option">
                            <input type="radio" name="order_type" value="tour" style="display: none;">
                            <div style="font-size: 1.5rem;">🚌</div>
                            <div style="font-weight: bold; color: #333; font-size: 0.9rem;">טיול מאורגן</div>
                        </label>
                    </div>
                </div>
                
                <!-- פרטי לקוח -->
                <div class="form-section">
                    <h3>👤 פרטי לקוח</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>שם הלקוח *</label>
                            <input type="text" name="customer_name" id="customer_name" required placeholder="Israel Israeli">
                        </div>
                        <div class="form-group">
                            <label>טלפון *</label>
                            <input type="tel" name="customer_phone" id="customer_phone" required placeholder="050-1234567">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>אימייל (לקבלה)</label>
                            <input type="email" name="customer_email" id="customer_email" placeholder="israel@email.com">
                        </div>
                    </div>
                </div>

                <!-- פרטי חופשה -->
                <div class="form-section">
                    <h3>🌍 פרטי החופשה</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>יעד *</label>
                            <input type="text" name="destination" id="destination" required placeholder="Prague, Czech Republic" autocomplete="off">
                            <div class="autocomplete-dropdown" id="destination-dropdown"></div>
                        </div>
                        <div class="form-group">
                            <label>מספר נוסעים *</label>
                            <input type="number" name="num_passengers" id="num_passengers" min="1" value="2" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>תאריך יציאה *</label>
                            <input type="date" name="departure_date" id="departure_date" required>
                        </div>
                        <div class="form-group">
                            <label>תאריך חזרה *</label>
                            <input type="date" name="return_date" id="return_date" required>
                        </div>
                    </div>
                </div>

                <!-- פרטי הטיסה -->
                <div class="form-section">
                    <h3>✈️ פרטי טיסה</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>חברת תעופה</label>
                            <input type="text" name="airline" id="airline" placeholder="Wizz Air (W6)" autocomplete="off">
                            <div class="autocomplete-dropdown" id="airline-dropdown"></div>
                        </div>
                        <div class="form-group">
                            <label>שעת המראה</label>
                            <input type="time" name="flight_time_out" id="flight_time_out">
                        </div>
                        <div class="form-group">
                            <label>שעת חזרה</label>
                            <input type="time" name="flight_time_return" id="flight_time_return">
                        </div>
                    </div>
                </div>

                <!-- פרטי מלון -->
                <div class="form-section">
                    <h3>🏨 פרטי מלון</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>שם המלון</label>
                            <input type="text" name="hotel_name" id="hotel_name" placeholder="Hilton Prague" autocomplete="off">
                            <div class="autocomplete-dropdown" id="hotel-dropdown"></div>
                        </div>
                        <div class="form-group">
                            <label>דירוג</label>
                            <select name="hotel_stars" id="hotel_stars">
                                <option value="">Select...</option>
                                <option value="3">3 Stars ⭐⭐⭐</option>
                                <option value="4">4 Stars ⭐⭐⭐⭐</option>
                                <option value="5">5 Stars ⭐⭐⭐⭐⭐</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>בסיס לינה</label>
                            <select name="board_basis" id="board_basis">
                                <option value="BB">Bed & Breakfast (BB)</option>
                                <option value="HB">Half Board (HB)</option>
                                <option value="FB">Full Board (FB)</option>
                                <option value="RO">Room Only (RO)</option>
                                <option value="AI">All Inclusive (AI)</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- מחיר -->
                <div class="form-section">
                    <h3>💰 מחיר</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>מחיר לאדם *</label>
                            <input type="number" name="price_per_person" id="price_per_person" min="0" required placeholder="1500">
                        </div>
                        <div class="form-group">
                            <label>מטבע</label>
                            <select name="currency" id="currency">
                                <option value="ILS">₪ ILS</option>
                                <option value="USD">$ USD</option>
                                <option value="EUR">€ EUR</option>
                            </select>
                        </div>
                    </div>
                    <div class="price-calculator" id="priceCalc" style="display:none;">
                        <div class="price-row"><span>מחיר לאדם:</span><span id="calcPerPerson">-</span></div>
                        <div class="price-row"><span>מספר נוסעים:</span><span id="calcPassengers">-</span></div>
                        <div class="price-row"><span>סה"כ לתשלום:</span><span id="calcTotal">-</span></div>
                    </div>
                </div>

                <!-- הערות -->
                <div class="form-section">
                    <h3>📝 הערות</h3>
                    <div class="form-group">
                        <textarea name="notes" id="notes" rows="3" placeholder="Additional notes..."></textarea>
                    </div>
                </div>

                <!-- כפתור שמירה -->
                <div class="action-buttons">
                    <button type="button" class="btn-random" onclick="fillRandom()">🎲 מילוי לבדיקה</button>
                    <button type="submit" name="save_draft" class="btn-save">💾 שמור וצור לינק תשלום</button>
                </div>
            </form>

            <!-- תצוגה מקדימה -->
            <div class="preview-box">
                <h3>👁️ תצוגה מקדימה של ההודעה</h3>
                <div id="previewText">מלא את הפרטים כדי לראות תצוגה מקדימה...</div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <?php if ($savedDraft): ?>
    <div class="success-modal show" id="successModal">
        <div class="success-content">
            <h2>✅ הטיוטה נשמרה!</h2>
            <p>לינק התשלום מוכן לשליחה ללקוח:</p>
            
            <div class="payment-link-box" id="paymentLinkBox">
                <?= htmlspecialchars($paymentLink) ?>
            </div>
            
            <button class="btn-whatsapp" onclick="sendWhatsAppWithLink()">
                📱 שלח ללקוח בוואטסאפ
            </button>
            
            <div style="margin-top: 15px;">
                <button class="btn-copy" onclick="copyLink()">📋 העתק לינק</button>
                <a href="draft.php" class="btn-new">➕ טיוטה חדשה</a>
                <a href="drafts_list.php" class="btn-drafts">📄 כל הטיוטות</a>
            </div>
        </div>
    </div>
    
    <script>
        var savedDraft = <?= json_encode($savedDraft) ?>;
        var paymentLink = <?= json_encode($paymentLink) ?>;
        
        function sendWhatsAppWithLink() {
            var phone = savedDraft.customer_phone.replace(/\D/g, '');
            if (phone.startsWith('0')) phone = '972' + phone.substring(1);
            
            var currencySymbols = { ILS: '₪', USD: '$', EUR: '€' };
            var symbol = currencySymbols[savedDraft.currency] || '₪';
            
            var msg = 'שלום ' + savedDraft.customer_name + '! 👋\n\n';
            msg += '✈️ הצעת מחיר לחופשה ב' + savedDraft.destination + '\n\n';
            msg += '💰 סה"כ לתשלום: ' + symbol + Number(savedDraft.total_price).toLocaleString() + '\n\n';
            msg += '💳 לתשלום מאובטח לחץ כאן:\n' + paymentLink + '\n\n';
            msg += '⏰ הלינק בתוקף ל-7 ימים\n\n';
            msg += 'שאלות? אשמח לעזור! 😊';
            
            window.open('https://wa.me/' + phone + '?text=' + encodeURIComponent(msg), '_blank');
        }
        
        function copyLink() {
            navigator.clipboard.writeText(paymentLink).then(function() {
                alert('הלינק הועתק! 📋');
            });
        }
    </script>
    <?php endif; ?>

    <script>
        // נתוני Autocomplete
        var destinations = <?= $destinationsJson ?>;
        var airlines = <?= $airlinesJson ?>;
        var hotels = <?= $hotelsJson ?>;
        
        var currencySymbols = { ILS: '₪', USD: '$', EUR: '€' };
        
        // === Autocomplete System ===
        function Autocomplete(inputId, dropdownId, items, filterFn) {
            var self = this;
            this.input = document.getElementById(inputId);
            this.dropdown = document.getElementById(dropdownId);
            this.items = items;
            this.filterFn = filterFn;
            this.selectedIndex = -1;
            
            if (!this.input || !this.dropdown) return;
            
            this.input.addEventListener('input', function() { self.onInput(); });
            this.input.addEventListener('keydown', function(e) { self.onKeydown(e); });
            this.input.addEventListener('focus', function() { self.onInput(); });
            this.input.addEventListener('blur', function() { setTimeout(function() { self.hide(); }, 200); });
        }
        
        Autocomplete.prototype.getFilteredItems = function() {
            return this.filterFn ? this.filterFn(this.items) : this.items;
        };
        
        Autocomplete.prototype.onInput = function() {
            var value = this.input.value.toLowerCase().trim();
            var items = this.getFilteredItems();
            
            if (value.length === 0) {
                this.showItems(items.slice(0, 10), '');
                return;
            }
            
            var filtered = items.filter(function(item) {
                var itemLower = (typeof item === 'string' ? item : item.name).toLowerCase();
                return itemLower.indexOf(value) !== -1;
            });
            
            this.showItems(filtered.slice(0, 10), value);
        };
        
        Autocomplete.prototype.showItems = function(items, searchTerm) {
            var self = this;
            this.selectedIndex = -1;
            
            if (items.length === 0) {
                this.dropdown.innerHTML = '<div class="no-results">No results found</div>';
                this.dropdown.classList.add('show');
                return;
            }
            
            this.dropdown.innerHTML = items.map(function(item, index) {
                var text = typeof item === 'string' ? item : item.name;
                var displayText = text;
                
                if (searchTerm) {
                    var regex = new RegExp('(' + searchTerm.replace(/[.*+?^${}()|[\]\\]/g, '\\$&') + ')', 'gi');
                    displayText = text.replace(regex, '<span class="match">$1</span>');
                }
                
                return '<div class="autocomplete-item" data-index="' + index + '" data-value="' + text.replace(/"/g, '&quot;') + '">' + displayText + '</div>';
            }).join('');
            
            var itemElements = this.dropdown.querySelectorAll('.autocomplete-item');
            for (var i = 0; i < itemElements.length; i++) {
                (function(item) {
                    item.addEventListener('mousedown', function(e) {
                        e.preventDefault();
                        self.select(item.getAttribute('data-value'));
                    });
                })(itemElements[i]);
            }
            
            this.dropdown.classList.add('show');
        };
        
        Autocomplete.prototype.onKeydown = function(e) {
            var items = this.dropdown.querySelectorAll('.autocomplete-item');
            
            if (e.key === 'ArrowDown') {
                e.preventDefault();
                this.selectedIndex = Math.min(this.selectedIndex + 1, items.length - 1);
                this.updateSelection(items);
            } else if (e.key === 'ArrowUp') {
                e.preventDefault();
                this.selectedIndex = Math.max(this.selectedIndex - 1, 0);
                this.updateSelection(items);
            } else if (e.key === 'Enter' && this.selectedIndex >= 0) {
                e.preventDefault();
                if (items[this.selectedIndex]) {
                    this.select(items[this.selectedIndex].getAttribute('data-value'));
                }
            } else if (e.key === 'Escape') {
                this.hide();
            }
        };
        
        Autocomplete.prototype.updateSelection = function(items) {
            for (var i = 0; i < items.length; i++) {
                if (i === this.selectedIndex) {
                    items[i].classList.add('selected');
                    items[i].scrollIntoView({ block: 'nearest' });
                } else {
                    items[i].classList.remove('selected');
                }
            }
        };
        
        Autocomplete.prototype.select = function(value) {
            this.input.value = value;
            this.hide();
            this.input.dispatchEvent(new Event('change'));
            updatePreview();
        };
        
        Autocomplete.prototype.hide = function() {
            this.dropdown.classList.remove('show');
        };
        
        // Initialize
        new Autocomplete('destination', 'destination-dropdown', destinations);
        new Autocomplete('airline', 'airline-dropdown', airlines);
        new Autocomplete('hotel_name', 'hotel-dropdown', hotels, function(items) {
            var dest = document.getElementById('destination').value;
            if (!dest) return items.map(function(h) { return h.name; });
            var destCity = dest.split(',')[0].trim().toLowerCase();
            var filtered = items.filter(function(h) {
                return h.destination && h.destination.toLowerCase().indexOf(destCity) !== -1;
            });
            return filtered.length > 0 ? filtered.map(function(h) { return h.name; }) : items.map(function(h) { return h.name; });
        });
        
        // === Preview Update ===
        function updatePreview() {
            var name = document.getElementById('customer_name').value || '[Customer Name]';
            var dest = document.getElementById('destination').value || '[Destination]';
            var depDate = document.getElementById('departure_date').value;
            var retDate = document.getElementById('return_date').value;
            var numPass = document.getElementById('num_passengers').value || 2;
            var airline = document.getElementById('airline').value;
            var flightOut = document.getElementById('flight_time_out').value;
            var flightRet = document.getElementById('flight_time_return').value;
            var hotel = document.getElementById('hotel_name').value;
            var stars = document.getElementById('hotel_stars').value;
            var board = document.getElementById('board_basis').value;
            var pricePerPerson = document.getElementById('price_per_person').value;
            var currency = document.getElementById('currency').value;
            
            var nights = '';
            if (depDate && retDate) {
                var diff = Math.round((new Date(retDate) - new Date(depDate)) / (1000*60*60*24));
                if (diff > 0) nights = diff + ' nights';
            }
            
            var formatDate = function(d) { return d ? new Date(d).toLocaleDateString('he-IL') : '[Date]'; };
            var boardNames = { 'BB': 'Bed & Breakfast', 'HB': 'Half Board', 'FB': 'Full Board', 'RO': 'Room Only', 'AI': 'All Inclusive' };
            
            var msg = 'שלום ' + name + '! 👋\n\n';
            msg += '✈️ הצעת מחיר לחופשה ב' + dest + '\n\n';
            msg += '📅 ' + formatDate(depDate) + ' - ' + formatDate(retDate);
            if (nights) msg += ' (' + nights + ')';
            msg += '\n👥 ' + numPass + ' נוסעים\n\n';
            
            if (airline) msg += '✈️ טיסה: ' + airline + '\n';
            if (flightOut) msg += '   המראה: ' + flightOut + '\n';
            if (flightRet) msg += '   חזרה: ' + flightRet + '\n';
            if (airline || flightOut) msg += '\n';
            
            if (hotel) msg += '🏨 ' + hotel;
            if (stars) { for (var i = 0; i < parseInt(stars); i++) msg += '⭐'; }
            if (hotel || stars) msg += '\n';
            if (board) msg += '   ' + boardNames[board] + '\n\n';
            
            if (pricePerPerson) {
                var symbol = currencySymbols[currency];
                var total = pricePerPerson * numPass;
                msg += '💰 ' + symbol + parseInt(pricePerPerson).toLocaleString() + ' לאדם\n';
                msg += '💵 סה"כ: ' + symbol + total.toLocaleString() + '\n\n';
                
                document.getElementById('priceCalc').style.display = 'block';
                document.getElementById('calcPerPerson').textContent = symbol + parseInt(pricePerPerson).toLocaleString();
                document.getElementById('calcPassengers').textContent = numPass;
                document.getElementById('calcTotal').textContent = symbol + total.toLocaleString();
            } else {
                document.getElementById('priceCalc').style.display = 'none';
            }
            
            msg += '💳 לתשלום מאובטח - לינק יישלח בהמשך\n\n';
            msg += 'שאלות? אשמח לעזור! 😊';
            
            document.getElementById('previewText').textContent = msg;
        }
        
        // Event listeners
        var formElements = document.querySelectorAll('#draftForm input, #draftForm select, #draftForm textarea');
        for (var i = 0; i < formElements.length; i++) {
            formElements[i].addEventListener('input', updatePreview);
            formElements[i].addEventListener('change', updatePreview);
        }
        
        // Default dates
        var today = new Date();
        var nextWeek = new Date(today.getTime() + 7*24*60*60*1000);
        document.getElementById('departure_date').value = nextWeek.toISOString().split('T')[0];
        document.getElementById('return_date').value = new Date(nextWeek.getTime() + 4*24*60*60*1000).toISOString().split('T')[0];
        
        // מילוי רנדומלי לבדיקה
        function fillRandom() {
            var firstNames = ['David', 'Moshe', 'Yossi', 'Avi', 'Dan', 'Eli', 'Oren', 'Tal'];
            var lastNames = ['Cohen', 'Levi', 'Israeli', 'Mizrahi', 'Peretz', 'Biton', 'Azulay'];
            var dests = ['Prague, Czech Republic', 'Barcelona, Spain', 'Rome, Italy', 'Paris, France', 'Athens, Greece'];
            var airlinesList = ['Wizz Air (W6)', 'Ryanair (FR)', 'El Al (LY)', 'Israir (6H)'];
            var hotelsList = ['Hilton', 'Marriott', 'Holiday Inn', 'Radisson', 'Novotel'];
            
            var name = firstNames[Math.floor(Math.random() * firstNames.length)] + ' ' + 
                       lastNames[Math.floor(Math.random() * lastNames.length)];
            var phone = '05' + Math.floor(Math.random() * 10) + '-' + 
                        Math.floor(1000000 + Math.random() * 9000000);
            var dest = dests[Math.floor(Math.random() * dests.length)];
            var passengers = Math.floor(Math.random() * 3) + 2; // 2-4
            var price = (Math.floor(Math.random() * 10) + 10) * 100; // 1000-2000
            
            document.getElementById('customer_name').value = name;
            document.getElementById('customer_phone').value = phone;
            document.getElementById('customer_email').value = name.toLowerCase().replace(' ', '.') + '@test.com';
            document.getElementById('destination').value = dest;
            document.getElementById('num_passengers').value = passengers;
            document.getElementById('airline').value = airlinesList[Math.floor(Math.random() * airlinesList.length)];
            document.getElementById('flight_time_out').value = '0' + (6 + Math.floor(Math.random() * 4)) + ':00';
            document.getElementById('flight_time_return').value = (18 + Math.floor(Math.random() * 4)) + ':00';
            document.getElementById('hotel_name').value = hotelsList[Math.floor(Math.random() * hotelsList.length)] + ' ' + dest.split(',')[0];
            document.getElementById('hotel_stars').value = Math.floor(Math.random() * 2) + 4; // 4-5
            document.getElementById('board_basis').value = ['BB', 'HB'][Math.floor(Math.random() * 2)];
            document.getElementById('price_per_person').value = price;
            document.getElementById('notes').value = 'Test booking';
            
            updatePreview();
        }
        
        updatePreview();
    </script>
    <script>
    // אתחול בוחר תאריכים
    const fpConfig = {
        locale: 'he',
        dateFormat: 'Y-m-d',
        altInput: true,
        altFormat: 'j F Y',
        allowInput: true,
        minDate: 'today',
        monthSelectorType: 'dropdown',
        onReady: function(selectedDates, dateStr, instance) {
            const yearInput = instance.calendarContainer.querySelector('.cur-year');
            if (yearInput) {
                const currentYear = new Date().getFullYear();
                const select = document.createElement('select');
                select.className = 'flatpickr-year-dropdown';
                select.style.cssText = 'font-size: 1rem; font-weight: bold; padding: 8px 10px; border-radius: 6px; border: 1px solid #ddd; background: white; cursor: pointer;';
                for (let y = currentYear - 1; y <= currentYear + 3; y++) {
                    const option = document.createElement('option');
                    option.value = y;
                    option.textContent = y;
                    if (y === currentYear) option.selected = true;
                    select.appendChild(option);
                }
                select.addEventListener('change', function() {
                    instance.changeYear(parseInt(this.value));
                });
                yearInput.parentNode.replaceChild(select, yearInput);
            }
        }
    };
    flatpickr('#departure_date', {
        ...fpConfig,
        onChange: function(selectedDates) {
            if (selectedDates[0]) returnPicker.set('minDate', selectedDates[0]);
        }
    });
    const returnPicker = flatpickr('#return_date', fpConfig);
    </script>
</body>
</html>
