<?php
// רשימת טיוטות
require_once 'includes/auth.php';
requireLogin();
blockAccountant();

$agent = getCurrentAgent();
$isAdmin = ($agent && isset($agent['role']) && $agent['role'] === 'admin');
$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

// פילטר סטטוס
$statusFilter = $_GET['status'] ?? '';

// שליפת טיוטות
$whereClauses = [];
$params = [];

// נציג רואה רק טיוטות שלו
if (!$isAdmin) {
    $whereClauses[] = "d.agent_id = ?";
    $params[] = $agent['id'];
}

if ($statusFilter) {
    $whereClauses[] = "d.status = ?";
    $params[] = $statusFilter;
}

$where = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

$sql = "SELECT d.*, a.full_name as agent_name 
        FROM drafts d 
        JOIN agents a ON d.agent_id = a.id 
        $where
        ORDER BY d.created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$drafts = $stmt->fetchAll();

// סטטיסטיקות (גם לפי הרשאות)
$statsWhere = !$isAdmin ? "WHERE agent_id = " . (int)$agent['id'] : "";
$stats = $pdo->query("
    SELECT 
        COUNT(*) as total,
        SUM(status = 'pending') as pending,
        SUM(status = 'sent') as sent,
        SUM(status = 'viewed') as viewed,
        SUM(status = 'partial') as partial,
        SUM(status = 'paid') as paid,
        SUM(status = 'expired') as expired
    FROM drafts
    $statsWhere
")->fetch();

$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$statusLabels = [
    'pending' => ['טיוטה', '#6c757d'],
    'sent' => ['נשלח', '#17a2b8'],
    'viewed' => ['נצפה', '#ffc107'],
    'partial' => ['שולם חלקי', '#fd7e14'],
    'paid' => ['שולם', '#28a745'],
    'expired' => ['פג תוקף', '#dc3545'],
    'cancelled' => ['בוטל', '#6c757d']
];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>רשימת טיוטות - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .header { display: flex; justify-content: space-between; align-items: center; padding: 15px 30px; background: white; box-shadow: 0 2px 10px rgba(0,0,0,0.1); flex-wrap: wrap; gap: 15px; }
        .main-nav { display: flex; gap: 5px; }
        .nav-link { padding: 10px 20px; text-decoration: none; color: #555; border-radius: 8px; font-weight: 500; transition: all 0.2s; }
        .nav-link:hover { background: #f0f0f0; color: #333; }
        .nav-link.active { background: #667eea; color: white; }
        
        .stats-row { display: flex; gap: 15px; margin-bottom: 25px; flex-wrap: wrap; }
        .stat-card { background: white; padding: 20px 25px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.08); text-align: center; min-width: 120px; cursor: pointer; transition: transform 0.2s; }
        .stat-card:hover { transform: translateY(-3px); }
        .stat-card.active { border: 2px solid #667eea; }
        .stat-card h3 { font-size: 1.8rem; margin-bottom: 5px; }
        .stat-card p { color: #666; font-size: 0.9rem; }
        
        .table-container { background: white; border-radius: 12px; overflow-x: auto; box-shadow: 0 2px 10px rgba(0,0,0,0.08); }
        table { width: 100%; border-collapse: collapse; min-width: 900px; }
        th { background: #f8f9fa; padding: 15px; text-align: right; font-weight: 600; color: #555; }
        td { padding: 15px; border-bottom: 1px solid #eee; }
        tr:hover { background: #f8f9fa; }
        
        .status-badge { padding: 5px 12px; border-radius: 20px; font-size: 0.85rem; font-weight: 500; }
        
        .btn-sm { padding: 6px 12px; border-radius: 6px; text-decoration: none; font-size: 0.85rem; margin: 2px; display: inline-block; border: none; cursor: pointer; vertical-align: middle; white-space: nowrap; }
        .btn-primary { background: #667eea; color: white; }
        .btn-success { background: #28a745; color: white; }
        .btn-info { background: #17a2b8; color: white; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-warning { background: #ffc107; color: #333; }
        .btn-sm:hover { opacity: 0.9; }
        
        .empty-state { text-align: center; padding: 60px 20px; color: #666; }
        .empty-state h3 { margin-bottom: 10px; }
        
        .actions { white-space: normal; min-width: 200px; }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <nav class="main-nav">
            <a href="complete_order_lite.php" class="nav-link">⚡ הזמנה לייט</a>
            <a href="drafts_list.php" class="nav-link active">📋 טיוטות</a>
            <a href="orders_panel.php" class="nav-link">🔍 פאנל מתקדם</a>
            <?php if ($isAdmin): ?>
            <a href="reports.php" class="nav-link">📈 דוחות</a>
            <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
            <?php endif; ?>
        </nav>
        <div class="user-info">
            <span class="user-name">שלום, <?= sanitize($agent['full_name']) ?></span>
            <a href="logout.php" class="btn-logout">התנתק</a>
        </div>
    </header>

    <div class="container" style="max-width:1200px; padding-top:30px;">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:25px;">
            <h1 style="margin:0;">📄 רשימת טיוטות</h1>
            <a href="draft.php" class="btn btn-primary" style="padding:12px 25px; text-decoration:none; border-radius:8px; background:#667eea; color:white;">+ טיוטה חדשה</a>
        </div>
        
        <!-- סטטיסטיקות -->
        <div class="stats-row">
            <a href="drafts_list.php" class="stat-card <?= !$statusFilter ? 'active' : '' ?>" style="text-decoration:none; color:inherit;">
                <h3><?= $stats['total'] ?></h3>
                <p>סה"כ</p>
            </a>
            <a href="drafts_list.php?status=sent" class="stat-card <?= $statusFilter === 'sent' ? 'active' : '' ?>" style="text-decoration:none; color:inherit;">
                <h3 style="color:#17a2b8;"><?= $stats['sent'] ?></h3>
                <p>נשלחו</p>
            </a>
            <a href="drafts_list.php?status=viewed" class="stat-card <?= $statusFilter === 'viewed' ? 'active' : '' ?>" style="text-decoration:none; color:inherit;">
                <h3 style="color:#ffc107;"><?= $stats['viewed'] ?></h3>
                <p>נצפו</p>
            </a>
            <a href="drafts_list.php?status=paid" class="stat-card <?= $statusFilter === 'paid' ? 'active' : '' ?>" style="text-decoration:none; color:inherit;">
                <h3 style="color:#28a745;"><?= $stats['paid'] ?></h3>
                <p>שולמו</p>
            </a>
            <a href="drafts_list.php?status=expired" class="stat-card <?= $statusFilter === 'expired' ? 'active' : '' ?>" style="text-decoration:none; color:inherit;">
                <h3 style="color:#dc3545;"><?= $stats['expired'] ?></h3>
                <p>פג תוקף</p>
            </a>
        </div>
        
        <!-- טבלה -->
        <div class="table-container">
            <?php if (empty($drafts)): ?>
                <div class="empty-state">
                    <h3>אין טיוטות</h3>
                    <p>צור טיוטה חדשה כדי לשלוח הצעת מחיר ללקוח</p>
                </div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>לקוח</th>
                            <th>יעד</th>
                            <th>תאריכים</th>
                            <th>סכום</th>
                            <th>סטטוס</th>
                            <th>נוצר</th>
                            <th>פעולות</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($drafts as $draft): ?>
                            <?php
                            $status = $statusLabels[$draft['status']] ?? ['?', '#666'];
                            $symbol = $currencySymbols[$draft['currency']] ?? '₪';
                            $isAddon = !empty($draft['parent_order_id']);
                            ?>
                            <tr style="<?= $isAddon ? 'background:#f0fff0;' : '' ?>">
                                <td>
                                    <?= $draft['id'] ?>
                                    <?php if ($isAddon): ?>
                                        <br><small style="color:#28a745;">🔗 תוספת #<?= $draft['parent_order_id'] ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?= htmlspecialchars($draft['customer_name']) ?></strong><br>
                                    <small style="color:#666;"><?= htmlspecialchars($draft['customer_phone']) ?></small>
                                </td>
                                <td>
                                    <?= htmlspecialchars($draft['destination']) ?>
                                    <?php if ($isAddon && $draft['addon_description']): ?>
                                        <br><small style="color:#666;"><?= htmlspecialchars($draft['addon_description']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?= date('d/m', strtotime($draft['departure_date'])) ?> - 
                                    <?= date('d/m', strtotime($draft['return_date'])) ?>
                                </td>
                                <td><strong><?= $symbol ?><?= number_format($draft['total_price']) ?></strong></td>
                                <td>
                                    <span class="status-badge" style="background: <?= $status[1] ?>20; color: <?= $status[1] ?>;">
                                        <?= $status[0] ?>
                                    </span>
                                </td>
                                <td>
                                    <?= date('d/m H:i', strtotime($draft['created_at'])) ?>
                                </td>
                                <td class="actions">
                                    <?php if (!in_array($draft['status'], ['paid', 'partial'])): ?>
                                        <a href="pay.php?token=<?= $draft['token'] ?>" target="_blank" class="btn-sm btn-info" title="צפה בדף תשלום">👁️</a>
                                        <button onclick="copyLink('<?= $draft['token'] ?>')" class="btn-sm btn-secondary" title="העתק לינק">📋</button>
                                        <button onclick="sendWhatsApp('<?= htmlspecialchars($draft['customer_phone']) ?>', '<?= $draft['token'] ?>', '<?= htmlspecialchars($draft['customer_name']) ?>', '<?= htmlspecialchars($draft['destination']) ?>', '<?= $draft['total_price'] ?>', '<?= $draft['currency'] ?>')" class="btn-sm btn-success" title="שלח בוואטסאפ">📱</button>
                                    <?php endif; ?>
                                    <?php if ($draft['status'] === 'partial'): ?>
                                        <a href="pay.php?token=<?= $draft['token'] ?>" target="_blank" class="btn-sm btn-warning" title="תשלום חלקי - יש יתרה">💳 יתרה</a>
                                    <?php endif; ?>
                                    <?php if ($draft['status'] === 'paid' && !$draft['order_id']): ?>
                                        <?php if ($isAddon): ?>
                                            <button onclick="completeAddon(<?= $draft['id'] ?>, <?= $draft['parent_order_id'] ?>)" class="btn-sm btn-success" title="סיים תוספת">✅ סיים תוספת</button>
                                        <?php else: ?>
                                            <button onclick="continueToOrder(<?= htmlspecialchars(json_encode($draft)) ?>)" class="btn-sm btn-primary" title="המשך להזמנה מלאה">📝 טופס מלא</button>
                                            <button onclick="continueToOrderLite(<?= $draft['id'] ?>)" class="btn-sm btn-success" title="המשך לטופס לייט">⚡ טופס לייט</button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if ($draft['order_id']): ?>
                                        <a href="view_order.php?id=<?= $draft['order_id'] ?>" class="btn-sm btn-primary" title="צפה בהזמנה">📦 צפה בהזמנה</a>
                                    <?php endif; ?>
                                    <?php if ($isAddon && $draft['parent_order_id']): ?>
                                        <a href="view_order.php?id=<?= $draft['parent_order_id'] ?>" class="btn-sm btn-secondary" title="צפה בהזמנה המקורית">👁️ הזמנה מקורית</a>
                                    <?php endif; ?>
                                    <?php if (!$draft['order_id'] && $draft['status'] !== 'paid'): ?>
                                        <button onclick="deleteDraft(<?= $draft['id'] ?>, '<?= htmlspecialchars($draft['customer_name']) ?>')" class="btn-sm btn-danger" title="מחק טיוטה">🗑️</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        var baseUrl = '<?= 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) ?>';
        
        function copyLink(token) {
            var link = baseUrl + '/pay.php?token=' + token;
            navigator.clipboard.writeText(link).then(function() {
                alert('הלינק הועתק! 📋');
            });
        }
        
        function sendWhatsApp(phone, token, name, dest, price, currency) {
            phone = phone.replace(/\D/g, '');
            if (phone.startsWith('0')) phone = '972' + phone.substring(1);
            
            var symbols = { ILS: '₪', USD: '$', EUR: '€' };
            var symbol = symbols[currency] || '₪';
            var link = baseUrl + '/pay.php?token=' + token;
            
            var msg = 'שלום ' + name + '! 👋\n\n';
            msg += '✈️ הצעת מחיר לחופשה ב' + dest + '\n\n';
            msg += '💰 סה"כ: ' + symbol + Number(price).toLocaleString() + '\n\n';
            msg += '💳 לתשלום מאובטח:\n' + link + '\n\n';
            msg += '⏰ בתוקף ל-7 ימים';
            
            window.open('https://wa.me/' + phone + '?text=' + encodeURIComponent(msg), '_blank');
        }
        
        function continueToOrder(draft) {
            // שמירת נתוני הטיוטה ב-sessionStorage
            sessionStorage.setItem('draftData', JSON.stringify(draft));
            // מעבר לטופס הזמנה עם פרמטר from=draft
            window.location.href = 'complete_order_lite.php?from=draft&draft_id=' + draft.id;
        }
        
        function continueToOrderLite(draftId) {
            // מעבר לטופס לייט עם פרמטר draft_id
            window.location.href = 'complete_order_lite.php?draft_id=' + draftId;
        }
        
        async function completeAddon(draftId, parentOrderId) {
            if (!confirm('לסיים את התוספת ולקשר להזמנה #' + parentOrderId + '?')) {
                return;
            }
            
            try {
                const response = await fetch('complete_addon.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'draft_id=' + draftId + '&parent_order_id=' + parentOrderId
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ התוספת נוספה להזמנה בהצלחה!');
                    location.reload();
                } else {
                    alert('❌ שגיאה: ' + result.error);
                }
            } catch (error) {
                alert('❌ שגיאה: ' + error.message);
            }
        }
        
        async function deleteDraft(draftId, customerName) {
            if (!confirm('למחוק את הטיוטה של ' + customerName + '?\n\nפעולה זו לא ניתנת לביטול!')) {
                return;
            }
            
            try {
                const response = await fetch('delete_draft.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'draft_id=' + draftId
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ הטיוטה נמחקה בהצלחה!');
                    location.reload();
                } else {
                    alert('❌ שגיאה: ' + result.error);
                }
            } catch (error) {
                alert('❌ שגיאה: ' + error.message);
            }
        }
    </script>
</body>
</html>
