<?php
// דף פרטי פריט - סטטיסטיקות מפורטות
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

$type = $_GET['type'] ?? '';
$name = $_GET['name'] ?? '';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';

if (!$type || !$name) {
    header('Location: settings.php');
    exit;
}

// תוויות לפי סוג
$typeLabels = [
    'supplier' => ['icon' => '📦', 'title' => 'ספק', 'tab' => 'suppliers'],
    'airline' => ['icon' => '✈️', 'title' => 'חברת תעופה', 'tab' => 'airlines'],
    'hotel' => ['icon' => '🏨', 'title' => 'מלון', 'tab' => 'hotels'],
    'destination' => ['icon' => '🌍', 'title' => 'יעד', 'tab' => 'destinations']
];

$typeInfo = $typeLabels[$type] ?? ['icon' => '📋', 'title' => 'פריט', 'tab' => 'suppliers'];

// בניית תנאי תאריכים
$dateCondition = "";
$dateParams = [];
if ($dateFrom) {
    $dateCondition .= " AND o.departure_date >= ?";
    $dateParams[] = $dateFrom;
}
if ($dateTo) {
    $dateCondition .= " AND o.departure_date <= ?";
    $dateParams[] = $dateTo;
}

// שליפת הזמנות לפי סוג
switch ($type) {
    case 'supplier':
        $whereClause = "(o.flight_supplier = ? OR o.hotel_supplier = ? OR o.package_supplier = ?)";
        $baseParams = [$name, $name, $name];
        break;
    case 'airline':
        $whereClause = "(o.airline_outbound = ? OR o.airline_return = ?)";
        $baseParams = [$name, $name];
        break;
    case 'hotel':
        $whereClause = "o.hotel_name = ?";
        $baseParams = [$name];
        break;
    case 'destination':
        $whereClause = "(o.destination LIKE ? OR o.destination LIKE ?)";
        $baseParams = [$name . '%', '%' . $name . '%'];
        break;
    default:
        $whereClause = "1=0";
        $baseParams = [];
}

// סטטיסטיקות כלליות
$sql = "SELECT 
            COUNT(*) as total_orders,
            SUM(CASE WHEN departure_date >= CURDATE() THEN 1 ELSE 0 END) as open_orders,
            SUM(CASE WHEN departure_date < CURDATE() THEN 1 ELSE 0 END) as past_orders,
            SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as this_week,
            SUM(CASE WHEN departure_date >= CURDATE() AND departure_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as this_month,
            SUM(total_price) as total_revenue,
            SUM(profit) as total_profit,
            SUM(flight_supplier_cost) as flight_cost,
            SUM(hotel_supplier_cost) as hotel_cost,
            SUM(CASE WHEN flight_supplier_paid = 'no' THEN flight_supplier_cost ELSE 0 END) as flight_pending,
            SUM(CASE WHEN hotel_supplier_paid = 'no' THEN hotel_supplier_cost ELSE 0 END) as hotel_pending,
            MIN(order_date) as first_order,
            MAX(order_date) as last_order,
            AVG(DATEDIFF(return_date, departure_date)) as avg_nights
        FROM orders o
        WHERE $whereClause $dateCondition";

$params = array_merge($baseParams, $dateParams);
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

// הזמנות קרובות
$sql2 = "SELECT o.*, a.full_name as agent_name 
         FROM orders o 
         LEFT JOIN agents a ON o.agent_id = a.id
         WHERE $whereClause 
         AND o.departure_date >= CURDATE()
         ORDER BY o.departure_date ASC
         LIMIT 10";
$stmt2 = $pdo->prepare($sql2);
$stmt2->execute($baseParams);
$upcomingOrders = $stmt2->fetchAll();

// כל ההזמנות (לטבלה למטה)
$sql3 = "SELECT o.*, a.full_name as agent_name 
         FROM orders o 
         LEFT JOIN agents a ON o.agent_id = a.id
         WHERE $whereClause $dateCondition
         ORDER BY o.departure_date DESC
         LIMIT 50";
$stmt3 = $pdo->prepare($sql3);
$stmt3->execute($params);
$allOrders = $stmt3->fetchAll();

// סטטיסטיקות לפי חודש (לגרף)
$sql4 = "SELECT 
            DATE_FORMAT(departure_date, '%Y-%m') as month,
            COUNT(*) as orders,
            SUM(total_price) as revenue
         FROM orders o
         WHERE $whereClause
         AND departure_date >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)
         GROUP BY DATE_FORMAT(departure_date, '%Y-%m')
         ORDER BY month ASC";
$stmt4 = $pdo->prepare($sql4);
$stmt4->execute($baseParams);
$monthlyStats = $stmt4->fetchAll();

// סטטוסים
$statuses = [
    'draft' => ['name' => 'טיוטה', 'color' => '#6c757d'],
    'sent' => ['name' => 'נשלח', 'color' => '#17a2b8'],
    'paid' => ['name' => 'שולם', 'color' => '#28a745'],
    'confirmed' => ['name' => 'אושר', 'color' => '#007bff'],
    'cancelled' => ['name' => 'בוטל', 'color' => '#dc3545']
];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $typeInfo['icon'] ?> <?= htmlspecialchars($name) ?> | CRM</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container { max-width: 1400px; margin: 0 auto; }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
            gap: 15px;
        }
        .header-title {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .header-title h1 { color: white; font-size: 1.8rem; }
        .header-title .type-badge {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.9rem;
        }
        .header-actions { display: flex; gap: 10px; }
        .btn {
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
        }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-primary { background: #667eea; color: white; }
        
        /* Date Filter */
        .date-filter {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }
        .date-filter label { font-weight: 500; color: #333; }
        .date-filter input {
            padding: 8px 12px;
            border: 2px solid #e0e0e0;
            border-radius: 6px;
        }
        .date-filter .quick-btns { display: flex; gap: 8px; flex-wrap: wrap; }
        .quick-btn {
            padding: 6px 12px;
            border: 1px solid #ddd;
            border-radius: 15px;
            background: white;
            cursor: pointer;
            font-size: 0.85rem;
        }
        .quick-btn:hover { background: #f0f0f0; }
        .quick-btn.active { background: #667eea; color: white; border-color: #667eea; }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
        }
        .stat-value { font-size: 2rem; font-weight: bold; }
        .stat-label { font-size: 0.85rem; color: #666; margin-top: 5px; }
        .stat-card.purple .stat-value { color: #667eea; }
        .stat-card.green .stat-value { color: #28a745; }
        .stat-card.blue .stat-value { color: #17a2b8; }
        .stat-card.orange .stat-value { color: #fd7e14; }
        .stat-card.red .stat-value { color: #dc3545; }
        
        /* Content Grid */
        .content-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        @media (max-width: 900px) {
            .content-grid { grid-template-columns: 1fr; }
        }
        
        .card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
        }
        .card-header {
            padding: 15px 20px;
            border-bottom: 1px solid #eee;
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .card-body { padding: 20px; }
        
        /* Upcoming Orders */
        .upcoming-order {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }
        .upcoming-order:last-child { border-bottom: none; }
        .upcoming-order .dest { font-weight: 600; }
        .upcoming-order .date { color: #666; font-size: 0.9rem; }
        .upcoming-order .days {
            padding: 3px 10px;
            border-radius: 10px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        .days-urgent { background: #ff6b6b; color: white; }
        .days-soon { background: #ffd43b; color: #333; }
        .days-ok { background: #69db7c; color: #333; }
        
        /* Chart placeholder */
        .chart-container {
            height: 200px;
            display: flex;
            align-items: flex-end;
            gap: 8px;
            padding: 10px 0;
        }
        .chart-bar {
            flex: 1;
            background: linear-gradient(to top, #667eea, #764ba2);
            border-radius: 4px 4px 0 0;
            position: relative;
            min-height: 20px;
        }
        .chart-bar .label {
            position: absolute;
            bottom: -25px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 0.7rem;
            color: #666;
            white-space: nowrap;
        }
        .chart-bar .value {
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        /* Orders Table */
        .orders-section {
            background: white;
            border-radius: 10px;
            overflow: hidden;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 12px 15px;
            text-align: right;
            border-bottom: 1px solid #eee;
        }
        th {
            background: #f8f9fa;
            font-weight: 600;
            font-size: 0.9rem;
        }
        tr:hover { background: #f8f9fa; }
        .status-badge {
            padding: 3px 10px;
            border-radius: 12px;
            color: white;
            font-size: 0.8rem;
        }
        .order-link { color: #667eea; text-decoration: none; font-weight: 600; }
        .order-link:hover { text-decoration: underline; }
        
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #666;
        }
        
        .see-all-link {
            color: #667eea;
            text-decoration: none;
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-title">
                <h1><?= $typeInfo['icon'] ?> <?= htmlspecialchars($name) ?></h1>
                <span class="type-badge"><?= $typeInfo['title'] ?></span>
            </div>
            <div class="header-actions">
                <a href="manage_orders.php?search=<?= urlencode($name) ?>" class="btn btn-primary">📋 כל ההזמנות</a>
                <a href="settings.php?tab=<?= $typeInfo['tab'] ?>" class="btn btn-secondary">← חזרה להגדרות</a>
            </div>
        </div>

        <!-- Date Filter -->
        <form method="GET" class="date-filter">
            <input type="hidden" name="type" value="<?= htmlspecialchars($type) ?>">
            <input type="hidden" name="name" value="<?= htmlspecialchars($name) ?>">
            
            <label>📅 טווח תאריכים:</label>
            <input type="date" name="date_from" value="<?= htmlspecialchars($dateFrom) ?>">
            <span>עד</span>
            <input type="date" name="date_to" value="<?= htmlspecialchars($dateTo) ?>">
            <button type="submit" class="btn btn-primary" style="padding:8px 15px;">סנן</button>
            
            <div class="quick-btns">
                <a href="?type=<?= $type ?>&name=<?= urlencode($name) ?>" class="quick-btn <?= !$dateFrom && !$dateTo ? 'active' : '' ?>">הכל</a>
                <a href="?type=<?= $type ?>&name=<?= urlencode($name) ?>&date_from=<?= date('Y-m-01') ?>&date_to=<?= date('Y-m-t') ?>" class="quick-btn">החודש</a>
                <a href="?type=<?= $type ?>&name=<?= urlencode($name) ?>&date_from=<?= date('Y-m-01', strtotime('+1 month')) ?>&date_to=<?= date('Y-m-t', strtotime('+1 month')) ?>" class="quick-btn">החודש הבא</a>
                <a href="?type=<?= $type ?>&name=<?= urlencode($name) ?>&date_from=<?= date('Y-01-01') ?>&date_to=<?= date('Y-12-31') ?>" class="quick-btn"><?= date('Y') ?></a>
            </div>
        </form>

        <!-- Stats Grid -->
        <div class="stats-grid">
            <div class="stat-card purple">
                <div class="stat-value"><?= number_format($stats['total_orders'] ?? 0) ?></div>
                <div class="stat-label">סה"כ הזמנות</div>
            </div>
            <div class="stat-card blue">
                <div class="stat-value"><?= number_format($stats['open_orders'] ?? 0) ?></div>
                <div class="stat-label">הזמנות פתוחות</div>
            </div>
            <div class="stat-card orange">
                <div class="stat-value"><?= number_format($stats['this_week'] ?? 0) ?></div>
                <div class="stat-label">יוצאות השבוע</div>
            </div>
            <div class="stat-card green">
                <div class="stat-value">₪<?= number_format($stats['total_revenue'] ?? 0) ?></div>
                <div class="stat-label">סה"כ מכירות</div>
            </div>
            <div class="stat-card green">
                <div class="stat-value">₪<?= number_format($stats['total_profit'] ?? 0) ?></div>
                <div class="stat-label">סה"כ רווח</div>
            </div>
            <?php if ($type === 'supplier'): ?>
            <div class="stat-card red">
                <div class="stat-value">₪<?= number_format(($stats['flight_pending'] ?? 0) + ($stats['hotel_pending'] ?? 0)) ?></div>
                <div class="stat-label">חוב פתוח</div>
            </div>
            <?php endif; ?>
            <?php if ($stats['avg_nights']): ?>
            <div class="stat-card">
                <div class="stat-value"><?= round($stats['avg_nights'], 1) ?></div>
                <div class="stat-label">לילות בממוצע</div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Content Grid -->
        <div class="content-grid">
            <!-- Upcoming Orders -->
            <div class="card">
                <div class="card-header">
                    <span>🗓️ יציאות קרובות</span>
                    <a href="manage_orders.php?search=<?= urlencode($name) ?>&quick=this_week" class="see-all-link">ראה הכל →</a>
                </div>
                <div class="card-body">
                    <?php if (empty($upcomingOrders)): ?>
                        <div class="empty-state">אין יציאות קרובות</div>
                    <?php else: ?>
                        <?php foreach ($upcomingOrders as $order): 
                            $days = (strtotime($order['departure_date']) - strtotime(date('Y-m-d'))) / 86400;
                            $daysClass = $days <= 2 ? 'days-urgent' : ($days <= 7 ? 'days-soon' : 'days-ok');
                            $daysText = $days == 0 ? 'היום' : ($days == 1 ? 'מחר' : $days . ' ימים');
                        ?>
                        <div class="upcoming-order">
                            <div>
                                <div class="dest">
                                    <a href="view_order.php?id=<?= $order['id'] ?>" class="order-link">#<?= $order['id'] ?></a>
                                    <?= htmlspecialchars($order['destination'] ?? '-') ?>
                                </div>
                                <div class="date"><?= date('d/m/Y', strtotime($order['departure_date'])) ?></div>
                            </div>
                            <span class="days <?= $daysClass ?>"><?= $daysText ?></span>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Monthly Chart -->
            <div class="card">
                <div class="card-header">
                    <span>📊 הזמנות לפי חודש</span>
                </div>
                <div class="card-body">
                    <?php if (empty($monthlyStats)): ?>
                        <div class="empty-state">אין נתונים להצגה</div>
                    <?php else: ?>
                        <?php 
                        $maxOrders = max(array_column($monthlyStats, 'orders'));
                        if ($maxOrders == 0) $maxOrders = 1;
                        ?>
                        <div class="chart-container">
                            <?php foreach ($monthlyStats as $m): 
                                $height = ($m['orders'] / $maxOrders) * 100;
                                $monthLabel = date('M', strtotime($m['month'] . '-01'));
                            ?>
                            <div class="chart-bar" style="height: <?= max(20, $height) ?>%;">
                                <span class="value"><?= $m['orders'] ?></span>
                                <span class="label"><?= $monthLabel ?></span>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- All Orders Table -->
        <div class="orders-section">
            <div class="card-header">
                <span>📋 רשימת הזמנות <?= $dateFrom || $dateTo ? '(מסוננת)' : '' ?></span>
                <span style="color:#666; font-size:0.9rem;"><?= count($allOrders) ?> הזמנות</span>
            </div>
            
            <?php if (empty($allOrders)): ?>
                <div class="empty-state">לא נמצאו הזמנות</div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>יעד</th>
                            <th>תאריך יציאה</th>
                            <th>מלון</th>
                            <th>סה"כ</th>
                            <th>רווח</th>
                            <th>סוכן</th>
                            <th>סטטוס</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($allOrders as $order): ?>
                        <tr>
                            <td><a href="view_order.php?id=<?= $order['id'] ?>" class="order-link">#<?= $order['id'] ?></a></td>
                            <td><?= htmlspecialchars($order['destination'] ?? '-') ?></td>
                            <td><?= $order['departure_date'] ? date('d/m/Y', strtotime($order['departure_date'])) : '-' ?></td>
                            <td><?= htmlspecialchars($order['hotel_name'] ?? '-') ?></td>
                            <td>₪<?= number_format($order['total_price'] ?? 0) ?></td>
                            <td>₪<?= number_format($order['profit'] ?? 0) ?></td>
                            <td><?= htmlspecialchars($order['agent_name'] ?? '-') ?></td>
                            <td>
                                <?php $st = $statuses[$order['status']] ?? ['name' => $order['status'], 'color' => '#999']; ?>
                                <span class="status-badge" style="background:<?= $st['color'] ?>"><?= $st['name'] ?></span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
