<?php
// ניהול שערי מטבע
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$message = '';
$autoFetchResult = null;

// וידוא שקיימת עמודת source
try {
    // בודק אם העמודה קיימת
    $stmt = $pdo->query("SHOW COLUMNS FROM exchange_rates LIKE 'source'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE exchange_rates ADD COLUMN source VARCHAR(100) DEFAULT 'ידני'");
    }
} catch (Exception $e) {
    // ממשיכים בכל מקרה
}

// עדכון שערים
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usdRate = (float)$_POST['usd_rate'];
    $eurRate = (float)$_POST['eur_rate'];
    $source = $_POST['source'] ?? 'ידני';
    
    if ($usdRate > 0 && $eurRate > 0) {
        try {
            // מנסה עם source
            $stmt = $pdo->prepare("INSERT INTO exchange_rates (currency, rate, updated_at, updated_by, source) 
                                   VALUES (?, ?, NOW(), ?, ?) 
                                   ON DUPLICATE KEY UPDATE rate = VALUES(rate), updated_at = NOW(), updated_by = VALUES(updated_by), source = VALUES(source)");
            $stmt->execute(['USD', $usdRate, $_SESSION['agent_id'], $source]);
            $stmt->execute(['EUR', $eurRate, $_SESSION['agent_id'], $source]);
        } catch (Exception $e) {
            // אם נכשל, מנסה בלי source
            $stmt = $pdo->prepare("INSERT INTO exchange_rates (currency, rate, updated_at, updated_by) 
                                   VALUES (?, ?, NOW(), ?) 
                                   ON DUPLICATE KEY UPDATE rate = VALUES(rate), updated_at = NOW(), updated_by = VALUES(updated_by)");
            $stmt->execute(['USD', $usdRate, $_SESSION['agent_id']]);
            $stmt->execute(['EUR', $eurRate, $_SESSION['agent_id']]);
        }
        $message = 'success';
    } else {
        $message = 'error';
    }
}

// שליפת שערים נוכחיים
$rates = [];
try {
    $stmt = $pdo->query("SELECT currency, rate, updated_at, source FROM exchange_rates");
    while ($row = $stmt->fetch()) {
        $rates[$row['currency']] = $row;
    }
} catch (Exception $e) {
    $stmt = $pdo->query("SELECT currency, rate, updated_at FROM exchange_rates");
    while ($row = $stmt->fetch()) {
        $rates[$row['currency']] = $row;
    }
}

$usdRate = $rates['USD']['rate'] ?? 3.65;
$eurRate = $rates['EUR']['rate'] ?? 3.95;
$lastUpdate = $rates['USD']['updated_at'] ?? null;
$source = $rates['USD']['source'] ?? 'לא ידוע';
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>שערי מטבע - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .rates-card {
            max-width: 500px;
            margin: 50px auto;
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 30px rgba(0,0,0,0.1);
        }
        .rates-title {
            text-align: center;
            font-size: 1.8rem;
            color: #1e3c72;
            margin-bottom: 30px;
        }
        .rate-input-group {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
        }
        .currency-symbol {
            font-size: 2rem;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: white;
            border-radius: 50%;
            font-weight: bold;
        }
        .rate-details {
            flex: 1;
        }
        .rate-label {
            font-size: 1.1rem;
            color: #333;
            margin-bottom: 5px;
        }
        .rate-input {
            width: 100%;
            padding: 12px;
            font-size: 1.3rem;
            border: 2px solid #ddd;
            border-radius: 8px;
            text-align: center;
        }
        .rate-input:focus {
            border-color: #1e3c72;
            outline: none;
        }
        .ils-symbol {
            color: #666;
            font-size: 0.9rem;
        }
        .save-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #e94560, #ff6b6b);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1.2rem;
            cursor: pointer;
            margin-top: 20px;
        }
        .save-btn:hover {
            opacity: 0.9;
        }
        .last-update {
            text-align: center;
            color: #666;
            margin-top: 20px;
            font-size: 0.9rem;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
        }
        .quick-rates {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-top: 10px;
        }
        .quick-rate-btn {
            padding: 5px 12px;
            background: #e9ecef;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.85rem;
        }
        .quick-rate-btn:hover {
            background: #dee2e6;
        }
        .auto-fetch-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            color: white;
            text-align: center;
        }
        .auto-fetch-btn {
            background: white;
            color: #667eea;
            border: none;
            padding: 15px 30px;
            font-size: 1.1rem;
            border-radius: 10px;
            cursor: pointer;
            font-weight: bold;
            margin-top: 10px;
        }
        .auto-fetch-btn:hover {
            background: #f0f0f0;
        }
        .auto-fetch-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
        .source-badge {
            display: inline-block;
            padding: 5px 12px;
            background: #e3f2fd;
            color: #1565c0;
            border-radius: 15px;
            font-size: 0.85rem;
            margin-top: 5px;
        }
        .fetched-rates {
            background: #d4edda;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            text-align: right;
            color: #155724;
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo">💱 <?= SITE_NAME ?></div>
            <nav class="nav">
                <a href="orders_new.php">📋 הזמנות</a>
                <a href="complete_order.php">➕ הזמנה חדשה</a>
                <a href="supplier_debts.php">💰 חובות לספקים</a>
                <a href="exchange_rates.php" class="active">💱 שערי מטבע</a>
            </nav>
        </div>
    </header>

    <div class="container">
        <div class="rates-card">
            <h1 class="rates-title">💱 שערי מטבע להיום</h1>
            
            <!-- משיכה אוטומטית מבנק ישראל -->
            <div class="auto-fetch-section">
                <div style="font-size: 1.2rem; margin-bottom: 10px;">🏦 משיכת שערים אוטומטית</div>
                <div style="font-size: 0.9rem; opacity: 0.9;">שער יציג מבנק ישראל + מרווח להמרה</div>
                
                <div style="margin: 15px 0; display: flex; align-items: center; justify-content: center; gap: 10px;">
                    <label style="font-size: 0.9rem;">מרווח (%):</label>
                    <input type="number" id="marginPercent" value="0.86" step="0.01" min="0" max="5" 
                           style="width: 70px; padding: 8px; border-radius: 5px; border: none; text-align: center; font-size: 1rem;">
                </div>
                
                <button type="button" class="auto-fetch-btn" onclick="fetchRatesFromBank()" id="fetchBtn">
                    🔄 משוך שערים עדכניים
                </button>
                <div id="fetchResult"></div>
            </div>
            
            <?php if ($message === 'success'): ?>
                <div class="alert alert-success">✅ השערים עודכנו בהצלחה!</div>
            <?php elseif ($message === 'error'): ?>
                <div class="alert alert-error">❌ שגיאה - הזן שערים תקינים</div>
            <?php endif; ?>
            
            <form method="POST" id="ratesForm">
                <input type="hidden" name="source" id="rateSource" value="ידני">
                
                <div class="rate-input-group">
                    <div class="currency-symbol">$</div>
                    <div class="rate-details">
                        <div class="rate-label">דולר אמריקאי (USD)</div>
                        <input type="number" step="0.0001" name="usd_rate" id="usdRate" class="rate-input" 
                               value="<?= $usdRate ?>" required>
                        <div class="ils-symbol">= 1 דולר בשקלים</div>
                        <div class="quick-rates">
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('usdRate').value='3.60'">3.60</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('usdRate').value='3.65'">3.65</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('usdRate').value='3.70'">3.70</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('usdRate').value='3.75'">3.75</button>
                        </div>
                    </div>
                </div>
                
                <div class="rate-input-group">
                    <div class="currency-symbol">€</div>
                    <div class="rate-details">
                        <div class="rate-label">יורו (EUR)</div>
                        <input type="number" step="0.0001" name="eur_rate" id="eurRate" class="rate-input" 
                               value="<?= $eurRate ?>" required>
                        <div class="ils-symbol">= 1 יורו בשקלים</div>
                        <div class="quick-rates">
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('eurRate').value='3.90'">3.90</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('eurRate').value='3.95'">3.95</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('eurRate').value='4.00'">4.00</button>
                            <button type="button" class="quick-rate-btn" onclick="document.getElementById('eurRate').value='4.05'">4.05</button>
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="save-btn">💾 שמור שערים</button>
            </form>
            
            <?php if ($lastUpdate): ?>
                <div class="last-update">
                    🕐 עדכון אחרון: <?= date('d/m/Y H:i', strtotime($lastUpdate)) ?>
                    <br>
                    <span class="source-badge">📍 מקור: <?= htmlspecialchars($source) ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
    async function fetchRatesFromBank() {
        const btn = document.getElementById('fetchBtn');
        const resultDiv = document.getElementById('fetchResult');
        const margin = document.getElementById('marginPercent').value || 0.9;
        
        btn.disabled = true;
        btn.innerHTML = '⏳ מושך שערים...';
        resultDiv.innerHTML = '';
        
        try {
            const response = await fetch(`api/fetch_exchange_rates.php?margin=${margin}`);
            const data = await response.json();
            
            if (data.success) {
                // מילוי השדות
                document.getElementById('usdRate').value = data.rates.USD;
                document.getElementById('eurRate').value = data.rates.EUR;
                document.getElementById('rateSource').value = `בנק ישראל + ${margin}% (אוטומטי)`;
                
                resultDiv.innerHTML = `
                    <div style="color: white; background: rgba(255,255,255,0.2); margin-top: 15px; padding: 12px; border-radius: 8px; text-align: right;">
                        ✅ נמשכו בהצלחה!<br>
                        <div style="margin-top: 8px;">
                            <strong>שער יציג:</strong><br>
                            💵 דולר: ${data.representative_rates.USD}<br>
                            💶 יורו: ${data.representative_rates.EUR}
                        </div>
                        <div style="margin-top: 8px;">
                            <strong>+ מרווח ${margin}%:</strong><br>
                            💵 דולר: ${data.rates.USD}<br>
                            💶 יורו: ${data.rates.EUR}
                        </div>
                        <small style="opacity: 0.8;">לחץ "שמור שערים" לשמירה במערכת</small>
                    </div>
                `;
                
                // הבהוב על השדות
                document.getElementById('usdRate').style.background = '#d4edda';
                document.getElementById('eurRate').style.background = '#d4edda';
                setTimeout(() => {
                    document.getElementById('usdRate').style.background = '';
                    document.getElementById('eurRate').style.background = '';
                }, 2000);
                
            } else {
                resultDiv.innerHTML = `
                    <div style="color: #ffcdd2; margin-top: 15px;">
                        ❌ ${data.error || 'שגיאה במשיכת שערים'}
                    </div>
                `;
            }
        } catch (error) {
            resultDiv.innerHTML = `
                <div style="color: #ffcdd2; margin-top: 15px;">
                    ❌ שגיאת תקשורת: ${error.message}
                </div>
            `;
        }
        
        btn.disabled = false;
        btn.innerHTML = '🔄 משוך שערים עדכניים';
    }
    </script>
</body>
</html>
