<?php
// ייצוא הזמנות לאקסל (CSV)
require_once 'includes/auth.php';
requireLogin();
blockAccountant();

$pdo = getDB();
$agent = getCurrentAgent();
$isAdmin = ($agent && $agent['role'] === 'admin');

// פרמטרי סינון (אותם פרמטרים כמו בפאנל)
$filters = [
    'order_id' => $_GET['order_id'] ?? '',
    'customer_name' => $_GET['customer_name'] ?? '',
    'destination' => $_GET['destination'] ?? '',
    'flight_supplier' => $_GET['flight_supplier'] ?? '',
    'flight_airline' => $_GET['flight_airline'] ?? '',
    'agent_id' => $_GET['agent_id'] ?? '',
    'payment_status' => $_GET['payment_status'] ?? '',
    'order_status' => $_GET['order_status'] ?? '',
    'date_from' => $_GET['date_from'] ?? '',
    'date_to' => $_GET['date_to'] ?? '',
    'flight_from' => $_GET['flight_from'] ?? '',
    'flight_to' => $_GET['flight_to'] ?? ''
];

// נציג יכול לייצא רק את ההזמנות שלו
if (!$isAdmin) {
    $filters['agent_id'] = $agent['id'];
}

// בניית שאילתה
$sql = "SELECT o.*, a.full_name as agent_name
        FROM orders o
        LEFT JOIN agents a ON o.agent_id = a.id
        WHERE 1=1";
$params = [];

if ($filters['order_id']) {
    $sql .= " AND o.id = ?";
    $params[] = $filters['order_id'];
}
if ($filters['customer_name']) {
    $sql .= " AND o.customer_name LIKE ?";
    $params[] = '%' . $filters['customer_name'] . '%';
}
if ($filters['destination']) {
    $sql .= " AND o.destination LIKE ?";
    $params[] = '%' . $filters['destination'] . '%';
}
if ($filters['flight_supplier']) {
    $sql .= " AND o.flight_supplier = ?";
    $params[] = $filters['flight_supplier'];
}
if ($filters['flight_airline']) {
    $sql .= " AND o.flight_airline LIKE ?";
    $params[] = '%' . $filters['flight_airline'] . '%';
}
if ($filters['agent_id']) {
    $sql .= " AND o.agent_id = ?";
    $params[] = $filters['agent_id'];
}
if ($filters['order_status']) {
    $sql .= " AND o.status = ?";
    $params[] = $filters['order_status'];
}
if ($filters['date_from']) {
    $sql .= " AND DATE(o.created_at) >= ?";
    $params[] = $filters['date_from'];
}
if ($filters['date_to']) {
    $sql .= " AND DATE(o.created_at) <= ?";
    $params[] = $filters['date_to'];
}
if ($filters['flight_from']) {
    $sql .= " AND DATE(o.flight_date_outbound) >= ?";
    $params[] = $filters['flight_from'];
}
if ($filters['flight_to']) {
    $sql .= " AND DATE(o.flight_date_outbound) <= ?";
    $params[] = $filters['flight_to'];
}

$sql .= " ORDER BY o.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// הגדרת headers להורדה
$filename = 'orders_export_' . date('Y-m-d_His') . '.csv';
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// BOM לתמיכה בעברית באקסל
echo "\xEF\xBB\xBF";

// פתיחת output stream
$output = fopen('php://output', 'w');

// כותרות
fputcsv($output, [
    'מס הזמנה',
    'תאריך הזמנה',
    'שם לקוח',
    'טלפון',
    'אימייל',
    'יעד',
    'תאריך טיסה הלוך',
    'תאריך טיסה חזור',
    'ספק',
    'קוד הזמנה ספק',
    'חברת תעופה',
    'נציג',
    'מספר נוסעים',
    'עלות ספק ($)',
    'שער המרה',
    'מחיר ללקוח (₪)',
    'רווח (₪)',
    'סטטוס תשלום ספק',
    'סטטוס הזמנה',
    'הערות'
]);

// נתונים
foreach ($orders as $o) {
    // חישוב סכום ששולם
    $payments = json_decode($o['customer_payments'] ?? '[]', true);
    $totalPaid = 0;
    if (is_array($payments)) {
        foreach ($payments as $p) {
            $totalPaid += floatval($p['amount'] ?? 0);
        }
    }
    
    $totalPrice = floatval($o['total_price'] ?? 0);
    $paymentStatus = '';
    if ($totalPaid >= $totalPrice && $totalPrice > 0) {
        $paymentStatus = 'שולם';
    } elseif ($totalPaid > 0) {
        $paymentStatus = 'חלקי';
    } else {
        $paymentStatus = 'לא שולם';
    }
    
    fputcsv($output, [
        $o['id'],
        date('d/m/Y', strtotime($o['created_at'])),
        $o['customer_name'] ?? '',
        $o['customer_phone'] ?? '',
        $o['customer_email'] ?? '',
        $o['destination'] ?? '',
        $o['flight_date_outbound'] ? date('d/m/Y', strtotime($o['flight_date_outbound'])) : '',
        $o['flight_date_return'] ? date('d/m/Y', strtotime($o['flight_date_return'])) : '',
        strtoupper($o['flight_supplier'] ?? ''),
        $o['supplier_booking_code'] ?? '',
        $o['flight_airline'] ?? '',
        $o['agent_name'] ?? '',
        $o['num_passengers'] ?? '',
        floatval($o['flight_supplier_cost'] ?? 0) + floatval($o['return_flight_supplier_cost'] ?? 0) + floatval($o['hotel_supplier_cost'] ?? 0),
        $o['flight_exchange_rate'] ?? '',
        $o['total_price'] ?? '',
        $o['profit'] ?? '',
        ($o['flight_supplier_paid'] ?? '') === 'paid' ? 'שולם' : 'לא שולם',
        $o['status'] ?? '',
        $o['notes'] ?? ''
    ]);
}

fclose($output);
exit;
