<?php
// ייצוא דוחות לאקסל (CSV)
require_once 'includes/auth.php';
requireLogin();

$agent = getCurrentAgent();
$isAccountant = ($agent && $agent['role'] === 'accountant');

$pdo = getDB();

$reportType = $_GET['report'] ?? 'profitability';

// רואה חשבון יכול לייצא רק את הדוח שלו
if ($isAccountant && $reportType !== 'accountant') {
    header('Location: reports.php?report=accountant');
    exit;
}

$dateFrom = $_GET['date_from'] ?? date('Y-m-01');
$dateTo = $_GET['date_to'] ?? date('Y-m-d');
$groupBy = $_GET['group_by'] ?? 'month';

$filename = $reportType . '_report_' . date('Y-m-d') . '.csv';
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// BOM לתמיכה בעברית
echo "\xEF\xBB\xBF";

$output = fopen('php://output', 'w');

switch ($reportType) {
    case 'profitability':
        // דוח רווחיות
        $groupField = 'DATE_FORMAT(o.created_at, "%Y-%m")';
        $groupLabel = 'חודש';
        
        if ($groupBy === 'supplier') {
            $groupField = 'IFNULL(o.flight_supplier, "לא צוין")';
            $groupLabel = 'ספק';
        } elseif ($groupBy === 'agent') {
            $groupField = 'IFNULL(a.full_name, "לא צוין")';
            $groupLabel = 'נציג';
        } elseif ($groupBy === 'airline') {
            $groupField = 'IFNULL(o.flight_airline, "לא צוין")';
            $groupLabel = 'חברת תעופה';
        } elseif ($groupBy === 'destination') {
            $groupField = 'IFNULL(o.destination, "לא צוין")';
            $groupLabel = 'יעד';
        }
        
        $sql = "SELECT 
                    $groupField as group_name,
                    COUNT(*) as order_count,
                    SUM(o.total_price) as total_revenue,
                    SUM(o.profit) as total_profit,
                    AVG(o.profit) as avg_profit
                FROM orders o
                LEFT JOIN agents a ON o.agent_id = a.id
                WHERE DATE(o.created_at) BETWEEN ? AND ?
                
                GROUP BY $groupField
                ORDER BY total_profit DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$dateFrom, $dateTo]);
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // כותרות
        fputcsv($output, [$groupLabel, 'הזמנות', 'הכנסות (₪)', 'רווח (₪)', 'רווח ממוצע (₪)']);
        
        // נתונים
        $totalOrders = 0;
        $totalRevenue = 0;
        $totalProfit = 0;
        
        foreach ($data as $row) {
            fputcsv($output, [
                $row['group_name'],
                $row['order_count'],
                $row['total_revenue'],
                $row['total_profit'],
                round($row['avg_profit'], 2)
            ]);
            $totalOrders += $row['order_count'];
            $totalRevenue += $row['total_revenue'];
            $totalProfit += $row['total_profit'];
        }
        
        // סיכום
        fputcsv($output, []);
        fputcsv($output, ['סה"כ', $totalOrders, $totalRevenue, $totalProfit, '']);
        break;
        
    case 'accountant':
        // דוח לרואה חשבון - טרנזקציות
        $sql = "
            -- הזמנות ראשיות
            SELECT 
                DATE(o.created_at) as transaction_date,
                o.created_at as full_date,
                o.id as order_id,
                NULL as addition_id,
                'הזמנה ראשית' as transaction_type,
                o.destination as description,
                (IFNULL(o.total_price, 0) - IFNULL(o.profit, 0)) as cost_ils,
                IFNULL(o.total_price, 0) as income_ils,
                IFNULL(o.profit, 0) as profit_ils
            FROM orders o
            WHERE DATE(o.created_at) BETWEEN ? AND ?
            
            UNION ALL
            
            -- תוספות להזמנות
            SELECT 
                DATE(a.created_at) as transaction_date,
                a.created_at as full_date,
                a.order_id as order_id,
                a.id as addition_id,
                CASE a.component 
                    WHEN 'flight_outbound' THEN 'תוספת טיסת הלוך'
                    WHEN 'flight_return' THEN 'תוספת טיסת חזור'
                    WHEN 'hotel' THEN 'תוספת מלון'
                    ELSE 'תוספת'
                END as transaction_type,
                a.description as description,
                IFNULL(a.amount_ils, IFNULL(a.amount, 0)) as cost_ils,
                IFNULL(a.customer_charge, 0) as income_ils,
                IFNULL(a.profit, 0) as profit_ils
            FROM order_additions a
            WHERE DATE(a.created_at) BETWEEN ? AND ?
            
            ORDER BY transaction_date ASC, full_date ASC
        ";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$dateFrom, $dateTo, $dateFrom, $dateTo]);
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // כותרות
        fputcsv($output, ['תאריך', 'מס הזמנה', 'סוג טרנזקציה', 'תיאור', 'עלות (₪)', 'הכנסה (₪)', 'רווח (₪)']);
        
        // נתונים
        $totalCost = 0;
        $totalIncome = 0;
        $totalProfit = 0;
        
        foreach ($data as $row) {
            fputcsv($output, [
                date('d/m/Y', strtotime($row['transaction_date'])),
                $row['order_id'],
                $row['transaction_type'],
                $row['description'],
                $row['cost_ils'],
                $row['income_ils'],
                $row['profit_ils']
            ]);
            $totalCost += floatval($row['cost_ils'] ?? 0);
            $totalIncome += floatval($row['income_ils'] ?? 0);
            $totalProfit += floatval($row['profit_ils'] ?? 0);
        }
        
        // סיכום
        fputcsv($output, []);
        fputcsv($output, ['סה"כ', count($data) . ' טרנזקציות', '', '', $totalCost, $totalIncome, $totalProfit]);
        break;
        
    case 'suppliers':
        // דוח תשלומים לספקים
        $sql = "SELECT 
                    IFNULL(flight_supplier, 'לא צוין') as supplier_name,
                    COUNT(*) as order_count,
                    SUM(IFNULL(flight_supplier_cost, 0) + IFNULL(return_flight_supplier_cost, 0)) as total_cost_usd,
                    SUM(CASE WHEN flight_supplier_paid = 'paid' THEN IFNULL(flight_supplier_cost, 0) ELSE 0 END) as paid_usd,
                    SUM(CASE WHEN flight_supplier_paid != 'paid' OR flight_supplier_paid IS NULL THEN IFNULL(flight_supplier_cost, 0) ELSE 0 END) as unpaid_usd
                FROM orders
                WHERE DATE(created_at) BETWEEN ? AND ?
                GROUP BY flight_supplier
                ORDER BY total_cost_usd DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$dateFrom, $dateTo]);
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // כותרות
        fputcsv($output, ['ספק', 'הזמנות', 'סה"כ חוב ($)', 'שולם ($)', 'ממתין לתשלום ($)']);
        
        // נתונים
        foreach ($data as $row) {
            fputcsv($output, [
                strtoupper($row['supplier_name']),
                $row['order_count'],
                $row['total_cost_usd'],
                $row['paid_usd'],
                $row['unpaid_usd']
            ]);
        }
        break;
}

fclose($output);
exit;
